/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.Scale;
import jmri.ScaleManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LayoutTurntable;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.util.FileUtil;
import jmri.util.PhysicalLocation;
import jmri.util.ThreadingUtil;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSDGeoFile
extends XmlFile {
    static final String VSDGeoDataFileName = "VSDGeoData.xml";
    protected Element root;
    private float[][][] blockParameter;
    private List<List<PhysicalLocation>> blockPositionlists;
    private List<PhysicalLocation>[] blockPositionlist;
    private List<List<Integer>> reporterlists = new ArrayList<List<Integer>>();
    private List<Integer>[] reporterlist = new ArrayList[8];
    private List<Boolean> circlelist;
    private int setup_index;
    private int num_issues;
    boolean geofile_ok;
    private int num_setups;
    private Scale _layout_scale;
    float layout_scale;
    private ArrayList<LayoutEditor> panels;
    private ArrayList<LayoutEditor> panelsFinal;
    HashMap<Block, LayoutEditor> possibleStartBlocks;
    ArrayList<Block> blockList;
    private LayoutEditor models;
    PhysicalLocation models_origin;
    int lf_version;
    int alf_version;
    private String check_time_str;
    private static final Logger log = LoggerFactory.getLogger(VSDGeoFile.class);

    public VSDGeoFile() {
        this.blockPositionlists = new ArrayList<List<PhysicalLocation>>();
        this.blockPositionlist = new ArrayList[8];
        for (int i = 0; i < 8; ++i) {
            this.reporterlist[i] = new ArrayList<Integer>();
            this.blockPositionlist[i] = new ArrayList<PhysicalLocation>();
        }
        this.circlelist = new ArrayList<Boolean>();
        this.models = null;
        this.geofile_ok = false;
        File file = new File(FileUtil.getUserFilesPath() + VSDGeoDataFileName);
        if (!file.exists()) {
            log.debug("File {} for train tracking is not available", (Object)VSDGeoDataFileName);
            this.lf_version = 1;
            return;
        }
        try {
            this.root = this.rootFromFile(file);
        }
        catch (Exception e) {
            log.error("Exception while loading file {}", (Object)VSDGeoDataFileName, (Object)e);
            return;
        }
        String n = this.root.getChildText("layout-scale");
        if (n != null) {
            this._layout_scale = ScaleManager.getScale(n);
            if (this._layout_scale == null) {
                this._layout_scale = ScaleManager.getScale("N");
                log.info("File {}: Element layout-scale '{}' unknown, defaulting to N", (Object)VSDGeoDataFileName, (Object)n);
            }
        } else {
            this._layout_scale = ScaleManager.getScale("N");
            log.info("File {}: Element layout-scale missing, defaulting to N", (Object)VSDGeoDataFileName);
        }
        this.layout_scale = (float)this._layout_scale.getScaleRatio();
        log.debug("layout-scale: {}, used for further calculations: {}", (Object)this._layout_scale, (Object)Float.valueOf(this.layout_scale));
        this.check_time_str = "2000";
        n = this.root.getChildText("check-time");
        if (n != null) {
            this.check_time_str = n.trim();
        }
        log.debug("check time: {}", (Object)this.check_time_str);
        n = this.root.getChildText("setup");
        if (n != null && !n.isEmpty()) {
            log.debug("A setup found for ALF version 1");
            this.alf_version = 1;
            ThreadingUtil.runOnGUI(() -> this.readGeoInfos());
        } else {
            n = this.root.getChildText("models");
            if (n == null || n.isEmpty()) {
                log.warn("No Panel specified in {}", (Object)VSDGeoDataFileName);
            } else {
                this.panels = new ArrayList<LayoutEditor>(InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class));
                if (this.panels.isEmpty()) {
                    log.warn("No Panel loaded. Please restart PanelPro and load Panel \"{}\" first", (Object)n);
                    return;
                }
                for (LayoutEditor panel : this.panels) {
                    log.debug("checking panel \"{}\" ... looking for \"{}\"", (Object)panel.getTitle(), (Object)n);
                    if (!n.equals(panel.getTitle())) continue;
                    this.models = panel;
                    break;
                }
                if (this.models == null) {
                    log.error("Loaded Panel \"{}\" does not match with specified Panel \"{}\". Please correct and restart PanelPro", this.panels, (Object)n);
                } else {
                    log.debug("selected panel: {}", (Object)this.models.getTitle());
                    n = this.root.getChildText("models-origin");
                    if (n != null && !n.isEmpty()) {
                        this.models_origin = PhysicalLocation.parse(n);
                        log.debug("models-origin: {}", (Object)this.models_origin);
                    } else {
                        this.models_origin = new PhysicalLocation(346.0f, 260.0f, 0.0f);
                    }
                    this.alf_version = 2;
                    log.debug("ALF version: {}", (Object)this.alf_version);
                    this.readPanelInfos();
                }
            }
        }
    }

    private void readGeoInfos() {
        this.num_issues = 0;
        this.num_setups = 0;
        int num_geodatasets = 0;
        int max_geodatasets = 0;
        for (Element c : this.root.getChildren("setup")) {
            num_geodatasets = c.getChildren("geodataset").size();
            log.debug("setup {} has {} geodataset(s)", (Object)(this.num_setups + 1), (Object)num_geodatasets);
            if (num_geodatasets > max_geodatasets) {
                max_geodatasets = num_geodatasets;
            }
            ++this.num_setups;
        }
        log.debug("counting setups: {}, maximum geodatasets: {}", (Object)this.num_setups, (Object)max_geodatasets);
        if (this.num_setups == 0 || num_geodatasets == 0 || this.num_setups > 8) {
            log.warn("File {}: Invalid number of setups or geodatasets", (Object)VSDGeoDataFileName);
            this.geofile_ok = false;
            return;
        }
        this.blockParameter = new float[this.num_setups][max_geodatasets][5];
        this.setup_index = 0;
        for (Element c0 : this.root.getChildren("setup")) {
            log.debug("--- SETUP: {}", (Object)(this.setup_index + 1));
            boolean is_end_position_set = false;
            int j = 0;
            for (Element c1 : c0.getChildren("geodataset")) {
                String n;
                int rep_int = 0;
                if (c1.getChildText("reporter-systemname") != null) {
                    String np = c1.getChildText("reporter-systemname");
                    Reporter rep = InstanceManager.getDefault(ReporterManager.class).getBySystemName(np);
                    if (rep != null) {
                        try {
                            rep_int = Integer.parseInt(Manager.getSystemSuffix(rep.getSystemName()));
                        }
                        catch (NumberFormatException e) {
                            log.warn("File {}: Reporter System Name '{}' is not valid for VSD", (Object)VSDGeoDataFileName, (Object)np);
                            ++this.num_issues;
                        }
                        this.reporterlist[this.setup_index].add(rep_int);
                        n = c1.getChildText("position");
                        if (n != null) {
                            PhysicalLocation pl = PhysicalLocation.parse(n);
                            this.blockPositionlist[this.setup_index].add(pl);
                            PhysicalLocation.setBeanPhysicalLocation(pl, rep);
                            log.debug("Reporter: {}, position set to: {}", (Object)rep, (Object)pl);
                        } else {
                            log.warn("File {}: Element position not found", (Object)VSDGeoDataFileName);
                            ++this.num_issues;
                        }
                    } else {
                        log.warn("File {}: No Reporter available for system name = {}", (Object)VSDGeoDataFileName, (Object)np);
                        ++this.num_issues;
                    }
                } else {
                    log.warn("File {}: Reporter system name missing", (Object)VSDGeoDataFileName);
                    ++this.num_issues;
                }
                if (this.num_issues == 0) {
                    n = c1.getChildText("radius");
                    if (n != null) {
                        this.blockParameter[this.setup_index][j][0] = Float.parseFloat(n);
                        log.debug(" radius: {}", (Object)n);
                    } else {
                        log.warn("File {}: Element radius not found", (Object)VSDGeoDataFileName);
                        ++this.num_issues;
                    }
                    n = c1.getChildText("slope");
                    if (n != null) {
                        this.blockParameter[this.setup_index][j][1] = Float.parseFloat(n);
                        log.debug(" slope: {}", (Object)n);
                    } else if (this.blockParameter[this.setup_index][j][0] == 0.0f) {
                        log.warn("File {}: Element slope not found", (Object)VSDGeoDataFileName);
                        ++this.num_issues;
                    }
                    n = c1.getChildText("rotate-xpos");
                    if (n != null) {
                        this.blockParameter[this.setup_index][j][2] = Float.parseFloat(n);
                        log.debug(" rotate-xpos: {}", (Object)n);
                    } else if (this.blockParameter[this.setup_index][j][0] > 0.0f) {
                        log.warn("File {}: Element rotate-xpos not found", (Object)VSDGeoDataFileName);
                        ++this.num_issues;
                    }
                    n = c1.getChildText("rotate-ypos");
                    if (n != null) {
                        this.blockParameter[this.setup_index][j][3] = Float.parseFloat(n);
                        log.debug(" rotate-ypos: {}", (Object)n);
                    } else if (this.blockParameter[this.setup_index][j][0] > 0.0f) {
                        log.warn("File {}: Element rotate-ypos not found", (Object)VSDGeoDataFileName);
                        ++this.num_issues;
                    }
                    n = c1.getChildText("length");
                    if (n != null) {
                        this.blockParameter[this.setup_index][j][4] = Float.parseFloat(n);
                        log.debug(" length: {}", (Object)n);
                    } else {
                        log.warn("File {}: Element length not found", (Object)VSDGeoDataFileName);
                        ++this.num_issues;
                    }
                    n = c1.getChildText("end-position");
                    if (n != null) {
                        if (!is_end_position_set) {
                            this.blockPositionlist[this.setup_index].add(PhysicalLocation.parse(n));
                            is_end_position_set = true;
                            log.debug("end-position for location {} set to {}", (Object)j, (Object)this.blockPositionlist[this.setup_index].get(this.blockPositionlist[this.setup_index].size() - 1));
                        } else {
                            log.warn("File {}: Only the last geodataset should have an end-position", (Object)VSDGeoDataFileName);
                            ++this.num_issues;
                        }
                    }
                }
                ++j;
            }
            if (!is_end_position_set) {
                log.warn("File {}: End-position missing for setup {}", (Object)VSDGeoDataFileName, (Object)(this.setup_index + 1));
                ++this.num_issues;
            }
            this.addLists();
            ++this.setup_index;
        }
        this.finishRead();
    }

    private void readPanelInfos() {
        int max_geodatasets = 0;
        this.possibleStartBlocks = new HashMap();
        this.blockList = new ArrayList();
        log.debug("Found panel: {}", (Object)this.models);
        this.panels = new ArrayList<LayoutEditor>(InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class));
        this.panelsFinal = new ArrayList();
        for (LayoutEditor layoutEditor : this.panels) {
            for (LayoutTrack layoutTrack : layoutEditor.getLayoutTracks()) {
                PositionablePoint pp;
                if (!(layoutTrack instanceof PositionablePoint) || (pp = (PositionablePoint)layoutTrack).getType() != PositionablePoint.PointType.EDGE_CONNECTOR || this.panelsFinal.contains(layoutEditor)) continue;
                this.panelsFinal.add(layoutEditor);
            }
        }
        log.debug("edge panels: {}", this.panelsFinal);
        if (this.panelsFinal.isEmpty()) {
            this.panelsFinal.add(this.models);
        }
        log.debug("final panels: {}", this.panelsFinal);
        int max_ts = 0;
        for (LayoutEditor p : this.panelsFinal) {
            for (LayoutTrack lt : p.getLayoutTracks()) {
                if (lt instanceof LayoutTurnout) {
                    ++max_geodatasets;
                    continue;
                }
                if (lt instanceof TrackSegment) {
                    ++max_geodatasets;
                    ++max_ts;
                    continue;
                }
                if (lt instanceof LevelXing) {
                    ++max_geodatasets;
                    ++max_geodatasets;
                    continue;
                }
                log.debug("no LayoutTurnout, no TrackSegment, no PositionablePoint, but: {}", (Object)lt);
            }
        }
        log.debug("number of turnouts and track segments: {}", (Object)max_geodatasets);
        if (max_geodatasets == 0) {
            log.warn("Panel must have minimum one layout track");
            return;
        }
        if (max_ts == 0) {
            log.warn("Panel must have minimum one track segment");
            return;
        }
        BlockManager blockManager = InstanceManager.getDefault(BlockManager.class);
        SortedSet blockSet = blockManager.getNamedBeanSet();
        if (blockSet.isEmpty()) {
            log.warn("Panel must have minimum one block");
            return;
        }
        LayoutBlockManager layoutBlockManager = InstanceManager.getDefault(LayoutBlockManager.class);
        log.debug("panels: {}", this.panelsFinal);
        for (LayoutEditor le : this.panelsFinal) {
            log.debug("### panel: {}", (Object)le);
            for (Block bl : blockSet) {
                LayoutBlock lblk;
                String userName2;
                if (bl == null || (userName2 = bl.getUserName()) == null || (lblk = (LayoutBlock)layoutBlockManager.getByUserName(userName2)) == null) continue;
                log.debug("File {}, block system name: {}, user name: {}", new Object[]{le.getTitle(), bl.getSystemName(), userName2});
                int tsInBlock = 0;
                ArrayList<LayoutTrack> layoutTracksInBlock = new ArrayList<LayoutTrack>();
                for (LayoutTrack lt : le.getLayoutTracks()) {
                    LayoutTurntable tt;
                    if (lt instanceof LayoutTurnout) {
                        LayoutTurnout to = (LayoutTurnout)lt;
                        if (to.getLayoutBlock() != lblk) continue;
                        layoutTracksInBlock.add(lt);
                        this.blockList.add(bl);
                        continue;
                    }
                    if (lt instanceof TrackSegment) {
                        TrackSegment ts = (TrackSegment)lt;
                        if (ts.getLayoutBlock() != lblk) continue;
                        layoutTracksInBlock.add(lt);
                        this.blockList.add(bl);
                        ++tsInBlock;
                        continue;
                    }
                    if (lt instanceof LevelXing) {
                        LevelXing lx = (LevelXing)lt;
                        if (lx.getLayoutBlockAC() != lblk && lx.getLayoutBlockBD() != lblk) continue;
                        layoutTracksInBlock.add(lt);
                        this.blockList.add(bl);
                        continue;
                    }
                    if (!(lt instanceof LayoutTurntable) || (tt = (LayoutTurntable)lt).getLayoutBlock() != lblk) continue;
                    layoutTracksInBlock.add(lt);
                    this.blockList.add(bl);
                }
                log.debug("layoutTracksInBlock: {}", layoutTracksInBlock);
                if (tsInBlock != true || this.possibleStartBlocks.get(bl) != null) continue;
                this.possibleStartBlocks.put(bl, le);
            }
        }
        log.debug("Block list: {}, possible start-blocks: {}", this.blockList, this.possibleStartBlocks);
        this.geofile_ok = true;
    }

    private void addLists() {
        if (this.num_issues == 0) {
            this.reporterlists.add(this.reporterlist[this.setup_index]);
            this.blockPositionlists.add(this.blockPositionlist[this.setup_index]);
            int last_index = this.blockPositionlist[this.setup_index].size() - 1;
            log.debug("first setup position: {}, last setup position: {}", (Object)this.blockPositionlist[this.setup_index].get(0), (Object)this.blockPositionlist[this.setup_index].get(last_index));
            if (this.blockPositionlist[this.setup_index].get(0) != null && this.blockPositionlist[this.setup_index].get((int)0).x == this.blockPositionlist[this.setup_index].get((int)last_index).x && this.blockPositionlist[this.setup_index].get((int)0).y == this.blockPositionlist[this.setup_index].get((int)last_index).y && this.blockPositionlist[this.setup_index].get((int)0).z == this.blockPositionlist[this.setup_index].get((int)last_index).z) {
                this.circlelist.add(true);
            } else {
                this.circlelist.add(false);
            }
            log.debug("circling: {}", (Object)this.circlelist.get(this.setup_index));
        }
    }

    private void finishRead() {
        if (log.isDebugEnabled()) {
            log.debug("--- LISTS");
            log.debug("number of Reporter lists: {}", (Object)this.reporterlists.size());
            log.debug("Reporter lists with their Reporters (digit only): {}", this.reporterlists);
            log.debug("number of Position lists: {}", (Object)this.blockPositionlists.size());
            log.debug("Position lists: {}", this.blockPositionlists);
            log.debug("--- COUNTERS");
            log.debug("number of setups: {}", (Object)this.num_setups);
            log.debug("number of issues: {}", (Object)this.num_issues);
        }
        this.setGeoFileStatus();
    }

    private void setGeoFileStatus() {
        if (this.num_issues > 0) {
            this.geofile_ok = false;
            log.warn("set geofile to not ok");
        } else {
            this.geofile_ok = true;
        }
    }

    int getCheckTime() {
        int check_time = 2000;
        if (StringUtils.isNumeric((CharSequence)this.check_time_str)) {
            int ct = Integer.parseInt(this.check_time_str);
            if (ct >= 500 && ct <= 5000) {
                check_time = ct;
            } else {
                log.info("Parameter check-time not in range 500 - 5000, defaulting to {} ms", (Object)ct);
            }
        } else {
            log.info("Parameter check-time not numeric, defaulting to {} ms", (Object)check_time);
        }
        return check_time;
    }

    public int getNumberOfSetups() {
        return this.num_setups;
    }

    public List<List<Integer>> getReporterList() {
        return this.reporterlists;
    }

    public float[][][] getBlockParameter() {
        return this.blockParameter;
    }

    public List<List<PhysicalLocation>> getBlockPosition() {
        return this.blockPositionlists;
    }

    public List<Boolean> getCirclingList() {
        return this.circlelist;
    }
}

