/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import jmri.Block;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutSlipView;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LayoutTurnoutView;
import jmri.jmrit.display.layoutEditor.LayoutTurntable;
import jmri.jmrit.display.layoutEditor.LayoutTurntableView;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.LevelXingView;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.display.layoutEditor.TrackSegmentView;
import jmri.jmrit.vsdecoder.VSDecoder;
import jmri.jmrit.vsdecoder.VSDecoderManager;
import jmri.util.ArrayUtil;
import jmri.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSDNavigation {
    private VSDecoder d;
    private boolean use_blocks = VSDecoderManager.instance().getVSDecoderPreferences().getUseBlocksSetting();
    private int lastTurntablePosition = -1;
    private static final Logger log = LoggerFactory.getLogger(VSDNavigation.class);

    VSDNavigation(VSDecoder vsd) {
        this.d = vsd;
    }

    boolean navigatePositionalPoint() {
        boolean result = true;
        PositionablePoint pp = (PositionablePoint)this.d.getLayoutTrack();
        PositionablePoint.PointType type = pp.getType();
        switch (type) {
            case ANCHOR: {
                if (pp.getConnect1().equals(this.d.getLastTrack())) {
                    this.d.setLayoutTrack(pp.getConnect2());
                    this.d.setReturnTrack(this.d.getLayoutTrack());
                } else if (pp.getConnect2().equals(this.d.getLastTrack())) {
                    this.d.setLayoutTrack(pp.getConnect1());
                    this.d.setReturnTrack(this.d.getLayoutTrack());
                } else {
                    result = false;
                    break;
                }
                this.d.setLastTrack(pp);
                break;
            }
            default: {
                this.d.setReturnTrack(pp.getConnect1());
                this.d.distanceOnTrack = this.d.getReturnDistance();
                this.d.setDistance(0.0);
                result = false;
                break;
            }
            case EDGE_CONNECTOR: {
                TrackSegment ts2 = null;
                if (pp.getLinkedPoint() != null) {
                    ts2 = pp.getLinkedPoint().getConnect1();
                    this.d.setModels(pp.getLinkedEditor());
                    this.d.setLayoutTrack(ts2);
                    this.d.setReturnTrack(this.d.getLayoutTrack());
                    if (pp.getLinkedPoint().equals(ts2.getConnect1())) {
                        this.d.setLastTrack(ts2.getConnect1());
                        break;
                    }
                    if (pp.getLinkedPoint().equals(ts2.getConnect2())) {
                        this.d.setLastTrack(ts2.getConnect2());
                        break;
                    }
                    log.warn(" EdgeConnector lost");
                    break;
                }
                log.warn(" EdgeConnector is not linked");
                this.d.setReturnTrack(this.d.getLastTrack());
                this.d.distanceOnTrack = this.d.getReturnDistance();
                this.d.setDistance(0.0);
                result = false;
                break;
            }
        }
        return result;
    }

    boolean navigateTrackSegment() {
        boolean result = false;
        if (this.use_blocks && ((TrackSegment)this.d.getLayoutTrack()).getLayoutBlock().getBlock() != VSDecoderManager.instance().currentBlock.get(this.d)) {
            this.d.setDistance(0.0);
            return result;
        }
        double distanceOnTrack = this.d.getDistance() + this.d.distanceOnTrack;
        this.d.nextLayoutTrack = null;
        TrackSegmentView tsv = this.d.getModels().getTrackSegmentView((TrackSegment)this.d.getLayoutTrack());
        if (tsv.isArc()) {
            Point2D.Double radius2D = new Point2D.Double(tsv.getCW() / 2.0, tsv.getCH() / 2.0);
            double radius = (((Point2D)radius2D).getX() + ((Point2D)radius2D).getY()) / 2.0;
            Point2D centre = tsv.getCentre();
            double tmpAngleDEG = tsv.getTmpAngle();
            double distance = 2.0 * radius * Math.PI * tmpAngleDEG / 360.0;
            this.d.setReturnDistance(distance);
            if (distanceOnTrack < distance) {
                Point2D p1 = this.d.getModels().getCoords(tsv.getConnect1(), tsv.getType1());
                Point2D p2 = this.d.getModels().getCoords(tsv.getConnect2(), tsv.getType2());
                if (!tsv.isCircle()) {
                    centre = MathUtil.midPoint(p1, p2);
                    Point2D centreSeg = tsv.getCentreSeg();
                    double newX = centre.getX() < centreSeg.getX() ? Math.min(p1.getX(), p2.getX()) : Math.max(p1.getX(), p2.getX());
                    double newY = centre.getY() < centreSeg.getY() ? Math.min(p1.getY(), p2.getY()) : Math.max(p1.getY(), p2.getY());
                    centre = new Point2D.Double(newX, newY);
                }
                double angle1DEG = MathUtil.computeAngleDEG(p1, centre) - 90.0;
                double angle2DEG = MathUtil.computeAngleDEG(p2, centre) - 90.0;
                Point2D centreSeg = tsv.getCentreSeg();
                double angle3DEG = MathUtil.computeAngleDEG(centreSeg, centre) - 90.0;
                double angleDeltaDEG = MathUtil.wrapPM360(2.0 * (angle3DEG - angle1DEG));
                double ratio = distanceOnTrack / distance;
                Point2D delta = new Point2D.Double(radius, 0.0);
                double angleDEG = 0.0;
                if (tsv.getConnect1().equals(this.d.getLastTrack())) {
                    this.d.nextLayoutTrack = tsv.getConnect2();
                    this.d.setReturnLastTrack(tsv.getConnect2());
                    angleDEG = angle1DEG;
                    angleDeltaDEG = MathUtil.lerp(0.0, angleDeltaDEG, ratio);
                } else if (tsv.getConnect2().equals(this.d.getLastTrack())) {
                    this.d.nextLayoutTrack = tsv.getConnect1();
                    this.d.setReturnLastTrack(tsv.getConnect1());
                    angleDEG = angle2DEG;
                    angleDeltaDEG = MathUtil.lerp(0.0, -angleDeltaDEG, ratio);
                } else {
                    log.info(" lost");
                    result = false;
                    angleDeltaDEG = 0.0;
                }
                double dirDeltaDEG = Math.signum(angleDeltaDEG) * -90.0;
                double newAngleDeg = -(angleDEG + angleDeltaDEG);
                delta = MathUtil.rotateDEG(delta, newAngleDeg);
                if (!tsv.isCircle()) {
                    delta = MathUtil.multiply(delta, ((Point2D)radius2D).getX() / radius, ((Point2D)radius2D).getY() / radius);
                }
                this.d.setLocation(MathUtil.add(centre, delta));
                this.d.setDirectionDEG(newAngleDeg + dirDeltaDEG);
                this.d.setDistance(0.0);
            } else {
                this.d.nextLayoutTrack = tsv.getConnect2();
                if (tsv.getConnect2().equals(this.d.getLastTrack())) {
                    this.d.nextLayoutTrack = tsv.getConnect1();
                }
                this.d.setDistance(distanceOnTrack - distance);
                distanceOnTrack = 0.0;
                result = true;
            }
            this.d.distanceOnTrack = distanceOnTrack;
        } else if (tsv.isBezier()) {
            Point2D ep1 = this.d.getModels().getCoords(tsv.getConnect1(), tsv.getType1());
            Point2D ep2 = this.d.getModels().getCoords(tsv.getConnect2(), tsv.getType2());
            int cnt = tsv.getBezierControlPoints().size() + 2;
            Point2D[] points = new Point2D[cnt];
            points[0] = ep1;
            for (int idx = 0; idx < cnt - 2; ++idx) {
                points[idx + 1] = tsv.getBezierControlPoints().get(idx);
            }
            points[cnt - 1] = ep2;
            double distance = MathUtil.drawBezier(null, points);
            this.d.setReturnDistance(distance);
            if (distanceOnTrack < distance) {
                this.d.nextLayoutTrack = tsv.getConnect2();
                this.d.setReturnLastTrack(tsv.getConnect2());
                if (tsv.getConnect2().equals(this.d.getLastTrack())) {
                    points = ArrayUtil.reverse(points);
                    this.d.nextLayoutTrack = tsv.getConnect1();
                    this.d.setReturnLastTrack(tsv.getConnect1());
                }
                GeneralPath path = MathUtil.getBezierPath(points);
                PathIterator i = path.getPathIterator(null);
                ArrayList<Point2D> pathPoints = new ArrayList<Point2D>();
                while (!i.isDone()) {
                    float[] data = new float[6];
                    switch (i.currentSegment(data)) {
                        case 0: 
                        case 1: {
                            pathPoints.add(new Point2D.Double(data[0], data[1]));
                            break;
                        }
                        default: {
                            log.error("Unknown path segment type: {}.", (Object)i.currentSegment(data));
                            log.info(" bezier lost");
                            result = false;
                        }
                    }
                    i.next();
                }
                return this.navigate(pathPoints, this.d.nextLayoutTrack);
            }
            this.d.nextLayoutTrack = tsv.getConnect2();
            if (tsv.getConnect2().equals(this.d.getLastTrack())) {
                this.d.nextLayoutTrack = tsv.getConnect1();
            }
            this.d.setDistance(distanceOnTrack - distance);
            distanceOnTrack = 0.0;
            result = true;
            this.d.distanceOnTrack = distanceOnTrack;
        } else {
            Point2D p1 = this.d.getModels().getCoords(tsv.getConnect1(), tsv.getType1());
            Point2D p2 = this.d.getModels().getCoords(tsv.getConnect2(), tsv.getType2());
            double distance = MathUtil.distance(p1, p2);
            this.d.setReturnDistance(distance);
            if (distanceOnTrack < distance) {
                if (tsv.getConnect1().equals(this.d.getLastTrack())) {
                    this.d.nextLayoutTrack = tsv.getConnect2();
                    this.d.setReturnLastTrack(tsv.getConnect2());
                } else if (tsv.getConnect2().equals(this.d.getLastTrack())) {
                    this.d.nextLayoutTrack = tsv.getConnect1();
                    this.d.setReturnLastTrack(tsv.getConnect1());
                    Point2D temp = p1;
                    p1 = p2;
                    p2 = temp;
                } else {
                    result = false;
                }
                double ratio = distanceOnTrack / distance;
                this.d.setLocation(MathUtil.lerp(p1, p2, ratio));
                this.d.setDirectionRAD(1.5707963267948966 - MathUtil.computeAngleRAD(p2, p1));
                this.d.setDistance(0.0);
            } else {
                if (tsv.getConnect1().equals(this.d.getLastTrack())) {
                    this.d.nextLayoutTrack = tsv.getConnect2();
                } else if (tsv.getConnect2().equals(this.d.getLastTrack())) {
                    this.d.nextLayoutTrack = tsv.getConnect1();
                }
                this.d.setDistance(distanceOnTrack - distance);
                distanceOnTrack = 0.0;
                result = true;
            }
            this.d.distanceOnTrack = distanceOnTrack;
        }
        if (result) {
            LayoutTrack last = this.d.getLayoutTrack();
            if (this.d.nextLayoutTrack != null) {
                this.d.setLayoutTrack(this.d.nextLayoutTrack);
            } else {
                result = false;
            }
            if (result) {
                this.d.setLastTrack(last);
                this.d.setReturnTrack(this.d.getLayoutTrack());
                this.d.setReturnLastTrack(this.d.getLayoutTrack());
            }
        }
        this.d.setTunnelState(tsv.isTunnelSideRight() || tsv.isTunnelSideLeft() || tsv.isTunnelHasEntry() || tsv.isTunnelHasExit());
        return result;
    }

    boolean navigateLayoutTurnout() {
        boolean result = false;
        if (this.use_blocks && ((LayoutTurnout)this.d.getLayoutTrack()).getLayoutBlock().getBlock() != VSDecoderManager.instance().currentBlock.get(this.d)) {
            this.d.setDistance(0.0);
            return result;
        }
        double distanceOnTrack = this.d.getDistance() + this.d.distanceOnTrack;
        LayoutTurnoutView tv = this.d.getModels().getLayoutTurnoutView((LayoutTurnout)this.d.getLayoutTrack());
        Point2D pM = tv.getCoordsCenter();
        Point2D pA = tv.getCoordsA();
        Point2D pB = tv.getCoordsB();
        Point2D pC = tv.getCoordsC();
        Point2D pD = tv.getCoordsD();
        int state = 1;
        if (this.d.getModels().isAnimating()) {
            state = tv.getState();
        }
        if (state != 2 && state != 4) {
            log.info("have to stop - state: {}", (Object)state);
            result = false;
        }
        this.d.nextLayoutTrack = null;
        switch (tv.getTurnoutType()) {
            case RH_TURNOUT: 
            case LH_TURNOUT: 
            case WYE_TURNOUT: {
                Point2D pStart = null;
                Point2D pEnd = null;
                if (tv.getConnectA().equals(this.d.getLastTrack())) {
                    pStart = pA;
                    if (state == 2) {
                        pEnd = pB;
                        this.d.nextLayoutTrack = tv.getConnectB();
                    } else if (state == 4) {
                        pEnd = pC;
                        this.d.nextLayoutTrack = tv.getConnectC();
                    }
                } else if (tv.getConnectB().equals(this.d.getLastTrack())) {
                    if (state == 2) {
                        pStart = pB;
                        pEnd = pA;
                        this.d.nextLayoutTrack = tv.getConnectA();
                    }
                } else if (tv.getConnectC().equals(this.d.getLastTrack())) {
                    if (state == 4) {
                        pStart = pC;
                        pEnd = pA;
                        this.d.nextLayoutTrack = tv.getConnectA();
                    }
                } else {
                    result = false;
                }
                if (this.d.nextLayoutTrack != null) {
                    this.d.setReturnLastTrack(this.d.nextLayoutTrack);
                    this.d.setReturnTrack(this.d.getLayoutTrack());
                    this.d.setDistance(0.0);
                }
                if (pStart != null) {
                    double distanceStart = MathUtil.distance(pStart, pM);
                    this.d.setReturnDistance(distanceStart);
                    if (distanceOnTrack < distanceStart) {
                        double ratio = distanceOnTrack / distanceStart;
                        this.d.setLocation(MathUtil.lerp(pStart, pM, ratio));
                        this.d.setDirectionRAD(1.5707963267948966 - MathUtil.computeAngleRAD(pM, pStart));
                        this.d.setDistance(0.0);
                        break;
                    }
                    if (pEnd != null) {
                        double distanceEnd = MathUtil.distance(pM, pEnd);
                        this.d.setReturnDistance(distanceEnd);
                        if (distanceOnTrack - distanceStart < distanceEnd) {
                            double ratio = (distanceOnTrack - distanceStart) / distanceEnd;
                            this.d.setLocation(MathUtil.lerp(pM, pEnd, ratio));
                            this.d.setDirectionRAD(1.5707963267948966 - MathUtil.computeAngleRAD(pEnd, pM));
                            this.d.setDistance(0.0);
                            break;
                        }
                        this.d.setDistance(distanceOnTrack - (distanceStart + distanceEnd));
                        distanceOnTrack = 0.0;
                        result = true;
                        break;
                    }
                    log.info(" Turnout has unknown state");
                    result = false;
                    distanceOnTrack = distanceStart;
                    this.d.setDistance(0.0);
                    this.d.setReturnDistance(0.0);
                    this.d.setReturnTrack(this.d.getLastTrack());
                    break;
                }
                log.info(" Turnout caused a stop");
                result = false;
                distanceOnTrack = 0.0;
                this.d.setDistance(0.0);
                this.d.setReturnDistance(0.0);
                this.d.setReturnTrack(this.d.getLastTrack());
                break;
            }
            case RH_XOVER: 
            case LH_XOVER: 
            case DOUBLE_XOVER: {
                Point2D pCDM;
                Point2D pABM;
                ArrayList<Point2D> points = new ArrayList<Point2D>();
                Point2D pAM = pABM = MathUtil.midPoint(pA, pB);
                Point2D pBM = pABM;
                Point2D pCM = pCDM = MathUtil.midPoint(pC, pD);
                Point2D pDM = pCDM;
                if (tv.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER) {
                    pAM = MathUtil.lerp(pA, pABM, 0.625);
                    pBM = MathUtil.lerp(pB, pABM, 0.625);
                    pCM = MathUtil.lerp(pC, pCDM, 0.625);
                    pDM = MathUtil.lerp(pD, pCDM, 0.625);
                }
                if (tv.getConnectA().equals(this.d.getLastTrack())) {
                    if (state == 2) {
                        points.add(pA);
                        points.add(pB);
                        this.d.nextLayoutTrack = tv.getConnectB();
                    } else if (tv.getTurnoutType() != LayoutTurnout.TurnoutType.LH_XOVER && state == 4) {
                        points.add(pA);
                        points.add(pAM);
                        points.add(pCM);
                        points.add(pC);
                        this.d.nextLayoutTrack = tv.getConnectC();
                    }
                } else if (tv.getConnectB().equals(this.d.getLastTrack())) {
                    if (state == 2) {
                        points.add(pB);
                        points.add(pA);
                        this.d.nextLayoutTrack = tv.getConnectA();
                    } else if (tv.getTurnoutType() != LayoutTurnout.TurnoutType.RH_XOVER && state == 4) {
                        points.add(pB);
                        points.add(pBM);
                        points.add(pDM);
                        points.add(pD);
                        this.d.nextLayoutTrack = tv.getConnectD();
                    }
                } else if (tv.getConnectC().equals(this.d.getLastTrack())) {
                    if (state == 2) {
                        points.add(pC);
                        points.add(pD);
                        this.d.nextLayoutTrack = tv.getConnectD();
                    } else if (tv.getTurnoutType() != LayoutTurnout.TurnoutType.LH_XOVER && state == 4) {
                        points.add(pC);
                        points.add(pCM);
                        points.add(pAM);
                        points.add(pA);
                        this.d.nextLayoutTrack = tv.getConnectA();
                    }
                } else if (tv.getConnectD().equals(this.d.getLastTrack())) {
                    if (state == 2) {
                        points.add(pD);
                        points.add(pC);
                        this.d.nextLayoutTrack = tv.getConnectC();
                    } else if (tv.getTurnoutType() != LayoutTurnout.TurnoutType.RH_XOVER && state == 4) {
                        points.add(pD);
                        points.add(pDM);
                        points.add(pBM);
                        points.add(pB);
                        this.d.nextLayoutTrack = tv.getConnectB();
                    }
                } else {
                    result = false;
                }
                if (this.d.nextLayoutTrack != null) {
                    this.d.setReturnLastTrack(this.d.nextLayoutTrack);
                    this.d.setReturnTrack(this.d.getLayoutTrack());
                }
                return this.navigate(points, this.d.nextLayoutTrack);
            }
            case SINGLE_SLIP: 
            case DOUBLE_SLIP: {
                log.warn("TurnoutView {}.navigate(...); slips should be being handled by LayoutSlip sub-class", (Object)tv.getName());
                break;
            }
            default: {
                result = false;
            }
        }
        this.d.distanceOnTrack = distanceOnTrack;
        if (result) {
            LayoutTrack last = this.d.getLayoutTrack();
            if (this.d.nextLayoutTrack != null) {
                this.d.setLayoutTrack(this.d.nextLayoutTrack);
            } else {
                result = false;
            }
            if (result) {
                this.d.setLastTrack(last);
                this.d.setReturnTrack(this.d.getLayoutTrack());
                this.d.setReturnLastTrack(this.d.getLayoutTrack());
            }
        }
        return result;
    }

    boolean navigateLayoutSlip() {
        if (this.use_blocks && ((LayoutSlip)this.d.getLayoutTrack()).getLayoutBlock().getBlock() != VSDecoderManager.instance().currentBlock.get(this.d)) {
            this.d.setDistance(0.0);
            return false;
        }
        boolean result = true;
        LayoutSlipView ltv = this.d.getModels().getLayoutSlipView((LayoutSlip)this.d.getLayoutTrack());
        Point2D pA = ltv.getCoordsA();
        Point2D pB = ltv.getCoordsB();
        Point2D pC = ltv.getCoordsC();
        Point2D pD = ltv.getCoordsD();
        this.d.nextLayoutTrack = null;
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        double third = 0.3333333333333333;
        Point2D pACT = MathUtil.lerp(pA, pC, third);
        Point2D pBDT = MathUtil.lerp(pB, pD, third);
        Point2D pCAT = MathUtil.lerp(pC, pA, third);
        Point2D pDBT = MathUtil.lerp(pD, pB, third);
        int slipState = ltv.getSlipState();
        boolean slip_lost = false;
        if (ltv.getConnectA().equals(this.d.getLastTrack())) {
            if (slipState == 2) {
                points.add(pA);
                points.add(pC);
                this.d.nextLayoutTrack = ltv.getConnectC();
            } else if (slipState == 6) {
                points.add(pA);
                points.add(pACT);
                points.add(pDBT);
                points.add(pD);
                this.d.nextLayoutTrack = ltv.getConnectD();
            } else {
                result = false;
                slip_lost = true;
            }
        } else if (ltv.getConnectB().equals(this.d.getLastTrack())) {
            if (slipState == 4) {
                points.add(pB);
                points.add(pD);
                this.d.nextLayoutTrack = ltv.getConnectD();
            } else if (slipState == 8) {
                points.add(pB);
                points.add(pBDT);
                points.add(pCAT);
                points.add(pC);
                this.d.nextLayoutTrack = ltv.getConnectC();
            } else {
                result = false;
                slip_lost = true;
            }
        } else if (ltv.getConnectC().equals(this.d.getLastTrack())) {
            if (slipState == 2) {
                points.add(pC);
                points.add(pA);
                this.d.nextLayoutTrack = ltv.getConnectA();
            } else if (slipState == 8) {
                points.add(pC);
                points.add(pCAT);
                points.add(pBDT);
                points.add(pB);
                this.d.nextLayoutTrack = ltv.getConnectB();
            } else {
                result = false;
                slip_lost = true;
            }
        } else if (ltv.getConnectD().equals(this.d.getLastTrack())) {
            if (slipState == 4) {
                points.add(pD);
                points.add(pB);
                this.d.nextLayoutTrack = ltv.getConnectB();
            } else if (slipState == 6) {
                points.add(pD);
                points.add(pDBT);
                points.add(pACT);
                points.add(pA);
                this.d.nextLayoutTrack = ltv.getConnectA();
            } else {
                result = false;
                slip_lost = true;
            }
        } else {
            result = false;
        }
        if (this.d.nextLayoutTrack != null) {
            this.d.setReturnLastTrack(this.d.nextLayoutTrack);
            this.d.setReturnTrack(this.d.getLayoutTrack());
        }
        if (slip_lost) {
            log.info(" Turnout state not good");
            this.d.setDistance(0.0);
            this.d.setReturnDistance(0.0);
        }
        if (result) {
            result = this.navigate(points, this.d.nextLayoutTrack);
        }
        return result;
    }

    boolean navigateLevelXing() {
        boolean result = false;
        Block block2 = null;
        LevelXing lx = (LevelXing)this.d.getLayoutTrack();
        if (lx.getConnectA().equals(this.d.getLastTrack()) || lx.getConnectC().equals(this.d.getLastTrack())) {
            block2 = lx.getLayoutBlockAC().getBlock();
        } else if (lx.getConnectB().equals(this.d.getLastTrack()) || lx.getConnectD().equals(this.d.getLastTrack())) {
            block2 = lx.getLayoutBlockBD().getBlock();
        }
        if (this.use_blocks && block2 != VSDecoderManager.instance().currentBlock.get(this.d)) {
            this.d.setDistance(0.0);
            return result;
        }
        double distanceOnTrack = this.d.getDistance() + this.d.distanceOnTrack;
        LevelXingView lxv = this.d.getModels().getLevelXingView((LevelXing)this.d.getLayoutTrack());
        Point2D pA = lxv.getCoordsA();
        Point2D pB = lxv.getCoordsB();
        Point2D pC = lxv.getCoordsC();
        Point2D pD = lxv.getCoordsD();
        Point2D p1 = null;
        Point2D p2 = null;
        this.d.nextLayoutTrack = null;
        if (lxv.getConnectA().equals(this.d.getLastTrack())) {
            p1 = pA;
            p2 = pC;
            this.d.nextLayoutTrack = lxv.getConnectC();
        } else if (lxv.getConnectB().equals(this.d.getLastTrack())) {
            p1 = pB;
            p2 = pD;
            this.d.nextLayoutTrack = lxv.getConnectD();
        } else if (lxv.getConnectC().equals(this.d.getLastTrack())) {
            p1 = pC;
            p2 = pA;
            this.d.nextLayoutTrack = lxv.getConnectA();
        } else if (lxv.getConnectD().equals(this.d.getLastTrack())) {
            p1 = pD;
            p2 = pB;
            this.d.nextLayoutTrack = lxv.getConnectB();
            result = false;
        }
        if (this.d.nextLayoutTrack != null) {
            this.d.setReturnLastTrack(this.d.nextLayoutTrack);
            this.d.setReturnTrack(this.d.getLayoutTrack());
        }
        if (p1 != null) {
            double distance = MathUtil.distance(p1, p2);
            this.d.setReturnDistance(distance);
            if (distanceOnTrack < distance) {
                double ratio = distanceOnTrack / distance;
                this.d.setLocation(MathUtil.lerp(p1, p2, ratio));
                this.d.setDirectionRAD(1.5707963267948966 - MathUtil.computeAngleRAD(p2, p1));
                this.d.setDistance(0.0);
            } else {
                this.d.setDistance(distanceOnTrack - distance);
                distanceOnTrack = 0.0;
                result = true;
            }
            this.d.distanceOnTrack = distanceOnTrack;
        }
        if (result) {
            LayoutTrack last = this.d.getLayoutTrack();
            if (this.d.nextLayoutTrack != null) {
                this.d.setLayoutTrack(this.d.nextLayoutTrack);
            } else {
                result = false;
            }
            if (result) {
                this.d.setLastTrack(last);
                this.d.setReturnTrack(this.d.getLayoutTrack());
                this.d.setReturnLastTrack(this.d.getLayoutTrack());
            }
        }
        return result;
    }

    boolean navigateLayoutTurntable() {
        boolean result = false;
        if (this.use_blocks && !((LayoutTurntable)this.d.getLayoutTrack()).getBlockName().equals(VSDecoderManager.instance().currentBlock.get(this.d).getUserName())) {
            this.d.setDistance(0.0);
            return false;
        }
        double distanceOnTrack = this.d.getDistance() + this.d.distanceOnTrack;
        this.d.nextLayoutTrack = null;
        LayoutTurntable turntable = (LayoutTurntable)this.d.getLayoutTrack();
        LayoutTurntableView ttv = this.d.getModels().getLayoutTurntableView(turntable);
        int num_rays = turntable.getNumberRays();
        log.debug("turntable name: {}, number rays: {}", (Object)ttv.getName(), (Object)num_rays);
        Point2D pStart = null;
        Point2D pEnd = null;
        if (num_rays < 1) {
            log.warn("A turntable must have at least one ray (better two)");
        } else if (turntable.getPosition() < 0) {
            log.warn("Turntable position not set");
        } else {
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            for (int i = 0; i < num_rays; ++i) {
                points.add(ttv.getRayCoordsOrdered(i));
            }
            for (LayoutTurntable.RayTrack rt : turntable.getRayTrackList()) {
                if (!rt.getConnect().equals(this.d.getLastTrack())) continue;
                double counterAngle = MathUtil.wrap360(rt.getAngle() + 180.0);
                boolean found = false;
                int indexT = -1;
                for (LayoutTurntable.RayTrack rta : turntable.getRayTrackList()) {
                    if (counterAngle != rta.getAngle()) continue;
                    found = true;
                    indexT = rta.getConnectionIndex();
                    break;
                }
                if (!found) {
                    if (turntable.getPosition() == rt.getConnectionIndex()) {
                        log.warn("non-existent opposite ray track; please return");
                        break;
                    }
                    log.warn("Wrong turntable position - please correct or return");
                    break;
                }
                boolean is_turned = false;
                int indexH = rt.getConnectionIndex();
                if (this.lastTurntablePosition >= 0 && turntable.getPosition() != this.lastTurntablePosition) {
                    is_turned = true;
                    double newAngle = turntable.getRayTrackList().get(turntable.getPosition()).getAngle();
                    double lastAngle = MathUtil.wrap360(newAngle + 180.0);
                    boolean found2 = false;
                    for (LayoutTurntable.RayTrack rtb : turntable.getRayTrackList()) {
                        if (lastAngle != rtb.getAngle()) continue;
                        found2 = true;
                        indexH = rtb.getConnectionIndex();
                        break;
                    }
                    if (found2) {
                        this.d.setLastTrack(turntable.getRayConnectIndexed(indexH));
                        this.d.nextLayoutTrack = turntable.getRayConnectIndexed(turntable.getPosition());
                        indexT = turntable.getPosition();
                    } else {
                        log.info("non-existent opposite ray track)");
                    }
                }
                if (turntable.getPosition() == indexT || turntable.getPosition() == indexH) {
                    pStart = (Point2D)points.get(indexH);
                    pEnd = is_turned ? (Point2D)points.get(turntable.getPosition()) : (Point2D)points.get(indexT);
                    this.d.nextLayoutTrack = turntable.getRayConnectIndexed(indexT);
                    log.debug("Next layout track set to: {}", (Object)this.d.nextLayoutTrack);
                    this.lastTurntablePosition = turntable.getPosition();
                    break;
                }
                log.warn("Wrong turntable position - please correct position");
                break;
            }
        }
        if (this.d.nextLayoutTrack != null) {
            this.d.setReturnLastTrack(this.d.nextLayoutTrack);
            this.d.setReturnTrack(this.d.getLayoutTrack());
            this.d.setDistance(0.0);
        }
        if (this.d.nextLayoutTrack == null) {
            log.debug("Next layout track not set");
            result = false;
        }
        if (pStart != null && pEnd != null) {
            double distance = MathUtil.distance(pStart, pEnd);
            this.d.setReturnDistance(distance);
            if (distanceOnTrack < distance) {
                double ratio = distanceOnTrack / distance;
                this.d.setLocation(MathUtil.lerp(pStart, pEnd, ratio));
                this.d.setDirectionRAD(1.5707963267948966 - MathUtil.computeAngleRAD(pEnd, pStart));
                this.d.setDistance(0.0);
            } else {
                this.d.setDistance(distanceOnTrack - distance);
                distanceOnTrack = 0.0;
                result = true;
            }
        } else {
            log.info("Turntable caused a stop");
            result = false;
            distanceOnTrack = 0.0;
            this.d.setDistance(0.0);
            this.d.setReturnDistance(0.0);
            this.d.setReturnTrack(this.d.getLastTrack());
            log.debug("new d.distanceOnTrack: {}, distanceOnTrack: {}, last: {}", new Object[]{this.d.distanceOnTrack, distanceOnTrack, this.d.getLastTrack()});
        }
        this.d.distanceOnTrack = distanceOnTrack;
        if (result) {
            log.debug("go to next layout track: {}", (Object)this.d.nextLayoutTrack);
            LayoutTrack last = this.d.getLayoutTrack();
            if (this.d.nextLayoutTrack != null) {
                this.d.setLayoutTrack(this.d.nextLayoutTrack);
                this.lastTurntablePosition = -1;
            } else {
                log.info(" TURNTABLE RESULT lost");
                result = false;
            }
            if (result) {
                this.d.setLastTrack(last);
                this.d.setReturnTrack(this.d.getLayoutTrack());
                this.d.setReturnLastTrack(this.d.getLayoutTrack());
            }
        }
        return result;
    }

    private boolean navigate(List<Point2D> points, @CheckForNull LayoutTrack nextLayoutTrack) {
        boolean result = false;
        double distanceOnTrack = this.d.getDistance() + this.d.distanceOnTrack;
        boolean nextLegFlag = true;
        Point2D lastPoint = null;
        double trackDistance = 0.0;
        for (Point2D p : points) {
            double distance;
            if (lastPoint != null && distanceOnTrack < (trackDistance += (distance = MathUtil.distance(lastPoint, p)))) {
                this.d.setLocation(MathUtil.lerp(p, lastPoint, (trackDistance - distanceOnTrack) / distance));
                this.d.setDirectionRAD(1.5707963267948966 - MathUtil.computeAngleRAD(p, lastPoint));
                nextLegFlag = false;
                break;
            }
            lastPoint = p;
        }
        if (nextLegFlag) {
            this.d.setDistance(distanceOnTrack - trackDistance);
            distanceOnTrack = 0.0;
            result = true;
        } else {
            this.d.setDistance(0.0);
        }
        this.d.distanceOnTrack = distanceOnTrack;
        if (result) {
            LayoutTrack last = this.d.getLayoutTrack();
            if (nextLayoutTrack != null) {
                this.d.setLayoutTrack(nextLayoutTrack);
            } else {
                result = false;
            }
            if (result) {
                this.d.setLastTrack(last);
                this.d.setReturnTrack(this.d.getLayoutTrack());
                this.d.setReturnLastTrack(this.d.getLayoutTrack());
            }
        }
        return result;
    }
}

