/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.zip.ZipException;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LayoutTurntable;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.vsdecoder.ConfigurableSound;
import jmri.jmrit.vsdecoder.Diesel3Sound;
import jmri.jmrit.vsdecoder.DieselSound;
import jmri.jmrit.vsdecoder.EngineSound;
import jmri.jmrit.vsdecoder.EngineSoundEvent;
import jmri.jmrit.vsdecoder.MomentarySoundEvent;
import jmri.jmrit.vsdecoder.SoundEvent;
import jmri.jmrit.vsdecoder.Steam1Sound;
import jmri.jmrit.vsdecoder.SteamSound;
import jmri.jmrit.vsdecoder.ToggleSoundEvent;
import jmri.jmrit.vsdecoder.Trigger;
import jmri.jmrit.vsdecoder.VSDConfig;
import jmri.jmrit.vsdecoder.VSDFile;
import jmri.jmrit.vsdecoder.VSDNavigation;
import jmri.jmrit.vsdecoder.VSDSound;
import jmri.jmrit.vsdecoder.VSDecoderManager;
import jmri.jmrit.vsdecoder.swing.VSDControl;
import jmri.util.PhysicalLocation;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSDecoder
implements PropertyChangeListener {
    boolean initialized = false;
    private boolean enabled = false;
    private boolean create_xy_series = false;
    private VSDConfig config;
    int dirfn = 1;
    PhysicalLocation posToSet;
    PhysicalLocation lastPos;
    PhysicalLocation startPos;
    int topspeed;
    int topspeed_rev;
    int setup_index;
    boolean is_muted;
    double distanceOnTrack;
    float distanceMeter;
    double distance;
    private double returnDistance;
    private Point2D location;
    private LayoutTrack lastTrack;
    private LayoutTrack layoutTrack;
    private LayoutTrack returnTrack;
    private LayoutTrack returnLastTrack;
    LayoutTrack nextLayoutTrack;
    private double directionRAD;
    private LayoutEditor models;
    private VSDNavigation navigation;
    HashMap<String, VSDSound> sound_list;
    LinkedHashMap<String, SoundEvent> event_list;
    private static final Logger log = LoggerFactory.getLogger(VSDecoder.class);

    public VSDecoder(VSDConfig cfg) {
        this.config = cfg;
        this.sound_list = new HashMap();
        this.event_list = new LinkedHashMap();
        this.initialized = this._init();
        try {
            VSDFile vsdfile = new VSDFile(this.config.getVSDPath());
            if (vsdfile.isInitialized()) {
                log.debug("Constructor: vsdfile init OK, loading XML...");
                this.setXml(vsdfile, this.config.getProfileName());
            } else {
                log.debug("Constructor: vsdfile init FAILED.");
                this.initialized = false;
            }
        }
        catch (ZipException e) {
            log.error("ZipException loading VSDecoder from {}", (Object)this.config.getVSDPath());
        }
        catch (IOException ioe) {
            log.error("IOException loading VSDecoder from {}", (Object)this.config.getVSDPath());
        }
        if (this.getEngineSound().getBuffersFreeState()) {
            this.setAddress(this.config.getLocoAddress());
            this.enable();
            if (VSDecoderManager.instance().geofile_ok) {
                this.setup_index = 0;
                if (VSDecoderManager.instance().alf_version == 2) {
                    this.navigation = new VSDNavigation(this);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("VSDecoder Init Complete.  Audio Objects Created:");
                InstanceManager.getDefault(AudioManager.class).getNamedBeanSet('S').forEach(s -> log.debug("\tSource: {}", s));
                InstanceManager.getDefault(AudioManager.class).getNamedBeanSet('B').forEach(s -> log.debug("\tBuffer: {}", s));
            }
            log.info("Number of used buffers: {}, max: {}", (Object)InstanceManager.getDefault(AudioManager.class).getNamedBeanSet('B').size(), (Object)255);
        } else {
            this.disable();
        }
    }

    public VSDecoder(String id, String name, String path) {
        this.config = new VSDConfig();
        this.config.setProfileName(name);
        this.config.setId(id);
        this.sound_list = new HashMap();
        this.event_list = new LinkedHashMap();
        this.initialized = this._init();
        this.config.setVSDPath(path);
        try {
            VSDFile vsdfile = new VSDFile(path);
            if (vsdfile.isInitialized()) {
                log.debug("Constructor: vsdfile init OK, loading XML...");
                this.setXml(vsdfile, name);
            } else {
                log.debug("Constructor: vsdfile init FAILED.");
                this.initialized = false;
            }
        }
        catch (ZipException e) {
            log.error("ZipException loading VSDecoder from {}", (Object)path);
        }
        catch (IOException ioe) {
            log.error("IOException loading VSDecoder from {}", (Object)path);
        }
    }

    private boolean _init() {
        this.enable();
        return true;
    }

    public String getId() {
        return this.config.getId();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setVSDFilePath(String p) {
        this.config.setVSDPath(p);
    }

    public String getVSDFilePath() {
        return this.config.getVSDPath();
    }

    public void shutdown() {
        log.debug("Shutting down sounds...");
        for (VSDSound vs : this.sound_list.values()) {
            log.debug("Stopping sound: {}", (Object)vs.getName());
            vs.shutdown();
        }
    }

    protected void throttlePropertyChange(PropertyChangeEvent event) {
        String eventName = event.getPropertyName();
        if (!this.enabled) {
            log.debug("VSDecoder disabled. Take no action.");
            return;
        }
        log.debug("VSDecoder throttle property change: {}", (Object)eventName);
        if (eventName.equals("throttleAssigned")) {
            Boolean b;
            Float s = (Float)InstanceManager.throttleManagerInstance().getThrottleInfo(this.config.getDccAddress(), "SpeedSetting");
            if (s != null) {
                this.getEngineSound().setFirstSpeed(true);
                log.debug("Existing DCC Throttle found. Speed: {}", (Object)s);
                this.throttlePropertyChange(new PropertyChangeEvent(this, "SpeedSetting", null, s));
            }
            if ((b = (Boolean)InstanceManager.throttleManagerInstance().getThrottleInfo(this.config.getDccAddress(), "IsForward")) != null) {
                this.dirfn = b != false ? 1 : -1;
                log.debug("Existing DCC Throttle found. IsForward is {}", (Object)b);
                log.debug("Initial dirfn: {} for {}", (Object)this.dirfn, (Object)this.config.getDccAddress());
                this.throttlePropertyChange(new PropertyChangeEvent(this, "IsForward", null, b));
            } else {
                log.warn("No existing DCC throttle found.");
            }
            if (this.event_list.get("ENGINE") != null) {
                for (Trigger t : this.event_list.get((Object)"ENGINE").trigger_list.values()) {
                    log.debug("ENGINE trigger  Name: {}, Event: {}, t: {}", new Object[]{t.getName(), t.getEventName(), t});
                    if (!t.getEventName().startsWith("F")) continue;
                    log.debug("F-Key trigger found: {}, name: {}, event: {}", new Object[]{t, t.getName(), t.getEventName()});
                    if (t.getName().equals("ENGINE_STARTSTOP") || t.getName().equals("BRAKE_KEY") || (b = (Boolean)InstanceManager.throttleManagerInstance().getThrottleInfo(this.config.getDccAddress(), t.getEventName())) == null) continue;
                    this.throttlePropertyChange(new PropertyChangeEvent(this, t.getEventName(), null, b));
                }
            }
        }
        for (SoundEvent t : this.event_list.values()) {
            t.propertyChange(event);
        }
        if (eventName.equals("IsForward")) {
            this.dirfn = (Boolean)event.getNewValue() != false ? 1 : -1;
        }
    }

    public void setAddress(LocoAddress l) {
        this.config.setLocoAddress(l);
        InstanceManager.throttleManagerInstance().attachListener(this.config.getDccAddress(), new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                log.debug("property change name: {}, old: {}, new: {}", new Object[]{event.getPropertyName(), event.getOldValue(), event.getNewValue()});
                VSDecoder.this.throttlePropertyChange(event);
            }
        });
        log.debug("VSDecoder: Address set to {}", (Object)this.config.getLocoAddress());
    }

    public LocoAddress getAddress() {
        return this.config.getLocoAddress();
    }

    public RosterEntry getRosterEntry() {
        return this.config.getRosterEntry();
    }

    public float getDecoderVolume() {
        return this.config.getVolume();
    }

    private void forwardMasterVolume(float volume) {
        log.debug("VSD config id: {}, Master volume: {}, Decoder volume: {}", new Object[]{this.getId(), Float.valueOf(volume), Float.valueOf(this.config.getVolume())});
        for (VSDSound vs : this.sound_list.values()) {
            vs.setVolume(volume * this.config.getVolume());
        }
    }

    public void setDecoderVolume(float decoder_volume) {
        this.config.setVolume(decoder_volume);
        float master_vol = 0.01f * (float)VSDecoderManager.instance().getMasterVolume();
        log.debug("config set decoder volume to {}, master volume adjusted: {}", (Object)Float.valueOf(decoder_volume), (Object)Float.valueOf(master_vol));
        for (VSDSound vs : this.sound_list.values()) {
            vs.setVolume(master_vol * decoder_volume);
        }
    }

    public boolean isMuted() {
        return this.getMuteState();
    }

    public void mute(boolean m) {
        for (VSDSound vs : this.sound_list.values()) {
            vs.mute(m);
        }
    }

    private void setMuteState(boolean m) {
        this.is_muted = m;
    }

    private boolean getMuteState() {
        return this.is_muted;
    }

    public void setPosition(PhysicalLocation p) {
        this.config.setPhysicalLocation(p);
        if (this.create_xy_series) {
            log.info("setPosition {}: {}\t{}", new Object[]{this.getAddress(), Float.valueOf((float)Math.round(p.x * 10000.0f) / 10000.0f), Float.valueOf(p.y)});
        }
        log.debug("address {} set Position: {}", (Object)this.getAddress(), (Object)p);
        this.lastPos = p;
        for (VSDSound s : this.sound_list.values()) {
            s.setPosition(p);
        }
        float tv = 0.01f * (float)VSDecoderManager.instance().getMasterVolume() * this.getDecoderVolume();
        log.debug("current master volume: {}, decoder volume: {}", (Object)VSDecoderManager.instance().getMasterVolume(), (Object)Float.valueOf(this.getDecoderVolume()));
        if (this.getEngineSound().getTunnel()) {
            log.debug("VSD: In tunnel, volume: {}", (Object)Float.valueOf(tv *= 0.5f));
        } else {
            log.debug("VSD: Not in tunnel, volume: {}", (Object)Float.valueOf(tv));
        }
        if (!this.getMuteState()) {
            for (VSDSound vs : this.sound_list.values()) {
                vs.setVolume(tv);
            }
        }
    }

    void setTunnelState(boolean t) {
        for (VSDSound vs : this.sound_list.values()) {
            vs.setTunnel(t);
        }
    }

    public PhysicalLocation getPosition() {
        return this.config.getPhysicalLocation();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (evt.getSource() instanceof VSDControl) {
            Train selected_train;
            if (property.equals("OptionChange") && (selected_train = InstanceManager.getDefault(TrainManager.class).getTrainByName((String)evt.getNewValue())) != null) {
                selected_train.addPropertyChangeListener(this);
                if (VSDecoderManager.instance().geofile_ok) {
                    Route r = selected_train.getRoute();
                    if (r != null) {
                        log.info("Train \"{}\" selected for {} - Route is now \"{}\"", new Object[]{selected_train, this.getAddress(), r.getName()});
                        if (r.getName().equals("VSDRoute1")) {
                            this.setup_index = 0;
                        } else if (r.getName().equals("VSDRoute2") && VSDecoderManager.instance().num_setups > 1) {
                            this.setup_index = 1;
                        } else if (r.getName().equals("VSDRoute3") && VSDecoderManager.instance().num_setups > 2) {
                            this.setup_index = 2;
                        } else if (r.getName().equals("VSDRoute4") && VSDecoderManager.instance().num_setups > 3) {
                            this.setup_index = 3;
                        } else {
                            log.warn("\"{}\" is not suitable for VSD Advanced Location Following", (Object)r.getName());
                        }
                    } else {
                        log.warn("Train \"{}\" is without Route", (Object)selected_train);
                    }
                }
            }
            return;
        }
        if (property.equals("VSDMF:Mute")) {
            log.debug("VSD: Mute change. value: {}", evt.getNewValue());
            this.setMuteState((Boolean)evt.getNewValue());
            this.mute(this.getMuteState());
        } else if (property.equals("VSDMF:VolumeChange")) {
            log.debug("VSD: Volume change. value: {}", evt.getOldValue());
            this.forwardMasterVolume(0.01f * (float)((Integer)evt.getOldValue()).intValue());
        } else if (property.equals("TrainLocation")) {
            PhysicalLocation p = this.getTrainPosition((Train)evt.getSource());
            if (p != null) {
                this.setPosition(this.getTrainPosition((Train)evt.getSource()));
            } else {
                log.debug("Train has null position");
                this.setPosition(new PhysicalLocation());
            }
        } else if (property.equals("TrainStatus")) {
            String status = (String)evt.getOldValue();
            log.debug("Train status changed: {}", (Object)status);
            log.debug("New Location: {}", (Object)this.getTrainPosition((Train)evt.getSource()));
            if (status.startsWith(Train.BUILT) || status.startsWith(Train.PARTIAL_BUILT)) {
                log.debug("Train built. status: {}", (Object)status);
                PhysicalLocation p = this.getTrainPosition((Train)evt.getSource());
                if (p != null) {
                    this.setPosition(this.getTrainPosition((Train)evt.getSource()));
                } else {
                    log.debug("Train has null position");
                    this.setPosition(new PhysicalLocation());
                }
            }
        }
    }

    protected PhysicalLocation getTrainPosition(Train t) {
        if (t == null) {
            log.debug("Train is null.");
            return null;
        }
        RouteLocation rloc = t.getCurrentRouteLocation();
        if (rloc == null) {
            log.debug("RouteLocation is null.");
            return null;
        }
        Location loc = rloc.getLocation();
        if (loc == null) {
            log.debug("Location is null.");
            return null;
        }
        return loc.getPhysicalLocation();
    }

    public VSDSound getSound(String name) {
        return this.sound_list.get(name);
    }

    public void setProfileName(String pn) {
        this.config.setProfileName(pn);
    }

    public String getProfileName() {
        return this.config.getProfileName();
    }

    void enable() {
        this.enabled = true;
    }

    void disable() {
        this.enabled = false;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    public EngineSound getEngineSound() {
        return (EngineSound)this.sound_list.get("ENGINE");
    }

    public Collection<SoundEvent> getEventList() {
        return this.event_list.values();
    }

    public Element getXml() {
        Element me = new Element("vsdecoder");
        ArrayList<Element> le = new ArrayList<Element>();
        me.setAttribute("name", this.config.getProfileName());
        for (SoundEvent se : this.event_list.values()) {
            le.add(se.getXml());
        }
        for (VSDSound vs : this.sound_list.values()) {
            le.add(vs.getXml());
        }
        me.addContent(le);
        return me;
    }

    public void setXml(VSDFile vf, String pn) {
        Element e = null;
        Element el2 = null;
        if (vf == null) {
            log.debug("Null VSD File Name");
            return;
        }
        log.debug("VSD File Name: {}, profile: {}", (Object)vf.getName(), (Object)pn);
        this.setVSDFilePath(vf.getName());
        Iterator i = vf.getRoot().getChildren("profile").iterator();
        while (i.hasNext() && !(e = (Element)i.next()).getAttributeValue("name").equals(pn)) {
        }
        if (e == null) {
            return;
        }
        this.setProfileName(e.getAttributeValue("name"));
        log.debug("Decoder Name: {}", (Object)e.getAttributeValue("name"));
        String n = e.getChildText("create-xy-series");
        if (n != null && n.equals("yes")) {
            this.create_xy_series = true;
            log.debug("Profile {}: xy-position-coordinates will be created in JMRI System Console", (Object)this.getProfileName());
        } else {
            this.create_xy_series = false;
            log.debug("Profile {}: xy-position-coordinates will NOT be created in JMRI System Console", (Object)this.getProfileName());
        }
        n = e.getChildText("start-position");
        this.startPos = n != null ? PhysicalLocation.parse(n) : null;
        log.debug("Start position: {}", (Object)this.startPos);
        for (Element el2 : e.getChildren()) {
            log.debug("Element: {}", (Object)el2);
            if (el2.getAttribute("name") == null) continue;
            log.debug("  Name: {}", (Object)el2.getAttributeValue("name"));
            log.debug("   type: {}", (Object)el2.getAttributeValue("type"));
        }
        String prefix = this.getId() + ":";
        log.debug("VSDecoder {}, prefix: {}", (Object)this.getId(), (Object)prefix);
        for (Element el2 : e.getChildren("sound")) {
            EngineSound es;
            if (el2.getAttributeValue("type") == null) {
                log.debug("Skipping empty Sound.");
                continue;
            }
            if (el2.getAttributeValue("type").equals("configurable")) {
                ConfigurableSound cs = new ConfigurableSound(prefix + el2.getAttributeValue("name"));
                cs.setXml(el2, vf);
                this.sound_list.put(el2.getAttributeValue("name"), cs);
                continue;
            }
            if (el2.getAttributeValue("type").equals("diesel")) {
                es = new DieselSound(prefix + el2.getAttributeValue("name"));
                ((DieselSound)es).setXml(el2, vf);
                this.sound_list.put(el2.getAttributeValue("name"), es);
                continue;
            }
            if (el2.getAttributeValue("type").equals("diesel3")) {
                es = new Diesel3Sound(prefix + el2.getAttributeValue("name"));
                ((Diesel3Sound)es).setXml(el2, vf);
                this.sound_list.put(el2.getAttributeValue("name"), es);
                this.topspeed_rev = this.topspeed = ((Diesel3Sound)es).top_speed;
                continue;
            }
            if (el2.getAttributeValue("type").equals("steam")) {
                es = new SteamSound(prefix + el2.getAttributeValue("name"));
                ((SteamSound)es).setXml(el2, vf);
                this.sound_list.put(el2.getAttributeValue("name"), es);
                this.topspeed_rev = this.topspeed = ((SteamSound)es).top_speed;
                continue;
            }
            if (!el2.getAttributeValue("type").equals("steam1")) continue;
            es = new Steam1Sound(prefix + el2.getAttributeValue("name"));
            ((Steam1Sound)es).setXml(el2, vf);
            this.sound_list.put(el2.getAttributeValue("name"), es);
            this.topspeed = ((Steam1Sound)es).top_speed;
            this.topspeed_rev = ((Steam1Sound)es).top_speed_reverse;
        }
        for (Element el2 : e.getChildren("sound-event")) {
            SoundEvent se;
            switch (SoundEvent.ButtonType.valueOf(el2.getAttributeValue("buttontype").toUpperCase())) {
                case MOMENTARY: {
                    se = new MomentarySoundEvent(el2.getAttributeValue("name"));
                    break;
                }
                case TOGGLE: {
                    se = new ToggleSoundEvent(el2.getAttributeValue("name"));
                    break;
                }
                case ENGINE: {
                    se = new EngineSoundEvent(el2.getAttributeValue("name"));
                    break;
                }
                default: {
                    se = new SoundEvent(el2.getAttributeValue("name"));
                }
            }
            se.setParent(this);
            se.setXml(el2, vf);
            this.event_list.put(se.getName(), se);
        }
    }

    void setLocation(Point2D location) {
        this.location = location;
    }

    Point2D getLocation() {
        return this.location;
    }

    LayoutTrack getLastTrack() {
        return this.lastTrack;
    }

    void setLastTrack(LayoutTrack lastTrack) {
        this.lastTrack = lastTrack;
    }

    void setLayoutTrack(LayoutTrack layoutTrack) {
        this.layoutTrack = layoutTrack;
    }

    LayoutTrack getLayoutTrack() {
        return this.layoutTrack;
    }

    void setReturnTrack(LayoutTrack returnTrack) {
        this.returnTrack = returnTrack;
    }

    LayoutTrack getReturnTrack() {
        return this.returnTrack;
    }

    void setReturnLastTrack(LayoutTrack returnLastTrack) {
        this.returnLastTrack = returnLastTrack;
    }

    LayoutTrack getReturnLastTrack() {
        return this.returnLastTrack;
    }

    double getDistance() {
        return this.distance;
    }

    void setDistance(double distance) {
        this.distance = distance;
    }

    double getReturnDistance() {
        return this.returnDistance;
    }

    void setReturnDistance(double returnDistance) {
        this.returnDistance = returnDistance;
    }

    double getDirectionRAD() {
        return this.directionRAD;
    }

    void setDirectionRAD(double directionRAD) {
        this.directionRAD = directionRAD;
    }

    void setDirectionDEG(double directionDEG) {
        this.directionRAD = Math.toRadians(directionDEG);
    }

    LayoutEditor getModels() {
        return this.models;
    }

    void setModels(LayoutEditor models) {
        this.models = models;
    }

    void navigate() {
        boolean result = false;
        do {
            if (this.getLayoutTrack() instanceof TrackSegment) {
                result = this.navigation.navigateTrackSegment();
                continue;
            }
            if (this.getLayoutTrack() instanceof LayoutSlip) {
                result = this.navigation.navigateLayoutSlip();
                continue;
            }
            if (this.getLayoutTrack() instanceof LayoutTurnout) {
                result = this.navigation.navigateLayoutTurnout();
                continue;
            }
            if (this.getLayoutTrack() instanceof PositionablePoint) {
                result = this.navigation.navigatePositionalPoint();
                continue;
            }
            if (this.getLayoutTrack() instanceof LevelXing) {
                result = this.navigation.navigateLevelXing();
                continue;
            }
            if (this.getLayoutTrack() instanceof LayoutTurntable) {
                result = this.navigation.navigateLayoutTurntable();
                continue;
            }
            log.warn("Track type not supported");
            this.setReturnDistance(0.0);
            this.setReturnTrack(this.getLastTrack());
            result = false;
        } while (result);
    }
}

