/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import javax.vecmath.Tuple3f;
import jmri.Audio;
import jmri.AudioManager;
import jmri.BasicRosterEntry;
import jmri.Block;
import jmri.BlockManager;
import jmri.IdTag;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.Manager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Path;
import jmri.PhysicalLocationReporter;
import jmri.Reportable;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.ThrottleManager;
import jmri.implementation.DefaultIdTag;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutSlip;
import jmri.jmrit.display.layoutEditor.LayoutTrack;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LayoutTurntable;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.jmrit.display.layoutEditor.TrackSegmentView;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.vsdecoder.LoadVSDFileAction;
import jmri.jmrit.vsdecoder.VSDConfig;
import jmri.jmrit.vsdecoder.VSDFile;
import jmri.jmrit.vsdecoder.VSDGeoFile;
import jmri.jmrit.vsdecoder.VSDManagerEvent;
import jmri.jmrit.vsdecoder.VSDManagerListener;
import jmri.jmrit.vsdecoder.VSDecoder;
import jmri.jmrit.vsdecoder.VSDecoderManagerThread;
import jmri.jmrit.vsdecoder.VSDecoderPreferences;
import jmri.jmrit.vsdecoder.listener.ListeningSpot;
import jmri.jmrit.vsdecoder.listener.VSDListener;
import jmri.jmrit.vsdecoder.swing.VSDManagerFrame;
import jmri.jmrix.loconet.TranspondingTag;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.MathUtil;
import jmri.util.PhysicalLocation;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSDecoderManager
implements PropertyChangeListener {
    private static final String vsd_property_change_name = "VSDecoder Manager";
    private static final int RADIUS = 0;
    private static final int SLOPE = 1;
    private static final int ROTATE_XPOS_I = 2;
    private static final int ROTATE_YPOS_I = 3;
    private static final int LENGTH = 4;
    private static final int ADDRESS = 0;
    private static final int BLOCK = 1;
    private static final int DISTANCE_TO_GO = 2;
    private static final int DIR_FN = 3;
    private static final int DIRECTION = 4;
    protected NamedBeanHandleManager nbhm = InstanceManager.getDefault(NamedBeanHandleManager.class);
    private HashMap<String, VSDListener> listenerTable;
    private HashMap<String, VSDecoder> decodertable;
    private HashMap<String, VSDecoder> decoderAddressMap;
    private HashMap<Integer, VSDecoder> decoderInBlock;
    private HashMap<String, String> profiletable;
    HashMap<VSDecoder, Block> currentBlock;
    private HashMap<Block, LayoutEditor> possibleStartBlocks;
    private Timer timer;
    private int[][] locoInBlock;
    private float[][][] blockParameter;
    private List<List<PhysicalLocation>> blockPositionlists;
    private List<List<Integer>> reporterlists;
    private List<Boolean> circlelist;
    private PhysicalLocation newPosition;
    private PhysicalLocation models_origin;
    private ArrayList<Block> blockList;
    protected EventListenerList listenerList = new EventListenerList();
    private static volatile VSDecoderManagerThread thread = null;
    private VSDecoderPreferences vsdecoderPrefs;
    private JmriJFrame managerFrame = null;
    private int vsdecoderID = 0;
    private int locorow = -1;
    private int check_time;
    private float layout_scale;
    private float distance_rest = 0.0f;
    private float distance_rest_old = 0.0f;
    private float distance_rest_new = 0.0f;
    private float xPosi;
    public static final int max_decoder = 8;
    boolean geofile_ok = false;
    int num_setups;
    private int lf_version;
    int alf_version;
    private static final Logger log = LoggerFactory.getLogger(VSDecoderManager.class);

    public VSDecoderManager() {
        this.listenerTable = new HashMap();
        this.decodertable = new HashMap();
        this.decoderAddressMap = new HashMap();
        this.decoderInBlock = new HashMap();
        this.profiletable = new HashMap();
        this.currentBlock = new HashMap();
        this.possibleStartBlocks = new HashMap();
        this.locoInBlock = new int[8][5];
        this.reporterlists = new ArrayList<List<Integer>>();
        this.blockPositionlists = new ArrayList<List<PhysicalLocation>>();
        this.circlelist = new ArrayList<Boolean>();
        String dirname = FileUtil.getUserFilesPath() + "vsdecoder" + File.separator;
        FileUtil.createDirectory(dirname);
        this.vsdecoderPrefs = new VSDecoderPreferences(dirname + "VSDecoderPreferences.xml");
        this.setupReporterManagerListener();
        VSDListener t = new VSDListener();
        this.listenerTable.put(t.getSystemName(), t);
        this.setListenerLocation(t.getSystemName(), this.vsdecoderPrefs.getListenerPosition());
        VSDGeoFile gf = new VSDGeoFile();
        if (gf.geofile_ok) {
            this.geofile_ok = true;
            this.alf_version = gf.alf_version;
            this.num_setups = gf.getNumberOfSetups();
            this.reporterlists = gf.getReporterList();
            this.blockParameter = gf.getBlockParameter();
            this.blockPositionlists = gf.getBlockPosition();
            this.circlelist = gf.getCirclingList();
            this.check_time = gf.getCheckTime();
            this.layout_scale = gf.layout_scale;
            this.models_origin = gf.models_origin;
            this.possibleStartBlocks = gf.possibleStartBlocks;
            this.blockList = gf.blockList;
        } else {
            this.geofile_ok = false;
            if (gf.lf_version > 0) {
                this.lf_version = gf.lf_version;
                log.debug("assume location following");
            }
        }
    }

    public static VSDecoderManager instance() {
        if (thread == null) {
            thread = VSDecoderManagerThread.instance(true);
        }
        return VSDecoderManagerThread.manager();
    }

    public VSDecoderPreferences getVSDecoderPreferences() {
        return this.vsdecoderPrefs;
    }

    public int getMasterVolume() {
        return this.getVSDecoderPreferences().getMasterVolume();
    }

    public void setMasterVolume(int mv) {
        this.getVSDecoderPreferences().setMasterVolume(mv);
    }

    public boolean checkForPossibleStartblock(Block blk) {
        if (this.possibleStartBlocks.containsKey(blk)) {
            return true;
        }
        if (this.geofile_ok) {
            log.warn("Block {} is not a valid starting block", (Object)blk);
        }
        return false;
    }

    public void doResume() {
        if (this.geofile_ok && this.getVSDecoderList().size() > 0) {
            this.initSoundPositionTimer();
        }
    }

    public JmriJFrame provideManagerFrame() {
        if (this.managerFrame == null) {
            if (GraphicsEnvironment.isHeadless()) {
                String vsdRosterGroup = "VSD";
                if (Roster.getDefault().getRosterGroupList().contains(vsdRosterGroup)) {
                    List<RosterEntry> rosterList = Roster.getDefault().getEntriesInGroup(vsdRosterGroup);
                    int entry_counter = 0;
                    for (RosterEntry entry : rosterList) {
                        if (entry_counter < 8) {
                            VSDConfig config = new VSDConfig();
                            config.setLocoAddress(entry.getDccLocoAddress());
                            log.info("Loading Roster Entry \"{}\", VSDecoder {} ...", (Object)entry.getId(), (Object)config.getLocoAddress());
                            String path = entry.getAttribute("VSDecoder_Path");
                            String profile = entry.getAttribute("VSDecoder_Profile");
                            if (path != null && profile != null) {
                                if (!LoadVSDFileAction.loadVSDFile(path)) continue;
                                log.info(" VSD path: {}", (Object)FileUtil.getExternalFilename(path));
                                config.setProfileName(profile);
                                log.debug(" entry VSD profile: {}", (Object)profile);
                                if (entry.getAttribute("VSDecoder_Volume") != null) {
                                    config.setVolume(Float.parseFloat(entry.getAttribute("VSDecoder_Volume")));
                                } else {
                                    config.setVolume(0.8f);
                                }
                                VSDecoder newDecoder = this.getVSDecoder(config);
                                if (newDecoder != null) {
                                    log.info("VSD {}, profile \"{}\" ready.", (Object)config.getLocoAddress(), (Object)config.getProfileName());
                                    ++entry_counter;
                                    continue;
                                }
                                log.warn("VSD {} failed", (Object)config.getProfileName());
                                continue;
                            }
                            log.error("Cannot load VSD File - path or profile missing - check your Roster Media");
                            continue;
                        }
                        log.warn("Only {} roster entries allowed. Disgarded {}", (Object)8, (Object)(rosterList.size() - 8));
                    }
                    if (entry_counter == 0) {
                        log.warn("No Roster entry found in Roster Group {}", (Object)vsdRosterGroup);
                    }
                } else {
                    log.warn("Roster group \"{}\" not found", (Object)vsdRosterGroup);
                }
            } else {
                this.managerFrame = new VSDManagerFrame();
            }
        } else {
            log.warn("Virtual Sound Decoder Manager is already running");
        }
        return this.managerFrame;
    }

    private String getNextVSDecoderID() {
        return "IAD:VSD:VSDecoderID" + ++this.vsdecoderID;
    }

    private Integer getNextlocorow() {
        return ++this.locorow;
    }

    public VSDecoder getVSDecoder(VSDConfig config) {
        String profile_name = config.getProfileName();
        if (this.decoderAddressMap.containsKey(config.getLocoAddress().toString())) {
            return this.decoderAddressMap.get(config.getLocoAddress().toString());
        }
        if (this.profiletable.containsKey(profile_name)) {
            String path = this.profiletable.get(profile_name);
            log.debug("Profile {} is in table.  Path: {}", (Object)profile_name, (Object)path);
            config.setVSDPath(path);
            config.setId(this.getNextVSDecoderID());
            VSDecoder vsd = new VSDecoder(config);
            this.decodertable.put(vsd.getId(), vsd);
            this.decoderAddressMap.put(vsd.getAddress().toString(), vsd);
            this.decoderInBlock.put(vsd.getAddress().getNumber(), vsd);
            this.locoInBlock[this.getNextlocorow().intValue()][0] = vsd.getAddress().getNumber();
            if (vsd.isEnabled()) {
                vsd.setDecoderVolume(vsd.getDecoderVolume());
                if (this.geofile_ok) {
                    if (vsd.topspeed == 0) {
                        log.info("Top-speed not defined. No advanced location following possible.");
                    } else {
                        this.initSoundPositionTimer();
                    }
                }
                return vsd;
            }
            this.deleteDecoder(vsd.getAddress().toString());
            return null;
        }
        log.error("Requested profile not loaded: {}", (Object)profile_name);
        return null;
    }

    public VSDecoder getVSDecoderByID(String id) {
        VSDecoder v = this.decodertable.get(id);
        if (v == null) {
            log.debug("No decoder in table! ID: {}", (Object)id);
        }
        return this.decodertable.get(id);
    }

    public VSDecoder getVSDecoderByAddress(String sa) {
        if (sa == null) {
            log.debug("Decoder Address is Null");
            return null;
        }
        log.debug("Decoder Address: {}", (Object)sa);
        VSDecoder rv = this.decoderAddressMap.get(sa);
        if (rv == null) {
            log.debug("Not found.");
        } else {
            log.debug("Found: {}", (Object)rv.getAddress());
        }
        return rv;
    }

    public ArrayList<String> getVSDProfileNames() {
        ArrayList<String> sl = new ArrayList<String>();
        for (String p : this.profiletable.keySet()) {
            sl.add(p);
        }
        return sl;
    }

    public Collection<VSDecoder> getVSDecoderList() {
        return this.decodertable.values();
    }

    public String getDefaultListenerName() {
        return "IAL$";
    }

    public ListeningSpot getDefaultListenerLocation() {
        VSDListener l = this.listenerTable.get(this.getDefaultListenerName());
        if (l != null) {
            return l.getLocation();
        }
        return null;
    }

    public void setListenerLocation(String id, ListeningSpot sp) {
        VSDListener l = this.listenerTable.get(id);
        log.debug("Set listener location {} listener: {}", (Object)sp, (Object)l);
        if (l != null) {
            l.setLocation(sp);
        }
    }

    public void setDecoderPositionByID(String id, PhysicalLocation p) {
        VSDecoder d = this.decodertable.get(id);
        if (d != null) {
            d.setPosition(p);
        }
    }

    public void setDecoderPositionByAddr(LocoAddress a, PhysicalLocation l) {
        if (a == null) {
            log.warn("Decoder Address is Null");
            return;
        }
        if (l == null) {
            log.warn("PhysicalLocation is Null");
            return;
        }
        if (l.equals((Tuple3f)PhysicalLocation.Origin)) {
            log.info("Location: {} ... ignoring", (Object)l);
            return;
        }
        log.debug("Decoder Address: {}", (Object)a.getNumber());
        for (VSDecoder d : this.decodertable.values()) {
            if (d == null) {
                log.debug("VSdecoder null pointer!");
                return;
            }
            LocoAddress pa = d.getAddress();
            if (pa == null) {
                log.info("Vsdecoder {} address null!", (Object)d);
                return;
            }
            LocoAddress.Protocol p = d.getAddress().getProtocol();
            if (p == null) {
                log.debug("Vsdecoder {} address = {} protocol null!", (Object)d, (Object)pa);
                return;
            }
            if (p == LocoAddress.Protocol.DCC_LONG || p == LocoAddress.Protocol.DCC_SHORT) {
                p = LocoAddress.Protocol.DCC;
            }
            if (d.getAddress().getNumber() != a.getNumber() || p != a.getProtocol()) continue;
            d.setPosition(l);
        }
    }

    public void addEventListener(VSDManagerListener listener) {
        this.listenerList.add(VSDManagerListener.class, listener);
    }

    public void removeEventListener(VSDManagerListener listener) {
        this.listenerList.remove(VSDManagerListener.class, listener);
    }

    void fireMyEvent(VSDManagerEvent evt) {
        for (VSDManagerListener l : (VSDManagerListener[])this.listenerList.getListeners(VSDManagerListener.class)) {
            l.eventAction(evt);
        }
    }

    public String getProfilePath(String profile) {
        return this.profiletable.get(profile);
    }

    protected void registerReporterListener(String sysName) {
        Reporter r = InstanceManager.getDefault(ReporterManager.class).getReporter(sysName);
        if (r == null) {
            return;
        }
        NamedBeanHandle<Reporter> h = this.nbhm.getNamedBeanHandle(sysName, r);
        PropertyChangeListener[] ll = r.getPropertyChangeListenersByReference(h.getName());
        if (ll.length == 0) {
            r.addPropertyChangeListener(this, h.getName(), vsd_property_change_name);
        }
    }

    protected void registerBeanListener(Manager<Block> beanManager, String sysName) {
        Block b = beanManager.getBySystemName(sysName);
        if (b == null) {
            log.debug("No bean by name {}", (Object)sysName);
            return;
        }
        NamedBeanHandle<Block> h = this.nbhm.getNamedBeanHandle(sysName, b);
        PropertyChangeListener[] ll = b.getPropertyChangeListenersByReference(h.getName());
        if (ll.length == 0) {
            b.addPropertyChangeListener(this, h.getName(), vsd_property_change_name);
            log.debug("Added listener to bean {} type {}", (Object)b.getDisplayName(), (Object)b.getClass().getName());
        }
    }

    protected void registerReporterListeners() {
        SortedSet reporterSet = InstanceManager.getDefault(ReporterManager.class).getNamedBeanSet();
        for (Reporter r : reporterSet) {
            if (r == null) continue;
            this.registerReporterListener(r.getSystemName());
        }
        SortedSet blockSet = InstanceManager.getDefault(BlockManager.class).getNamedBeanSet();
        for (Block b : blockSet) {
            if (b == null) continue;
            this.registerBeanListener(InstanceManager.getDefault(BlockManager.class), b.getSystemName());
        }
    }

    private void setupReporterManagerListener() {
        InstanceManager.getDefault(ReporterManager.class).addPropertyChangeListener(this);
        SortedSet reporterSet = InstanceManager.getDefault(ReporterManager.class).getNamedBeanSet();
        for (Reporter r : reporterSet) {
            if (r == null) continue;
            this.registerReporterListener(r.getSystemName());
        }
        SortedSet blockSet = InstanceManager.getDefault(BlockManager.class).getNamedBeanSet();
        for (Block b : blockSet) {
            if (b == null) continue;
            this.registerBeanListener(InstanceManager.getDefault(BlockManager.class), b.getSystemName());
        }
    }

    public void deleteDecoder(String address) {
        log.debug("delete Decoder called, VSDecoder DCC address: {}", (Object)address);
        if (this.getVSDecoderByAddress(address) == null) {
            log.warn("VSDecoder not found");
        } else {
            this.removeVSDecoder(address);
        }
    }

    private void removeVSDecoder(String sa) {
        VSDecoder d = this.getVSDecoderByAddress(sa);
        InstanceManager.getDefault(ThrottleManager.class).removeListener(d.getAddress(), d);
        if (this.geofile_ok && this.getVSDecoderList().size() == 1) {
            this.stopSoundPositionTimer();
            this.timer = null;
        }
        d.shutdown();
        d.disable();
        this.decodertable.remove(d.getId());
        this.decoderAddressMap.remove(sa);
        this.currentBlock.remove(d);
        this.decoderInBlock.remove(d.getAddress().getNumber());
        this.locoInBlockRemove(d.getAddress().getNumber());
        --this.locorow;
        d.sound_list.clear();
        d.event_list.clear();
        AudioManager am = InstanceManager.getDefault(AudioManager.class);
        ArrayList<Audio> sources = new ArrayList<Audio>(am.getNamedBeanSet('S'));
        ArrayList<Audio> buffers = new ArrayList<Audio>(am.getNamedBeanSet('B'));
        for (Audio source : sources) {
            if (!source.getSystemName().contains(d.getId())) continue;
            source.dispose();
        }
        for (Audio buffer : buffers) {
            if (!buffer.getSystemName().contains(d.getId())) continue;
            buffer.dispose();
        }
        log.info("New number of buffers used after deletion: {}, max: {}", (Object)am.getNamedBeanSet('B').size(), (Object)255);
    }

    public void atStart(Block blk) {
        int locoAddress = this.getLocoAddr(blk);
        if (locoAddress != 0) {
            if (this.decoderInBlock.containsKey(locoAddress)) {
                VSDecoder d = this.decoderInBlock.get(locoAddress);
                if (this.geofile_ok) {
                    if (this.alf_version == 2 && this.blockList.contains(blk)) {
                        this.handleAlf2(d, locoAddress, blk);
                    } else {
                        log.debug("Block {} not valid for panel {}", (Object)blk, (Object)d.getModels());
                    }
                } else {
                    d.getEngineSound().setTunnel(blk.getPhysicalLocation().isTunnel());
                    d.setPosition(blk.getPhysicalLocation());
                }
            } else {
                log.warn("Block value \"{}\" is not a valid VSDecoder address", blk.getValue());
            }
        }
    }

    public int getLocoAddr(Block blk) {
        if (blk == null || blk.getValue() == null) {
            return 0;
        }
        Object blkVal = blk.getValue();
        int locoAddress = 0;
        if (blkVal instanceof String) {
            String val = blkVal.toString();
            RosterEntry entry = Roster.getDefault().getEntryForId(val);
            if (entry != null) {
                locoAddress = Integer.parseInt(entry.getDccAddress());
            } else if (StringUtils.isNumeric((CharSequence)val)) {
                locoAddress = Integer.parseInt(val);
            } else if (InstanceManager.getDefault(TrainManager.class).getTrainByName(val) != null) {
                Train selected_train = InstanceManager.getDefault(TrainManager.class).getTrainByName(val);
                locoAddress = selected_train.getLeadEngineDccAddress().isEmpty() ? 0 : Integer.parseInt(selected_train.getLeadEngineDccAddress());
            }
        } else if (blkVal instanceof BasicRosterEntry) {
            locoAddress = Integer.parseInt(((RosterEntry)blkVal).getDccAddress());
        } else if (blkVal instanceof DefaultIdTag) {
            String val = ((DefaultIdTag)blkVal).getTagID();
            if (StringUtils.isNumeric((CharSequence)val)) {
                locoAddress = Integer.parseInt(val);
            }
        } else {
            log.warn("Block Value \"{}\" found - unsupported object!", blkVal);
        }
        log.debug("loco address: {}", (Object)locoAddress);
        return locoAddress;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        log.debug("property change type {} name {} old {} new {}", new Object[]{evt.getSource().getClass().getName(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()});
        if (evt.getSource() instanceof ReporterManager) {
            this.reporterManagerPropertyChange(evt);
        } else if (evt.getSource() instanceof Reporter) {
            this.reporterPropertyChange(evt);
        } else if (evt.getSource() instanceof Block) {
            log.debug("Block property change! name: {} old: {} new = {}", new Object[]{evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()});
            this.blockPropertyChange(evt);
        } else if (evt.getSource() instanceof VSDManagerFrame) {
            if (evt.getPropertyName().equals("VSDMF:RemoveDecoder")) {
                this.removeVSDecoder((String)evt.getOldValue());
            } else if (evt.getPropertyName().equals("VSDMF:CloseWindow")) {
                this.stopSoundPositionTimer();
                this.timer = null;
                if (this.managerFrame != null) {
                    this.managerFrame = null;
                }
            }
        }
    }

    public void blockPropertyChange(PropertyChangeEvent event) {
        String eventName = event.getPropertyName();
        if (event.getSource() instanceof PhysicalLocationReporter) {
            Block blk = (Block)event.getSource();
            String repVal = null;
            if ("state".equals(eventName)) {
                if ((Integer)event.getNewValue() == 2) {
                    Reporter blockReporter = blk.getReporter();
                    if (blockReporter == null) {
                        log.debug("Block {} has no reporter!  Skipping state-type report", (Object)blk.getSystemName());
                        return;
                    }
                    if (blk.isReportingCurrent()) {
                        Object currentReport = blockReporter.getCurrentReport();
                        if (currentReport != null) {
                            repVal = currentReport instanceof Reportable ? ((Reportable)currentReport).toReportString() : currentReport.toString();
                        }
                    } else {
                        Object lastReport = blockReporter.getLastReport();
                        if (lastReport != null) {
                            repVal = lastReport instanceof Reportable ? ((Reportable)lastReport).toReportString() : lastReport.toString();
                        }
                    }
                } else {
                    log.debug("Ignoring report. not an OCCUPIED event.");
                    return;
                }
                log.debug("block repVal: {}", repVal);
            } else if ("value".equals(eventName)) {
                if (event.getNewValue() == null) {
                    return;
                }
                this.atStart(blk);
            } else {
                log.debug("Not a supported Block event type.  Ignoring.");
                return;
            }
            if (repVal == null) {
                log.debug("Report from Block {} is null!", (Object)blk.getSystemName());
            }
            if (repVal != null && blk.getDirection(repVal) == PhysicalLocationReporter.Direction.ENTER) {
                this.setDecoderPositionByAddr(blk.getLocoAddress(repVal), blk.getPhysicalLocation());
            }
        } else {
            log.debug("Reporter doesn't support physical location reporting.");
        }
    }

    public void reporterPropertyChange(PropertyChangeEvent event) {
        String eventName = event.getPropertyName();
        if (this.lf_version == 1 || this.geofile_ok && this.alf_version == 1) {
            if (event.getSource() instanceof PhysicalLocationReporter && eventName.equals("currentReport")) {
                PhysicalLocationReporter arp = (PhysicalLocationReporter)event.getSource();
                if (event.getNewValue() instanceof IdTag) {
                    if (event.getNewValue() instanceof TranspondingTag) {
                        String repVal = ((Reportable)event.getNewValue()).toReportString();
                        int locoAddress = arp.getLocoAddress(repVal).getNumber();
                        log.debug("Reporter repVal: {}, number: {}", (Object)repVal, (Object)locoAddress);
                        if (this.decoderInBlock.containsKey(locoAddress)) {
                            VSDecoder d = this.decoderInBlock.get(locoAddress);
                            if (this.geofile_ok) {
                                Reporter rp = (Reporter)event.getSource();
                                int new_rp = 0;
                                try {
                                    new_rp = Integer.parseInt(Manager.getSystemSuffix(rp.getSystemName()));
                                }
                                catch (NumberFormatException e) {
                                    log.warn("Invalid Reporter system name '{}'", (Object)rp.getSystemName());
                                }
                                if (this.reporterlists.get(d.setup_index).contains(new_rp)) {
                                    if (arp.getDirection(repVal) == PhysicalLocationReporter.Direction.ENTER) {
                                        this.handleAlf(d, locoAddress, new_rp);
                                    }
                                } else {
                                    log.info("Reporter {} not valid for {} setup {}", new Object[]{new_rp, "VSDGeoData.xml", d.setup_index + 1});
                                }
                            } else if (arp.getDirection(repVal) == PhysicalLocationReporter.Direction.ENTER) {
                                d.getEngineSound().setTunnel(arp.getPhysicalLocation(repVal).isTunnel());
                                d.setPosition(arp.getPhysicalLocation(repVal));
                                log.debug("position set to: {}", (Object)arp.getPhysicalLocation(repVal));
                            }
                        } else {
                            log.info(" decoder address {} is not valid!", (Object)locoAddress);
                        }
                        return;
                    }
                    IdTag newValue = (IdTag)event.getNewValue();
                    this.decoderInBlock.get(arp.getLocoAddress(newValue.getTagID()).getNumber()).getEngineSound().setTunnel(arp.getPhysicalLocation(null).isTunnel());
                    this.setDecoderPositionByAddr(arp.getLocoAddress(newValue.getTagID()), arp.getPhysicalLocation(null));
                } else {
                    log.info("Reporter's return type is not supported.");
                }
            } else {
                log.debug("Reporter doesn't support physical location reporting or isn't reporting new info.");
            }
        }
    }

    public void reporterManagerPropertyChange(PropertyChangeEvent event) {
        String eventName = event.getPropertyName();
        log.debug("VSDecoder received Reporter Manager Property Change: {}", (Object)eventName);
        if (eventName.equals("length")) {
            for (Reporter r : InstanceManager.getDefault(ReporterManager.class).getNamedBeanSet()) {
                this.registerReporterListener(r.getSystemName());
            }
        }
    }

    private void handleAlf(VSDecoder d, int locoAddress, int new_rp) {
        int new_rp_index = this.reporterlists.get(d.setup_index).indexOf(new_rp);
        int old_rp = -1;
        int old_rp_index = -1;
        int ix = this.getArrayIndex(locoAddress);
        if (ix < this.locoInBlock.length) {
            old_rp = this.locoInBlock[ix][1];
            if (old_rp == 0) {
                old_rp = -1;
            }
            old_rp_index = this.reporterlists.get(d.setup_index).indexOf(old_rp);
        } else {
            log.warn(" Array locoInBlock INDEX {} IS NOT VALID! Set to 0.", (Object)ix);
            ix = 0;
        }
        log.debug("new_rp: {}, old_rp: {}, new index: {}, old index: {}", new Object[]{new_rp, old_rp, new_rp_index, old_rp_index});
        if (new_rp != old_rp) {
            int lastrepix = this.reporterlists.get(d.setup_index).size() - 1;
            if (old_rp == -1 || old_rp_index + d.dirfn == new_rp_index || this.circlelist.get(d.setup_index).booleanValue() && d.dirfn == -1 && old_rp_index == 0 && new_rp_index == lastrepix || this.circlelist.get(d.setup_index).booleanValue() && d.dirfn == 1 && old_rp_index == lastrepix && new_rp_index == 0) {
                this.locoInBlock[ix][1] = new_rp;
                log.debug(" distance rest (old) to go in block {}: {} cm", (Object)old_rp, (Object)this.locoInBlock[ix][2]);
                this.locoInBlock[ix][2] = Math.round(this.blockParameter[d.setup_index][new_rp_index][4] * 100.0f);
                log.debug(" distance rest (new) to go in block {}: {} cm", (Object)new_rp, (Object)this.locoInBlock[ix][2]);
                d.posToSet = d.dirfn == 1 ? this.blockPositionlists.get(d.setup_index).get(new_rp_index) : this.blockPositionlists.get(d.setup_index).get(new_rp_index + 1);
                if (old_rp == -1 && d.startPos != null) {
                    d.posToSet = d.startPos;
                }
                d.getEngineSound().setTunnel(this.blockPositionlists.get(d.setup_index).get(new_rp_index).isTunnel());
                log.debug("address {}: position to set: {}", (Object)d.getAddress(), (Object)d.posToSet);
                d.setPosition(d.posToSet);
                this.changeDirection(d, locoAddress, new_rp_index);
            } else {
                log.info(" Validation failed! Last reporter: {}, new reporter: {}, dirfn: {} for {}", new Object[]{old_rp, new_rp, d.dirfn, locoAddress});
            }
        } else {
            log.info(" Same PhysicalLocationReporter, position not set!");
        }
    }

    private void handleAlf2(VSDecoder d, int locoAddress, Block newBlock) {
        if (this.currentBlock.get(d) != newBlock) {
            int ix = this.getArrayIndex(locoAddress);
            if (this.locoInBlock[ix][3] == 0) {
                if (d.getLayoutTrack() == null) {
                    if (this.possibleStartBlocks.get(newBlock) != null) {
                        d.setModels(this.possibleStartBlocks.get(newBlock));
                        log.debug("Block: {}, models: {}", (Object)newBlock, (Object)d.getModels());
                        TrackSegment ts = null;
                        for (LayoutTrack lt : d.getModels().getLayoutTracks()) {
                            if (lt instanceof TrackSegment && (ts = (TrackSegment)lt).getLayoutBlock() != null && ts.getLayoutBlock().getBlock() == newBlock) break;
                        }
                        if (ts != null) {
                            TrackSegmentView tsv = d.getModels().getTrackSegmentView(ts);
                            d.setLayoutTrack(ts);
                            d.setReturnTrack(d.getLayoutTrack());
                            d.setReturnLastTrack(tsv.getConnect2());
                            d.setLastTrack(tsv.getConnect1());
                            d.setReturnDistance(MathUtil.distance(d.getModels().getCoords(tsv.getConnect1(), tsv.getType1()), d.getModels().getCoords(tsv.getConnect2(), tsv.getType2())));
                            d.setDistance(0.0);
                            d.distanceOnTrack = 0.5 * d.getReturnDistance();
                            if (d.dirfn == -1) {
                                d.setLayoutTrack(d.getReturnTrack());
                                d.setLastTrack(d.getReturnLastTrack());
                            }
                            this.locoInBlock[ix][3] = d.dirfn;
                            this.currentBlock.put(d, newBlock);
                            d.posToSet = new PhysicalLocation(0.0f, 0.0f, 0.0f);
                            log.info("at start - TS: {}, block: {}, loco: {}, panel: {}", new Object[]{ts.getName(), newBlock, locoAddress, d.getModels().getTitle()});
                        }
                    } else {
                        log.warn("block {} is not a valid start block; valid start blocks are: {}", (Object)newBlock, this.possibleStartBlocks);
                    }
                }
            } else {
                this.currentBlock.put(d, newBlock);
                if (d.distanceOnTrack > 0.0) {
                    boolean result = true;
                    d.distanceOnTrack = 0.0;
                    LayoutTrack last = d.getLayoutTrack();
                    if (d.getLayoutTrack() instanceof TrackSegment) {
                        TrackSegmentView tsv = d.getModels().getTrackSegmentView((TrackSegment)d.getLayoutTrack());
                        log.debug(" true - layout track: {}, last track: {}, connect1: {}, connect2: {}, last block: {}", new Object[]{d.getLayoutTrack().getName(), d.getLastTrack().getName(), tsv.getConnect1(), tsv.getConnect2(), tsv.getBlockName()});
                        if (tsv.getConnect1().equals(d.getLastTrack())) {
                            d.setLayoutTrack(tsv.getConnect2());
                        } else if (tsv.getConnect2().equals(d.getLastTrack())) {
                            d.setLayoutTrack(tsv.getConnect1());
                        } else {
                            log.info(" TS lost, c1: {}, c2: {}, last track: {}", new Object[]{tsv.getConnect1(), tsv.getConnect2(), d.getLastTrack()});
                            result = false;
                        }
                        if (result) {
                            d.setLastTrack(last);
                            d.setReturnTrack(d.getLayoutTrack());
                            d.setReturnLastTrack(d.getLayoutTrack());
                            log.debug(" next track (layout track): {}, last track: {}", (Object)d.getLayoutTrack(), (Object)d.getLastTrack());
                        }
                    } else if (d.getLayoutTrack() instanceof LayoutTurnout || d.getLayoutTrack() instanceof LayoutSlip || d.getLayoutTrack() instanceof LevelXing || d.getLayoutTrack() instanceof LayoutTurntable) {
                        if (d.nextLayoutTrack != null) {
                            d.setLayoutTrack(d.nextLayoutTrack);
                        } else {
                            result = false;
                        }
                        if (result) {
                            d.setLastTrack(last);
                            d.setReturnTrack(d.getLayoutTrack());
                            d.setReturnLastTrack(d.getLayoutTrack());
                        }
                    }
                }
            }
        } else {
            log.warn(" Same PhysicalLocationReporter, position not set!");
        }
    }

    private void changeDirection(VSDecoder d, int locoAddress, int new_rp_index) {
        PhysicalLocation point1 = this.blockPositionlists.get(d.setup_index).get(new_rp_index);
        PhysicalLocation point2 = this.blockPositionlists.get(d.setup_index).get(new_rp_index + 1);
        Point2D.Double coords1 = new Point2D.Double(point1.x, point1.y);
        Point2D.Double coords2 = new Point2D.Double(point2.x, point2.y);
        int direct = d.dirfn == 1 ? Path.computeDirection(coords1, coords2) : Path.computeDirection(coords2, coords1);
        this.locoInBlock[this.getArrayIndex((int)locoAddress)][4] = direct;
        log.debug("direction: {} ({})", (Object)Path.decodeDirection(direct), (Object)direct);
    }

    public int getArrayIndex(int number) {
        for (int i = 0; i < this.locoInBlock.length; ++i) {
            if (this.locoInBlock[i][0] != number) continue;
            return i;
        }
        return this.locoInBlock.length;
    }

    public void locoInBlockRemove(int numb) {
        int k;
        int i;
        int remove_index = 0;
        for (i = 0; i < this.locoInBlock.length; ++i) {
            if (this.locoInBlock[i][0] != numb) continue;
            remove_index = i;
        }
        for (i = remove_index; i < this.locoInBlock.length - 1; ++i) {
            for (k = 0; k < this.locoInBlock[i].length; ++k) {
                this.locoInBlock[i][k] = this.locoInBlock[i + 1][k];
            }
        }
        int il = this.locoInBlock.length - 1;
        for (k = 0; k < this.locoInBlock[il].length; ++k) {
            this.locoInBlock[il][k] = 0;
        }
    }

    public void loadProfiles(VSDFile vf) {
        Element root = vf.getRoot();
        if (root == null) {
            return;
        }
        ArrayList<String> new_entries = new ArrayList<String>();
        for (Element e : root.getChildren("profile")) {
            String pname = e.getAttributeValue("name");
            log.debug("Profile name: {}", (Object)pname);
            if (pname == null || pname.isEmpty()) continue;
            this.profiletable.put(pname, vf.getName());
            new_entries.add(pname);
        }
        if (!GraphicsEnvironment.isHeadless()) {
            this.fireMyEvent(new VSDManagerEvent(this, VSDManagerEvent.EventType.PROFILE_LIST_CHANGE, new_entries));
        }
    }

    void initSoundPositionTimer() {
        if (this.timer == null) {
            this.timer = new Timer(this.check_time, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (VSDecoder d : VSDecoderManager.this.getVSDecoderList()) {
                        if (VSDecoderManager.this.alf_version == 1) {
                            VSDecoderManager.this.calcNewPosition(d);
                            continue;
                        }
                        if (VSDecoderManager.this.alf_version != 2 || d.getLayoutTrack() == null) continue;
                        int ix = VSDecoderManager.this.getArrayIndex(d.getAddress().getNumber());
                        float actualspeed = d.getEngineSound().getActualSpeed();
                        if (VSDecoderManager.this.locoInBlock[ix][3] != d.dirfn && d.getEngineSound().isEngineStarted()) {
                            VSDecoderManager.this.locoInBlock[ix][3] = d.dirfn;
                            d.distanceOnTrack = d.distanceOnTrack <= d.getReturnDistance() ? d.getReturnDistance() - d.distanceOnTrack : d.getReturnDistance();
                            d.setLayoutTrack(d.getReturnTrack());
                            d.setLastTrack(d.getReturnLastTrack());
                            log.debug("direction changed to {}, layout: {}, last: {}, return: {}, d.getReturnDistance: {}, d.distanceOnTrack: {}, d.getDistance: {}", new Object[]{d.dirfn, d.getLayoutTrack(), d.getLastTrack(), d.getReturnTrack(), d.getReturnDistance(), d.distanceOnTrack, d.getDistance()});
                            d.setDistance(0.0);
                        }
                        if (!(d.getEngineSound().isEngineStarted() && actualspeed > 0.0f) && !(d.getLayoutTrack() instanceof LayoutTurntable)) continue;
                        float speed_ms = actualspeed * (float)(d.dirfn == 1 ? d.topspeed : d.topspeed_rev) * 0.44704f / VSDecoderManager.this.layout_scale;
                        d.setDistance(d.getDistance() + (double)(speed_ms * (float)VSDecoderManager.this.check_time) / 10.0);
                        d.navigate();
                        if (d.getLocation() == null) continue;
                        Point2D loc = d.getLocation();
                        Point2D.Double loc2 = new Point2D.Double(((float)loc.getX() - VSDecoderManager.this.models_origin.x) * 0.01f, (VSDecoderManager.this.models_origin.y - (float)loc.getY()) * 0.01f);
                        d.posToSet.x = (float)((Point2D)loc2).getX();
                        d.posToSet.y = (float)((Point2D)loc2).getY();
                        d.posToSet.z = 0.0f;
                        log.debug("address {} position to set: {}, location: {}", new Object[]{d.getAddress(), d.posToSet, loc});
                        d.setPosition(d.posToSet);
                    }
                }
            });
            this.timer.setRepeats(true);
            this.timer.setInitialDelay(this.check_time);
            this.timer.start();
            log.debug("timer {} started, check time: {}", (Object)this.timer, (Object)this.check_time);
        }
    }

    void stopSoundPositionTimer() {
        if (this.timer != null) {
            if (this.timer.isRunning()) {
                this.timer.stop();
            } else {
                log.debug("timer {} was not running", (Object)this.timer);
            }
        }
    }

    public void calcNewPosition(VSDecoder d) {
        float actualspeed = d.getEngineSound().getActualSpeed();
        if (actualspeed > 0.0f && d.topspeed > 0) {
            int dadr = d.getAddress().getNumber();
            int dadr_index = this.getArrayIndex(dadr);
            if (dadr_index < this.locoInBlock.length) {
                int dadr_block = this.locoInBlock[dadr_index][1];
                if (this.reporterlists.get(d.setup_index).contains(dadr_block)) {
                    int dadr_block_index = this.reporterlists.get(d.setup_index).indexOf(dadr_block);
                    this.newPosition = new PhysicalLocation(0.0f, 0.0f, 0.0f, d.getEngineSound().getTunnel());
                    float speed_ms = actualspeed * (float)(d.dirfn == 1 ? d.topspeed : d.topspeed_rev) * 0.44704f / this.layout_scale;
                    d.distanceMeter = speed_ms * (float)this.check_time / 1000.0f;
                    if (this.locoInBlock[dadr_index][3] == 0) {
                        this.locoInBlock[dadr_index][3] = d.dirfn;
                    }
                    this.distance_rest_old = (float)this.locoInBlock[dadr_index][2] / 100.0f;
                    if (this.locoInBlock[dadr_index][3] == d.dirfn) {
                        this.distance_rest = this.distance_rest_old;
                    } else {
                        this.distance_rest = this.blockParameter[d.setup_index][dadr_block_index][4] - this.distance_rest_old;
                        this.locoInBlock[dadr_index][3] = d.dirfn;
                        this.changeDirection(d, dadr, dadr_block_index);
                        log.debug("direction changed to {}", (Object)this.locoInBlock[dadr_index][4]);
                    }
                    this.distance_rest_new = this.distance_rest - d.distanceMeter;
                    log.debug(" distance_rest_old: {}, distance_rest: {}, distance_rest_new: {} (all in Meter)", new Object[]{Float.valueOf(this.distance_rest_old), Float.valueOf(this.distance_rest), Float.valueOf(this.distance_rest_new)});
                    if (this.distance_rest_new > 0.0f) {
                        if (this.blockParameter[d.setup_index][dadr_block_index][0] == 0.0f) {
                            if (this.locoInBlock[dadr_index][4] == 32) {
                                this.newPosition.x = d.lastPos.x;
                                this.newPosition.y = d.lastPos.y - d.distanceMeter;
                            } else if (this.locoInBlock[dadr_index][4] == 16) {
                                this.newPosition.x = d.lastPos.x;
                                this.newPosition.y = d.lastPos.y + d.distanceMeter;
                            } else {
                                this.xPosi = d.distanceMeter * (float)Math.sqrt(1.0f / (1.0f + this.blockParameter[d.setup_index][dadr_block_index][1] * this.blockParameter[d.setup_index][dadr_block_index][1]));
                                if (this.locoInBlock[dadr_index][4] == 160 || this.locoInBlock[dadr_index][4] == 128 || this.locoInBlock[dadr_index][4] == 144) {
                                    this.newPosition.x = d.lastPos.x - this.xPosi;
                                    this.newPosition.y = d.lastPos.y - this.xPosi * this.blockParameter[d.setup_index][dadr_block_index][1];
                                } else {
                                    this.newPosition.x = d.lastPos.x + this.xPosi;
                                    this.newPosition.y = d.lastPos.y + this.xPosi * this.blockParameter[d.setup_index][dadr_block_index][1];
                                }
                            }
                            this.newPosition.z = 0.0f;
                        } else {
                            float anglePos = d.distanceMeter / this.blockParameter[d.setup_index][dadr_block_index][0] * (float)(-d.dirfn);
                            float rotate_xpos = this.blockParameter[d.setup_index][dadr_block_index][2];
                            float rotate_ypos = this.blockParameter[d.setup_index][dadr_block_index][3];
                            this.newPosition.x = rotate_xpos + (float)Math.cos(anglePos) * (d.lastPos.x - rotate_xpos) - (float)Math.sin(anglePos) * (d.lastPos.y - rotate_ypos);
                            this.newPosition.y = rotate_ypos + (float)Math.sin(anglePos) * (d.lastPos.x - rotate_xpos) + (float)Math.cos(anglePos) * (d.lastPos.y - rotate_ypos);
                            this.newPosition.z = 0.0f;
                        }
                        log.debug("position to set: {}", (Object)this.newPosition);
                        d.setPosition(this.newPosition);
                        log.debug(" distance rest to go in block: {} of {} cm", (Object)Math.round(this.distance_rest_new * 100.0f), (Object)Math.round(this.blockParameter[d.setup_index][dadr_block_index][4] * 100.0f));
                        this.locoInBlock[dadr_index][2] = Math.round(this.distance_rest_new * 100.0f);
                        log.debug(" saved distance rest: {}", (Object)this.locoInBlock[dadr_index][2]);
                    } else {
                        log.debug(" new position not set due to less distance");
                    }
                } else {
                    log.warn(" block for loco address {} not yet identified. May be there is another loco in the same block", (Object)dadr);
                }
            } else {
                log.warn(" decoder {} not found", (Object)dadr);
            }
        }
    }
}

