/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import jmri.jmrit.XmlFile;
import jmri.jmrit.vsdecoder.VSDecoderManager;
import jmri.jmrit.vsdecoder.listener.ListeningSpot;
import jmri.util.FileUtil;
import jmri.util.PhysicalLocation;
import jmri.util.ThreadingUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSDecoderPreferences {
    public static final String VSDPreferencesFileName = "VSDecoderPreferences.xml";
    public static final int DefaultMasterVolume = 80;
    private boolean _autoStartEngine = false;
    private boolean _autoLoadVSDFile = false;
    private boolean _use_blocks = true;
    private String _defaultVSDFilePath = null;
    private ListeningSpot _listenerPosition;
    private int _masterVolume;
    private String prefFile;
    private ArrayList<PropertyChangeListener> listeners;
    private static final Logger log = LoggerFactory.getLogger(VSDecoderPreferences.class);

    public VSDecoderPreferences(String sfile) {
        Element root;
        this.prefFile = sfile;
        VSDecoderPrefsXml prefs = new VSDecoderPrefsXml();
        File file = new File(this.prefFile);
        this._defaultVSDFilePath = FileUtil.getExternalFilename("program:resources/vsdecoder");
        this._listenerPosition = new ListeningSpot();
        this._masterVolume = 80;
        try {
            root = prefs.rootFromFile(file);
        }
        catch (IOException e2) {
            log.info("Did not find VSDecoder preferences file.  This is normal if you haven't save the preferences before");
            root = null;
        }
        catch (RuntimeException | JDOMException e) {
            log.error("Exception while loading VSDecoder preferences", e);
            root = null;
        }
        if (root != null) {
            Element rf = root.getChild("VSDecoderPreferences");
            ThreadingUtil.runOnGUI(() -> this.load(rf));
        }
    }

    public VSDecoderPreferences() {
    }

    private void load(Element e) {
        Element c;
        if (e == null) {
            return;
        }
        Attribute a = e.getAttribute("isAutoStartingEngine");
        if (a != null) {
            this.setAutoStartEngine(a.getValue().equals("true"));
        }
        if ((a = e.getAttribute("isAutoLoadingVSDFile")) != null) {
            this.setAutoLoadVSDFile(a.getValue().equals("true"));
        } else {
            a = e.getAttribute("isAutoLoadingDefaultVSDFile");
            if (a != null) {
                this.setAutoLoadVSDFile(a.getValue().equals("true"));
            }
        }
        a = e.getAttribute("useBlocks");
        if (a != null) {
            this.setUseBlocksSetting(a.getValue().equals("true"));
        }
        if ((c = e.getChild("DefaultVSDFilePath")) != null) {
            this.setDefaultVSDFilePath(c.getValue());
        }
        if ((c = e.getChild("ListenerPosition")) != null) {
            this._listenerPosition.parseListeningSpot(c);
        } else {
            this._listenerPosition = new ListeningSpot();
        }
        c = e.getChild("MasterVolume");
        if (c != null) {
            this.setMasterVolume(Integer.parseInt(c.getValue()));
        }
    }

    private Element store() {
        Element e = new Element("VSDecoderPreferences");
        e.setAttribute("isAutoStartingEngine", "" + this.isAutoStartingEngine());
        e.setAttribute("isAutoLoadingVSDFile", "" + this.isAutoLoadingVSDFile());
        e.setAttribute("useBlocks", "" + this.getUseBlocksSetting());
        Element ec = new Element("DefaultVSDFilePath");
        ec.setText(this.getDefaultVSDFilePath());
        e.addContent((Content)ec);
        e.addContent((Content)this._listenerPosition.getXml("ListenerPosition"));
        ec = new Element("MasterVolume");
        ec.setText("" + this.getMasterVolume());
        e.addContent((Content)ec);
        return e;
    }

    public void set(VSDecoderPreferences tp) {
        this.setAutoStartEngine(tp.isAutoStartingEngine());
        this.setAutoLoadVSDFile(tp.isAutoLoadingVSDFile());
        this.setUseBlocksSetting(tp.getUseBlocksSetting());
        this.setDefaultVSDFilePath(tp.getDefaultVSDFilePath());
        this.setListenerPosition(tp.getListenerPosition());
        this.setMasterVolume(tp.getMasterVolume());
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                PropertyChangeListener l = this.listeners.get(i);
                PropertyChangeEvent e = new PropertyChangeEvent(this, "VSDecoderPreferences", null, this);
                l.propertyChange(e);
            }
        }
    }

    public boolean compareTo(VSDecoderPreferences tp) {
        return this.isAutoStartingEngine() != tp.isAutoStartingEngine() || this.isAutoLoadingVSDFile() != tp.isAutoLoadingVSDFile() || this.getUseBlocksSetting() != tp.getUseBlocksSetting() || !this.getDefaultVSDFilePath().equals(tp.getDefaultVSDFilePath()) || this.getListenerPosition().equals(tp.getListenerPosition()) == false || !this.getMasterVolume().equals(tp.getMasterVolume());
    }

    public void save() {
        if (this.prefFile == null) {
            return;
        }
        XmlFile xf = new XmlFile(){};
        xf.makeBackupFile(this.prefFile);
        File file = new File(this.prefFile);
        try {
            File parentDir = file.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdir()) {
                log.error("failed to make parent directory");
            }
            if (!file.createNewFile()) {
                log.error("createNewFile failed");
            }
        }
        catch (IOException | RuntimeException exp) {
            log.error("Exception while writing the new VSDecoder preferences file, may not be complete", (Throwable)exp);
        }
        try {
            Element root = new Element("vsdecoder-preferences");
            Document doc = XmlFile.newDocument(root);
            root.setContent((Content)this.store());
            xf.writeXML(file, doc);
        }
        catch (IOException | RuntimeException ex) {
            log.warn("Exception in storing vsdecoder preferences xml", (Throwable)ex);
        }
    }

    public String getDefaultVSDFilePath() {
        return this._defaultVSDFilePath;
    }

    public void setDefaultVSDFilePath(String s) {
        this._defaultVSDFilePath = s;
    }

    public boolean isAutoStartingEngine() {
        return this._autoStartEngine;
    }

    public void setAutoStartEngine(boolean b) {
        this._autoStartEngine = b;
    }

    public boolean isAutoLoadingVSDFile() {
        return this._autoLoadVSDFile;
    }

    public void setUseBlocksSetting(boolean b) {
        this._use_blocks = b;
    }

    public boolean getUseBlocksSetting() {
        return this._use_blocks;
    }

    public void setAutoLoadVSDFile(boolean b) {
        this._autoLoadVSDFile = b;
    }

    public ListeningSpot getListenerPosition() {
        log.debug("getListenerPosition(): {}", (Object)this._listenerPosition);
        return this._listenerPosition;
    }

    public void setListenerPosition(ListeningSpot p) {
        VSDecoderManager vm = VSDecoderManager.instance();
        vm.setListenerLocation(vm.getDefaultListenerName(), p);
        this._listenerPosition = p;
    }

    public PhysicalLocation getListenerPhysicalLocation() {
        return this._listenerPosition.getPhysicalLocation();
    }

    public void setListenerPosition(PhysicalLocation p) {
        VSDecoderManager vm = VSDecoderManager.instance();
        vm.setListenerLocation(vm.getDefaultListenerName(), new ListeningSpot(p));
    }

    public void setMasterVolume(int v) {
        this._masterVolume = v;
    }

    public Integer getMasterVolume() {
        return this._masterVolume;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    static class VSDecoderPrefsXml
    extends XmlFile {
        VSDecoderPrefsXml() {
        }
    }
}

