/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder.listener;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import jmri.util.PhysicalLocation;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListeningSpot {
    private Vector3d _location;
    private Vector3d _up;
    private Vector3d _lookAt;
    private String _name;
    private static final Vector3d _atVector = new Vector3d(0.0, 1.0, 0.0);
    private static final Vector3d _upVector = new Vector3d(0.0, 0.0, 1.0);
    private static final Vector3d _locVector = new Vector3d(0.0, 0.0, 0.0);
    private static final double MAX_DIST = 9999.99;
    private static final Logger log = LoggerFactory.getLogger(ListeningSpot.class);

    public ListeningSpot() {
        this._name = null;
        this._location = _locVector;
        this._up = _upVector;
        this._lookAt = _atVector;
    }

    public ListeningSpot(Vector3f position) {
        this._name = null;
        this._location = new Vector3d(position);
        this._up = _upVector;
        this._lookAt = _atVector;
    }

    public ListeningSpot(String name, Vector3d loc, Vector3d up, Vector3d at) {
        this._name = name;
        this._location = loc;
        this._up = up;
        this._lookAt = at;
    }

    public String getName() {
        return this._name;
    }

    public Vector3d getLocation() {
        return this._location;
    }

    public PhysicalLocation getPhysicalLocation() {
        return new PhysicalLocation(this._location.x, this._location.y, this._location.z);
    }

    public Vector3d getUpVector() {
        return this._up;
    }

    public Vector3d getLookAtVector() {
        return this._lookAt;
    }

    public Double getBearing() {
        Vector3d lav = this.getLookAtVector();
        Double b = Math.toDegrees(Math.atan(lav.x / lav.y));
        if (lav.y < 0.0) {
            b = b + 180.0;
        } else if (b < 0.0) {
            b = b + 360.0;
        }
        return b;
    }

    public Double getAzimuth() {
        Vector3d lav = this.getLookAtVector();
        Double r = Math.sqrt(lav.x * lav.x + lav.y * lav.y + lav.z * lav.z);
        return 90.0 - Math.toDegrees(Math.acos(lav.z / r));
    }

    public void setName(String n) {
        this._name = n;
    }

    public void setLocation(Vector3d loc) {
        this._location = loc;
    }

    public void setLocation(Double x, Double y, Double z) {
        if (x == null) {
            x = 0.0;
        } else {
            x = ListeningSpot.checkLimits(x);
            x = ListeningSpot.roundDecimal(x);
        }
        if (y == null) {
            y = 0.0;
        } else {
            y = ListeningSpot.checkLimits(y);
            y = ListeningSpot.roundDecimal(y);
        }
        if (z == null) {
            z = 0.0;
        } else {
            z = ListeningSpot.checkLimits(z);
            z = ListeningSpot.roundDecimal(z);
        }
        this._location = new Vector3d(x.doubleValue(), y.doubleValue(), z.doubleValue());
    }

    public void setLocation(PhysicalLocation l) {
        this._location = new Vector3d((double)l.getX(), (double)l.getY(), (double)l.getZ());
    }

    public void setUpVector(Vector3d up) {
        this._up = up;
    }

    public void setLookAtVector(Vector3d at) {
        this._lookAt = at;
    }

    public void setOrientation(PhysicalLocation target) {
        Vector3d la = new Vector3d();
        la.sub((Tuple3d)target.toVector3d(), (Tuple3d)this._location);
        la.normalize();
        this._lookAt = la;
        this._up = this.calcUpFromLookAt(la);
    }

    private Vector3d calcUpFromLookAt(Vector3d la) {
        Vector3d _la = la;
        _la.normalize();
        Vector3d up = new Vector3d();
        up.cross(_la, _upVector);
        up.cross(up, _la);
        up.normalize();
        return up;
    }

    public void setOrientation(Double bearing, Double azimuth) {
        if (bearing == null) {
            bearing = 0.0;
        }
        if (azimuth == null) {
            azimuth = 0.0;
        }
        if (azimuth > 90.0) {
            azimuth = 180.0 - azimuth;
        } else if (azimuth < -90.0) {
            azimuth = -180.0 - azimuth;
        }
        double y = Math.sin(Math.toRadians(90.0 - azimuth)) * Math.cos(Math.toRadians(bearing));
        double x = Math.sin(Math.toRadians(90.0 - azimuth)) * Math.sin(Math.toRadians(bearing));
        double z = Math.cos(Math.toRadians(90.0 - azimuth));
        this._lookAt = new Vector3d(x, y, z);
        this._up = this.calcUpFromLookAt(this._lookAt);
        this._lookAt.x = ListeningSpot.roundDecimal(this._lookAt.x);
        this._lookAt.y = ListeningSpot.roundDecimal(this._lookAt.y);
        this._lookAt.z = ListeningSpot.roundDecimal(this._lookAt.z);
        this._up.x = ListeningSpot.roundDecimal(this._up.x);
        this._up.y = ListeningSpot.roundDecimal(this._up.y);
        this._up.z = ListeningSpot.roundDecimal(this._up.z);
    }

    public Boolean equals(ListeningSpot other) {
        if (this._name.equals(other.getName()) && this._location == other.getLocation() && this._up == other.getUpVector() && this._lookAt == other.getLookAtVector()) {
            return true;
        }
        return false;
    }

    private Vector3d parseVector3d(String pos) {
        if (pos == null) {
            return null;
        }
        String syntax = "\\((\\s*[-+]?[0-9]*\\.?[0-9]+),(\\s*[-+]?[0-9]*\\.?[0-9]+),(\\s*[-+]?[0-9]*\\.?[0-9]+)\\)";
        try {
            Pattern p = Pattern.compile(syntax);
            Matcher m = p.matcher(pos);
            if (!m.matches()) {
                log.error("String does not match a valid position pattern. syntax: {}, string: {}", (Object)syntax, (Object)pos);
                return null;
            }
            String xs = m.group(1);
            String ys = m.group(2);
            String zs = m.group(3);
            log.debug("Loading Vector3d: x = {} y = {} z = {}", new Object[]{xs, ys, zs});
            return new Vector3d(Double.parseDouble(m.group(1)), Double.parseDouble(m.group(2)), Double.parseDouble(m.group(3)));
        }
        catch (PatternSyntaxException e) {
            log.error("Malformed Vector3d syntax! {}", (Object)syntax);
            return null;
        }
        catch (IllegalStateException e) {
            log.error("Group called before match operation executed syntax: {}, string: {}, {}", new Object[]{syntax, pos, e.toString()});
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            log.error("Index out of bounds: {}, string: {}, {}", new Object[]{syntax, pos, e.toString()});
            return null;
        }
    }

    public String toString() {
        if (this._location == null || this._lookAt == null || this._up == null) {
            return "ListeningSpot (undefined)";
        }
        return "ListeningSpot Name: " + this._name + " Location: " + this._location.toString() + " LookAt: " + this._lookAt.toString() + " Up: " + this._up.toString();
    }

    public ListeningSpot parseListeningSpot(Element e) {
        this.setXml(e);
        return new ListeningSpot(this._name, this._location, this._up, this._lookAt);
    }

    public Element getXml(String elementName) {
        Element me = new Element(elementName);
        me.setAttribute("name", this._name == null ? "default" : this._name);
        me.setAttribute("location", this._location.toString());
        me.setAttribute("up", this._up.toString());
        me.setAttribute("look_at", this._lookAt.toString());
        return me;
    }

    public void setXml(Element e) {
        if (e != null) {
            this._name = e.getAttributeValue("name");
            this._location = this.parseVector3d(e.getAttributeValue("location"));
            this._up = this.parseVector3d(e.getAttributeValue("up"));
            this._lookAt = this.parseVector3d(e.getAttributeValue("look_at"));
            log.debug("ListeningSpot: name: {}, location: {}, up: {}, lookAt: {}", new Object[]{this._name, this._location, this._up, this._lookAt});
        }
    }

    private static double roundDecimal(double value) {
        return (double)Math.round(value * 100.0) / 100.0;
    }

    private static double checkLimits(double value) {
        value = Math.max(-9999.99, value);
        value = Math.min(9999.99, value);
        return value;
    }
}

