/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder.swing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.jmrit.vsdecoder.EnginePane;
import jmri.jmrit.vsdecoder.swing.Bundle;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DieselPane
extends EnginePane {
    static final int THROTTLE_MIN = 1;
    static final int THROTTLE_MAX = 18;
    static final int THROTTLE_INIT = 1;
    public static final String THROTTLE = "VSDDP:Throttle";
    public static final String START = "VSDDP:Start";
    public static final String VOLUME = "VSDDP:Volume";
    JSpinner throttle_spinner;
    private JSlider volume_slider;
    JToggleButton start_button;
    int throttle_setting;
    private boolean engine_is_started;
    private Timer timer;
    int dtime = 1;
    float lastSpeed = 0.0f;
    private static final Logger log = LoggerFactory.getLogger(DieselPane.class);

    public DieselPane(String n) {
        super(n);
        this.initComponents();
        this.throttle_setting = 1;
        this.engine_is_started = this.start_button.isSelected();
    }

    public DieselPane() {
        this((String)null);
    }

    @Override
    public void initContext(Object context) {
        this.initComponents();
    }

    protected Timer newTimer(int time, boolean repeat, ActionListener al) {
        this.timer = new Timer(time, al);
        this.timer.setRepeats(repeat);
        return this.timer;
    }

    void startDelayTimer() {
        if (this.dtime > 1) {
            this.start_button.setEnabled(false);
            this.timer = this.newTimer(this.dtime, false, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DieselPane.this.start_button.setEnabled(true);
                }
            });
            this.timer.start();
        }
    }

    @Override
    public void setButtonDelay(long t) {
        if (t > Integer.MAX_VALUE) {
            t = Integer.MAX_VALUE;
        }
        this.dtime = (int)t;
    }

    @Override
    public void initComponents() {
        this.throttle_spinner = new JSpinner(new SpinnerNumberModel(1, 1, 18, 1));
        this.throttle_spinner.setPreferredSize(new Dimension(40, 30));
        this.throttle_spinner.setToolTipText(Bundle.getMessage("ToolTipDP_ThrottleSpinner"));
        this.throttle_spinner.setEnabled(false);
        this.add(this.throttle_spinner);
        this.start_button = new JToggleButton();
        this.start_button.setText(Bundle.getMessage("ButtonEngineStart"));
        this.start_button.setPreferredSize(new Dimension(150, 30));
        this.start_button.setToolTipText(Bundle.getMessage("ToolTipDP_StartButton"));
        this.start_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DieselPane.this.startButtonChange(e);
            }
        });
        this.start_button.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                DieselPane.this.startButtonStateChange(ev);
            }
        });
        this.add(this.start_button);
        this.volume_slider = new JSlider(0, 100);
        this.volume_slider.setMinorTickSpacing(10);
        this.volume_slider.setPaintTicks(true);
        this.volume_slider.setPreferredSize(new Dimension(160, 30));
        this.volume_slider.setToolTipText(Bundle.getMessage("DecoderVolumeToolTip"));
        this.volume_slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DieselPane.this.volumeChange(e);
            }
        });
        this.add(this.volume_slider);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setVisible(true);
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="I18N of Headless Info Message")
    public void startButtonStateChange(ChangeEvent ev) {
        AbstractButton abstractButton = (AbstractButton)ev.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        boolean armed = buttonModel.isArmed();
        boolean pressed = buttonModel.isPressed();
        boolean selected = buttonModel.isSelected();
        if (armed && pressed && selected && this.lastSpeed > 0.0f && !this.engine_is_started) {
            buttonModel.setArmed(false);
            buttonModel.setPressed(false);
            buttonModel.setSelected(false);
            if (GraphicsEnvironment.isHeadless()) {
                log.info(Bundle.getMessage("EngineStartSpeedMessage"));
            } else {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("EngineStartSpeedMessage"));
            }
        }
        if (armed && pressed && selected && this.lastSpeed > 0.0f && this.engine_is_started && this.getStopOption()) {
            buttonModel.setArmed(false);
            buttonModel.setPressed(false);
            if (GraphicsEnvironment.isHeadless()) {
                log.info(Bundle.getMessage("EngineStopSpeedMessage"));
            } else {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("EngineStopSpeedMessage"));
            }
        }
    }

    public void throttleChange(ChangeEvent e) {
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, THROTTLE, this.throttle_setting, this.throttle_spinner.getModel().getValue()));
        this.throttle_setting = this.throttleNotch();
    }

    public void startButtonChange(ActionEvent e) {
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, START, this.engine_is_started, this.start_button.isSelected()));
        this.engine_is_started = this.start_button.isSelected();
        if (this.engine_is_started) {
            this.start_button.setText(Bundle.getMessage("ButtonEngineStop"));
        } else {
            this.start_button.setText(Bundle.getMessage("ButtonEngineStart"));
        }
        this.startDelayTimer();
    }

    protected void volumeChange(ChangeEvent e) {
        JSlider v = (JSlider)e.getSource();
        log.debug("Decoder Volume slider set to value: {}", (Object)v.getValue());
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, VOLUME, v.getValue(), null));
    }

    @Override
    public void startButtonClick() {
        this.start_button.doClick();
    }

    public boolean engineIsOn() {
        return this.start_button.isSelected();
    }

    public int throttleNotch() {
        return (Integer)this.throttle_spinner.getModel().getValue();
    }

    @Override
    public void setThrottle(int t) {
        this.throttle_spinner.setValue(t);
    }

    @Override
    public void setSpeed(float s) {
        this.lastSpeed = s;
    }

    public JSlider getVolumeSlider() {
        return this.volume_slider;
    }
}

