/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder.swing;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import javax.swing.AbstractAction;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.PhysicalLocationReporter;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.vsdecoder.VSDecoderManager;
import jmri.jmrit.vsdecoder.listener.ListeningSpot;
import jmri.jmrit.vsdecoder.swing.ManageLocationsFrame;
import jmri.util.PhysicalLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageLocationsAction
extends AbstractAction {
    private ManageLocationsFrame f = null;
    private ListeningSpot listenerLoc;
    private static final Logger log = LoggerFactory.getLogger(ManageLocationsAction.class);

    public ManageLocationsAction(String s) {
        super(s);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.f == null || !this.f.isVisible()) {
            this.listenerLoc = VSDecoderManager.instance().getVSDecoderPreferences().getListenerPosition();
            ReporterManager rmgr = InstanceManager.getDefault(ReporterManager.class);
            SortedSet reporterSet = rmgr.getNamedBeanSet();
            Object[][] reporterTable = new Object[reporterSet.size()][7];
            int i = 0;
            for (Reporter r : reporterSet) {
                if (r != null) {
                    if (r instanceof PhysicalLocationReporter) {
                        PhysicalLocation p = ((PhysicalLocationReporter)((Object)r)).getPhysicalLocation();
                        reporterTable[i][0] = r.getSystemName();
                        reporterTable[i][1] = r.getDisplayName();
                        reporterTable[i][2] = true;
                        reporterTable[i][3] = Float.valueOf(p.getX());
                        reporterTable[i][4] = Float.valueOf(p.getY());
                        reporterTable[i][5] = Float.valueOf(p.getZ());
                        reporterTable[i][6] = p.isTunnel();
                    } else {
                        reporterTable[i][0] = r.getSystemName();
                        reporterTable[i][1] = r.getDisplayName();
                        reporterTable[i][2] = false;
                        reporterTable[i][3] = Float.valueOf(0.0f);
                        reporterTable[i][4] = Float.valueOf(0.0f);
                        reporterTable[i][5] = Float.valueOf(0.0f);
                        reporterTable[i][6] = false;
                    }
                }
                ++i;
            }
            BlockManager bmgr = InstanceManager.getDefault(BlockManager.class);
            SortedSet blockSet = bmgr.getNamedBeanSet();
            Object[][] blockTable = new Object[blockSet.size()][7];
            i = 0;
            for (Block b : blockSet) {
                if (b != null) {
                    PhysicalLocation p = b.getPhysicalLocation();
                    blockTable[i][0] = b.getSystemName();
                    blockTable[i][1] = b.getDisplayName();
                    blockTable[i][2] = true;
                    blockTable[i][3] = Float.valueOf(p.getX());
                    blockTable[i][4] = Float.valueOf(p.getY());
                    blockTable[i][5] = Float.valueOf(p.getZ());
                    blockTable[i][6] = p.isTunnel();
                }
                ++i;
            }
            LocationManager lmgr = InstanceManager.getDefault(LocationManager.class);
            List<Location> locations = lmgr.getLocationsByIdList();
            log.debug("TableSize: {}", (Object)locations.size());
            Object[][] opsTable = new Object[locations.size()][6];
            i = 0;
            for (Location l : locations) {
                log.debug("i: {}, MLA: {}, Name: {}, table: {}", new Object[]{i, l.getId(), l.getName(), Arrays.toString(opsTable[i])});
                opsTable[i][0] = l.getName();
                PhysicalLocation p = l.getPhysicalLocation();
                opsTable[i][1] = p == PhysicalLocation.Origin ? Boolean.valueOf(false) : Boolean.valueOf(true);
                opsTable[i][2] = Float.valueOf(p.getX());
                opsTable[i][3] = Float.valueOf(p.getY());
                opsTable[i][4] = Float.valueOf(p.getZ());
                opsTable[i][5] = p.isTunnel();
                ++i;
            }
            this.f = new ManageLocationsFrame(this.listenerLoc, reporterTable, opsTable, blockTable);
        }
        this.f.setExtendedState(0);
    }
}

