/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import jmri.jmrit.vsdecoder.EngineSoundEvent;
import jmri.jmrit.vsdecoder.SoundEvent;
import jmri.jmrit.vsdecoder.VSDConfig;
import jmri.jmrit.vsdecoder.swing.Bundle;
import jmri.jmrit.vsdecoder.swing.VSDOptionsDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSDControl
extends JPanel {
    public static final String OPTION_CHANGE = "OptionChange";
    public static final String DELETE = "DeleteDecoder";
    private static final int NUMBER_SOUNDS = 8;
    private static final Map<String, Integer> Mnemonics = new HashMap<String, Integer>();
    String address;
    Border tb;
    JLabel addressLabel;
    JButton optionButton;
    JButton deleteButton;
    JPanel soundsPanel;
    JPanel configPanel;
    private VSDConfig config;
    private static final Logger log;

    public VSDControl() {
        this.initComponents("");
    }

    public VSDControl(String title) {
        this.address = title;
        this.config = new VSDConfig();
        this.initComponents(title);
    }

    public VSDControl(VSDConfig c) {
        this.config = c;
        this.address = this.config.getLocoAddress().toString();
        this.initComponents(this.address);
    }

    public static JPanel generateBlank() {
        VSDControl temp = new VSDControl("");
        JLabel jl = new JLabel(Bundle.getMessage("BlankVSDControlLabel"));
        jl.setMinimumSize(temp.getPreferredSize());
        jl.setPreferredSize(temp.getPreferredSize());
        jl.setHorizontalAlignment(0);
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add((Component)jl, "Center");
        jl.setMinimumSize(temp.getPreferredSize());
        jp.setPreferredSize(temp.getPreferredSize());
        jp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder()));
        return jp;
    }

    private GridBagConstraints setConstraints(int x, int y) {
        return this.setConstraints(x, y, 2, new Insets(2, 2, 2, 2), 21);
    }

    private GridBagConstraints setConstraints(int x, int y, int fill, Insets ins, int anchor) {
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = ins;
        gbc1.gridx = x;
        gbc1.gridy = y;
        gbc1.weightx = 100.0;
        gbc1.weighty = 100.0;
        gbc1.gridwidth = 1;
        gbc1.anchor = anchor;
        gbc1.fill = fill;
        return gbc1;
    }

    protected void initComponents(String title) {
        this.tb = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder());
        this.setBorder(this.tb);
        this.setLayout(new GridBagLayout());
        this.soundsPanel = new JPanel();
        this.soundsPanel.setLayout(new GridBagLayout());
        this.addressLabel = new JLabel(this.address);
        this.configPanel = new JPanel();
        this.configPanel.setLayout(new BoxLayout(this.configPanel, 3));
        this.optionButton = new JButton(Bundle.getMessage("OptionsButtonLabel"));
        this.deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
        this.configPanel.add(Box.createHorizontalGlue());
        this.configPanel.add(this.optionButton);
        this.optionButton.setToolTipText(Bundle.getMessage("MgrOptionButtonToolTip"));
        this.optionButton.setMnemonic(Mnemonics.get("OptionButton"));
        this.configPanel.add(Box.createHorizontalGlue());
        this.configPanel.add(this.deleteButton);
        this.deleteButton.setToolTipText(Bundle.getMessage("MgrDeleteButtonToolTip"));
        this.deleteButton.setMnemonic(Mnemonics.get("DeleteButton"));
        JPanel alPanel = new JPanel();
        alPanel.setLayout(new BoxLayout(alPanel, 3));
        alPanel.add(this.addressLabel);
        alPanel.add(new JLabel(this.config.getProfileName()));
        this.add((Component)alPanel, new GridBagConstraints(0, 0, 1, 2, 100.0, 100.0, 21, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.soundsPanel, this.setConstraints(2, 0));
        this.add((Component)this.configPanel, this.setConstraints(3, 0));
        this.optionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VSDControl.this.optionButtonPressed(e);
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VSDControl.this.deleteButtonPressed(e);
            }
        });
        this.setVisible(true);
    }

    void addSoundButtons(ArrayList<SoundEvent> elist) {
        this.soundsPanel.removeAll();
        int i = 0;
        for (SoundEvent e : elist) {
            if (e.getButton() == null) continue;
            log.debug("adding button {}", (Object)e.getButton());
            JComponent jc = e.getButton();
            GridBagConstraints gbc = new GridBagConstraints();
            if (e instanceof EngineSoundEvent) {
                gbc.gridy = 1;
                if (elist.size() > 8) {
                    gbc.gridy = 2;
                }
                gbc.gridwidth = elist.size() - 1;
                gbc.fill = 0;
                gbc.anchor = 21;
                this.soundsPanel.add((Component)jc, gbc);
                continue;
            }
            gbc.gridy = 0;
            if (++i > 8) {
                gbc.gridy = 1;
            }
            this.soundsPanel.add((Component)jc, gbc);
        }
    }

    protected void optionButtonPressed(ActionEvent e) {
        log.debug("({}) Option Button Pressed", (Object)this.address);
        VSDOptionsDialog d = new VSDOptionsDialog(this, Bundle.getMessage("OptionsDialogTitlePrefix") + " " + this.address);
        d.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                log.debug("property change name: {}, old: {}, new: {}", new Object[]{event.getPropertyName(), event.getOldValue(), event.getNewValue()});
                VSDControl.this.optionsDialogPropertyChange(event);
            }
        });
    }

    protected void deleteButtonPressed(ActionEvent e) {
        log.debug("({}) Delete Button Pressed", (Object)this.address);
        this.firePropertyChange(DELETE, this.address, null);
    }

    protected void optionsDialogPropertyChange(PropertyChangeEvent event) {
        log.debug("internal options dialog handler");
        this.firePropertyChange(OPTION_CHANGE, null, event.getNewValue());
    }

    static {
        Mnemonics.put("OptionButton", 79);
        Mnemonics.put("DeleteButton", 68);
        log = LoggerFactory.getLogger(VSDControl.class);
    }
}

