/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder.swing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.AudioManager;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Sensor;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.vsdecoder.LoadVSDFileAction;
import jmri.jmrit.vsdecoder.SoundEvent;
import jmri.jmrit.vsdecoder.VSDConfig;
import jmri.jmrit.vsdecoder.VSDecoder;
import jmri.jmrit.vsdecoder.VSDecoderManager;
import jmri.jmrit.vsdecoder.swing.Bundle;
import jmri.jmrit.vsdecoder.swing.VSDConfigDialog;
import jmri.jmrit.vsdecoder.swing.VSDControl;
import jmri.jmrit.vsdecoder.swing.VSDPreferencesAction;
import jmri.util.JmriJFrame;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSDManagerFrame
extends JmriJFrame {
    public static final String MUTE = "VSDMF:Mute";
    public static final String VOLUME_CHANGE = "VSDMF:VolumeChange";
    public static final String REMOVE_DECODER = "VSDMF:RemoveDecoder";
    public static final String CLOSE_WINDOW = "VSDMF:CloseWindow";
    private static final Map<String, Integer> Mnemonics = new HashMap<String, Integer>();
    private int master_volume;
    private JPanel decoderPane;
    private JPanel volumePane;
    private JPanel decoderBlank;
    private JButton addButton;
    private VSDConfig config;
    private VSDConfigDialog cd;
    private List<JMenu> menuList;
    private boolean is_auto_loading;
    private boolean is_block_using;
    private boolean is_viewing;
    private static final Logger log;

    public VSDManagerFrame() {
        super(true, true);
        this.addPropertyChangeListener(VSDecoderManager.instance());
        this.is_auto_loading = VSDecoderManager.instance().getVSDecoderPreferences().isAutoLoadingVSDFile();
        this.is_block_using = VSDecoderManager.instance().getVSDecoderPreferences().getUseBlocksSetting();
        this.is_viewing = !VSDecoderManager.instance().getVSDecoderList().isEmpty();
        this.initGUI();
    }

    @Override
    public void initComponents() {
    }

    private void initGUI() {
        log.debug("initGUI");
        this.setTitle(Bundle.getMessage("VSDManagerFrameTitle"));
        this.buildMenu();
        this.setLayout(new BoxLayout(this.getContentPane(), 3));
        this.decoderPane = new JPanel();
        this.decoderPane.setLayout(new BoxLayout(this.decoderPane, 3));
        this.decoderBlank = VSDControl.generateBlank();
        this.decoderPane.add(this.decoderBlank);
        this.volumePane = new JPanel();
        this.volumePane.setLayout(new BoxLayout(this.volumePane, 2));
        JToggleButton muteButton = new JToggleButton(Bundle.getMessage("MuteButtonLabel"));
        this.addButton = new JButton(Bundle.getMessage("AddButtonLabel"));
        JSlider volume = new JSlider(0, 100);
        volume.setMinorTickSpacing(10);
        volume.setPaintTicks(true);
        this.master_volume = VSDecoderManager.instance().getMasterVolume();
        volume.setValue(this.master_volume);
        volume.setPreferredSize(new Dimension(200, 20));
        volume.setToolTipText(Bundle.getMessage("MgrVolumeToolTip"));
        volume.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VSDManagerFrame.this.volumeChange(e);
            }
        });
        this.volumePane.add(new JLabel(Bundle.getMessage("VolumePaneLabel")));
        this.volumePane.add(volume);
        this.volumePane.add(muteButton);
        muteButton.setToolTipText(Bundle.getMessage("MgrMuteToolTip"));
        muteButton.setMnemonic(Mnemonics.get("MuteButton"));
        muteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VSDManagerFrame.this.muteButtonPressed(e);
            }
        });
        this.volumePane.add(this.addButton);
        this.addButton.setToolTipText(Bundle.getMessage("MgrAddButtonToolTip"));
        this.addButton.setMnemonic(Mnemonics.get("AddButton"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VSDManagerFrame.this.addButtonPressed(e);
            }
        });
        this.add(this.decoderPane);
        this.add(this.volumePane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VSDManagerFrame.this.firePropertyChange(VSDManagerFrame.CLOSE_WINDOW, null, null);
            }
        });
        log.debug("pane size + {}", (Object)this.decoderPane.getPreferredSize());
        this.pack();
        this.setVisible(true);
        ThreadingUtil.runOnGUI(() -> {
            if (this.is_viewing) {
                this.runViewing();
            } else if (this.is_auto_loading) {
                this.runAutoLoad();
            }
        });
    }

    private void runViewing() {
        log.debug("Viewing mode");
        for (VSDecoder vsd : VSDecoderManager.instance().getVSDecoderList()) {
            RosterEntry roster;
            if (vsd.getRosterEntry() != null) {
                roster = vsd.getRosterEntry();
            } else {
                roster = new RosterEntry(vsd.getAddress().toString());
                roster.setId(vsd.getId());
                roster.setDccAddress(String.valueOf(vsd.getAddress().getNumber()));
                roster.putAttribute("VSDecoder_Path", vsd.getVSDFilePath());
                roster.putAttribute("VSDecoder_Profile", vsd.getProfileName());
                roster.putAttribute("VSDecoder_LaunchThrottle", "no");
            }
            this.addButton.doClick();
            this.cd.setRosterItem(roster);
        }
        this.is_viewing = false;
    }

    private void runAutoLoad() {
        log.debug("Auto-Loading VSDecoder");
        String vsdRosterGroup = "VSD";
        Object msg = "";
        if (Roster.getDefault().getRosterGroupList().contains(vsdRosterGroup)) {
            List<RosterEntry> rosterList = Roster.getDefault().getEntriesInGroup(vsdRosterGroup);
            if (!rosterList.isEmpty()) {
                int entry_counter = 1;
                for (RosterEntry entry : rosterList) {
                    if (entry_counter <= 8) {
                        this.addButton.doClick();
                        this.cd.setRosterItem(entry);
                        ++entry_counter;
                        continue;
                    }
                    msg = "Only 8 Roster Entries allowed. Discarded " + (rosterList.size() - 8);
                }
            } else {
                msg = "No Roster Entry found in Roster Group " + vsdRosterGroup;
            }
        } else {
            msg = "Roster Group \"" + vsdRosterGroup + "\" not found";
        }
        if (!((String)msg).isEmpty()) {
            JmriJOptionPane.showMessageDialog(null, "Auto-Loading: " + (String)msg);
            log.warn("Auto-Loading VSDecoder aborted");
        }
    }

    protected void muteButtonPressed(ActionEvent e) {
        JToggleButton b = (JToggleButton)e.getSource();
        log.debug("Mute button pressed. value: {}", (Object)b.isSelected());
        this.firePropertyChange(MUTE, !b.isSelected(), b.isSelected());
    }

    protected void addButtonPressed(ActionEvent e) {
        log.debug("Add button pressed");
        if (!this.is_viewing && VSDecoderManager.instance().getVSDecoderList().size() >= 8) {
            JmriJOptionPane.showMessageDialog(null, "VSDecoder cannot be created. Maximal number is " + String.valueOf(8));
        } else if (InstanceManager.getDefault(AudioManager.class).getNamedBeanSet('B').size() == 255) {
            JmriJOptionPane.showMessageDialog(null, "Decoder cannot be created! No more free buffers.");
        } else {
            this.config = new VSDConfig();
            this.cd = new VSDConfigDialog(this.decoderPane, Bundle.getMessage("NewDecoderConfigPaneTitle"), this.config, this.is_auto_loading, this.is_viewing);
            this.cd.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    log.debug("property change name {}, old: {}, new: {}", new Object[]{event.getPropertyName(), event.getOldValue(), event.getNewValue()});
                    VSDManagerFrame.this.addButtonPropertyChange(event);
                }
            });
        }
    }

    protected void addButtonPropertyChange(PropertyChangeEvent event) {
        log.debug("internal config dialog handler");
        if (!this.is_viewing && VSDecoderManager.instance().getVSDecoderByAddress(this.config.getLocoAddress().toString()) != null) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("MgrAddDuplicateMessage"));
        } else {
            VSDecoder newDecoder = VSDecoderManager.instance().getVSDecoder(this.config);
            if (newDecoder != null) {
                VSDControl newControl = new VSDControl(this.config);
                newControl.addPropertyChangeListener(newDecoder);
                this.addPropertyChangeListener(newDecoder);
                newControl.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        log.debug("property change name {}, old: {}, new: {}", new Object[]{event.getPropertyName(), event.getOldValue(), event.getNewValue()});
                        VSDManagerFrame.this.vsdControlPropertyChange(event);
                    }
                });
                if (this.decoderPane.isAncestorOf(this.decoderBlank)) {
                    this.decoderPane.remove(this.decoderBlank);
                }
                this.decoderPane.add(newControl);
                newControl.addSoundButtons(new ArrayList<SoundEvent>(newDecoder.getEventList()));
                this.firePropertyChange(VOLUME_CHANGE, (Object)this.master_volume, null);
                log.debug("Master volume set to {}", (Object)this.master_volume);
                this.decoderPane.revalidate();
                this.decoderPane.repaint();
                this.pack();
                if (this.is_viewing) {
                    VSDecoderManager.instance().doResume();
                } else {
                    this.getStartBlock(newDecoder);
                }
            }
        }
    }

    private void getStartBlock(VSDecoder vsd) {
        Block start_block = null;
        for (Block blk : InstanceManager.getDefault(BlockManager.class).getNamedBeanSet()) {
            int locoAddress;
            if (!VSDecoderManager.instance().checkForPossibleStartblock(blk) || (locoAddress = VSDecoderManager.instance().getLocoAddr(blk)) != vsd.getAddress().getNumber()) continue;
            log.debug("found start block: {}, loco address: {}", (Object)blk, (Object)locoAddress);
            Sensor s = blk.getSensor();
            if (s != null && this.is_block_using && s.getKnownState() == 1) {
                try {
                    s.setState(2);
                }
                catch (JmriException ex) {
                    log.debug("Exception setting sensor");
                }
            }
            start_block = blk;
            break;
        }
        if (start_block != null) {
            VSDecoderManager.instance().atStart(start_block);
        }
    }

    protected void vsdControlPropertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if (property.equals("DeleteDecoder")) {
            String ov = (String)event.getOldValue();
            log.debug("vsdControlPropertyChange. ID: {}, old: {}", (Object)"DeleteDecoder", (Object)ov);
            VSDecoder vsd = VSDecoderManager.instance().getVSDecoderByAddress(ov);
            if (vsd == null) {
                log.warn("Lost context, VSDecoder is null. Quit JMRI and start over.");
                return;
            }
            if (vsd.getEngineSound().isEngineStarted()) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("MgrDeleteWhenEngineStopped"));
                return;
            }
            this.removePropertyChangeListener(vsd);
            log.debug("vsdControlPropertyChange. ID: {}, old: {}", (Object)REMOVE_DECODER, (Object)ov);
            this.firePropertyChange(REMOVE_DECODER, ov, null);
            this.decoderPane.remove((VSDControl)event.getSource());
            if (this.decoderPane.getComponentCount() == 0) {
                this.decoderPane.add(this.decoderBlank);
            }
            this.decoderPane.revalidate();
            this.decoderPane.repaint();
            this.pack();
        }
    }

    protected void volumeChange(ChangeEvent event) {
        JSlider v = (JSlider)event.getSource();
        log.debug("Volume slider moved. value: {}", (Object)v.getValue());
        this.master_volume = v.getValue();
        this.firePropertyChange(VOLUME_CHANGE, (Object)this.master_volume, null);
        if (VSDecoderManager.instance().getMasterVolume() != v.getValue()) {
            VSDecoderManager.instance().setMasterVolume(v.getValue());
            VSDecoderManager.instance().getVSDecoderPreferences().save();
            log.debug("VSD Preferences saved");
        }
    }

    private void buildMenu() {
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        fileMenu.setMnemonic(Mnemonics.get("FileMenu"));
        fileMenu.add(new LoadVSDFileAction(Bundle.getMessage("VSDecoderFileMenuLoadVSDFile")));
        JMenu editMenu = new JMenu(Bundle.getMessage("MenuEdit"));
        editMenu.setMnemonic(Mnemonics.get("EditMenu"));
        editMenu.add(new VSDPreferencesAction(Bundle.getMessage("VSDecoderFileMenuPreferences")));
        this.menuList = new ArrayList<JMenu>(2);
        this.menuList.add(fileMenu);
        this.menuList.add(editMenu);
        this.setJMenuBar(new JMenuBar());
        this.getJMenuBar().add(fileMenu);
        this.getJMenuBar().add(editMenu);
        this.addHelpMenu("package.jmri.jmrit.vsdecoder.swing.VSDManagerFrame", true);
    }

    static {
        Mnemonics.put("FileMenu", 70);
        Mnemonics.put("EditMenu", 69);
        Mnemonics.put("MuteButton", 77);
        Mnemonics.put("AddButton", 65);
        log = LoggerFactory.getLogger(VSDManagerFrame.class);
    }
}

