/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.vsdecoder.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrit.vsdecoder.VSDecoderManager;
import jmri.jmrit.vsdecoder.VSDecoderPreferences;
import jmri.jmrit.vsdecoder.swing.Bundle;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJFileChooser;

class VSDecoderPreferencesPane
extends JPanel
implements PropertyChangeListener {
    private JCheckBox cbAutoStartEngine;
    private JCheckBox cbAutoLoadVSDFile;
    private JCheckBox cbUseBlocks;
    private JTextField tfDefaultVSDFilePath;
    private JLabel labelDefaultVSDFilePath;
    private JButton jbApply;
    private JButton jbCancel;
    private JButton jbSave;
    private JFrame m_container = null;

    public VSDecoderPreferencesPane(VSDecoderPreferences tp) {
        this.initComponents();
        this.setComponents(tp);
        tp.addPropertyChangeListener(this);
    }

    public VSDecoderPreferencesPane() {
        this(VSDecoderManager.instance().getVSDecoderPreferences());
    }

    private GridBagConstraints setConstraints(Insets i, int x, int y, int width, int fill) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = i;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.anchor = 21;
        gbc.fill = fill;
        return gbc;
    }

    private void initComponents() {
        JPanel prefsPane = new JPanel();
        JPanel controlPane = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.jbCancel = new JButton();
        this.jbSave = new JButton();
        this.jbApply = new JButton();
        this.labelDefaultVSDFilePath = new JLabel();
        this.cbAutoStartEngine = new JCheckBox();
        this.cbAutoLoadVSDFile = new JCheckBox();
        this.cbUseBlocks = new JCheckBox();
        this.tfDefaultVSDFilePath = new JTextField(40);
        JButton jbPathBrowse = new JButton(Bundle.getMessage("Browse"));
        jbPathBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSDecoderPreferencesPane.this.jbPathBrowseActionPerformed(evt);
            }
        });
        this.cbAutoStartEngine.setText(Bundle.getMessage("AutoStartEngine"));
        this.cbAutoLoadVSDFile.setText(Bundle.getMessage("AutoLoadVSDFile"));
        this.cbUseBlocks.setText(Bundle.getMessage("UseBlocks"));
        this.tfDefaultVSDFilePath.setColumns(30);
        this.labelDefaultVSDFilePath.setText(Bundle.getMessage("DefaultVSDFilePath"));
        this.jbSave.setText(Bundle.getMessage("ButtonSave"));
        this.jbSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSDecoderPreferencesPane.this.jbSaveActionPerformed(evt);
            }
        });
        this.jbSave.setVisible(false);
        this.jbCancel.setText(Bundle.getMessage("ButtonCancel"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSDecoderPreferencesPane.this.jbCancelActionPerformed(evt);
            }
        });
        this.jbApply.setText(Bundle.getMessage("ButtonApply"));
        this.jbApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSDecoderPreferencesPane.this.jbApplyActionPerformed(evt);
            }
        });
        prefsPane.setLayout(new GridBagLayout());
        prefsPane.setBorder(BorderFactory.createEmptyBorder());
        controlPane.setLayout(new GridBagLayout());
        controlPane.setBorder(BorderFactory.createEmptyBorder());
        prefsPane.add((Component)this.cbAutoStartEngine, this.setConstraints(new Insets(2, 10, 2, 2), 0, 0, 2, 0));
        prefsPane.add((Component)this.cbAutoLoadVSDFile, this.setConstraints(new Insets(2, 10, 2, 2), 0, 1, 2, 0));
        prefsPane.add((Component)this.cbUseBlocks, this.setConstraints(new Insets(2, 10, 2, 2), 0, 2, 2, 0));
        prefsPane.add((Component)this.labelDefaultVSDFilePath, this.setConstraints(new Insets(2, 10, 2, 2), 0, 3, 1, 0));
        prefsPane.add((Component)this.tfDefaultVSDFilePath, this.setConstraints(new Insets(2, 10, 2, 2), 1, 3, 3, 2));
        prefsPane.add((Component)jbPathBrowse, this.setConstraints(new Insets(2, 2, 2, 2), 5, 3, 1, 0));
        controlPane.add((Component)this.jbSave, this.setConstraints(new Insets(5, 3, 5, 2), 2, 100, 1, 0));
        controlPane.add((Component)this.jbCancel, this.setConstraints(new Insets(5, 3, 5, 2), 0, 100, 1, 0));
        controlPane.add((Component)this.jbApply, this.setConstraints(new Insets(5, 3, 5, 5), 1, 100, 1, 0));
        this.add((Component)prefsPane, this.setConstraints(new Insets(2, 2, 2, 2), 0, 0, 1, 0));
        this.add((Component)controlPane, this.setConstraints(new Insets(2, 2, 2, 2), 0, 1, 1, 0));
        this.setVisible(true);
    }

    private void setComponents(VSDecoderPreferences tp) {
        if (tp == null) {
            return;
        }
        this.cbAutoStartEngine.setSelected(tp.isAutoStartingEngine());
        this.cbAutoLoadVSDFile.setSelected(tp.isAutoLoadingVSDFile());
        this.cbUseBlocks.setSelected(tp.getUseBlocksSetting());
        this.tfDefaultVSDFilePath.setText(tp.getDefaultVSDFilePath());
    }

    private VSDecoderPreferences getVSDecoderPreferences() {
        VSDecoderPreferences tp = new VSDecoderPreferences();
        tp.setAutoStartEngine(this.cbAutoStartEngine.isSelected());
        tp.setAutoLoadVSDFile(this.cbAutoLoadVSDFile.isSelected());
        tp.setUseBlocksSetting(this.cbUseBlocks.isSelected());
        tp.setDefaultVSDFilePath(this.tfDefaultVSDFilePath.getText());
        tp.setListenerPosition(VSDecoderManager.instance().getVSDecoderPreferences().getListenerPosition());
        tp.setMasterVolume(VSDecoderManager.instance().getVSDecoderPreferences().getMasterVolume());
        return tp;
    }

    private void jbPathBrowseActionPerformed(ActionEvent evt) {
        String path = this.tfDefaultVSDFilePath.getText() != null ? this.tfDefaultVSDFilePath.getText() : VSDecoderManager.instance().getVSDecoderPreferences().getDefaultVSDFilePath();
        JmriJFileChooser fc = new JmriJFileChooser(FileUtil.getExternalFilename(path));
        fc.setFileSelectionMode(1);
        int rv = fc.showOpenDialog(this);
        if (rv == 0) {
            try {
                this.tfDefaultVSDFilePath.setText(fc.getSelectedFile().getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void jbApplyActionPerformed(ActionEvent evt) {
        VSDecoderManager.instance().getVSDecoderPreferences().set(this.getVSDecoderPreferences());
    }

    private void jbSaveActionPerformed(ActionEvent evt) {
        VSDecoderManager.instance().getVSDecoderPreferences().set(this.getVSDecoderPreferences());
        VSDecoderManager.instance().getVSDecoderPreferences().save();
        if (this.m_container != null) {
            VSDecoderManager.instance().getVSDecoderPreferences().removePropertyChangeListener(this);
            this.m_container.setVisible(false);
            this.m_container.dispose();
        }
    }

    private void jbCancelActionPerformed(ActionEvent evt) {
        this.setComponents(VSDecoderManager.instance().getVSDecoderPreferences());
        if (this.m_container != null) {
            VSDecoderManager.instance().getVSDecoderPreferences().removePropertyChangeListener(this);
            this.m_container.setVisible(false);
            this.m_container.dispose();
        }
    }

    public void setContainer(JFrame f) {
        this.m_container = f;
        this.jbSave.setVisible(true);
        this.jbCancel.setText(Bundle.getMessage("ButtonCancel"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null || evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("VSDecoderPreferences") && evt.getNewValue() != null && evt.getNewValue() instanceof VSDecoderPreferences) {
            this.setComponents((VSDecoderPreferences)evt.getNewValue());
        }
    }
}

