/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.whereused;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jmri.AudioManager;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.ReporterManager;
import jmri.RouteManager;
import jmri.SectionManager;
import jmri.SensorManager;
import jmri.SignalHeadManager;
import jmri.SignalMastManager;
import jmri.TurnoutManager;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.whereused.AudioWhereUsed;
import jmri.jmrit.whereused.BlockWhereUsed;
import jmri.jmrit.whereused.Bundle;
import jmri.jmrit.whereused.EntryExitWhereUsed;
import jmri.jmrit.whereused.LightWhereUsed;
import jmri.jmrit.whereused.MemoryWhereUsed;
import jmri.jmrit.whereused.OBlockWhereUsed;
import jmri.jmrit.whereused.ReporterWhereUsed;
import jmri.jmrit.whereused.RouteWhereUsed;
import jmri.jmrit.whereused.SectionWhereUsed;
import jmri.jmrit.whereused.SensorWhereUsed;
import jmri.jmrit.whereused.SignalHeadWhereUsed;
import jmri.jmrit.whereused.SignalMastWhereUsed;
import jmri.jmrit.whereused.TurnoutWhereUsed;
import jmri.jmrit.whereused.WarrantWhereUsed;
import jmri.swing.NamedBeanComboBox;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhereUsedFrame
extends JmriJFrame {
    ItemType _itemType = ItemType.NONE;
    JComboBox<ItemType> _itemTypeBox;
    NamedBean _itemBean;
    NamedBeanComboBox<?> _itemNameBox = new NamedBeanComboBox(InstanceManager.getDefault(SensorManager.class));
    JPanel _topPanel;
    JPanel _bottomPanel;
    JPanel _scrolltext = new JPanel();
    JTextArea _textArea;
    JButton _createButton;
    JLabel itemNameLabel;
    JFileChooser userFileChooser = new JmriJFileChooser(FileUtil.getUserFilesPath());
    private static final Logger log = LoggerFactory.getLogger(WhereUsedFrame.class);

    public WhereUsedFrame() {
        super(true, true);
        this.setTitle(Bundle.getMessage("TitleWhereUsed"));
        this.createFrame();
        this.addHelpMenu("package.jmri.jmrit.whereused.WhereUsed", true);
    }

    void createFrame() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.buildTopPanel();
        contentPane.add((Component)this._topPanel, "North");
        this.buildWhereUsedListing(ItemType.NONE, null);
        JScrollPane scrollPane = new JScrollPane(this._scrolltext);
        contentPane.add(scrollPane);
        this.buildBottomPanel();
        contentPane.add((Component)this._bottomPanel, "South");
        this.pack();
    }

    void buildTopPanel() {
        this._topPanel = new JPanel();
        JLabel itemTypeLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("LabelItemType")));
        this._topPanel.add(itemTypeLabel);
        this._itemTypeBox = new JComboBox();
        itemTypeLabel.setLabelFor(this._itemTypeBox);
        for (ItemType itemType : ItemType.values()) {
            this._itemTypeBox.addItem(itemType);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._itemTypeBox);
        this._topPanel.add(this._itemTypeBox);
        this.itemNameLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("LabelItemName")));
        this._topPanel.add(this.itemNameLabel);
        this.itemNameLabel.setLabelFor(this._itemNameBox);
        this._topPanel.add(this._itemNameBox);
        this._itemTypeBox.addActionListener(e -> {
            this._itemType = this._itemTypeBox.getItemAt(this._itemTypeBox.getSelectedIndex());
            this.setItemNameBox(this._itemType);
        });
        this._createButton = new JButton(Bundle.getMessage("ButtonCreate"));
        this._createButton.addActionListener(e -> this.buildWhereUsedListing(this._itemType, this._itemBean));
        this._topPanel.add(this._createButton);
        this._itemNameBox.setEnabled(false);
        this._createButton.setEnabled(false);
    }

    void buildBottomPanel() {
        this._bottomPanel = new JPanel();
        this._bottomPanel.setLayout(new BorderLayout());
        JButton saveButton = new JButton(Bundle.getMessage("SaveButton"));
        saveButton.setToolTipText(Bundle.getMessage("SaveButtonHint"));
        this._bottomPanel.add((Component)saveButton, "East");
        saveButton.addActionListener(e -> this.saveWhereUsedPressed());
    }

    void setItemNameBox(ItemType itemType) {
        this._createButton.setEnabled(false);
        this.buildWhereUsedListing(ItemType.NONE, null);
        NamedBeanComboBox<?> newNameBox = this.createNameBox(itemType);
        if (newNameBox == null) {
            this._itemNameBox.setSelectedIndex(-1);
            this._itemNameBox.setEnabled(false);
            return;
        }
        this._itemNameBox = newNameBox;
        this.itemNameLabel.setLabelFor(newNameBox);
        this._itemNameBox.setSelectedIndex(-1);
        this._topPanel.remove(3);
        this._topPanel.add((Component)this._itemNameBox, 3);
        this._itemNameBox.setEnabled(true);
        this._itemNameBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this._itemBean = (NamedBean)e.getItem();
                this._createButton.setEnabled(true);
            }
        });
        this.pack();
        this.repaint();
    }

    void buildWhereUsedListing(ItemType type, NamedBean bean) {
        switch (type) {
            case TURNOUT: {
                this._textArea = TurnoutWhereUsed.getWhereUsed(bean);
                break;
            }
            case SENSOR: {
                this._textArea = SensorWhereUsed.getWhereUsed(bean);
                break;
            }
            case LIGHT: {
                this._textArea = LightWhereUsed.getWhereUsed(bean);
                break;
            }
            case SIGNALHEAD: {
                this._textArea = SignalHeadWhereUsed.getWhereUsed(bean);
                break;
            }
            case SIGNALMAST: {
                this._textArea = SignalMastWhereUsed.getWhereUsed(bean);
                break;
            }
            case REPORTER: {
                this._textArea = ReporterWhereUsed.getWhereUsed(bean);
                break;
            }
            case MEMORY: {
                this._textArea = MemoryWhereUsed.getWhereUsed(bean);
                break;
            }
            case ROUTE: {
                this._textArea = RouteWhereUsed.getWhereUsed(bean);
                break;
            }
            case OBLOCK: {
                this._textArea = OBlockWhereUsed.getWhereUsed(bean);
                break;
            }
            case BLOCK: {
                this._textArea = BlockWhereUsed.getWhereUsed(bean);
                break;
            }
            case SECTION: {
                this._textArea = SectionWhereUsed.getWhereUsed(bean);
                break;
            }
            case WARRANT: {
                this._textArea = WarrantWhereUsed.getWhereUsed(bean);
                break;
            }
            case ENTRYEXIT: {
                this._textArea = EntryExitWhereUsed.getWhereUsed(bean);
                break;
            }
            case AUDIO: {
                this._textArea = AudioWhereUsed.getWhereUsed(bean);
                break;
            }
            default: {
                this._textArea = new JTextArea(Bundle.getMessage("TypePrompt", Bundle.getMessage("ButtonCreate")));
            }
        }
        this._textArea.setFont(new Font("Monospaced", 0, 12));
        this._textArea.setTabSize(4);
        this._textArea.setEditable(false);
        this._textArea.setCaretPosition(0);
        if (this._scrolltext.getComponentCount() > 0) {
            this._scrolltext.remove(0);
        }
        this._scrolltext.add(this._textArea);
        this.pack();
        this.repaint();
    }

    void saveWhereUsedPressed() {
        this.userFileChooser.setApproveButtonText(Bundle.getMessage("SaveDialogApprove"));
        this.userFileChooser.setDialogTitle(Bundle.getMessage("SaveDialogTitle"));
        this.userFileChooser.rescanCurrentDirectory();
        String itemName = this._itemNameBox.getSelectedItemDisplayName();
        String fileName = Bundle.getMessage("SaveFileName", itemName == null ? "Unknown" : itemName);
        this.userFileChooser.setSelectedFile(new File(fileName));
        int retVal = this.userFileChooser.showSaveDialog(null);
        if (retVal != 0) {
            log.debug("Save where used content stopped, no file selected");
            return;
        }
        File file = this.userFileChooser.getSelectedFile();
        log.debug("Save where used content to '{}'", (Object)file);
        if (file.exists()) {
            Object[] options = new Object[]{Bundle.getMessage("SaveDuplicateReplace"), Bundle.getMessage("SaveDuplicateAppend"), Bundle.getMessage("ButtonCancel")};
            int selectedOption = JmriJOptionPane.showOptionDialog(null, Bundle.getMessage("SaveDuplicatePrompt", file.getName(), Bundle.getMessage("SaveDuplicateAppend"), Bundle.getMessage("SaveDuplicateReplace")), Bundle.getMessage("SaveDuplicateTitle"), -1, 2, null, options, options[0]);
            if (selectedOption == 2 || selectedOption == -1) {
                log.debug("Save where used content stopped, file replace/append cancelled");
                return;
            }
            if (selectedOption == 0) {
                FileUtil.delete(file);
            }
        }
        try {
            FileUtil.appendTextToFile(file, this._textArea.getText());
        }
        catch (IOException e) {
            log.error("Unable to write where used content to '{}', exception", (Object)file, (Object)e);
        }
    }

    NamedBeanComboBox<?> createNameBox(ItemType itemType) {
        NamedBeanComboBox nameBox;
        switch (itemType) {
            case TURNOUT: {
                nameBox = new NamedBeanComboBox(InstanceManager.getDefault(TurnoutManager.class));
                break;
            }
            case SENSOR: {
                nameBox = new NamedBeanComboBox(InstanceManager.getDefault(SensorManager.class));
                break;
            }
            case LIGHT: {
                nameBox = new NamedBeanComboBox(InstanceManager.getDefault(LightManager.class));
                break;
            }
            case SIGNALHEAD: {
                nameBox = new NamedBeanComboBox(InstanceManager.getDefault(SignalHeadManager.class));
                break;
            }
            case SIGNALMAST: {
                nameBox = new NamedBeanComboBox(InstanceManager.getDefault(SignalMastManager.class));
                break;
            }
            case REPORTER: {
                nameBox = new NamedBeanComboBox(InstanceManager.getDefault(ReporterManager.class));
                break;
            }
            case MEMORY: {
                nameBox = new NamedBeanComboBox(InstanceManager.getDefault(MemoryManager.class));
                break;
            }
            case ROUTE: {
                nameBox = new NamedBeanComboBox(InstanceManager.getDefault(RouteManager.class));
                break;
            }
            case OBLOCK: {
                nameBox = new NamedBeanComboBox(InstanceManager.getDefault(OBlockManager.class));
                break;
            }
            case BLOCK: {
                nameBox = new NamedBeanComboBox(InstanceManager.getDefault(BlockManager.class));
                break;
            }
            case SECTION: {
                nameBox = new NamedBeanComboBox(InstanceManager.getDefault(SectionManager.class));
                break;
            }
            case WARRANT: {
                nameBox = new NamedBeanComboBox(InstanceManager.getDefault(WarrantManager.class));
                break;
            }
            case ENTRYEXIT: {
                nameBox = new NamedBeanComboBox(InstanceManager.getDefault(EntryExitPairs.class));
                break;
            }
            case AUDIO: {
                nameBox = new NamedBeanComboBox(InstanceManager.getDefault(AudioManager.class));
                break;
            }
            default: {
                return null;
            }
        }
        nameBox.setEditable(false);
        nameBox.setValidatingInput(false);
        JComboBoxUtil.setupComboBoxMaxRows(nameBox);
        return nameBox;
    }

    static enum ItemType {
        NONE("ItemTypeNone"),
        TURNOUT("BeanNameTurnout"),
        SENSOR("BeanNameSensor"),
        LIGHT("BeanNameLight"),
        SIGNALHEAD("BeanNameSignalHead"),
        SIGNALMAST("BeanNameSignalMast"),
        REPORTER("BeanNameReporter"),
        MEMORY("BeanNameMemory"),
        ROUTE("BeanNameRoute"),
        OBLOCK("BeanNameOBlock"),
        BLOCK("BeanNameBlock"),
        SECTION("BeanNameSection"),
        WARRANT("BeanNameWarrant"),
        ENTRYEXIT("BeanNameEntryExit"),
        AUDIO("BeanNameAudio");

        private final String _bundleKey;

        private ItemType(String bundleKey) {
            this._bundleKey = bundleKey;
        }

        public String toString() {
            return Bundle.getMessage(this._bundleKey);
        }
    }
}

