/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.util.ArrayList;
import java.util.List;
import jmri.Manager;
import jmri.jmrit.withrottle.ControllerInterface;
import jmri.jmrit.withrottle.DeviceServer;

public abstract class AbstractController {
    ArrayList<ControllerInterface> listeners = null;
    List<String> sysNameList = null;
    boolean isValid = false;
    boolean canBuildList = true;

    abstract boolean verifyCreation();

    abstract void handleMessage(String var1, DeviceServer var2);

    abstract void register();

    abstract void deregister();

    public void buildList(Manager<?> manager) {
        if (this.sysNameList == null) {
            this.sysNameList = new ArrayList<String>(manager.getNamedBeanSet().size());
            manager.getNamedBeanSet().forEach(bean -> this.sysNameList.add(bean.getSystemName()));
            this.filterList();
            this.register();
            this.canBuildList = false;
        }
    }

    public void filterList() {
    }

    public void checkCanBuildList() {
        if (this.listeners.isEmpty()) {
            if (this.sysNameList != null) {
                this.deregister();
                this.sysNameList = null;
            }
            this.canBuildList = true;
        }
    }

    public void addControllerListener(ControllerInterface listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeControllerListener(ControllerInterface listener) {
        if (this.listeners == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
        this.checkCanBuildList();
    }
}

