/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.Nonnull;
import jmri.jmrit.XmlFile;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWiThrottlePreferences {
    private String fileName;
    private static final Logger log = LoggerFactory.getLogger(AbstractWiThrottlePreferences.class);

    public void openFile(String fileName) {
        Element root;
        this.fileName = fileName;
        AbstractWiThrottlePreferencesXml prefsXml = new AbstractWiThrottlePreferencesXml();
        File file = new File(this.fileName);
        try {
            root = prefsXml.rootFromFile(file);
        }
        catch (FileNotFoundException ea) {
            log.info("Could not find WiThrottle preferences file ({}).  Normal if preferences have not been saved before.", (Object)fileName);
            root = null;
        }
        catch (IOException | JDOMException eb) {
            log.error("Exception while loading throttles preferences:", eb);
            root = null;
        }
        if (root != null) {
            Element child = root.getChild("WiThrottlePreferences");
            if (child == null) {
                log.error("WiThrottle Preferences not loaded, no WiThrottlePreferences element in {}", (Object)fileName);
                return;
            }
            this.load(child);
        }
    }

    abstract void load(@Nonnull Element var1);

    abstract Element store();

    public void save() {
        if (this.fileName == null) {
            return;
        }
        XmlFile xmlFile = new XmlFile(){};
        xmlFile.makeBackupFile(this.fileName);
        File file = new File(this.fileName);
        try {
            File parentDir = file.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdir()) {
                log.warn("Could not create parent directory for prefs file :{}", (Object)this.fileName);
                return;
            }
            if (file.createNewFile()) {
                log.debug("Creating new WiThrottle prefs file: {}", (Object)this.fileName);
            }
        }
        catch (IOException ea) {
            log.error("Could not create WiThrottle preferences file.");
        }
        try {
            Element root = new Element("withrottle-prefs");
            Document doc = XmlFile.newDocument(root);
            root.setContent((Content)this.store());
            xmlFile.writeXML(file, doc);
        }
        catch (IOException eb) {
            log.warn("Exception in storing WiThrottle xml:", (Throwable)eb);
        }
    }

    public static class AbstractWiThrottlePreferencesXml
    extends XmlFile {
    }
}

