/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.ThrottleListener;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.withrottle.ThrottleController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistFunctionController
implements ThrottleListener {
    private DccThrottle throttle;
    private RosterEntry rosterLoco = null;
    private ThrottleController throttleController;
    private static final Logger log = LoggerFactory.getLogger(ConsistFunctionController.class);

    public ConsistFunctionController(ThrottleController tc) {
        this.throttleController = tc;
    }

    public ConsistFunctionController(ThrottleController tc, RosterEntry re) {
        this.throttleController = tc;
        this.rosterLoco = re;
    }

    @Override
    public void notifyThrottleFound(DccThrottle t) {
        if (log.isDebugEnabled()) {
            log.debug("Lead Loco throttle found: {}, for consist: {}", (Object)t, (Object)this.throttleController.getCurrentAddressString());
        }
        this.throttle = t;
        if (this.rosterLoco == null) {
            this.rosterLoco = this.throttleController.findRosterEntry(this.throttle);
        }
        this.throttleController.syncThrottleFunctions(this.throttle, this.rosterLoco);
        this.throttleController.setFunctionThrottle(t);
        this.throttleController.sendFunctionLabels(this.rosterLoco);
        this.throttleController.sendAllFunctionStates(this.throttle);
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
        log.error("Throttle request failed for {} because {}", (Object)address, (Object)reason);
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
    }

    public void dispose() {
        InstanceManager.throttleManagerInstance().releaseThrottle(this.throttle, this);
    }

    public DccThrottle getThrottle() {
        return this.throttle;
    }

    boolean requestThrottle(DccLocoAddress loco) {
        return InstanceManager.throttleManagerInstance().requestThrottle(loco, (ThrottleListener)this, true);
    }
}

