/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.withrottle.ConsistFunctionController;
import jmri.jmrit.withrottle.ControllerInterface;
import jmri.jmrit.withrottle.ThrottleControllerListener;
import jmri.jmrit.withrottle.WiThrottlePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottleController
implements ThrottleListener,
PropertyChangeListener {
    DccThrottle throttle;
    DccThrottle functionThrottle;
    RosterEntry rosterLoco = null;
    DccLocoAddress leadAddress;
    char whichThrottle;
    float speedMultiplier = 0.007936508f;
    protected Queue<Float> lastSentSpeed;
    protected float newSpeed;
    boolean isAddressSet;
    protected ArrayList<ThrottleControllerListener> listeners;
    protected ArrayList<ControllerInterface> controllerListeners;
    boolean useLeadLocoF;
    ConsistFunctionController leadLocoF = null;
    String locoKey = "";
    final boolean isMomF2 = InstanceManager.getDefault(WiThrottlePreferences.class).isUseMomF2();
    private static final Logger log = LoggerFactory.getLogger(ThrottleController.class);

    public ThrottleController() {
        this.lastSentSpeed = new LinkedList<Float>();
    }

    public ThrottleController(char whichThrottleChar, ThrottleControllerListener tcl, ControllerInterface cl) {
        this();
        this.setWhichThrottle(whichThrottleChar);
        this.addThrottleControllerListener(tcl);
        this.addControllerListener(cl);
    }

    public void setWhichThrottle(char c) {
        this.whichThrottle = c;
    }

    public void addThrottleControllerListener(ThrottleControllerListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeThrottleControllerListener(ThrottleControllerListener l) {
        if (this.listeners == null) {
            return;
        }
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    public void addControllerListener(ControllerInterface listener) {
        if (this.controllerListeners == null) {
            this.controllerListeners = new ArrayList(1);
        }
        if (!this.controllerListeners.contains(listener)) {
            this.controllerListeners.add(listener);
        }
    }

    public void removeControllerListener(ControllerInterface listener) {
        if (this.controllerListeners == null) {
            return;
        }
        if (this.controllerListeners.contains(listener)) {
            this.controllerListeners.remove(listener);
        }
    }

    public void addressRelease() {
        this.isAddressSet = false;
        InstanceManager.throttleManagerInstance().releaseThrottle(this.throttle, this);
        this.throttle.removePropertyChangeListener(this);
        this.throttle = null;
        this.rosterLoco = null;
        this.sendAddress();
        this.clearLeadLoco();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ThrottleControllerListener l = this.listeners.get(i);
            l.notifyControllerAddressReleased(this);
            log.debug("Notify TCListener address released: {}", l.getClass());
        }
    }

    public void addressDispatch() {
        this.isAddressSet = false;
        InstanceManager.throttleManagerInstance().dispatchThrottle(this.throttle, this);
        this.throttle.removePropertyChangeListener(this);
        this.throttle = null;
        this.rosterLoco = null;
        this.sendAddress();
        this.clearLeadLoco();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ThrottleControllerListener l = this.listeners.get(i);
            l.notifyControllerAddressReleased(this);
            log.debug("Notify TCListener address dispatched: {}", l.getClass());
        }
    }

    @Override
    public void notifyThrottleFound(DccThrottle t) {
        if (this.isAddressSet) {
            log.debug("Throttle: {} is already set. (Found is: {})", (Object)this.getCurrentAddressString(), (Object)t.getLocoAddress());
            return;
        }
        if (t == null) {
            log.error("*throttle is null!*");
            return;
        }
        this.throttle = t;
        this.setFunctionThrottle(this.throttle);
        this.isAddressSet = true;
        log.debug("DccThrottle found for: {}", (Object)this.throttle.getLocoAddress());
        for (int i = 0; i < this.listeners.size(); ++i) {
            ThrottleControllerListener l = this.listeners.get(i);
            l.notifyControllerAddressFound(this);
            log.debug("Notify TCListener address found: {}", l.getClass());
        }
        if (this.rosterLoco == null) {
            this.rosterLoco = this.findRosterEntry(this.throttle);
        }
        this.syncThrottleFunctions(this.throttle, this.rosterLoco);
        this.sendAddress();
        this.sendFunctionLabels(this.rosterLoco);
        this.sendAllFunctionStates(this.throttle);
        this.sendCurrentSpeed(this.throttle);
        this.sendCurrentDirection(this.throttle);
        this.sendSpeedStepMode(this.throttle);
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
        log.warn("Throttle request failed for {} because {}.", (Object)address, (Object)reason);
        if (!(address instanceof DccLocoAddress)) {
            log.warn("Throttle address {} is not a DccLocoAddress", (Object)address);
            return;
        }
        for (ThrottleControllerListener l : this.listeners) {
            l.notifyControllerAddressDeclined(this, (DccLocoAddress)address, reason);
            log.debug("Notify TCListener address declined in-use: {}", l.getClass());
        }
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
        this.notifyFailedThrottleRequest(address, "Steal Required");
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String eventName = event.getPropertyName();
        log.debug("property change: {}", (Object)eventName);
        if (eventName.startsWith("F")) {
            if (eventName.contains("Momentary")) {
                return;
            }
            StringBuilder message = new StringBuilder("RPF}|{");
            message.append(this.whichThrottle);
            message.append("]\\[");
            message.append(eventName);
            message.append("}|{");
            message.append(event.getNewValue());
            for (ControllerInterface listener : this.controllerListeners) {
                listener.sendPacketToDevice(message.toString());
            }
        }
    }

    public RosterEntry findRosterEntry(DccThrottle t) {
        List<RosterEntry> l;
        RosterEntry re = null;
        if (t.getLocoAddress() != null && (l = Roster.getDefault().matchingList(null, null, "" + ((DccLocoAddress)t.getLocoAddress()).getNumber(), null, null, null, null)).size() > 0) {
            log.debug("Roster Loco found: {}", (Object)l.get(0).getDccAddress());
            re = l.get(0);
        }
        return re;
    }

    public void syncThrottleFunctions(DccThrottle t, RosterEntry re) {
        if (re != null) {
            int highestCommon = Math.min(t.getFunctions().length, re.getMaxFnNumAsInt() + 1);
            for (int funcNum = 0; funcNum < highestCommon; ++funcNum) {
                t.setFunctionMomentary(funcNum, !re.getFunctionLockable(funcNum));
            }
        }
    }

    public void sendFunctionLabels(RosterEntry re) {
        if (re != null) {
            StringBuilder functionString = new StringBuilder();
            if (this.whichThrottle == 'S') {
                functionString.append("RS29}|{");
            } else {
                functionString.append("RF29}|{");
            }
            functionString.append(this.getCurrentAddressString());
            for (int i = 0; i < 29; ++i) {
                functionString.append("]\\[");
                if (re.getFunctionLabel(i) == null) continue;
                functionString.append(re.getFunctionLabel(i));
            }
            for (ControllerInterface listener : this.controllerListeners) {
                listener.sendPacketToDevice(functionString.toString());
            }
        }
    }

    public void sendAllFunctionStates(DccThrottle t) {
        log.debug("Sending state of all functions");
        StringBuilder message = new StringBuilder(this.buildFStatesHeader());
        for (int cnt = 0; cnt < 29; ++cnt) {
            message.append("]\\[F");
            message.append(cnt);
            message.append("}|{");
            message.append(t.getFunction(cnt));
        }
        for (ControllerInterface listener : this.controllerListeners) {
            listener.sendPacketToDevice(message.toString());
        }
    }

    protected String buildFStatesHeader() {
        return "RPF}|{" + this.whichThrottle;
    }

    protected synchronized void sendCurrentSpeed(DccThrottle t) {
    }

    protected void sendCurrentDirection(DccThrottle t) {
    }

    protected void sendSpeedStepMode(DccThrottle t) {
    }

    protected void sendAllMomentaryStates(DccThrottle t) {
    }

    public boolean sort(String inPackage) {
        if (inPackage.charAt(0) == 'Q') {
            this.shutdownThrottle();
            return false;
        }
        if (this.isAddressSet) {
            try {
                switch (inPackage.charAt(0)) {
                    case 'V': {
                        this.setSpeed(Integer.parseInt(inPackage.substring(1)));
                        break;
                    }
                    case 'X': {
                        this.eStop();
                        break;
                    }
                    case 'F': {
                        this.handleFunction(inPackage);
                        break;
                    }
                    case 'f': {
                        this.forceFunction(inPackage.substring(1));
                        break;
                    }
                    case 'R': {
                        this.setDirection(!inPackage.endsWith("0"));
                        break;
                    }
                    case 'r': {
                        this.addressRelease();
                        break;
                    }
                    case 'd': {
                        this.addressDispatch();
                        break;
                    }
                    case 'L': {
                        this.addressRelease();
                        int addr = Integer.parseInt(inPackage.substring(1));
                        this.setAddress(addr, true);
                        break;
                    }
                    case 'S': {
                        this.addressRelease();
                        int addr = Integer.parseInt(inPackage.substring(1));
                        this.setAddress(addr, false);
                        break;
                    }
                    case 'E': {
                        this.addressRelease();
                        this.requestEntryFromID(inPackage.substring(1));
                        break;
                    }
                    case 'C': {
                        this.setLocoForConsistFunctions(inPackage.substring(1));
                        break;
                    }
                    case 'c': {
                        this.setRosterLocoForConsistFunctions(inPackage.substring(1));
                        break;
                    }
                    case 'I': {
                        this.idle();
                        break;
                    }
                    case 's': {
                        this.handleSpeedStepMode(ThrottleController.decodeSpeedStepMode(inPackage.substring(1)));
                        break;
                    }
                    case 'm': {
                        this.handleMomentary(inPackage.substring(1));
                        break;
                    }
                    case 'q': {
                        this.handleRequest(inPackage.substring(1));
                        break;
                    }
                    default: {
                        log.warn("Unhandled code: {}", (Object)Character.valueOf(inPackage.charAt(0)));
                        break;
                    }
                }
            }
            catch (NullPointerException e) {
                log.warn("No throttle frame to receive: {}", (Object)inPackage);
                return false;
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {}
        } else {
            switch (inPackage.charAt(0)) {
                case 'L': {
                    int addr = Integer.parseInt(inPackage.substring(1));
                    this.setAddress(addr, true);
                    break;
                }
                case 'S': {
                    int addr = Integer.parseInt(inPackage.substring(1));
                    this.setAddress(addr, false);
                    break;
                }
                case 'E': {
                    this.requestEntryFromID(inPackage.substring(1));
                    break;
                }
                case 'C': {
                    this.setLocoForConsistFunctions(inPackage.substring(1));
                    break;
                }
                case 'c': {
                    this.setRosterLocoForConsistFunctions(inPackage.substring(1));
                    break;
                }
            }
        }
        return true;
    }

    private void clearLeadLoco() {
        if (this.useLeadLocoF) {
            this.leadLocoF.dispose();
            this.functionThrottle.removePropertyChangeListener(this);
            if (this.throttle != null) {
                this.setFunctionThrottle(this.throttle);
            }
            this.leadLocoF = null;
            this.useLeadLocoF = false;
        }
    }

    public void setFunctionThrottle(DccThrottle t) {
        this.functionThrottle = t;
        this.functionThrottle.addPropertyChangeListener(this);
    }

    public void setLocoForConsistFunctions(String inPackage) {
        this.leadAddress = new DccLocoAddress(Integer.parseInt(inPackage.substring(1)), inPackage.charAt(0) != 'S');
        log.debug("Setting lead loco address: {}, for consist: {}", (Object)this.leadAddress, (Object)this.getCurrentAddressString());
        this.clearLeadLoco();
        this.leadLocoF = new ConsistFunctionController(this);
        this.useLeadLocoF = this.leadLocoF.requestThrottle(this.leadAddress);
        if (!this.useLeadLocoF) {
            log.warn("Lead loco address not available.");
            this.leadLocoF = null;
        }
    }

    public void setRosterLocoForConsistFunctions(String id) {
        List<RosterEntry> l = Roster.getDefault().matchingList(null, null, null, null, null, null, id);
        if (l.size() > 0) {
            log.debug("Consist Lead Roster Loco found: {} for ID: {}", (Object)l.get(0).getDccAddress(), (Object)id);
            RosterEntry re = l.get(0);
            this.clearLeadLoco();
            this.leadLocoF = new ConsistFunctionController(this, re);
            this.useLeadLocoF = this.leadLocoF.requestThrottle(re.getDccLocoAddress());
            if (!this.useLeadLocoF) {
                log.warn("Lead loco address not available.");
                this.leadLocoF = null;
            }
        } else {
            log.debug("No Roster Loco found for: {}", (Object)id);
        }
    }

    public void shutdownThrottle() {
        try {
            if (this.isAddressSet) {
                this.throttle.setSpeedSetting(0.0f);
                this.addressRelease();
            }
        }
        catch (NullPointerException e) {
            log.warn("No throttle to shutdown");
        }
        this.clearLeadLoco();
    }

    protected synchronized void setSpeed(int rawSpeed) {
        float spd = (float)rawSpeed * this.speedMultiplier;
        log.debug("raw: {}, NewSpd: {}", (Object)rawSpeed, (Object)Float.valueOf(spd));
        while (!this.lastSentSpeed.offer(Float.valueOf(spd))) {
            log.debug("failed attempting to add speed to queue");
        }
        this.throttle.setSpeedSetting(spd);
    }

    protected void setDirection(boolean isForward) {
        log.debug("set direction to: {}", (Object)(isForward ? "Fwd" : "Rev"));
        this.throttle.setIsForward(isForward);
    }

    protected void eStop() {
        this.throttle.setSpeedSetting(-1.0f);
    }

    protected void idle() {
        this.throttle.setSpeedSetting(0.0f);
    }

    protected void setAddress(int number, boolean isLong) {
        log.debug("setAddress: {}, isLong: {}", (Object)number, (Object)isLong);
        if (this.rosterLoco != null) {
            InstanceManager.throttleManagerInstance().requestThrottle(this.rosterLoco, (ThrottleListener)this, true);
        } else {
            InstanceManager.throttleManagerInstance().requestThrottle(new DccLocoAddress(number, isLong), (ThrottleListener)this, true);
        }
    }

    public void requestEntryFromID(String id) {
        List<RosterEntry> l = Roster.getDefault().matchingList(null, null, null, null, null, null, id);
        if (l.size() > 0) {
            RosterEntry re;
            log.debug("Roster Loco found: {} for ID: {}", (Object)l.get(0).getDccAddress(), (Object)id);
            this.rosterLoco = re = l.get(0);
            this.setAddress(Integer.parseInt(re.getDccAddress()), re.isLongAddress());
        } else {
            log.debug("No Roster Loco found for: {}", (Object)id);
        }
    }

    public DccThrottle getThrottle() {
        return this.throttle;
    }

    public DccThrottle getFunctionThrottle() {
        return this.functionThrottle;
    }

    public DccLocoAddress getCurrentAddress() {
        return (DccLocoAddress)this.throttle.getLocoAddress();
    }

    public String getCurrentAddressString() {
        if (this.isAddressSet) {
            return ((DccLocoAddress)this.throttle.getLocoAddress()).toString();
        }
        return "Not Set";
    }

    public String getCurrentRosterIdString() {
        if (this.rosterLoco != null) {
            return this.rosterLoco.getId();
        }
        return " ";
    }

    public void sendAddress() {
        for (ControllerInterface listener : this.controllerListeners) {
            listener.sendPacketToDevice(this.whichThrottle + this.getCurrentAddressString());
        }
    }

    protected void handleFunction(String inPackage) {
        int receivedFunction = Integer.parseInt(inPackage.substring(2));
        if (inPackage.charAt(1) == '1') {
            log.debug("Trying to set function {}", (Object)receivedFunction);
            boolean state = this.functionThrottle.getFunction(receivedFunction);
            this.functionThrottle.setFunction(receivedFunction, !state);
            log.debug("Throttle: {}, Function: {}, set state: {}", new Object[]{this.functionThrottle.getLocoAddress(), receivedFunction, !state});
        } else {
            if (this.isMomF2 && receivedFunction == 2) {
                this.functionThrottle.setFunction(2, false);
                return;
            }
            if (this.functionThrottle.getFunctionMomentary(receivedFunction)) {
                this.functionThrottle.setFunction(receivedFunction, false);
                log.debug("Throttle: {}, Momentary Function: {}, set false", (Object)this.functionThrottle.getLocoAddress(), (Object)receivedFunction);
            }
        }
    }

    protected void forceFunction(String inPackage) {
        int receivedFunction = Integer.parseInt(inPackage.substring(1));
        boolean newVal = inPackage.charAt(0) == '1';
        log.debug("Trying to set function {} to {}", (Object)receivedFunction, (Object)newVal);
        this.throttle.setFunction(receivedFunction, newVal);
    }

    protected void handleSpeedStepMode(SpeedStepMode newMode) {
        this.throttle.setSpeedStepMode(newMode);
    }

    protected void handleMomentary(String inPackage) {
        int receivedFunction = Integer.parseInt(inPackage.substring(1));
        boolean newVal = inPackage.charAt(0) == '1';
        log.debug("Trying to set function {} to {}", (Object)receivedFunction, (Object)(newVal ? "Momentary" : "Locking"));
        this.throttle.setFunctionMomentary(receivedFunction, newVal);
    }

    protected void handleRequest(String inPackage) {
        switch (inPackage.charAt(0)) {
            case 'V': {
                this.sendCurrentSpeed(this.throttle);
                break;
            }
            case 'R': {
                this.sendCurrentDirection(this.throttle);
                break;
            }
            case 's': {
                this.sendSpeedStepMode(this.throttle);
                break;
            }
            case 'm': {
                this.sendAllMomentaryStates(this.throttle);
                break;
            }
            default: {
                log.warn("Unhandled code: {}", (Object)Character.valueOf(inPackage.charAt(0)));
            }
        }
    }

    private static SpeedStepMode decodeSpeedStepMode(String mode) {
        if (mode.equals("1")) {
            return SpeedStepMode.NMRA_DCC_128;
        }
        if (mode.equals("2")) {
            return SpeedStepMode.NMRA_DCC_28;
        }
        if (mode.equals("4")) {
            return SpeedStepMode.NMRA_DCC_27;
        }
        if (mode.equals("8")) {
            return SpeedStepMode.NMRA_DCC_14;
        }
        if (mode.equals("16")) {
            return SpeedStepMode.MOTOROLA_28;
        }
        return SpeedStepMode.getByName(mode);
    }
}

