/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.roster.rostergroup.RosterGroupSelector;
import jmri.jmrit.roster.swing.RosterGroupComboBox;
import jmri.jmrit.throttle.LargePowerManagerButton;
import jmri.jmrit.throttle.StopAllButton;
import jmri.jmrit.withrottle.Bundle;
import jmri.jmrit.withrottle.ControllerFilterAction;
import jmri.jmrit.withrottle.DeviceListener;
import jmri.jmrit.withrottle.DeviceManager;
import jmri.jmrit.withrottle.DeviceServer;
import jmri.jmrit.withrottle.FacelessServer;
import jmri.jmrit.withrottle.WiThrottlePreferences;
import jmri.jmrit.withrottle.WiThrottlesListModel;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.prefs.JmriPreferencesActionFactory;
import jmri.util.swing.JmriAbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserInterface
extends JmriJFrame
implements DeviceListener,
RosterGroupSelector {
    JMenuBar menuBar;
    JMenuItem serverOnOff;
    JPanel panel;
    JLabel portLabel = new JLabel(Bundle.getMessage("LabelPending"));
    JLabel manualPortLabel = new JLabel();
    String manualPortLabelString = "";
    JLabel numConnected;
    JScrollPane scrollTable;
    JTable withrottlesList;
    WiThrottlesListModel withrottlesListModel;
    UserPreferencesManager userPreferences = InstanceManager.getDefault(UserPreferencesManager.class);
    String rosterGroupSelectorPreferencesName = this.getClass().getName() + ".rosterGroupSelector";
    RosterGroupComboBox rosterGroupSelector = new RosterGroupComboBox(this.userPreferences.getComboBoxLastSelection(this.rosterGroupSelectorPreferencesName));
    private FacelessServer facelessServer;
    boolean isListen = true;
    private final ArrayList<DeviceServer> deviceList = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(UserInterface.class);

    UserInterface() {
        super(true, true);
        this.facelessServer = (FacelessServer)InstanceManager.getOptionalDefault(DeviceManager.class).orElseGet(() -> InstanceManager.setDefault(DeviceManager.class, new FacelessServer()));
        for (DeviceServer ds : this.facelessServer.getDeviceList()) {
            this.deviceList.add(ds);
            ds.addDeviceListener(this);
        }
        this.facelessServer.addDeviceListener(this);
        this.facelessServer.setSelectedRosterGroup(this.rosterGroupSelector.getSelectedItem());
        this.addIPAddressesToUI();
        this.createWindow();
    }

    private void addIPAddressesToUI() {
        int port = InstanceManager.getDefault(WiThrottlePreferences.class).getPort();
        StringBuilder as = new StringBuilder();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    String hostAddress = inetAddress.getHostAddress();
                    if (hostAddress.equals("0.0.0.0") || hostAddress.regionMatches(0, "127", 0, 3) || hostAddress.contains(":")) continue;
                    this.portLabel.setText(inetAddress.getHostName());
                    as.append(hostAddress).append(":").append(port).append("<br/>");
                }
            }
            this.manualPortLabel.setText("<html>" + as + "</html>");
        }
        catch (SocketException ex) {
            log.warn("Unable to enumerate Network Interfaces: {}", (Object)ex.getMessage());
        }
    }

    protected void createWindow() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints con = new GridBagConstraints();
        this.getContentPane().add(this.panel);
        con.fill = 0;
        con.weightx = 0.5;
        con.weighty = 0.0;
        JLabel label = new JLabel(MessageFormat.format(Bundle.getMessage("LabelListening"), DeviceServer.getWiTVersion()));
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 2;
        this.panel.add((Component)label, con);
        con.gridx = 0;
        con.gridy = 1;
        con.gridwidth = 2;
        this.panel.add((Component)this.portLabel, con);
        con.gridy = 2;
        this.panel.add((Component)this.manualPortLabel, con);
        this.numConnected = new JLabel(Bundle.getMessage("LabelClients") + " " + this.deviceList.size());
        con.weightx = 0.0;
        con.gridx = 2;
        con.gridy = 2;
        con.ipadx = 5;
        con.gridwidth = 1;
        this.panel.add((Component)this.numConnected, con);
        JPanel rgsPanel = new JPanel();
        rgsPanel.add(new JLabel(Bundle.getMessage("RosterGroupLabel")));
        rgsPanel.add(this.rosterGroupSelector);
        rgsPanel.setToolTipText(Bundle.getMessage("RosterGroupToolTip"));
        JToolBar withrottleToolBar = new JToolBar();
        withrottleToolBar.setFloatable(false);
        withrottleToolBar.add(new StopAllButton());
        withrottleToolBar.add(new LargePowerManagerButton());
        withrottleToolBar.add(rgsPanel);
        con.weightx = 0.5;
        con.ipadx = 0;
        con.gridx = 1;
        con.gridy = 3;
        con.gridwidth = 2;
        this.panel.add((Component)withrottleToolBar, con);
        URL imageURL = FileUtil.findURL("resources/IconForWiThrottle.gif");
        if (imageURL != null) {
            ImageIcon image = new ImageIcon(imageURL);
            JLabel icon = new JLabel(image);
            con.weightx = 0.5;
            con.gridx = 2;
            con.gridy = 0;
            con.ipady = 5;
            con.gridheight = 2;
            this.panel.add((Component)icon, con);
        }
        this.withrottlesListModel = new WiThrottlesListModel(this.deviceList);
        this.withrottlesList = new JTable(this.withrottlesListModel);
        this.withrottlesList.setPreferredScrollableViewportSize(new Dimension(300, 80));
        this.withrottlesList.setRowHeight(20);
        this.scrollTable = new JScrollPane(this.withrottlesList);
        con.gridx = 0;
        con.gridy = 4;
        con.weighty = 1.0;
        con.ipadx = 10;
        con.ipady = 10;
        con.gridheight = 3;
        con.gridwidth = 0;
        con.fill = 1;
        this.panel.add((Component)this.scrollTable, con);
        this.buildMenu();
        this.setTitle("WiThrottle");
        this.pack();
        this.setDefaultCloseOperation(1);
        this.setVisible(true);
        this.setMinimumSize(new Dimension(400, 250));
        this.rosterGroupSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = (String)((JComboBox)e.getSource()).getSelectedItem();
                UserInterface.this.userPreferences.setComboBoxLastSelection(UserInterface.this.rosterGroupSelectorPreferencesName, s);
                UserInterface.this.facelessServer.setSelectedRosterGroup(s);
                for (DeviceServer device : UserInterface.this.deviceList) {
                    device.sendPacketToDevice(device.sendRoster());
                }
            }
        });
    }

    protected void buildMenu() {
        this.setJMenuBar(new JMenuBar());
        JMenu menu = new JMenu(Bundle.getMessage("MenuMenu"));
        this.serverOnOff = new JMenuItem(Bundle.getMessage("MenuMenuStop"));
        this.serverOnOff.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (UserInterface.this.isListen) {
                    UserInterface.this.disableServer();
                    UserInterface.this.serverOnOff.setText(Bundle.getMessage("MenuMenuStart"));
                    UserInterface.this.portLabel.setText(Bundle.getMessage("LabelNone"));
                    UserInterface.this.manualPortLabel.setText(null);
                } else {
                    UserInterface.this.enableServer();
                    UserInterface.this.serverOnOff.setText(Bundle.getMessage("MenuMenuStop"));
                    UserInterface.this.addIPAddressesToUI();
                }
            }
        });
        menu.add(this.serverOnOff);
        menu.add(new ControllerFilterAction());
        JmriAbstractAction prefsAction = InstanceManager.getDefault(JmriPreferencesActionFactory.class).getCategorizedAction(Bundle.getMessage("MenuMenuPrefs"), "WITHROTTLE");
        menu.add(prefsAction);
        this.getJMenuBar().add(menu);
        this.addHelpMenu("package.jmri.jmrit.withrottle.UserInterface", true);
    }

    public WiThrottlesListModel getThrottleList() {
        return this.withrottlesListModel;
    }

    @Override
    public void notifyDeviceConnected(DeviceServer device) {
        this.deviceList.add(device);
        if (this.withrottlesListModel != null) {
            this.withrottlesListModel.updateDeviceList(this.deviceList);
        }
        if (this.numConnected != null) {
            this.numConnected.setText(Bundle.getMessage("LabelClients") + " " + this.deviceList.size());
        }
    }

    @Override
    public void notifyDeviceDisconnected(DeviceServer device) {
        if (this.deviceList.size() < 1) {
            return;
        }
        if (!this.deviceList.remove(device)) {
            return;
        }
        if (this.numConnected != null) {
            this.numConnected.setText(Bundle.getMessage("LabelClients") + " " + this.deviceList.size());
        }
        if (this.withrottlesListModel != null) {
            this.withrottlesListModel.updateDeviceList(this.deviceList);
        }
        device.removeDeviceListener(this);
    }

    @Override
    public void notifyDeviceAddressChanged(DeviceServer device) {
        if (this.withrottlesListModel != null) {
            this.withrottlesListModel.updateDeviceList(this.deviceList);
        }
    }

    @Override
    public void notifyDeviceInfoChanged(DeviceServer device) {
        if (this.withrottlesListModel != null) {
            this.withrottlesListModel.updateDeviceList(this.deviceList);
        }
    }

    void disableServer() {
        this.facelessServer.disableServer();
        this.isListen = false;
    }

    private void enableServer() {
        this.facelessServer.listen();
        this.isListen = true;
    }

    @Override
    public String getSelectedRosterGroup() {
        return this.rosterGroupSelector.getSelectedRosterGroup();
    }
}

