/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.io.File;
import java.util.Set;
import javax.annotation.Nonnull;
import jmri.implementation.AbstractInstanceInitializer;
import jmri.jmrit.withrottle.AbstractWiThrottlePreferences;
import jmri.util.FileUtil;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WiThrottlePreferences
extends AbstractWiThrottlePreferences {
    public static final int DEFAULT_PORT = 12090;
    private boolean isRestartRequired = false;
    private boolean useEStop = true;
    private int eStopDelay = 10;
    private boolean useMomF2 = true;
    private boolean exclusiveUseOfAddress = false;
    private int port = 12090;
    private boolean allowTrackPower = true;
    private boolean allowTurnout = true;
    private boolean allowTurnoutCreation = false;
    private boolean allowRoute = true;
    private boolean allowConsist = true;
    private boolean useWiFiConsist = true;
    private boolean displayFastClock = true;
    private boolean asLoadedUseEStop = true;
    private int asLoadedEStopDelay = 10;
    private boolean asLoadedUseMomF2 = true;
    private boolean asLoadedExclusive = false;
    private int asLoadedPort = 0;
    private boolean asLoadedAllowTrackPower = true;
    private boolean asLoadedAllowTurnout = true;
    private boolean asLoadedAllowTurnoutCreation = false;
    private boolean asLoadedAllowRoute = true;
    private boolean asLoadedAllowConsist = true;
    private boolean asLoadedUseWiFiConsist = true;
    private boolean asLoadedDisplayFastClock = true;
    private static final Logger log = LoggerFactory.getLogger(WiThrottlePreferences.class);

    public WiThrottlePreferences(String fileName) {
        super.openFile(fileName);
    }

    public WiThrottlePreferences() {
    }

    @Override
    public void load(@Nonnull Element child) {
        Attribute a = child.getAttribute("isUseEStop");
        if (a != null) {
            this.setUseEStop(a.getValue().equalsIgnoreCase("true"));
            this.asLoadedUseEStop = this.isUseEStop();
        }
        if ((a = child.getAttribute("isExclusiveUseOfAddress")) != null) {
            this.setExclusiveUseOfAddress(a.getValue().equalsIgnoreCase("true"));
            this.asLoadedExclusive = this.isExclusiveUseOfAddress();
        }
        if ((a = child.getAttribute("getEStopDelay")) != null) {
            try {
                this.setEStopDelay(Integer.parseInt(a.getValue()));
                this.asLoadedEStopDelay = this.getEStopDelay();
            }
            catch (NumberFormatException e) {
                log.debug("EStop Delay \"{}\" is invalid.", (Object)a.getValue(), (Object)e);
            }
        }
        if ((a = child.getAttribute("isUseMomF2")) != null) {
            this.setUseMomF2(a.getValue().equalsIgnoreCase("true"));
            this.asLoadedUseMomF2 = this.isUseMomF2();
        }
        if ((a = child.getAttribute("getPort")) != null) {
            try {
                this.setPort(a.getIntValue());
            }
            catch (DataConversionException ex) {
                log.error("Port {} is invalid.", (Object)a.getValue());
            }
            this.asLoadedPort = this.getPort();
        }
        if ((a = child.getAttribute("isAllowTrackPower")) != null) {
            this.setAllowTrackPower(a.getValue().equalsIgnoreCase("true"));
            this.asLoadedAllowTrackPower = this.isAllowTrackPower();
        }
        if ((a = child.getAttribute("isAllowTurnout")) != null) {
            this.setAllowTurnout(a.getValue().equalsIgnoreCase("true"));
            this.asLoadedAllowTurnout = this.isAllowTurnout();
        }
        if ((a = child.getAttribute("isAllowTurnoutCreation")) != null) {
            this.setAllowTurnoutCreation(a.getValue().equalsIgnoreCase("true"));
            this.asLoadedAllowTurnoutCreation = this.isAllowTurnoutCreation();
        }
        if ((a = child.getAttribute("isAllowRoute")) != null) {
            this.setAllowRoute(a.getValue().equalsIgnoreCase("true"));
            this.asLoadedAllowRoute = this.isAllowRoute();
        }
        if ((a = child.getAttribute("isAllowConsist")) != null) {
            this.setAllowConsist(a.getValue().equalsIgnoreCase("true"));
            this.asLoadedAllowConsist = this.isAllowConsist();
        }
        if ((a = child.getAttribute("isUseWiFiConsist")) != null) {
            this.setUseWiFiConsist(a.getValue().equalsIgnoreCase("true"));
            this.asLoadedUseWiFiConsist = this.isUseWiFiConsist();
        }
        if ((a = child.getAttribute("isDisplayFastClock")) != null) {
            this.setDisplayFastClock(a.getValue().equalsIgnoreCase("true"));
            this.asLoadedDisplayFastClock = this.isDisplayFastClock();
        }
    }

    public boolean compareValuesDifferent(WiThrottlePreferences prefs) {
        return prefs.isUseEStop() != this.isUseEStop() || prefs.getEStopDelay() != this.getEStopDelay() || prefs.isUseMomF2() != this.isUseMomF2() || prefs.isExclusiveUseOfAddress() != this.isExclusiveUseOfAddress() || prefs.getPort() != this.getPort() || prefs.isAllowTrackPower() != this.isAllowTrackPower() || prefs.isAllowTurnout() != this.isAllowTurnout() || prefs.isAllowTurnoutCreation() != this.isAllowTurnoutCreation() || prefs.isAllowRoute() != this.isAllowRoute() || prefs.isAllowConsist() != this.isAllowConsist() || prefs.isUseWiFiConsist() != this.isUseWiFiConsist() || prefs.isDisplayFastClock() != this.isDisplayFastClock();
    }

    public void apply(WiThrottlePreferences prefs) {
        this.setUseEStop(prefs.isUseEStop());
        this.setEStopDelay(prefs.getEStopDelay());
        this.setUseMomF2(prefs.isUseMomF2());
        this.setExclusiveUseOfAddress(prefs.isExclusiveUseOfAddress());
        this.setPort(prefs.getPort());
        this.setAllowTrackPower(prefs.isAllowTrackPower());
        this.setAllowTurnout(prefs.isAllowTurnout());
        this.setAllowTurnoutCreation(prefs.isAllowTurnoutCreation());
        this.setAllowRoute(prefs.isAllowRoute());
        this.setAllowConsist(prefs.isAllowConsist());
        this.setUseWiFiConsist(prefs.isUseWiFiConsist());
        this.setDisplayFastClock(prefs.isDisplayFastClock());
    }

    @Override
    public Element store() {
        if (this.isDirty()) {
            this.isRestartRequired = true;
        }
        Element element = new Element("WiThrottlePreferences");
        element.setAttribute("isUseEStop", "" + this.isUseEStop());
        this.asLoadedUseEStop = this.isUseEStop();
        element.setAttribute("getEStopDelay", "" + this.getEStopDelay());
        this.asLoadedEStopDelay = this.getEStopDelay();
        element.setAttribute("isUseMomF2", "" + this.isUseMomF2());
        this.asLoadedUseMomF2 = this.isUseMomF2();
        element.setAttribute("isExclusiveUseOfAddress", "" + this.isExclusiveUseOfAddress());
        this.asLoadedExclusive = this.isExclusiveUseOfAddress();
        element.setAttribute("getPort", "" + this.getPort());
        this.asLoadedPort = this.getPort();
        element.setAttribute("isAllowTrackPower", "" + this.isAllowTrackPower());
        this.asLoadedAllowTrackPower = this.isAllowTrackPower();
        element.setAttribute("isAllowTurnout", "" + this.isAllowTurnout());
        this.asLoadedAllowTurnout = this.isAllowTurnout();
        element.setAttribute("isAllowTurnoutCreation", "" + this.isAllowTurnoutCreation());
        this.asLoadedAllowTurnoutCreation = this.isAllowTurnoutCreation();
        element.setAttribute("isAllowRoute", "" + this.isAllowRoute());
        this.asLoadedAllowRoute = this.isAllowRoute();
        element.setAttribute("isAllowConsist", "" + this.isAllowConsist());
        this.asLoadedAllowConsist = this.isAllowConsist();
        element.setAttribute("isUseWiFiConsist", "" + this.isUseWiFiConsist());
        this.asLoadedUseWiFiConsist = this.isUseWiFiConsist();
        element.setAttribute("isDisplayFastClock", "" + this.isDisplayFastClock());
        this.asLoadedDisplayFastClock = this.isDisplayFastClock();
        return element;
    }

    public boolean isDirty() {
        return this.asLoadedUseEStop != this.isUseEStop() || this.asLoadedEStopDelay != this.getEStopDelay() || this.asLoadedUseMomF2 != this.isUseMomF2() || this.asLoadedExclusive != this.isExclusiveUseOfAddress() || this.asLoadedPort == 0 || this.asLoadedPort != this.getPort() || this.asLoadedAllowTrackPower != this.isAllowTrackPower() || this.asLoadedAllowTurnout != this.isAllowTurnout() || this.asLoadedAllowTurnoutCreation != this.isAllowTurnoutCreation() || this.asLoadedAllowRoute != this.isAllowRoute() || this.asLoadedAllowConsist != this.isAllowConsist() || this.asLoadedUseWiFiConsist != this.isUseWiFiConsist() || this.asLoadedDisplayFastClock != this.isDisplayFastClock();
    }

    public boolean isRestartRequired() {
        return this.isRestartRequired;
    }

    public boolean isUseEStop() {
        return this.useEStop;
    }

    public void setUseEStop(boolean value) {
        this.useEStop = value;
    }

    public int getEStopDelay() {
        return this.eStopDelay;
    }

    public void setEStopDelay(int value) {
        this.eStopDelay = value;
    }

    public boolean isUseMomF2() {
        return this.useMomF2;
    }

    public void setUseMomF2(boolean value) {
        this.useMomF2 = value;
    }

    public boolean isExclusiveUseOfAddress() {
        return this.exclusiveUseOfAddress;
    }

    public void setExclusiveUseOfAddress(boolean value) {
        this.exclusiveUseOfAddress = value;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int value) {
        this.port = value;
    }

    public boolean isAllowTrackPower() {
        return this.allowTrackPower;
    }

    public void setAllowTrackPower(boolean value) {
        this.allowTrackPower = value;
    }

    public boolean isAllowTurnout() {
        return this.allowTurnout;
    }

    public void setAllowTurnout(boolean value) {
        this.allowTurnout = value;
    }

    public boolean isAllowTurnoutCreation() {
        return this.allowTurnoutCreation;
    }

    public void setAllowTurnoutCreation(boolean value) {
        this.allowTurnoutCreation = value;
    }

    public boolean isAllowRoute() {
        return this.allowRoute;
    }

    public void setAllowRoute(boolean value) {
        this.allowRoute = value;
    }

    public boolean isAllowConsist() {
        return this.allowConsist;
    }

    public void setAllowConsist(boolean value) {
        this.allowConsist = value;
    }

    public boolean isUseWiFiConsist() {
        return this.useWiFiConsist;
    }

    public void setUseWiFiConsist(boolean value) {
        this.useWiFiConsist = value;
    }

    public boolean isDisplayFastClock() {
        return this.displayFastClock;
    }

    public void setDisplayFastClock(boolean value) {
        this.displayFastClock = value;
    }

    public static class Initializer
    extends AbstractInstanceInitializer {
        @Override
        public <T> Object getDefault(Class<T> type) {
            if (type.equals(WiThrottlePreferences.class)) {
                return new WiThrottlePreferences(FileUtil.getUserFilesPath() + "throttle" + File.separator + "WiThrottlePreferences.xml");
            }
            return super.getDefault(type);
        }

        @Override
        public Set<Class<?>> getInitalizes() {
            Set<Class<?>> set = super.getInitalizes();
            set.add(WiThrottlePreferences.class);
            return set;
        }
    }
}

