/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.withrottle;

import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import jmri.jmrit.withrottle.DeviceServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WiThrottlesListModel
extends AbstractTableModel {
    ArrayList<DeviceServer> deviceList;
    static final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.withrottle.WiThrottleBundle");
    private static final Logger log = LoggerFactory.getLogger(WiThrottlesListModel.class);

    WiThrottlesListModel(ArrayList<DeviceServer> deviceList) {
        this.deviceList = deviceList;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.deviceList.size();
    }

    @Override
    public String getColumnName(int col) {
        String title;
        switch (col) {
            case 0: {
                title = rb.getString("LabelDeviceName");
                break;
            }
            case 1: {
                title = rb.getString("LabelAddress");
                break;
            }
            case 2: {
                title = rb.getString("LabelRosterId");
                break;
            }
            default: {
                title = "";
            }
        }
        return title;
    }

    @Override
    public String getValueAt(int row, int col) {
        if (this.deviceList.size() < 1) {
            return null;
        }
        if (row >= this.deviceList.size()) {
            log.debug("row is greater than device list size");
            return null;
        }
        if (col == 0) {
            return this.deviceList.get(row).getName();
        }
        if (col == 1) {
            return this.deviceList.get(row).getCurrentAddressString();
        }
        return this.deviceList.get(row).getCurrentRosterIdString();
    }

    public void updateDeviceList(ArrayList<DeviceServer> deviceList) {
        this.deviceList = deviceList;
        this.fireTableDataChanged();
    }
}

