/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.z21server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.z21server.ClientManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppClient
implements PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(AppClient.class);
    private final InetAddress address;
    private final HashMap<Integer, DccThrottle> throttles;
    private final PropertyChangeListener changeListener;
    private DccThrottle activeThrottle = null;
    private RosterEntry activeRosterEntry = null;
    private Date timestamp;
    private static final int packetLenght = 14;

    public AppClient(InetAddress address, PropertyChangeListener changeListener) {
        this.address = address;
        this.changeListener = changeListener;
        this.throttles = new HashMap();
        this.heartbeat();
    }

    public void addThrottle(int locoAddress, DccThrottle throttle) {
        if (!this.throttles.containsKey(locoAddress)) {
            this.throttles.put(locoAddress, throttle);
            throttle.addPropertyChangeListener(this);
        }
        log.trace("addThrottle: list: {}", this.throttles.keySet());
    }

    public DccThrottle getActiveThrottle() {
        return this.activeThrottle;
    }

    public String getActiveRosterIdString() {
        return this.activeRosterEntry != null ? this.activeRosterEntry.getId() : null;
    }

    public void setActiveThrottle(DccThrottle t) {
        this.activeThrottle = t;
        this.activeRosterEntry = AppClient.findRosterEntry(t);
    }

    public void clear() {
        log.trace("clear: list: {}", this.throttles.keySet());
        for (DccThrottle t : this.throttles.values()) {
            t.removePropertyChangeListener(this);
        }
        this.throttles.clear();
    }

    public DccThrottle getThrottleFromLocoAddress(int locoAddress) {
        if (this.throttles.containsKey(locoAddress)) {
            return this.throttles.get(locoAddress);
        }
        return null;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void heartbeat() {
        this.timestamp = new Date();
    }

    public boolean isTimestampExpired() {
        Duration duration = Duration.between(this.timestamp.toInstant(), new Date().toInstant());
        log.trace("Duration without heartbeat: {}", (Object)duration);
        return duration.toSeconds() >= 60L;
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Messages can be of any length, null is used to indicate absence of message for caller")
    public byte[] getLocoStatusMessage(Integer locoAddress) {
        if (this.throttles.containsKey(locoAddress)) {
            return this.buildLocoPacket(this.throttles.get(locoAddress));
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (this.changeListener != null) {
            log.trace("AppClient: Throttle change event: loco: {}, {}", (Object)((DccThrottle)pce.getSource()).getLocoAddress(), (Object)pce);
            this.changeListener.propertyChange(new PropertyChangeEvent(pce.getSource(), "throttle-change", null, this.buildLocoPacket((DccThrottle)pce.getSource())));
        }
    }

    public static RosterEntry findRosterEntry(DccThrottle t) {
        List<RosterEntry> l;
        RosterEntry re = null;
        if (t.getLocoAddress() != null && (l = Roster.getDefault().matchingList(null, null, "" + ((DccLocoAddress)t.getLocoAddress()).getNumber(), null, null, null, null)).size() > 0) {
            log.debug("Roster Loco found: {}", (Object)l.get(0).getDccAddress());
            re = l.get(0);
        }
        return re;
    }

    private byte[] buildLocoPacket(DccThrottle t) {
        byte[] locoPacket = new byte[14];
        locoPacket[0] = 14;
        locoPacket[1] = 0;
        locoPacket[2] = 64;
        locoPacket[3] = 0;
        locoPacket[4] = -17;
        int locoAddress = t.getLocoAddress().getNumber();
        locoPacket[5] = (byte)(locoAddress >> 8);
        locoPacket[6] = (byte)locoAddress;
        if (locoAddress >= 128) {
            locoPacket[5] = (byte)(locoPacket[5] | 0xC0);
        }
        locoPacket[7] = 4;
        float speed = t.getSpeedSetting();
        int packetspeed = Math.round(speed / ClientManager.speedMultiplier);
        if (speed < 0.0f) {
            packetspeed = 0;
        }
        if (packetspeed > 128) {
            packetspeed = 128;
        }
        locoPacket[8] = (byte)((t.getIsForward() ? -128 : 0) + (byte)packetspeed);
        locoPacket[9] = (byte)((byte)(t.getFunction(0) ? 16 : 0) + (t.getFunction(4) ? 8 : 0) + (t.getFunction(3) ? 4 : 0) + (t.getFunction(2) ? 2 : 0) + (t.getFunction(1) ? 1 : 0));
        locoPacket[10] = (byte)((byte)(t.getFunction(12) ? 128 : 0) + (t.getFunction(11) ? 64 : 0) + (t.getFunction(10) ? 32 : 0) + (t.getFunction(9) ? 16 : 0) + (t.getFunction(8) ? 8 : 0) + (t.getFunction(7) ? 4 : 0) + (t.getFunction(6) ? 2 : 0) + (t.getFunction(5) ? 1 : 0));
        locoPacket[11] = (byte)((byte)(t.getFunction(20) ? 128 : 0) + (t.getFunction(19) ? 64 : 0) + (t.getFunction(18) ? 32 : 0) + (t.getFunction(17) ? 16 : 0) + (t.getFunction(16) ? 8 : 0) + (t.getFunction(15) ? 4 : 0) + (t.getFunction(14) ? 2 : 0) + (t.getFunction(13) ? 1 : 0));
        locoPacket[12] = (byte)((byte)(t.getFunction(28) ? 128 : 0) + (t.getFunction(27) ? 64 : 0) + (t.getFunction(26) ? 32 : 0) + (t.getFunction(25) ? 16 : 0) + (t.getFunction(24) ? 8 : 0) + (t.getFunction(23) ? 4 : 0) + (t.getFunction(22) ? 2 : 0) + (t.getFunction(21) ? 1 : 0));
        locoPacket[13] = ClientManager.xor(locoPacket);
        return locoPacket;
    }
}

