/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.z21server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.ThrottleListener;
import jmri.jmrit.z21server.AppClient;
import jmri.jmrit.z21server.TurnoutNumberMapHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientManager
implements ThrottleListener {
    private static ClientManager instance;
    private static final HashMap<InetAddress, AppClient> registeredClients;
    private static final HashMap<Integer, InetAddress> requestedThrottlesList;
    private PropertyChangeListener changeListener = null;
    private PropertyChangeListener clientListener = null;
    public static float speedMultiplier;
    private static final Logger log;

    private ClientManager() {
    }

    public static synchronized ClientManager getInstance() {
        if (instance == null) {
            instance = new ClientManager();
        }
        return instance;
    }

    public void setChangeListener(PropertyChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public void setClientListener(PropertyChangeListener clientListener) {
        this.clientListener = clientListener;
    }

    public HashMap<InetAddress, AppClient> getRegisteredClients() {
        return registeredClients;
    }

    public synchronized void registerLocoIfNeeded(InetAddress clientAddress, int locoAddress) {
        if (!registeredClients.containsKey(clientAddress)) {
            AppClient client = new AppClient(clientAddress, this.changeListener);
            registeredClients.put(clientAddress, client);
            if (this.clientListener != null) {
                this.clientListener.propertyChange(new PropertyChangeEvent(this, "client-registered", null, null));
            }
        }
        if (registeredClients.get(clientAddress).getThrottleFromLocoAddress(locoAddress) == null) {
            requestedThrottlesList.put(locoAddress, clientAddress);
            InstanceManager.throttleManagerInstance().requestThrottle(locoAddress, ClientManager.getInstance());
        }
    }

    public synchronized void setLocoSpeedAndDirection(InetAddress clientAddress, int locoAddress, int speed, boolean forward) {
        AppClient client = registeredClients.get(clientAddress);
        if (client != null) {
            DccThrottle throttle = client.getThrottleFromLocoAddress(locoAddress);
            if (throttle != null) {
                if (throttle.getIsForward() != forward) {
                    throttle.setIsForward(forward);
                }
                throttle.setSpeedSetting((float)speed * speedMultiplier);
                this.setActiveThrottle(client, throttle);
            } else {
                log.info("Unable to find throttle for loco {} from client {}", (Object)locoAddress, (Object)clientAddress);
            }
        } else {
            log.info("App client {} is not registered", (Object)clientAddress);
        }
    }

    public synchronized void setLocoFunction(InetAddress clientAddress, int locoAddress, int functionNumber, int functionState) {
        AppClient client = registeredClients.get(clientAddress);
        if (client != null) {
            DccThrottle throttle = client.getThrottleFromLocoAddress(locoAddress);
            if (throttle != null) {
                boolean bOn;
                boolean bl = bOn = (functionState & 1) == 1;
                if ((functionState & 3) == 2) {
                    log.trace("Toggle! old state: {}", (Object)throttle.getFunction(functionNumber));
                    bOn = !throttle.getFunction(functionNumber);
                }
                log.trace("set function {} to value: {}", (Object)functionNumber, (Object)bOn);
                throttle.setFunction(functionNumber, bOn);
                this.setActiveThrottle(client, throttle);
            } else {
                log.info("Unable to find throttle for loco {} from client {}", (Object)locoAddress, (Object)clientAddress);
            }
        } else {
            log.info("App client {} is not registered", (Object)clientAddress);
        }
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Messages can be of any length, null is used to indicate absence of message for caller")
    public synchronized byte[] getLocoStatusMessage(InetAddress address, Integer locoAddress) {
        if (registeredClients.containsKey(address)) {
            AppClient client = registeredClients.get(address);
            return client.getLocoStatusMessage(locoAddress);
        }
        return null;
    }

    private void setActiveThrottle(AppClient client, DccThrottle throttle) {
        if (client.getActiveThrottle() != throttle) {
            client.setActiveThrottle(throttle);
            if (this.clientListener != null) {
                this.clientListener.propertyChange(new PropertyChangeEvent(this, "active-throttle", null, null));
            }
        }
    }

    public synchronized void setTurnout(InetAddress clientAddress, int turnoutNumber, boolean state) {
        int turnoutState = state ? 4 : 2;
        TurnoutNumberMapHandler.getInstance().setStateForNumber(turnoutNumber + 1, turnoutState);
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Messages can be of any length, null is used to indicate absence of message for caller")
    public synchronized byte[] getTurnoutStatusMessage(InetAddress address, Integer turnoutNumber) {
        int state = TurnoutNumberMapHandler.getInstance().getStateForNumber(turnoutNumber + 1);
        if (state >= 0) {
            byte[] turnoutPacket = new byte[9];
            turnoutPacket[0] = 9;
            turnoutPacket[1] = 0;
            turnoutPacket[2] = 64;
            turnoutPacket[3] = 0;
            turnoutPacket[4] = 67;
            turnoutPacket[5] = (byte)(turnoutNumber >> 8);
            turnoutPacket[6] = (byte)(turnoutNumber & 0xFF);
            turnoutPacket[7] = 0;
            if (state == 2) {
                turnoutPacket[7] = 2;
            }
            if (state == 4) {
                turnoutPacket[7] = 1;
            }
            turnoutPacket[8] = ClientManager.xor(turnoutPacket);
            return turnoutPacket;
        }
        return null;
    }

    public synchronized void heartbeat(InetAddress clientAddress) {
        AppClient client = registeredClients.get(clientAddress);
        if (client != null) {
            client.heartbeat();
        }
    }

    public synchronized void handleExpiredClients(boolean removeAll) {
        HashMap<InetAddress, AppClient> tempMap = new HashMap<InetAddress, AppClient>(registeredClients);
        for (AppClient c : tempMap.values()) {
            if (!c.isTimestampExpired() && !removeAll) continue;
            log.debug("Remove expired client [{}]", (Object)c.getAddress());
            this.unregisterClient(c.getAddress());
        }
    }

    public synchronized void unregisterClient(InetAddress clientAddress) {
        log.info("Remove client [{}]", (Object)clientAddress);
        if (registeredClients.containsKey(clientAddress)) {
            registeredClients.get(clientAddress).clear();
        }
        registeredClients.remove(clientAddress);
        if (this.clientListener != null) {
            this.clientListener.propertyChange(new PropertyChangeEvent(this, "client-unregistered", null, null));
        }
        Iterator<Map.Entry<Integer, InetAddress>> it = requestedThrottlesList.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, InetAddress> e = it.next();
            if (!e.getValue().equals(clientAddress)) continue;
            log.error("The list requestedThrottlesList should be empty, but is not. Remove {}", e);
            it.remove();
        }
    }

    @Override
    public synchronized void notifyThrottleFound(DccThrottle t) {
        int locoAddress = t.getLocoAddress().getNumber();
        InetAddress client = requestedThrottlesList.get(locoAddress);
        if (client != null) {
            registeredClients.get(client).addThrottle(locoAddress, t);
            requestedThrottlesList.remove(locoAddress);
        }
    }

    @Override
    public synchronized void notifyFailedThrottleRequest(LocoAddress address, String reason) {
        log.info("Unable to get Throttle for loco address {}, reason : {}", (Object)address.getNumber(), (Object)reason);
        requestedThrottlesList.remove(address.getNumber());
    }

    @Override
    public synchronized void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
        InstanceManager.throttleManagerInstance().responseThrottleDecision(address, (ThrottleListener)ClientManager.getInstance(), ThrottleListener.DecisionType.SHARE);
    }

    public static byte xor(byte[] packet) {
        byte xor = (byte)(packet[0] ^ packet[1]);
        for (int i = 2; i < packet.length - 1; ++i) {
            xor = (byte)(xor ^ packet[i]);
        }
        return xor;
    }

    static {
        registeredClients = new HashMap();
        requestedThrottlesList = new HashMap();
        speedMultiplier = 0.0078125f;
        log = LoggerFactory.getLogger(ClientManager.class);
    }
}

