/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.z21server;

import jmri.jmrit.z21server.MainServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacelessServer {
    private static FacelessServer instance;
    private static MainServer server;
    private static Thread currentThread;
    private static final Logger log;

    private FacelessServer() {
        FacelessServer.initServer();
        FacelessServer.createThread();
    }

    private static void initServer() {
        server = new MainServer();
    }

    private static synchronized void createThread() {
        currentThread = new Thread(server);
        currentThread.setName("Z21 App Server");
    }

    public static synchronized FacelessServer getInstance() {
        if (instance == null) {
            instance = new FacelessServer();
        }
        return instance;
    }

    public synchronized void start() {
        if (currentThread.getState() == Thread.State.TERMINATED) {
            FacelessServer.createThread();
        }
        if (currentThread.getState() == Thread.State.NEW) {
            log.info("Trying to start new z21 server...");
            currentThread.start();
        }
    }

    public synchronized void stop() {
        currentThread.interrupt();
    }

    static {
        log = LoggerFactory.getLogger(FacelessServer.class);
    }
}

