/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.z21server;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jmri.jmrit.z21server.AppClient;
import jmri.jmrit.z21server.ClientManager;
import jmri.jmrit.z21server.Service40;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainServer
implements Runnable,
PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(MainServer.class);
    public static final int port = 21105;
    DatagramSocket mySS;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final short HEADER_SIZE = 4;

    @Override
    public void run() {
        try {
            this.mySS = new DatagramSocket(21105);
            byte[] buf = new byte[256];
            DatagramPacket packet = new DatagramPacket(buf, buf.length);
            log.info("Created socket, listening for connections");
            ClientManager.getInstance().setChangeListener(this);
            Service40.setChangeListener(this);
            while (!Thread.interrupted()) {
                boolean bReceivedData;
                log.trace("Loop ****");
                ClientManager.getInstance().handleExpiredClients(false);
                this.mySS.setSoTimeout(2000);
                try {
                    this.mySS.receive(packet);
                    bReceivedData = true;
                }
                catch (Exception e) {
                    bReceivedData = false;
                }
                if (!bReceivedData) continue;
                InetAddress clientAddress = packet.getAddress();
                ClientManager.getInstance().heartbeat(clientAddress);
                byte[] rawData = packet.getData();
                byte dataLenght = rawData[0];
                byte[] actualData = Arrays.copyOf(rawData, (int)dataLenght);
                String ident = "[" + clientAddress + "]  ";
                log.debug("{}: recv raw frame {} ", (Object)ident, (Object)MainServer.bytesToHex(actualData));
                if (actualData.length < 3) {
                    log.debug("error, frame : {}", (Object)MainServer.bytesToHex(actualData));
                }
                byte[] response = null;
                switch (actualData[2]) {
                    case 80: {
                        byte[] maskArray = Arrays.copyOfRange(actualData, 4, (int)dataLenght);
                        int mask = MainServer.fromByteArrayLittleEndian(maskArray);
                        log.debug("{} Broadcast request with mask : {}", (Object)ident, (Object)Integer.toBinaryString(mask));
                        break;
                    }
                    case 48: {
                        log.debug("{} Disconnect frame", (Object)ident);
                        ClientManager.getInstance().unregisterClient(clientAddress);
                        break;
                    }
                    case 16: {
                        log.debug("Send 32bit serialnumber");
                        response = new byte[]{8, 0, 16, 0, 0, 0, 0, 0};
                        break;
                    }
                    case 64: {
                        byte[] payloadData = Arrays.copyOfRange(actualData, 4, (int)dataLenght);
                        response = Service40.handleService(payloadData, clientAddress);
                        break;
                    }
                    default: {
                        log.debug("{} Service not yet implemented : 0x{}", (Object)ident, (Object)Integer.toHexString(actualData[2] & 0xFF));
                    }
                }
                if (response == null) continue;
                this.sendResponse(clientAddress, response);
            }
            log.info("Z21 App Server shut down.");
        }
        catch (SocketException e) {
            log.info("Z21 App Server encountered an error, exiting.", (Throwable)e);
        }
        if (this.mySS != null) {
            this.mySS.close();
        }
    }

    public void sendResponseToRegisteredClients(byte[] response) {
        HashMap<InetAddress, AppClient> registeredClients = ClientManager.getInstance().getRegisteredClients();
        log.trace("Sending to all registered clients (broadcast)");
        for (Map.Entry<InetAddress, AppClient> entry : registeredClients.entrySet()) {
            this.sendResponse(entry.getKey(), response);
        }
    }

    public void sendResponse(InetAddress respAddress, byte[] response) {
        if (response != null) {
            DatagramPacket responsePacket = new DatagramPacket(response, response.length, respAddress, 21105);
            if (log.isTraceEnabled()) {
                String sendIdent = "[-> " + respAddress + "]  ";
                log.trace("{}: send raw frame {} ", (Object)sendIdent, (Object)MainServer.bytesToHex(response));
            }
            try {
                this.mySS.send(responsePacket);
            }
            catch (Exception e) {
                log.debug("Unable to send packet to client {}", (Object)respAddress.toString());
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        log.trace("change event: {}", (Object)pce);
        if (pce.getNewValue() != null) {
            this.sendResponseToRegisteredClients((byte[])pce.getNewValue());
        }
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    private static int fromByteArrayLittleEndian(byte[] bytes) {
        return (bytes[2] & 0xFF) << 24 | (bytes[3] & 0xFF) << 16 | (bytes[0] & 0xFF) << 8 | (bytes[1] & 0xFF) << 0;
    }
}

