/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.z21server;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Route;
import jmri.RouteManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.configurexml.StoreXmlUserAction;
import jmri.jmrit.z21server.Bundle;
import jmri.jmrit.z21server.TurnoutNumberMapHandler;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberMapFrame
extends JmriJFrame
implements TableModelListener {
    private static final String[] COLUMN_NAMES = new String[]{Bundle.getMessage("ColumnSystemName"), Bundle.getMessage("ColumnUserName"), Bundle.getMessage("ColumnTurnoutNumber")};
    private final List<JTable> tablelList = new ArrayList<JTable>();
    private static final Logger log = LoggerFactory.getLogger(NumberMapFrame.class);

    public NumberMapFrame() {
        super(Bundle.getMessage("TitleNumberMapFrame"), true, true);
    }

    @Override
    public void initComponents() {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.addTab(Turnout.class, TurnoutManager.class, "Turnouts", "ToolTipTurnoutTab", "LabelTurnoutTab", tabbedPane);
        this.addTab(Route.class, RouteManager.class, "Routes", "ToolTipRouteTab", "LabelRouteTab", tabbedPane);
        this.addTab(Light.class, LightManager.class, "Lights", "ToolTipLightTab", "LabelLightTab", tabbedPane);
        this.addTab(SignalMast.class, SignalMastManager.class, "SignalMasts", "ToolTipSignalMastTab", "LabelSignalMastTab", tabbedPane);
        this.addTab(SignalHead.class, SignalHeadManager.class, "SignalHeads", "ToolTipSignalHeadTab", "LabelSignalHeadTab", tabbedPane);
        this.addTab(Sensor.class, SensorManager.class, "Sensors", "ToolTipSensorTab", "LabelSensorTab", tabbedPane);
        this.add(tabbedPane);
        this.pack();
        this.addHelpMenu("package.jmri.jmrit.z21server.z21server", true);
    }

    private <T extends NamedBean> void addTab(@Nonnull Class<T> type, @Nonnull Class<?> mgrType, String tabName, String tabToolTip, String tabLabel, JTabbedPane tabbedPane) {
        Manager mgr = (Manager)InstanceManager.getNullableDefault(mgrType);
        if (mgr == null) {
            return;
        }
        JPanel tPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(Bundle.getMessage(tabLabel), 0);
        tPanel.add((Component)label, "North");
        tPanel.add((Component)this.addCancelSavePanel(), "West");
        JLabel messageField = new JLabel();
        MapTableModel mapTableModel = new MapTableModel(mgrType, messageField);
        JTable table = new JTable(mapTableModel);
        this.tablelList.add(table);
        mapTableModel.setTable(table);
        this.buildTable(table);
        JScrollPane scrollPane = new JScrollPane(table);
        tPanel.add((Component)scrollPane, "Center");
        tPanel.add((Component)this.addButtonsPanel(messageField, mapTableModel), "South");
        tabbedPane.addTab(Bundle.getMessage(tabName), null, tPanel, Bundle.getMessage(tabToolTip));
    }

    private void buildTable(JTable table) {
        table.getModel().addTableModelListener(this);
        table.setPreferredScrollableViewportSize(new Dimension(580, 240));
        table.setShowHorizontalLines(true);
        table.setGridColor(Color.gray);
        table.setAutoCreateRowSorter(true);
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn tNumber = columnModel.getColumn(2);
        tNumber.setResizable(false);
        tNumber.setMinWidth(60);
        tNumber.setMaxWidth(200);
        TableColumn sName = columnModel.getColumn(0);
        sName.setResizable(true);
        sName.setMinWidth(80);
        sName.setPreferredWidth(80);
        sName.setMaxWidth(340);
        TableColumn uName = columnModel.getColumn(1);
        uName.setResizable(true);
        uName.setMinWidth(180);
        uName.setPreferredWidth(300);
        uName.setMaxWidth(440);
    }

    private JPanel addButtonsPanel(JLabel messageField, MapTableModel<?, ?> fm) {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        pane.add(Box.createHorizontalGlue());
        pane.add(messageField);
        pane.add(Box.createHorizontalStrut(10));
        JButton removeAllButton = new JButton(Bundle.getMessage("ButtonRemoveAll"));
        removeAllButton.addActionListener(event -> fm.removeAllMapNumbers());
        pane.add(removeAllButton);
        return pane;
    }

    private JPanel addCancelSavePanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(Box.createVerticalGlue());
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.setAlignmentX(0.5f);
        cancelButton.setToolTipText(Bundle.getMessage("ToolTipCancel"));
        cancelButton.addActionListener(event -> this.dispose());
        p.add(cancelButton);
        JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
        saveButton.setAlignmentX(0.5f);
        saveButton.setToolTipText(Bundle.getMessage("ToolTipSave"));
        saveButton.addActionListener(event -> {
            this.storeValues();
            this.dispose();
        });
        p.add(saveButton);
        return p;
    }

    @Override
    protected void storeValues() {
        new StoreXmlUserAction().actionPerformed(null);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("Set mod flag true for: {}", (Object)this.getTitle());
        }
        this.setModifiedFlag(true);
    }

    @Override
    public void dispose() {
        log.trace("dispose - remove table models and its listeners from ");
        for (JTable t : this.tablelList) {
            MapTableModel model = (MapTableModel)t.getModel();
            model.dispose();
        }
        this.tablelList.clear();
        super.dispose();
    }

    private static class MapTableModel<E extends NamedBean, M extends Manager<E>>
    extends AbstractTableModel
    implements PropertyChangeListener {
        private final Manager<E> mgr;
        private final JLabel messageField;
        private JTable table;
        private String lastInvalid = null;
        List<String> sysNameList = null;
        boolean isDirty;
        public static final int SNAMECOL = 0;
        public static final int UNAMECOL = 1;
        public static final int TNUMCOL = 2;

        MapTableModel(Class<?> mgrType, JLabel messageField) {
            this.mgr = (Manager)InstanceManager.getDefault(mgrType);
            this.sysNameList = new ArrayList<String>(this.mgr.getNamedBeanSet().size());
            this.mgr.getNamedBeanSet().forEach(bean -> this.sysNameList.add(bean.getSystemName()));
            this.mgr.addPropertyChangeListener(this);
            this.messageField = messageField;
        }

        public void setTable(JTable table) {
            this.table = table;
        }

        @Override
        public Object getValueAt(int r, int c) {
            if (r >= this.sysNameList.size()) {
                log.debug("row is greater than list size");
                return null;
            }
            E t = this.mgr.getBySystemName(this.sysNameList.get(r));
            switch (c) {
                case 2: {
                    Object o;
                    if (t != null && (o = t.getProperty("Z21TurnoutMap")) != null) {
                        return o.toString();
                    }
                    return null;
                }
                case 0: {
                    return this.sysNameList.get(r);
                }
                case 1: {
                    return t != null ? t.getUserName() : null;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            log.trace("field modified {}: row: {}, col: {}", new Object[]{type, r, c});
            E t = this.mgr.getBySystemName(this.sysNameList.get(r));
            if (t != null) {
                switch (c) {
                    case 2: {
                        if (type == null || type.toString().isEmpty()) {
                            t.removeProperty("Z21TurnoutMap");
                            this.lastInvalid = null;
                            this.messageField.setText(null);
                        } else {
                            log.trace("old value: {}, new value {}", this.getValueAt(r, c), type);
                            if (Pattern.matches("^(#.*|(\\d+))$", type.toString())) {
                                t.setProperty("Z21TurnoutMap", type);
                                this.lastInvalid = null;
                                this.messageField.setText(null);
                            } else {
                                log.warn("Invalid value: '{}'", type);
                                if (this.lastInvalid.equals(this.getValueAt(r, c))) {
                                    t.removeProperty("Z21TurnoutMap");
                                    this.lastInvalid = null;
                                } else {
                                    this.table.setValueAt(this.getValueAt(r, c), r, c);
                                    this.lastInvalid = type.toString();
                                    this.messageField.setText(Bundle.getMessage("MessageInvalidValue", type.toString()));
                                }
                            }
                        }
                        if (!this.isDirty) {
                            this.fireTableChanged(new TableModelEvent(this));
                            this.isDirty = true;
                        }
                        TurnoutNumberMapHandler.getInstance().propertyChange(new PropertyChangeEvent(this, "NumberMapChanged", null, t));
                        break;
                    }
                    default: {
                        log.warn("Unhandled col: {}", (Object)c);
                    }
                }
            }
        }

        public void removeAllMapNumbers() {
            for (String sysName : this.sysNameList) {
                E t = this.mgr.getBySystemName(sysName);
                if (t == null) continue;
                t.removeProperty("Z21TurnoutMap");
            }
            this.messageField.setText(null);
            this.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            log.trace("property changed: {}", (Object)e.getPropertyName());
            this.fireTableDataChanged();
        }

        public void dispose() {
            log.trace("dispose MapTableModel - remove listeners from {}", (Object)this.mgr.getClass().getName());
            this.mgr.removePropertyChangeListener(this);
        }

        @Override
        public String getColumnName(int c) {
            return COLUMN_NAMES[c];
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.sysNameList.size();
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 2;
        }
    }
}

