/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.z21server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Iterator;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.PowerManager;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.jmrit.z21server.ClientManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Service40 {
    private static final String moduleIdent = "[Service 40] ";
    private static PropertyChangeListener changeListener = null;
    private static final Logger log = LoggerFactory.getLogger(Service40.class);

    public static void setChangeListener(PropertyChangeListener cl) {
        changeListener = cl;
        PowerManager powerMgr = InstanceManager.getNullableDefault(PowerManager.class);
        if (powerMgr != null) {
            powerMgr.addPropertyChangeListener(pce -> {
                if (changeListener != null) {
                    log.trace("Service40: power change event: {}", (Object)pce);
                    changeListener.propertyChange(new PropertyChangeEvent(pce.getSource(), "trackpower-change", null, Service40.buildTrackPowerPacket()));
                }
            });
        }
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Messages can be of any length, null is used to indicate absence of message for caller")
    public static byte[] handleService(byte[] data, InetAddress clientAddress) {
        byte command = data[0];
        switch (command) {
            case 33: {
                return Service40.handleHeader21(data[1]);
            }
            case -29: {
                return Service40.handleHeaderE3(Arrays.copyOfRange(data, 1, 4), clientAddress);
            }
            case -28: {
                return Service40.handleHeaderE4(Arrays.copyOfRange(data, 1, 5), clientAddress);
            }
            case 67: {
                return Service40.handleHeader43(Arrays.copyOfRange(data, 1, 3), clientAddress);
            }
            case 83: {
                return Service40.handleHeader53(Arrays.copyOfRange(data, 1, 4), clientAddress);
            }
            case -128: {
                return Service40.handleHeader80();
            }
            case -15: {
                return Service40.handleHeaderF1();
            }
        }
        log.debug("{} Header {} not yet supported", (Object)moduleIdent, (Object)Integer.toHexString(command & 0xFF));
        return null;
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Messages can be of any length, null is used to indicate absence of message for caller")
    private static byte[] handleHeader21(int db0) {
        switch (db0) {
            case 33: {
                break;
            }
            case 36: {
                byte[] answer = new byte[8];
                answer[0] = 8;
                answer[1] = 0;
                answer[2] = 64;
                answer[3] = 0;
                answer[4] = 98;
                answer[5] = 34;
                answer[6] = 0;
                PowerManager powerMgr = InstanceManager.getNullableDefault(PowerManager.class);
                if (powerMgr != null && powerMgr.getPower() != 2) {
                    answer[6] = (byte)(answer[6] | 2);
                }
                answer[7] = ClientManager.xor(answer);
                return answer;
            }
            case -128: {
                log.info("{} Set track power to off", (Object)moduleIdent);
                return Service40.setTrackPower(false);
            }
            case -127: {
                log.info("{} Set track power to on", (Object)moduleIdent);
                return Service40.setTrackPower(true);
            }
        }
        return null;
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Messages can be of any length, null is used to indicate absence of message for caller")
    private static byte[] setTrackPower(boolean state) {
        PowerManager powerMgr = InstanceManager.getNullableDefault(PowerManager.class);
        if (powerMgr != null) {
            try {
                powerMgr.setPower(state ? 2 : 4);
            }
            catch (JmriException ex) {
                log.error("Cannot set power from z21");
                return Service40.buildTrackPowerPacket();
            }
        }
        return null;
    }

    private static byte[] buildTrackPowerPacket() {
        byte[] trackPowerPacket = new byte[7];
        trackPowerPacket[0] = 7;
        trackPowerPacket[1] = 0;
        trackPowerPacket[2] = 64;
        trackPowerPacket[3] = 0;
        trackPowerPacket[4] = 97;
        trackPowerPacket[5] = 0;
        PowerManager powerMgr = InstanceManager.getNullableDefault(PowerManager.class);
        if (powerMgr != null) {
            trackPowerPacket[5] = (byte)(powerMgr.getPower() == 2 ? 1 : 0);
        }
        trackPowerPacket[6] = ClientManager.xor(trackPowerPacket);
        return trackPowerPacket;
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Messages can be of any length, null is used to indicate absence of message for caller")
    private static byte[] handleHeaderE3(byte[] data, InetAddress clientAddress) {
        byte db0 = data[0];
        if (db0 == -16) {
            int locomotiveAddress = ((data[1] & 0xFF & 0x3F) << 8) + (data[2] & 0xFF);
            log.debug("{} Get loco no {} status", (Object)moduleIdent, (Object)locomotiveAddress);
            ClientManager.getInstance().registerLocoIfNeeded(clientAddress, locomotiveAddress);
            return ClientManager.getInstance().getLocoStatusMessage(clientAddress, locomotiveAddress);
        }
        log.debug("{} Header E3 with function {} is not supported", (Object)moduleIdent, (Object)Integer.toHexString(db0));
        return null;
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Messages can be of any length, null is used to indicate absence of message for caller")
    private static byte[] handleHeaderE4(byte[] data, InetAddress clientAddress) {
        if (data[0] == 19) {
            int locomotiveAddress = ((data[1] & 0xFF & 0x3F) << 8) + (data[2] & 0xFF);
            int rawSpeedData = data[3] & 0xFF;
            boolean bForward = (rawSpeedData & 0x80) >> 7 == 1;
            int actualSpeed = rawSpeedData & 0x7F;
            log.debug("Set loco no {} direction {} with speed {}", new Object[]{locomotiveAddress, bForward ? "FWD" : "RWD", actualSpeed});
            ClientManager.getInstance().setLocoSpeedAndDirection(clientAddress, locomotiveAddress, actualSpeed, bForward);
        } else if (data[0] == -8) {
            int locomotiveAddress = ((data[1] & 0xFF & 0x3F) << 8) + (data[2] & 0xFF);
            int functionSwitchType = (data[3] & 0xFF & 0xC0) >> 6;
            int functionNumber = data[3] & 0xFF & 0x3F;
            if (log.isDebugEnabled()) {
                String cmd;
                String string = cmd = (functionSwitchType & 1) == 1 ? "ON" : "OFF";
                if ((functionSwitchType & 3) == 2) {
                    cmd = "TOGGLE";
                }
                log.debug("Set loco no {} function no {}: {}", new Object[]{locomotiveAddress, functionNumber, cmd});
            }
            ClientManager.getInstance().setLocoFunction(clientAddress, locomotiveAddress, functionNumber, functionSwitchType);
        }
        return null;
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Messages can be of any length, null is used to indicate absence of message for caller")
    private static byte[] handleHeader43(byte[] data, InetAddress clientAddress) {
        int turnoutNumber = ((data[0] & 0xFF) << 8) + (data[1] & 0xFF);
        log.debug("{} Get turnout no {} status", (Object)moduleIdent, (Object)turnoutNumber);
        return ClientManager.getInstance().getTurnoutStatusMessage(clientAddress, turnoutNumber);
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Messages can be of any length, null is used to indicate absence of message for caller")
    private static byte[] handleHeader53(byte[] data, InetAddress clientAddress) {
        int turnoutNumber = ((data[0] & 0xFF) << 8) + (data[1] & 0xFF);
        log.debug("{} Set turnout no {} to state {}", new Object[]{moduleIdent, turnoutNumber, data[2] & 0xFF});
        if ((data[2] & 8) == 8) {
            ClientManager.getInstance().setTurnout(clientAddress, turnoutNumber, (data[2] & 1) == 0);
        }
        return ClientManager.getInstance().getTurnoutStatusMessage(clientAddress, turnoutNumber);
    }

    private static byte[] handleHeader80() {
        byte[] stoppedPacket;
        log.info("{} Stop all locos", (Object)moduleIdent);
        Iterator<ThrottleFrame> tpi = InstanceManager.getDefault(ThrottleFrameManager.class).getThrottlesListPanel().getTableModel().iterator();
        while (tpi.hasNext()) {
            DccThrottle t = tpi.next().getAddressPanel().getThrottle();
            if (t == null) continue;
            t.setSpeedSetting(-1.0f);
        }
        stoppedPacket = new byte[]{7, 0, 64, 0, -127, 0, ClientManager.xor(stoppedPacket)};
        return stoppedPacket;
    }

    private static byte[] handleHeaderF1() {
        byte[] fwVersionPacket;
        log.info("{} Get Firmware Version", (Object)moduleIdent);
        fwVersionPacket = new byte[]{9, 0, 64, 0, -13, 10, 1, 67, ClientManager.xor(fwVersionPacket)};
        return fwVersionPacket;
    }
}

