/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.z21server;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Light;
import jmri.LightManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Route;
import jmri.RouteManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutNumberMapHandler
implements PropertyChangeListener {
    private static TurnoutNumberMapHandler instance;
    public static final String beanProperty = "Z21TurnoutMap";
    private static final Class<?>[] mgrList;
    private final Map<Integer, NamedBean> turnoutNumberList = new HashMap<Integer, NamedBean>();
    private static final Logger log;

    private TurnoutNumberMapHandler() {
    }

    public static synchronized TurnoutNumberMapHandler getInstance() {
        if (instance == null) {
            instance = new TurnoutNumberMapHandler();
            instance.loadNumberList();
            instance.addPropertyChangeListeners();
        }
        return instance;
    }

    public static Class<?>[] getManagerClassList() {
        return mgrList;
    }

    public int getStateForNumber(int turnoutNumber) {
        int state = -1;
        NamedBean b = this.turnoutNumberList.get(turnoutNumber);
        if (b != null) {
            SignalMast s;
            Light l;
            log.debug("Turnout number {} is {} - {}", new Object[]{turnoutNumber, b.getSystemName(), b.getUserName()});
            log.trace("  class: {}", (Object)b.getClass().getName());
            state = b instanceof Route ? 2 : (b instanceof Light ? ((l = (Light)b).getState() == 2 ? 4 : 2) : (b instanceof SignalMast ? ((s = (SignalMast)b).getHeld() ? 2 : 4) : (b instanceof SignalHead ? ((s = (SignalHead)b).getHeld() ? 2 : 4) : (b instanceof Sensor ? ((s = (Sensor)b).getKnownState() == 2 ? 4 : 2) : b.getState()))));
        }
        log.debug("state for number {} is {}", (Object)turnoutNumber, (Object)state);
        return state;
    }

    public void setStateForNumber(int turnoutNumber, int state) {
        NamedBean b = this.turnoutNumberList.get(turnoutNumber);
        if (b != null) {
            log.debug("Turnout number {} is {} - {}", new Object[]{turnoutNumber, b.getSystemName(), b.getUserName()});
            if (b instanceof Turnout) {
                Turnout t = (Turnout)b;
                t.setCommandedState(state);
            } else if (b instanceof Route) {
                Route r = (Route)b;
                if (state == 4) {
                    r.setRoute();
                }
            } else if (b instanceof Light) {
                Light l = (Light)b;
                l.setState(state == 4 ? 2 : 4);
            } else if (b instanceof SignalMast) {
                SignalMast s = (SignalMast)b;
                s.setHeld(state == 2);
            } else if (b instanceof SignalHead) {
                SignalHead s = (SignalHead)b;
                s.setHeld(state == 2);
            } else if (b instanceof Sensor) {
                Sensor s = (Sensor)b;
                try {
                    s.setKnownState(state == 4 ? 2 : 4);
                }
                catch (JmriException e) {
                    log.warn("Sensor not set");
                }
            }
        }
    }

    public void loadNumberList() {
        this.turnoutNumberList.clear();
        for (Class<?> clazz : mgrList) {
            this.loadNumberTable(clazz);
        }
    }

    private <T extends NamedBean> void loadNumberTable(Class<?> clazz) {
        Pattern pattern = Pattern.compile("^(\\d+)$");
        Manager mgr = (Manager)InstanceManager.getNullableDefault(clazz);
        if (mgr != null) {
            log.trace("mgr: {} {}", (Object)mgr, (Object)mgr.getClass().getName());
            for (NamedBean t : mgr.getNamedBeanSet()) {
                String val;
                Matcher matcher;
                Object o = t.getProperty(beanProperty);
                if (o == null || !(matcher = pattern.matcher(val = o.toString())).matches() || matcher.group(0) == null) continue;
                int num = Integer.parseInt(matcher.group(0));
                log.debug("Found number {}: {} - {}", new Object[]{num, t.getSystemName(), t.getUserName()});
                this.turnoutNumberList.put(num, t);
            }
        }
    }

    private void addPropertyChangeListeners() {
        for (Class<?> clazz : mgrList) {
            Manager mgr = (Manager)InstanceManager.getNullableDefault(clazz);
            if (mgr == null) continue;
            mgr.addPropertyChangeListener(instance);
        }
    }

    private void removePropertyChangeListeners() {
        for (Class<?> clazz : mgrList) {
            Manager mgr = (Manager)InstanceManager.getNullableDefault(clazz);
            if (mgr == null) continue;
            mgr.removePropertyChangeListener(instance);
        }
    }

    public void dispose() {
        this.removePropertyChangeListeners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.trace("property changed: {}", (Object)e.getPropertyName());
        this.loadNumberList();
    }

    static {
        mgrList = new Class[]{TurnoutManager.class, RouteManager.class, LightManager.class, SignalMastManager.class, SignalHeadManager.class, SensorManager.class};
        log = LoggerFactory.getLogger(TurnoutNumberMapHandler.class);
    }
}

