/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.z21server;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import jmri.jmrit.throttle.LargePowerManagerButton;
import jmri.jmrit.throttle.StopAllButton;
import jmri.jmrit.z21server.Bundle;
import jmri.jmrit.z21server.ClientManager;
import jmri.jmrit.z21server.FacelessServer;
import jmri.jmrit.z21server.NumberMapAction;
import jmri.jmrit.z21server.Z21ClientsListModel;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserInterface
extends JmriJFrame
implements PropertyChangeListener {
    JMenuBar menuBar;
    JMenuItem serverOnOff;
    JPanel panel;
    JLabel portLabel = new JLabel(Bundle.getMessage("LabelPending"));
    JLabel manualPortLabel = new JLabel();
    JLabel numConnected;
    JScrollPane scrollTable;
    JTable z21ClientsList;
    Z21ClientsListModel z21ClientsListModel;
    private FacelessServer facelessServer = FacelessServer.getInstance();
    boolean isListen = true;
    private static final Logger log = LoggerFactory.getLogger(UserInterface.class);

    UserInterface() {
        super(true, true);
        ClientManager.getInstance().setClientListener(this);
        this.addIPAddressesToUI();
        this.createWindow();
    }

    private void addIPAddressesToUI() {
        int port = 21105;
        StringBuilder as = new StringBuilder();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    String hostAddress = inetAddress.getHostAddress();
                    if (hostAddress.equals("0.0.0.0") || hostAddress.regionMatches(0, "127", 0, 3) || hostAddress.contains(":")) continue;
                    this.portLabel.setText(inetAddress.getHostName());
                    as.append(hostAddress).append(":").append(port).append("<br/>");
                }
            }
            this.manualPortLabel.setText("<html>" + as + "</html>");
        }
        catch (SocketException ex) {
            log.warn("Unable to enumerate Network Interfaces: {}", (Object)ex.getMessage());
        }
    }

    protected void createWindow() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints con = new GridBagConstraints();
        this.getContentPane().add(this.panel);
        con.fill = 0;
        con.weightx = 0.5;
        con.weighty = 0.0;
        JLabel label = new JLabel(Bundle.getMessage("LabelListening"));
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 2;
        this.panel.add((Component)label, con);
        con.gridx = 0;
        con.gridy = 1;
        con.gridwidth = 2;
        this.panel.add((Component)this.portLabel, con);
        con.gridy = 2;
        this.panel.add((Component)this.manualPortLabel, con);
        this.numConnected = new JLabel(Bundle.getMessage("LabelClients") + " " + ClientManager.getInstance().getRegisteredClients().size());
        con.weightx = 0.0;
        con.gridx = 2;
        con.gridy = 2;
        con.ipadx = 5;
        con.gridwidth = 1;
        this.panel.add((Component)this.numConnected, con);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(new StopAllButton());
        toolBar.add(new LargePowerManagerButton());
        con.weightx = 0.5;
        con.ipadx = 0;
        con.gridx = 1;
        con.gridy = 3;
        con.gridwidth = 2;
        this.panel.add((Component)toolBar, con);
        URL imageURL = FileUtil.findURL("resources/z21appIcon.png");
        if (imageURL != null) {
            ImageIcon image = new ImageIcon(imageURL);
            image.setImage(image.getImage().getScaledInstance(32, 32, 1));
            JLabel icon = new JLabel(image);
            con.weightx = 0.5;
            con.gridx = 2;
            con.gridy = 0;
            con.ipady = 5;
            con.gridheight = 2;
            this.panel.add((Component)icon, con);
        }
        this.z21ClientsListModel = new Z21ClientsListModel();
        this.z21ClientsList = new JTable(this.z21ClientsListModel);
        this.z21ClientsList.setPreferredScrollableViewportSize(new Dimension(300, 80));
        this.z21ClientsList.setRowHeight(20);
        this.scrollTable = new JScrollPane(this.z21ClientsList);
        con.gridx = 0;
        con.gridy = 4;
        con.weighty = 1.0;
        con.ipadx = 10;
        con.ipady = 10;
        con.gridheight = 3;
        con.gridwidth = 0;
        con.fill = 1;
        this.panel.add((Component)this.scrollTable, con);
        this.buildMenu();
        this.setTitle("Z21 App Server");
        this.pack();
        this.setDefaultCloseOperation(1);
        this.setVisible(true);
        this.setMinimumSize(new Dimension(400, 100));
    }

    protected void buildMenu() {
        this.setJMenuBar(new JMenuBar());
        JMenu menu = new JMenu(Bundle.getMessage("MenuMenu"));
        this.serverOnOff = new JMenuItem(Bundle.getMessage("MenuMenuStop"));
        this.serverOnOff.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (UserInterface.this.isListen) {
                    UserInterface.this.disableServer();
                    UserInterface.this.serverOnOff.setText(Bundle.getMessage("MenuMenuStart"));
                    UserInterface.this.manualPortLabel.setText(null);
                } else {
                    UserInterface.this.enableServer();
                    UserInterface.this.serverOnOff.setText(Bundle.getMessage("MenuMenuStop"));
                    String host = "";
                    try {
                        host = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (Exception e) {
                        host = "unknown ip";
                    }
                    UserInterface.this.manualPortLabel.setText("<html>" + host + "</html>");
                }
            }
        });
        menu.add(this.serverOnOff);
        menu.add(new NumberMapAction());
        this.getJMenuBar().add(menu);
        this.addHelpMenu("package.jmri.jmrit.z21server.z21server", true);
    }

    public Z21ClientsListModel getThrottleList() {
        return this.z21ClientsListModel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        this.numConnected.setText(Bundle.getMessage("LabelClients") + " " + ClientManager.getInstance().getRegisteredClients().size());
        if (this.isListen) {
            this.addIPAddressesToUI();
        } else {
            this.portLabel.setText(Bundle.getMessage("LabelNone"));
            this.manualPortLabel.setText("");
        }
        this.z21ClientsListModel.updateClientList();
    }

    void disableServer() {
        this.facelessServer.stop();
        this.isListen = false;
        this.propertyChange(null);
        ClientManager.getInstance().handleExpiredClients(true);
    }

    private void enableServer() {
        this.facelessServer.start();
        this.isListen = true;
        this.propertyChange(null);
    }
}

