/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.z21server;

import java.net.InetAddress;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import jmri.jmrit.z21server.AppClient;
import jmri.jmrit.z21server.Bundle;
import jmri.jmrit.z21server.ClientManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21ClientsListModel
extends AbstractTableModel {
    ArrayList<InetAddress> addrList = new ArrayList<InetAddress>(ClientManager.getInstance().getRegisteredClients().keySet());
    private static final Logger log = LoggerFactory.getLogger(Z21ClientsListModel.class);

    Z21ClientsListModel() {
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return ClientManager.getInstance().getRegisteredClients().size();
    }

    @Override
    public String getColumnName(int col) {
        String title;
        switch (col) {
            case 0: {
                title = Bundle.getMessage("LabelDeviceName");
                break;
            }
            case 1: {
                title = Bundle.getMessage("LabelAddress");
                break;
            }
            case 2: {
                title = Bundle.getMessage("LabelRosterId");
                break;
            }
            default: {
                title = "";
            }
        }
        return title;
    }

    @Override
    public String getValueAt(int row, int col) {
        if (this.addrList.size() < 1) {
            return null;
        }
        if (row >= this.addrList.size()) {
            log.debug("row is greater than device list size");
            return null;
        }
        AppClient client = ClientManager.getInstance().getRegisteredClients().get(this.addrList.get(row));
        if (col == 0) {
            return this.addrList.get(row).toString();
        }
        if (col == 1) {
            return client != null && client.getActiveThrottle() != null ? client.getActiveThrottle().getLocoAddress().toString() : "";
        }
        return client != null && client.getActiveThrottle() != null ? client.getActiveRosterIdString() : "";
    }

    public void updateClientList() {
        this.addrList = new ArrayList<InetAddress>(ClientManager.getInstance().getRegisteredClients().keySet());
        this.fireTableDataChanged();
    }
}

