/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.jmrix.Bundle;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.jmrix.PortAdapter;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.ValidatedTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionConfig
implements ConnectionConfig {
    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Field used by implementing classes")
    protected int NUMOPTIONS = 2;
    protected JCheckBox showAdvanced = new JCheckBox(Bundle.getMessage("AdditionalConnectionSettings"));
    protected JLabel systemPrefixLabel = new JLabel(Bundle.getMessage("ConnectionPrefix"));
    protected JLabel connectionNameLabel = new JLabel(Bundle.getMessage("ConnectionName"));
    protected ValidatedTextField systemPrefixField;
    protected JTextField connectionNameField = new JTextField(15);
    protected JPanel _details = null;
    protected final Map<String, Option> options = new TreeMap<String, Option>();
    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Field used by implementing classes")
    protected ArrayList<JComponent> additionalItems = new ArrayList(0);
    protected GridBagLayout gbLayout = new GridBagLayout();
    protected GridBagConstraints cL = new GridBagConstraints();
    protected GridBagConstraints cR = new GridBagConstraints();
    private static final Logger log = LoggerFactory.getLogger(AbstractConnectionConfig.class);

    public AbstractConnectionConfig() {
        try {
            this.systemPrefixField = new ValidatedTextField((Integer)4, true, "[A-Za-z]\\d*", Bundle.getMessage("TipPrefixFormat"));
        }
        catch (PatternSyntaxException e) {
            log.error("Prefix unexpected parse exception during setup", (Throwable)e);
        }
    }

    protected abstract void checkInitDone();

    public abstract void updateAdapter();

    @Override
    public boolean isDirty() {
        return this.getAdapter() == null || this.getAdapter().isDirty();
    }

    @Override
    public boolean isRestartRequired() {
        return this.getAdapter() == null || this.getAdapter().isRestartRequired();
    }

    protected abstract void setInstance();

    @Override
    public abstract String getInfo();

    @Override
    public abstract void loadDetails(JPanel var1);

    protected abstract void showAdvancedItems();

    protected int addStandardDetails(PortAdapter adapter, boolean incAdvanced, int i) {
        for (Map.Entry<String, Option> entry : this.options.entrySet()) {
            if (entry.getValue().isAdvanced().booleanValue()) continue;
            this.cR.gridy = i;
            this.cL.gridy = i++;
            this.gbLayout.setConstraints(entry.getValue().getLabel(), this.cL);
            this.gbLayout.setConstraints(entry.getValue().getComponent(), this.cR);
            this._details.add(entry.getValue().getLabel());
            this._details.add(entry.getValue().getComponent());
        }
        if (adapter.getSystemConnectionMemo() != null) {
            this.cR.gridy = i;
            this.cL.gridy = i++;
            this.gbLayout.setConstraints(this.systemPrefixLabel, this.cL);
            this.gbLayout.setConstraints(this.systemPrefixField, this.cR);
            this.systemPrefixLabel.setLabelFor(this.systemPrefixField);
            this._details.add(this.systemPrefixLabel);
            this._details.add(this.systemPrefixField);
            this.systemPrefixField.setToolTipText(Bundle.getMessage("TipPrefixFormat"));
            this.cR.gridy = i;
            this.cL.gridy = i++;
            this.gbLayout.setConstraints(this.connectionNameLabel, this.cL);
            this.gbLayout.setConstraints(this.connectionNameField, this.cR);
            this.connectionNameLabel.setLabelFor(this.connectionNameField);
            this._details.add(this.connectionNameLabel);
            this._details.add(this.connectionNameField);
        }
        if (incAdvanced) {
            this.cL.gridwidth = 2;
            this.cL.gridy = i;
            this.cR.gridy = i++;
            this.gbLayout.setConstraints(this.showAdvanced, this.cL);
            this._details.add(this.showAdvanced);
            this.cL.gridwidth = 1;
        }
        return i;
    }

    @Override
    public abstract String getManufacturer();

    @Override
    public abstract void setManufacturer(String var1);

    @Override
    public abstract String getConnectionName();

    @Override
    public abstract boolean getDisabled();

    @Override
    public abstract void setDisabled(boolean var1);

    @Override
    public void register() {
        this.setInstance();
        InstanceManager.getDefault(ConfigureManager.class).registerPref(this);
        ConnectionConfigManager ccm = InstanceManager.getNullableDefault(ConnectionConfigManager.class);
        if (ccm != null) {
            ccm.add(this);
        }
    }

    @Override
    public void dispose() {
        ConnectionConfigManager ccm = InstanceManager.getNullableDefault(ConnectionConfigManager.class);
        if (ccm != null) {
            ccm.remove(this);
        }
    }

    protected void addNameEntryCheckers(final @Nonnull PortAdapter adapter) {
        if (adapter.getSystemConnectionMemo() != null) {
            this.systemPrefixField.addActionListener(e -> this.checkPrefixEntry(adapter));
            this.systemPrefixField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    AbstractConnectionConfig.this.checkPrefixEntry(adapter);
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.connectionNameField.addActionListener(e -> this.checkNameEntry(adapter));
            this.connectionNameField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    AbstractConnectionConfig.this.checkNameEntry(adapter);
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        }
    }

    private void checkPrefixEntry(@Nonnull PortAdapter adapter) {
        if (!this.systemPrefixField.isValid()) {
            this.systemPrefixField.setText(adapter.getSystemConnectionMemo().getSystemPrefix());
        }
        if (!adapter.getSystemConnectionMemo().setSystemPrefix(this.systemPrefixField.getText())) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ConnectionPrefixDialog", this.systemPrefixField.getText()));
            this.systemPrefixField.setText(adapter.getSystemConnectionMemo().getSystemPrefix());
        }
    }

    private void checkNameEntry(@Nonnull PortAdapter adapter) {
        if (!adapter.getSystemConnectionMemo().setUserName(this.connectionNameField.getText())) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ConnectionNameDialog", this.connectionNameField.getText()));
            this.connectionNameField.setText(adapter.getSystemConnectionMemo().getUserName());
        }
    }

    protected static class Option {
        String optionDisplayName;
        JComponent optionSelection;
        Boolean advanced;
        JLabel label = null;

        public Option(String name, JComponent optionSelection, Boolean advanced) {
            this.optionDisplayName = name;
            this.optionSelection = optionSelection;
            this.advanced = advanced;
        }

        protected String getDisplayName() {
            return this.optionDisplayName;
        }

        public JLabel getLabel() {
            if (this.label == null) {
                this.label = new JLabel(this.getDisplayName(), 2);
            }
            return this.label;
        }

        public JComponent getComponent() {
            return this.optionSelection;
        }

        protected Boolean isAdvanced() {
            return this.advanced;
        }

        protected void setAdvanced(Boolean boo) {
            this.advanced = boo;
        }

        public String getItem() {
            if (this.optionSelection instanceof JComboBox) {
                return (String)((JComboBox)this.optionSelection).getSelectedItem();
            }
            if (this.optionSelection instanceof JTextField) {
                return ((JTextField)this.optionSelection).getText();
            }
            return null;
        }
    }
}

