/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.jmrit.MemoryContents;
import jmri.jmrix.Bundle;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WrapLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoaderPane
extends JmriPanel
implements ActionListener {
    JLabel inputFileName = new JLabel("");
    protected JButton selectButton;
    protected JButton loadButton;
    protected JButton verifyButton;
    protected JButton abortButton;
    JRadioButton address24bit = new JRadioButton(Bundle.getMessage("Button24bit"));
    JRadioButton address16bit = new JRadioButton(Bundle.getMessage("Button16bit"));
    protected ButtonGroup addressSizeButtonGroup = new ButtonGroup();
    protected JProgressBar bar;
    protected JLabel status = new JLabel("");
    JPanel inputFileNamePanel;
    protected MemoryContents inputContent = new MemoryContents();
    private int inputFileLabelWidth;
    private static JFileChooser chooser;
    protected boolean abortOperation;
    private static final Logger log;

    @Override
    public abstract String getHelpTarget();

    protected void addOptionsPanel() {
    }

    @Override
    public void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.inputFileNamePanel = new JPanel();
        this.inputFileNamePanel.setLayout(new WrapLayout());
        JLabel l = new JLabel(Bundle.getMessage("LabelInpFile"));
        this.inputFileLabelWidth = l.getMinimumSize().width;
        l.setAlignmentX(0.5f);
        this.inputFileNamePanel.add(l);
        this.inputFileNamePanel.add(new Box.Filler(new Dimension(5, 20), new Dimension(5, 20), new Dimension(5, 20)));
        this.inputFileNamePanel.add(this.inputFileName);
        this.selectButton = new JButton(Bundle.getMessage("ButtonSelect"));
        this.selectButton.addActionListener(e -> {
            this.inputContent = new MemoryContents();
            this.setDefaultFieldValues();
            this.updateDownloadVerifyButtons();
            this.selectInputFile();
            this.doRead(chooser);
        });
        this.inputFileNamePanel.add(this.selectButton);
        this.add(this.inputFileNamePanel);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JLabel l2 = new JLabel(Bundle.getMessage("LabelBitMode") + " ");
        l2.setEnabled(false);
        p.add(l2);
        p.add(this.address16bit);
        p.add(this.address24bit);
        this.addressSizeButtonGroup.add(this.address16bit);
        this.addressSizeButtonGroup.add(this.address24bit);
        this.addressSizeButtonGroup.clearSelection();
        this.address16bit.setEnabled(false);
        this.address24bit.setEnabled(false);
        this.add(p);
        this.setDefaultFieldValues();
        this.add(new JSeparator());
        this.addOptionsPanel();
        p = new JPanel();
        p.setLayout(new WrapLayout());
        this.loadButton = new JButton(Bundle.getMessage("ButtonDownload"));
        this.loadButton.setEnabled(false);
        this.loadButton.setToolTipText(Bundle.getMessage("TipLoadDisabled"));
        p.add(this.loadButton);
        this.loadButton.addActionListener(e -> this.doLoad());
        this.verifyButton = new JButton(Bundle.getMessage("ButtonVerify"));
        this.verifyButton.setEnabled(false);
        this.verifyButton.setToolTipText(Bundle.getMessage("TipVerifyDisabled"));
        p.add(this.verifyButton);
        this.verifyButton.addActionListener(e -> this.doVerify());
        this.add(p);
        this.abortButton = new JButton(Bundle.getMessage("ButtonAbort"));
        this.abortButton.setEnabled(false);
        this.abortButton.setToolTipText(Bundle.getMessage("TipAbortDisabled"));
        p.add(this.abortButton);
        this.abortButton.addActionListener(e -> this.setOperationAborted(true));
        this.add(p);
        this.add(new JSeparator());
        this.bar = new JProgressBar(0, 100);
        this.bar.setStringPainted(true);
        this.add(this.bar);
        this.add(new JSeparator());
        p = new JPanel();
        p.setLayout(new WrapLayout());
        this.status.setText(Bundle.getMessage("StatusSelectFile"));
        this.status.setAlignmentX(0.0f);
        this.status.setFont(this.status.getFont().deriveFont(0.9f * (float)this.inputFileName.getFont().getSize()));
        this.status.setForeground(Color.gray);
        p.add(this.status);
        this.add(p);
    }

    protected void addChooserFilters(JFileChooser chooser) {
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Intel Hex Format Firmware (*.hex)", "hex");
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
    }

    private void selectInputFile() {
        String name = this.inputFileName.getText();
        if (name.equals("")) {
            name = FileUtil.getUserFilesPath();
        }
        if (chooser == null) {
            chooser = new JmriJFileChooser(name);
            this.addChooserFilters(chooser);
        }
        this.inputFileName.setText("");
        int retVal = chooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        String newFileName = chooser.getSelectedFile().getName();
        this.inputFileName.setText(newFileName);
        double currentStringWidth = this.inputFileName.getMinimumSize().width;
        this.inputFileName.setToolTipText(newFileName);
        double allowedWidth = this.inputFileNamePanel.getSize().width * 4 / 5 - this.inputFileLabelWidth;
        if (currentStringWidth > allowedWidth) {
            double startPoint = (double)this.inputFileName.getText().length() * (1.0 - allowedWidth / currentStringWidth);
            String displayableName = "..." + this.inputFileName.getText().substring((int)startPoint);
            log.info("Shortening display of filename {} to {}", (Object)this.inputFileName.getText(), (Object)displayableName);
            log.debug("Width required to display the full file name = {}", (Object)currentStringWidth);
            log.debug("Allowed width = {}", (Object)allowedWidth);
            log.debug("Amount of text not displayed = {}", (Object)startPoint);
            this.inputFileName.setText(displayableName);
        }
        this.inputFileName.updateUI();
        this.inputFileNamePanel.updateUI();
        this.updateUI();
        this.loadButton.setEnabled(false);
        this.loadButton.setToolTipText(Bundle.getMessage("TipLoadDisabled"));
        this.verifyButton.setEnabled(false);
        this.verifyButton.setToolTipText(Bundle.getMessage("TipVerifyDisabled"));
        this.status.setText(Bundle.getMessage("StatusDoDownload"));
    }

    protected void handleOptionsInFileContent(MemoryContents inputContent) {
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="Passing I18N exception text through to log")
    protected void doRead(JFileChooser chooser) {
        if (this.inputFileName.getText().equals("")) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorNoInputFile"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.loadButton.setEnabled(false);
        this.loadButton.setToolTipText(Bundle.getMessage("TipLoadDisabled"));
        this.verifyButton.setEnabled(false);
        this.verifyButton.setToolTipText(Bundle.getMessage("TipVerifyDisabled"));
        this.abortButton.setEnabled(false);
        this.abortButton.setToolTipText(Bundle.getMessage("TipAbortDisabled"));
        this.inputContent = new MemoryContents();
        this.bar.setValue(0);
        try {
            this.inputContent.readHex(new File(chooser.getSelectedFile().getPath()));
        }
        catch (FileNotFoundException f) {
            log.error(f.getLocalizedMessage());
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorFileNotFound"), Bundle.getMessage("ErrorTitle"), 0);
            this.status.setText(Bundle.getMessage("StatusFileNotFound"));
            this.disableDownloadVerifyButtons();
            return;
        }
        catch (MemoryContents.MemoryFileAddressingRangeException | MemoryContents.MemoryFileChecksumException | MemoryContents.MemoryFileNoDataRecordsException | MemoryContents.MemoryFileNoEOFRecordException | MemoryContents.MemoryFileRecordContentException | MemoryContents.MemoryFileRecordFoundAfterEOFRecord | MemoryContents.MemoryFileRecordLengthException | MemoryContents.MemoryFileUnknownRecordType f) {
            log.error(f.getLocalizedMessage());
            this.status.setText(Bundle.getMessage("ErrorFileContentsError"));
            this.disableDownloadVerifyButtons();
            return;
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage());
            this.status.setText(Bundle.getMessage("ErrorFileReadError"));
            this.disableDownloadVerifyButtons();
            return;
        }
        log.debug("Read complete: {}", (Object)this.inputContent.toString());
        this.loadButton.setEnabled(true);
        this.loadButton.setToolTipText(Bundle.getMessage("TipLoadEnabled"));
        this.verifyButton.setEnabled(true);
        this.verifyButton.setToolTipText(Bundle.getMessage("TipVerifyEnabled"));
        this.status.setText(Bundle.getMessage("StatusDoDownload"));
        this.handleOptionsInFileContent(this.inputContent);
        MemoryContents.LoadOffsetFieldType addresstype = this.inputContent.getCurrentAddressFormat();
        if (addresstype == MemoryContents.LoadOffsetFieldType.ADDRESSFIELDSIZE16BITS) {
            this.address16bit.setSelected(true);
            this.address24bit.setSelected(false);
        } else if (addresstype == MemoryContents.LoadOffsetFieldType.ADDRESSFIELDSIZE24BITS) {
            this.address16bit.setSelected(false);
            this.address24bit.setSelected(true);
        }
        if (!this.parametersAreValid()) {
            this.status.setText(Bundle.getMessage("ErrorInvalidParameter"));
            this.disableDownloadVerifyButtons();
        } else if (!this.inputContent.isEmpty()) {
            this.enableDownloadVerifyButtons();
        }
    }

    protected void doLoad() {
        this.status.setText(Bundle.getMessage("StatusDownloading"));
        this.loadButton.setEnabled(false);
        this.loadButton.setToolTipText(Bundle.getMessage("TipDisabledDownload"));
        this.verifyButton.setEnabled(false);
        this.verifyButton.setToolTipText(Bundle.getMessage("TipDisabledDownload"));
        this.abortButton.setEnabled(true);
        this.abortButton.setToolTipText(Bundle.getMessage("TipAbortEnabled"));
        this.selectButton.setEnabled(false);
    }

    protected void doVerify() {
        this.status.setText(Bundle.getMessage("StatusVerifying"));
        this.loadButton.setEnabled(false);
        this.loadButton.setToolTipText(Bundle.getMessage("TipDisabledDownload"));
        this.verifyButton.setEnabled(false);
        this.verifyButton.setToolTipText(Bundle.getMessage("TipDisabledDownload"));
        this.abortButton.setEnabled(true);
        this.abortButton.setToolTipText(Bundle.getMessage("TipAbortEnabled"));
        this.selectButton.setEnabled(false);
    }

    protected void enableDownloadVerifyButtons() {
        log.debug("enableGUI");
        if (this.isOperationAborted()) {
            this.status.setText(Bundle.getMessage("StatusAbort"));
        } else {
            this.status.setText(Bundle.getMessage("StatusDone"));
        }
        this.setOperationAborted(false);
        this.loadButton.setEnabled(true);
        this.loadButton.setToolTipText(Bundle.getMessage("TipLoadEnabled"));
        this.verifyButton.setEnabled(true);
        this.verifyButton.setToolTipText(Bundle.getMessage("TipVerifyEnabled"));
        this.abortButton.setEnabled(false);
        this.abortButton.setToolTipText(Bundle.getMessage("TipAbortDisabled"));
        this.selectButton.setEnabled(true);
    }

    protected void disableDownloadVerifyButtons() {
        log.debug("disableGUI");
        this.setOperationAborted(false);
        this.loadButton.setEnabled(false);
        this.loadButton.setToolTipText(Bundle.getMessage("TipLoadDisabled"));
        this.verifyButton.setEnabled(false);
        this.verifyButton.setToolTipText(Bundle.getMessage("TipVerifyDisabled"));
        this.abortButton.setEnabled(false);
        this.abortButton.setToolTipText(Bundle.getMessage("TipAbortDisabled"));
        this.selectButton.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOperationAborted(boolean state) {
        AbstractLoaderPane abstractLoaderPane = this;
        synchronized (abstractLoaderPane) {
            this.abortOperation = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isOperationAborted() {
        AbstractLoaderPane abstractLoaderPane = this;
        synchronized (abstractLoaderPane) {
            return this.abortOperation;
        }
    }

    protected void setDefaultFieldValues() {
    }

    protected boolean parametersAreValid() {
        return true;
    }

    protected boolean intParameterIsValid(JTextField jtf, int minOk, int maxOk) {
        boolean allIsOk = true;
        jtf.setForeground(Color.black);
        String text = jtf.getText();
        if (text.equals("")) {
            jtf.setText("0");
            jtf.setForeground(Color.red);
            allIsOk = false;
        } else {
            int junk;
            try {
                junk = Integer.parseInt(text);
            }
            catch (NumberFormatException ex) {
                junk = -1;
            }
            if (junk < minOk || junk > maxOk) {
                jtf.setForeground(Color.red);
                allIsOk = false;
            } else {
                jtf.setForeground(Color.black);
            }
        }
        jtf.updateUI();
        return allIsOk;
    }

    protected void updateDownloadVerifyButtons() {
        if (this.parametersAreValid() && !this.inputContent.isEmpty()) {
            this.enableDownloadVerifyButtons();
        } else {
            this.disableDownloadVerifyButtons();
        }
    }

    public void clearInputFileName() {
        this.inputFileName.setText("");
        this.inputFileName.setToolTipText("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateDownloadVerifyButtons();
        log.info("ActionListener");
    }

    static {
        log = LoggerFactory.getLogger(AbstractLoaderPane.class);
    }
}

