/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.util.Objects;
import javax.annotation.Nonnull;
import jmri.jmrix.AbstractMessage;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMRMessage
extends AbstractMessage {
    private int mNeededMode;
    private boolean _isBinary;
    protected static final int SHORT_TIMEOUT = 2000;
    protected static final int LONG_TIMEOUT = 60000;
    private int mTimeout;
    private int mRetries = 0;
    private static final Logger log = LoggerFactory.getLogger(AbstractMRMessage.class);

    public AbstractMRMessage() {
        this.setBinary(false);
        this.setNeededMode(1);
        this.setTimeout(2000);
        this.setRetries(0);
    }

    public AbstractMRMessage(int i) {
        this();
        if (i < 1) {
            log.error("invalid length {} in call to ctor", (Object)i);
            throw new IllegalArgumentException("invalid length in call to ctor");
        }
        this._nDataChars = i;
        this._dataChars = new int[i];
    }

    public AbstractMRMessage(@Nonnull AbstractMRMessage m) {
        this();
        Objects.requireNonNull(m, "copy ctor of null message");
        this._nDataChars = m._nDataChars;
        this._dataChars = new int[this._nDataChars];
        System.arraycopy(m._dataChars, 0, this._dataChars, 0, this._nDataChars);
        this.setTimeout(m.getTimeout());
        this.setRetries(m.getRetries());
        this.setNeededMode(m.getNeededMode());
    }

    public AbstractMRMessage(String s) {
        this(s.length());
        for (int i = 0; i < this._nDataChars; ++i) {
            this._dataChars[i] = s.charAt(i);
        }
    }

    public void setOpCode(int i) {
        this._dataChars[0] = i;
    }

    public int getOpCode() {
        try {
            return this._dataChars[0];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0;
        }
    }

    public String getOpCodeHex() {
        return "0x" + Integer.toHexString(this.getOpCode());
    }

    public final void setNeededMode(int pMode) {
        this.mNeededMode = pMode;
    }

    public final int getNeededMode() {
        return this.mNeededMode;
    }

    public boolean replyExpected() {
        return true;
    }

    public final boolean isBinary() {
        return this._isBinary;
    }

    public final void setBinary(boolean b) {
        this._isBinary = b;
    }

    public final void setTimeout(int t) {
        this.mTimeout = t;
    }

    public final int getTimeout() {
        return this.mTimeout;
    }

    public final void setRetries(int i) {
        this.mRetries = i;
    }

    public final int getRetries() {
        return this.mRetries;
    }

    public void addIntAsThree(int val, int offset) {
        String s = "" + val;
        if (s.length() != 3) {
            s = "0" + s;
        }
        if (s.length() != 3) {
            s = "0" + s;
        }
        this.setElement(offset, s.charAt(0));
        this.setElement(offset + 1, s.charAt(1));
        this.setElement(offset + 2, s.charAt(2));
    }

    public void addIntAsTwoHex(int val, int offset) {
        Object s = Integer.toHexString(val).toUpperCase();
        if (((String)s).length() < 2) {
            s = "0" + (String)s;
        }
        if (((String)s).length() > 2) {
            log.error("can't add as two hex digits: {}", s);
        }
        this.setElement(offset, ((String)s).charAt(0));
        this.setElement(offset + 1, ((String)s).charAt(1));
    }

    public void addIntAsThreeHex(int val, int offset) {
        Object s = Integer.toHexString(val).toUpperCase();
        if (((String)s).length() > 3) {
            log.error("can't add as three hex digits: {}", s);
        }
        if (((String)s).length() != 3) {
            s = "0" + (String)s;
        }
        if (((String)s).length() != 3) {
            s = "0" + (String)s;
        }
        this.setElement(offset, ((String)s).charAt(0));
        this.setElement(offset + 1, ((String)s).charAt(1));
        this.setElement(offset + 2, ((String)s).charAt(2));
    }

    public void addIntAsFourHex(int val, int offset) {
        Object s = Integer.toHexString(val).toUpperCase();
        if (((String)s).length() > 4) {
            log.error("can't add as three hex digits: {}", s);
        }
        if (((String)s).length() != 4) {
            s = "0" + (String)s;
        }
        if (((String)s).length() != 4) {
            s = "0" + (String)s;
        }
        if (((String)s).length() != 4) {
            s = "0" + (String)s;
        }
        this.setElement(offset, ((String)s).charAt(0));
        this.setElement(offset + 1, ((String)s).charAt(1));
        this.setElement(offset + 2, ((String)s).charAt(2));
        this.setElement(offset + 3, ((String)s).charAt(3));
    }

    @Override
    public String toString() {
        Object s = "";
        for (int i = 0; i < this._nDataChars; ++i) {
            if (this._isBinary) {
                if (i != 0) {
                    s = (String)s + " ";
                }
                s = StringUtil.appendTwoHexFromInt(this._dataChars[i] & 0xFF, (String)s);
                continue;
            }
            s = (String)s + (char)this._dataChars[i];
        }
        return s;
    }
}

