/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.AbstractNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMRNodeTrafficController
extends AbstractMRTrafficController {
    protected int minNode = -1;
    protected int maxNode = -1;
    protected volatile int numNodes = 0;
    protected AbstractNode[] nodeArray;
    private boolean[] mustInit;
    protected int curSerialNodeIndex = 0;
    private static final Logger log = LoggerFactory.getLogger(AbstractMRNodeTrafficController.class);

    protected void init(int minNode, int maxNode) {
        this.minNode = minNode;
        this.maxNode = maxNode;
        this.nodeArray = new AbstractNode[this.maxNode + 1];
        this.mustInit = new boolean[this.maxNode + 1];
        for (int i = 0; i <= this.maxNode; ++i) {
            this.mustInit[i] = true;
        }
    }

    protected boolean getMustInit(int i) {
        return this.mustInit[i];
    }

    protected void setMustInit(int i, boolean v) {
        this.mustInit[i] = v;
    }

    protected void setMustInit(AbstractNode node, boolean v) {
        for (int i = 0; i < this.numNodes; ++i) {
            if (this.nodeArray[i] != node) continue;
            this.mustInit[i] = v;
            return;
        }
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Method itself is synchronized to protect numNodes")
    public void registerNode(AbstractNode node) {
        AbstractMRNodeTrafficController abstractMRNodeTrafficController = this;
        synchronized (abstractMRNodeTrafficController) {
            this.nodeArray[this.numNodes] = node;
            this.mustInit[this.numNodes] = true;
            ++this.numNodes;
        }
    }

    public synchronized AbstractNode getNode(int index) {
        if (index >= this.numNodes) {
            return null;
        }
        return this.nodeArray[index];
    }

    public synchronized AbstractNode getNodeFromAddress(int addr) {
        for (int i = 0; i < this.numNodes; ++i) {
            if (this.getNode(i).getNodeAddress() != addr) continue;
            return this.getNode(i);
        }
        return null;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Method itself is synchronized to protect numNodes")
    public synchronized void deleteNode(int nodeAddress) {
        int index = 0;
        for (int i = 0; i < this.numNodes; ++i) {
            if (this.nodeArray[i].getNodeAddress() != nodeAddress) continue;
            index = i;
        }
        if (index == this.curSerialNodeIndex) {
            log.warn("Deleting the serial node active in the polling loop");
        }
        --this.numNodes;
        if (index < this.numNodes) {
            for (int j = index; j < this.numNodes; ++j) {
                this.nodeArray[j] = this.nodeArray[j + 1];
            }
        }
        this.nodeArray[this.numNodes] = null;
    }
}

