/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.Bundle;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.TextAreaFIFO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMonFrame
extends JmriJFrame {
    protected JButton clearButton = new JButton(Bundle.getMessage("ButtonClearScreen"));
    protected JToggleButton freezeButton = new JToggleButton(Bundle.getMessage("ButtonFreezeScreen"));
    protected JScrollPane jScrollPane1 = new JScrollPane();
    protected TextAreaFIFO monTextPane = new TextAreaFIFO(MAX_LINES);
    protected JButton startLogButton = new JButton(Bundle.getMessage("ButtonStartLogging"));
    protected JButton stopLogButton = new JButton(Bundle.getMessage("ButtonStopLogging"));
    protected JCheckBox rawCheckBox = new JCheckBox(Bundle.getMessage("ButtonShowRaw"));
    protected JCheckBox timeCheckBox = new JCheckBox(Bundle.getMessage("ButtonShowTimestamps"));
    protected JCheckBox alwaysOnTopCheckBox = new JCheckBox(Bundle.getMessage("ButtonWindowOnTop"));
    protected JCheckBox autoScrollCheckBox = new JCheckBox(Bundle.getMessage("ButtonAutoScroll"));
    protected JButton openFileChooserButton = new JButton(Bundle.getMessage("ButtonChooseLogFile"));
    protected JTextField entryField = new JTextField();
    protected JButton enterButton = new JButton(Bundle.getMessage("ButtonAddMessage"));
    private final String rawDataCheck = this.getClass().getName() + ".RawData";
    private final String timeStampCheck = this.getClass().getName() + ".TimeStamp";
    private final String alwaysOnTopCheck = this.getClass().getName() + ".alwaysOnTop";
    private final String autoScrollCheck = this.getClass().getName() + ".AutoScroll";
    public UserPreferencesManager userPrefs;
    final AbstractMonFrame self;
    public final JFileChooser logFileChooser = new JmriJFileChooser(FileUtil.getUserFilesPath());
    String newline = System.getProperty("line.separator");
    private volatile PrintStream logStream = null;
    DateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
    StringBuffer linesBuffer = new StringBuffer();
    private static int MAX_LINES = 500;
    private static final Logger log = LoggerFactory.getLogger(AbstractMonFrame.class);

    protected abstract String title();

    protected abstract void init();

    @Override
    @OverridingMethodsMustInvokeSuper
    public void dispose() {
        if (this.userPrefs != null) {
            this.userPrefs.setSimplePreferenceState(this.timeStampCheck, this.timeCheckBox.isSelected());
            this.userPrefs.setSimplePreferenceState(this.rawDataCheck, this.rawCheckBox.isSelected());
            this.userPrefs.setSimplePreferenceState(this.alwaysOnTopCheck, this.alwaysOnTopCheckBox.isSelected());
            this.userPrefs.setSimplePreferenceState(this.autoScrollCheck, !this.autoScrollCheckBox.isSelected());
        }
        this.stopLogButtonActionPerformed(null);
        this.monTextPane.dispose();
        super.dispose();
    }

    public AbstractMonFrame() {
        this.self = this;
    }

    @Override
    public void initComponents() {
        this.userPrefs = InstanceManager.getDefault(UserPreferencesManager.class);
        this.monTextPane.setVisible(true);
        this.monTextPane.setToolTipText(Bundle.getMessage("TooltipMonTextPane"));
        this.monTextPane.setEditable(false);
        JTextField t = new JTextField(200);
        int x = this.jScrollPane1.getPreferredSize().width + t.getPreferredSize().width;
        int y = this.jScrollPane1.getPreferredSize().height + 10 * t.getPreferredSize().height;
        this.jScrollPane1.getViewport().add(this.monTextPane);
        this.jScrollPane1.setPreferredSize(new Dimension(x, y));
        this.jScrollPane1.setVisible(true);
        this.setTitle(this.title());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.jScrollPane1);
        JPanel paneA = new JPanel();
        paneA.setLayout(new BoxLayout(paneA, 1));
        JPanel topActions = new JPanel();
        topActions.add(this.getActionButtonsPanel());
        topActions.add(this.getCheckBoxPanel());
        paneA.add(topActions);
        paneA.add(this.getLogToFilePanel());
        JPanel pane3 = new JPanel();
        pane3.setLayout(new BoxLayout(pane3, 0));
        this.enterButton.setVisible(true);
        this.enterButton.setToolTipText(Bundle.getMessage("TooltipAddMessage"));
        this.enterButton.addActionListener(this::enterButtonActionPerformed);
        this.entryField.setToolTipText(Bundle.getMessage("TooltipEntryPane", Bundle.getMessage("ButtonAddMessage")));
        pane3.add(this.enterButton);
        pane3.add(this.entryField);
        paneA.add(pane3);
        this.getContentPane().add(paneA);
        this.init();
        this.setHelp();
        this.pack();
        paneA.setMaximumSize(paneA.getSize());
        this.pack();
    }

    protected JPanel getCheckBoxPanel() {
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 0));
        this.rawCheckBox.setVisible(true);
        this.rawCheckBox.setToolTipText(Bundle.getMessage("TooltipShowRaw"));
        this.rawCheckBox.setSelected(this.userPrefs.getSimplePreferenceState(this.rawDataCheck));
        this.timeCheckBox.setVisible(true);
        this.timeCheckBox.setToolTipText(Bundle.getMessage("TooltipShowTimestamps"));
        this.timeCheckBox.setSelected(this.userPrefs.getSimplePreferenceState(this.timeStampCheck));
        this.alwaysOnTopCheckBox.setVisible(true);
        this.alwaysOnTopCheckBox.setToolTipText(Bundle.getMessage("TooltipWindowOnTop"));
        this.alwaysOnTopCheckBox.setSelected(this.userPrefs.getSimplePreferenceState(this.alwaysOnTopCheck));
        this.setAlwaysOnTop(this.alwaysOnTopCheckBox.isSelected());
        this.alwaysOnTopCheckBox.addActionListener(e -> this.setAlwaysOnTop(this.alwaysOnTopCheckBox.isSelected()));
        this.autoScrollCheckBox.setVisible(true);
        this.autoScrollCheckBox.setToolTipText(Bundle.getMessage("TooltipAutoScroll"));
        this.autoScrollCheckBox.setSelected(!this.userPrefs.getSimplePreferenceState(this.autoScrollCheck));
        this.autoScrollCheckBox.addActionListener(e -> this.monTextPane.setAutoScroll(this.autoScrollCheckBox.isSelected()));
        pane1.add(this.rawCheckBox);
        pane1.add(this.timeCheckBox);
        pane1.add(this.alwaysOnTopCheckBox);
        pane1.add(this.autoScrollCheckBox);
        return pane1;
    }

    protected JPanel getActionButtonsPanel() {
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 0));
        this.clearButton.setVisible(true);
        this.clearButton.setToolTipText(Bundle.getMessage("TooltipClearMonHistory"));
        this.clearButton.addActionListener(this::clearButtonActionPerformed);
        this.freezeButton.setVisible(true);
        this.freezeButton.setToolTipText(Bundle.getMessage("TooltipStopScroll"));
        pane1.add(this.clearButton);
        pane1.add(this.freezeButton);
        return pane1;
    }

    protected JPanel getLogToFilePanel() {
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BoxLayout(pane1, 0));
        this.startLogButton.setVisible(true);
        this.startLogButton.setToolTipText(Bundle.getMessage("TooltipStartLogging"));
        this.stopLogButton.setVisible(false);
        this.stopLogButton.setToolTipText(Bundle.getMessage("TooltipStopLogging"));
        this.openFileChooserButton.setVisible(true);
        this.openFileChooserButton.setToolTipText(Bundle.getMessage("TooltipChooseLogFile"));
        this.startLogButton.addActionListener(this::startLogButtonActionPerformed);
        this.stopLogButton.addActionListener(this::stopLogButtonActionPerformed);
        this.logFileChooser.setSelectedFile(new File("monitorLog.txt"));
        this.openFileChooserButton.addActionListener(this::openFileChooserButtonActionPerformed);
        pane1.add(this.openFileChooserButton);
        pane1.add(this.startLogButton);
        pane1.add(this.stopLogButton);
        return pane1;
    }

    protected void setHelp() {
        this.addHelpMenu("package.jmri.jmrix.AbstractMonFrame", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextLine(String line, String raw) {
        StringBuilder sb = new StringBuilder(120);
        if (this.timeCheckBox.isSelected()) {
            sb.append(this.df.format(new Date())).append(": ");
        }
        if (this.rawCheckBox.isSelected()) {
            sb.append('[').append(raw).append("]  ");
        }
        sb.append(line);
        Object object = this.self;
        synchronized (object) {
            this.linesBuffer.append(sb.toString());
        }
        if (!this.freezeButton.isSelected()) {
            Runnable r = () -> {
                AbstractMonFrame abstractMonFrame = this.self;
                synchronized (abstractMonFrame) {
                    this.monTextPane.append(this.linesBuffer.toString());
                    this.linesBuffer.setLength(0);
                }
            };
            SwingUtilities.invokeLater(r);
        }
        if (this.logStream != null) {
            object = this.logStream;
            synchronized (object) {
                String logLine = sb.toString();
                if (!this.newline.equals("\n")) {
                    int lim = sb.length();
                    StringBuilder out = new StringBuilder(sb.length() + 10);
                    for (int i = 0; i < lim; ++i) {
                        if (sb.charAt(i) == '\n') {
                            out.append(this.newline);
                            continue;
                        }
                        out.append(sb.charAt(i));
                    }
                    logLine = out.toString();
                }
                this.logStream.print(logLine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearButtonActionPerformed(ActionEvent e) {
        StringBuffer stringBuffer = this.linesBuffer;
        synchronized (stringBuffer) {
            this.linesBuffer.setLength(0);
            this.monTextPane.setText("");
        }
    }

    public synchronized void startLogButtonActionPerformed(ActionEvent e) {
        if (this.logStream == null) {
            try {
                this.logStream = new PrintStream(new FileOutputStream(this.logFileChooser.getSelectedFile()));
            }
            catch (FileNotFoundException ex) {
                log.error("exception", (Throwable)ex);
            }
        }
        this.updateLoggingButtons();
    }

    public synchronized void stopLogButtonActionPerformed(ActionEvent e) {
        if (this.logStream != null) {
            this.logStream.flush();
            this.logStream.close();
            this.logStream = null;
        }
        this.updateLoggingButtons();
    }

    private void updateLoggingButtons() {
        this.startLogButton.setVisible(this.logStream == null);
        this.stopLogButton.setVisible(this.logStream != null);
    }

    public void openFileChooserButtonActionPerformed(ActionEvent e) {
        int retVal = this.logFileChooser.showSaveDialog(this);
        if (retVal == 0) {
            boolean loggingNow = this.logStream != null;
            this.stopLogButtonActionPerformed(e);
            if (loggingNow) {
                this.startLogButtonActionPerformed(e);
            }
        }
    }

    public void enterButtonActionPerformed(ActionEvent e) {
        this.nextLine(this.entryField.getText() + "\n", "");
    }

    public final synchronized JTextArea getTextArea() {
        return this.monTextPane;
    }
}

