/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import jmri.SystemConnectionMemo;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.JmrixConfigPane;
import jmri.jmrix.NetworkPortAdapter;
import jmri.util.LoggingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNetworkPortController
extends AbstractPortController
implements NetworkPortAdapter {
    protected String m_HostName = null;
    private String m_HostAddress = null;
    protected int m_port = 0;
    protected Socket socketConn = null;
    protected int connTimeout = 0;
    private static final Logger log = LoggerFactory.getLogger(AbstractNetworkPortController.class);

    protected AbstractNetworkPortController(SystemConnectionMemo connectionMemo) {
        super(connectionMemo);
        this.setHostName("");
    }

    @Override
    public void connect(String host, int port) throws IOException {
        this.setHostName(host);
        this.setPort(port);
        this.connect();
    }

    @Override
    public void connect() throws IOException {
        log.debug("connect() starts to {}:{}", (Object)this.getHostName(), (Object)this.getPort());
        this.opened = false;
        if (this.getHostAddress() == null || this.m_port == 0) {
            log.error("No host name or port set: {}:{}", (Object)this.m_HostName, (Object)this.m_port);
            return;
        }
        try {
            this.socketConn = new Socket(this.getHostAddress(), this.m_port);
            this.socketConn.setKeepAlive(true);
            this.socketConn.setSoTimeout(this.getConnectionTimeout());
            this.opened = true;
        }
        catch (IOException e) {
            log.error("Error opening network connection to {} because {}", (Object)this.getHostName(), (Object)e.getMessage());
            if (this.m_port != 0) {
                ConnectionStatus.instance().setConnectionState(this.getUserName(), this.m_HostName + ":" + this.m_port, "Not Connected");
            } else {
                ConnectionStatus.instance().setConnectionState(this.getUserName(), this.m_HostName, "Not Connected");
            }
            throw e;
        }
        if (this.opened && this.m_port != 0) {
            ConnectionStatus.instance().setConnectionState(this.getUserName(), this.m_HostName + ":" + this.m_port, "Connected");
        } else if (this.opened) {
            ConnectionStatus.instance().setConnectionState(this.getUserName(), this.m_HostName, "Connected");
        }
        log.trace("connect ends");
    }

    @Override
    public void setHostName(String s) {
        log.trace("setHostName({})", (Object)s, (Object)new Exception("traceback only"));
        this.m_HostName = s;
        if ((s == null || s.equals("")) && !this.getMdnsConfigure()) {
            this.m_HostName = JmrixConfigPane.NONE;
        }
    }

    @Override
    public String getHostName() {
        String envVar = "JMRI_HOSTNAME";
        String fromEnv = System.getenv("JMRI_HOSTNAME");
        log.debug("Environment {} {} was {}", new Object[]{"JMRI_HOSTNAME", fromEnv, this.m_HostName});
        String fromProp = System.getProperty("JMRI_HOSTNAME");
        log.debug("Property {} {} was {}", new Object[]{"JMRI_HOSTNAME", fromProp, this.m_HostName});
        if (fromEnv != null) {
            LoggingUtil.infoOnce(log, "{} set, using environment \"{}\" as Host Name", "JMRI_HOSTNAME", fromEnv);
            return fromEnv;
        }
        if (fromProp != null) {
            LoggingUtil.infoOnce(log, "{} set, using property \"{}\" as Host Name", "JMRI_HOSTNAME", fromProp);
            return fromProp;
        }
        return this.m_HostName;
    }

    protected void setHostAddress(String s) {
        log.trace("setHostAddress({})", (Object)s);
        this.m_HostAddress = s;
        if (s == null || s.equals("")) {
            this.m_HostAddress = this.m_HostName;
        }
    }

    protected String getHostAddress() {
        if (this.m_HostAddress == null) {
            return this.getHostName();
        }
        log.info("getHostAddress is {}", (Object)this.m_HostAddress);
        return this.m_HostAddress;
    }

    @Override
    public void setPort(int p) {
        log.trace("setPort(int {})", (Object)p);
        this.m_port = p;
    }

    @Override
    public void setPort(String p) {
        log.trace("setPort(String {})", (Object)p);
        this.m_port = Integer.parseInt(p);
    }

    @Override
    public int getPort() {
        return this.m_port;
    }

    @Override
    public String getCurrentPortName() {
        String t = this.getMdnsConfigure() ? this.getHostAddress() : this.getHostName();
        int p = this.getPort();
        if (t != null && !t.equals("")) {
            if (p != 0) {
                return t + ":" + p;
            }
            return t;
        }
        return JmrixConfigPane.NONE;
    }

    @Override
    public void setMdnsConfigure(boolean autoconfig) {
    }

    @Override
    public boolean getMdnsConfigure() {
        return false;
    }

    @Override
    public void autoConfigure() {
    }

    @Override
    public void setAdvertisementName(String AdName) {
    }

    @Override
    public String getAdvertisementName() {
        return null;
    }

    @Override
    public void setServiceType(String ServiceType) {
    }

    @Override
    public String getServiceType() {
        return null;
    }

    @Override
    public DataInputStream getInputStream() {
        log.trace("getInputStream() starts");
        if (this.socketConn == null) {
            log.error("getInputStream invoked with null socketConn");
        }
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            if (this.m_port != 0) {
                ConnectionStatus.instance().setConnectionState(this.getUserName(), this.m_HostName + ":" + this.m_port, "Not Connected");
            } else {
                ConnectionStatus.instance().setConnectionState(this.getUserName(), this.m_HostName, "Not Connected");
            }
        }
        try {
            log.trace("getInputStream() returns normally");
            return new DataInputStream(this.socketConn.getInputStream());
        }
        catch (IOException ex1) {
            log.error("Exception getting input stream:", (Throwable)ex1);
            return null;
        }
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        try {
            return new DataOutputStream(this.socketConn.getOutputStream());
        }
        catch (IOException e) {
            log.error("getOutputStream exception:", (Throwable)e);
            if (this.m_port != 0) {
                ConnectionStatus.instance().setConnectionState(this.getUserName(), this.m_HostName + ":" + this.m_port, "Not Connected");
            } else {
                ConnectionStatus.instance().setConnectionState(this.getUserName(), this.m_HostName, "Not Connected");
            }
            return null;
        }
    }

    @Override
    protected void closeConnection() {
        try {
            this.socketConn.close();
        }
        catch (IOException e) {
            log.trace("Unable to close socket", (Throwable)e);
        }
        this.opened = false;
    }

    @Override
    protected void resetupConnection() {
    }

    @Override
    protected void reconnectFromLoop(int retryNum) {
        try {
            if (this.getMdnsConfigure()) {
                this.autoConfigure();
            }
            this.connect();
        }
        catch (IOException ex) {
            log.trace("restart failed", (Throwable)ex);
        }
    }

    protected void setConnectionTimeout(int t) {
        this.connTimeout = t;
        try {
            if (this.socketConn != null) {
                this.socketConn.setSoTimeout(this.getConnectionTimeout());
            }
        }
        catch (SocketException se) {
            log.debug("Unable to set socket timeout option on socket");
        }
    }

    protected int getConnectionTimeout() {
        return this.connTimeout;
    }
}

