/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNode {
    public int nodeAddress = 0;
    boolean needSend = true;
    private static final Logger log = LoggerFactory.getLogger(AbstractNode.class);

    public int getNodeAddress() {
        return this.nodeAddress;
    }

    public void setNodeAddress(int address) {
        if (!this.checkNodeAddress(address)) {
            log.error("illegal node address: {}", (Object)Integer.toString(address));
            this.nodeAddress = 0;
            throw new IllegalArgumentException("Attempt to set address to invalid value: " + address);
        }
        this.nodeAddress = address;
    }

    protected abstract boolean checkNodeAddress(int var1);

    public abstract AbstractMRMessage createInitPacket();

    public abstract AbstractMRMessage createOutPacket();

    public abstract boolean getSensorsActive();

    public abstract boolean handleTimeout(AbstractMRMessage var1, AbstractMRListener var2);

    public abstract void resetTimeout(AbstractMRMessage var1);

    public boolean mustSend() {
        return this.needSend;
    }

    public void resetMustSend() {
        this.needSend = false;
    }

    public void setMustSend() {
        this.needSend = true;
    }
}

