/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.Timer;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrix.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProgrammer
extends PropertyChangeSupport
implements Programmer {
    private ProgrammingMode mode = null;
    protected int SHORT_TIMEOUT = 2000;
    protected int LONG_TIMEOUT = 60000;
    Timer timer = null;
    private static final Logger log = LoggerFactory.getLogger(AbstractProgrammer.class);

    @Override
    @Nonnull
    public String decodeErrorCode(int code) {
        String retval;
        if (code == 0) {
            return Bundle.getMessage("StatusOK");
        }
        StringBuilder sbuf = new StringBuilder();
        if ((code & 2) != 0) {
            sbuf.append(Bundle.getMessage("NoLocoDetected")).append(" ");
        }
        if ((code & 4) != 0) {
            sbuf.append(Bundle.getMessage("ProgrammerBusy")).append(" ");
        }
        if ((code & 8) != 0) {
            sbuf.append(Bundle.getMessage("NotImplemented")).append(" ");
        }
        if ((code & 0x10) != 0) {
            sbuf.append(Bundle.getMessage("UserAborted")).append(" ");
        }
        if ((code & 0x40) != 0) {
            sbuf.append(Bundle.getMessage("ConfirmFailed")).append(" ");
        }
        if ((code & 0x80) != 0) {
            sbuf.append(Bundle.getMessage("FailedTimeout")).append(" ");
        }
        if ((code & 1) != 0) {
            sbuf.append(Bundle.getMessage("UnknownError")).append(" ");
        }
        if ((code & 0x20) != 0) {
            sbuf.append(Bundle.getMessage("NoAck")).append(" ");
        }
        if ((code & 0x100) != 0) {
            sbuf.append(Bundle.getMessage("ProgrammingShort")).append(" ");
        }
        if ((code & 0x200) != 0) {
            sbuf.append(Bundle.getMessage("SequenceError")).append(" ");
        }
        if ((code & 0x400) != 0) {
            sbuf.append(Bundle.getMessage("CommError")).append(" ");
        }
        if (sbuf.length() > 2) {
            sbuf.setLength(sbuf.length() - 2);
        }
        if ((retval = sbuf.toString()).isEmpty()) {
            return "unknown status code: " + code;
        }
        return retval;
    }

    @Override
    public abstract void writeCV(String var1, int var2, ProgListener var3) throws ProgrammerException;

    @Override
    public abstract void readCV(String var1, ProgListener var2) throws ProgrammerException;

    @Override
    public abstract void confirmCV(String var1, int var2, ProgListener var3) throws ProgrammerException;

    @Override
    public boolean getCanRead() {
        return true;
    }

    @Override
    public boolean getCanRead(String addr) {
        if (!this.getCanRead()) {
            return false;
        }
        return Integer.parseInt(addr) <= 1024;
    }

    @Override
    public final void setMode(ProgrammingMode m) {
        List<ProgrammingMode> validModes = this.getSupportedModes();
        if (m == null) {
            if (!validModes.isEmpty()) {
                throw new IllegalArgumentException("Cannot set null mode when modes are present");
            }
            this.mode = null;
        }
        if (!validModes.contains(m)) {
            throw new IllegalArgumentException("Invalid requested mode: " + m);
        }
        ProgrammingMode oldMode = this.mode;
        this.mode = m;
        this.firePropertyChange("Mode", oldMode, m);
    }

    public ProgrammingMode getBestMode() {
        if (!this.getSupportedModes().isEmpty()) {
            return this.getSupportedModes().get(0);
        }
        return null;
    }

    @Override
    public final ProgrammingMode getMode() {
        if (this.mode == null) {
            this.mode = this.getBestMode();
        }
        return this.mode;
    }

    @Override
    @Nonnull
    public abstract List<ProgrammingMode> getSupportedModes();

    @Override
    public boolean getCanWrite() {
        return true;
    }

    @Override
    public boolean getCanWrite(String addr) {
        return this.getCanWrite();
    }

    @Override
    @Nonnull
    public Programmer.WriteConfirmMode getWriteConfirmMode(String addr) {
        return Programmer.WriteConfirmMode.NotVerified;
    }

    protected void startShortTimer() {
        log.debug("startShortTimer");
        this.restartTimer(this.SHORT_TIMEOUT);
    }

    protected void startLongTimer() {
        log.debug("startLongTimer");
        this.restartTimer(this.LONG_TIMEOUT);
    }

    protected synchronized void stopTimer() {
        log.debug("stop timer");
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    protected synchronized void restartTimer(int delay) {
        log.debug("(re)start timer with delay {}", (Object)delay);
        if (this.timer == null) {
            this.timer = new Timer(delay, e -> this.timeout());
        }
        this.timer.stop();
        this.timer.setInitialDelay(delay);
        this.timer.setRepeats(false);
        this.timer.start();
    }

    public int registerFromCV(int cv) throws ProgrammerException {
        if (cv <= 4) {
            return cv;
        }
        switch (cv) {
            case 29: {
                return 5;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
        }
        log.warn("Unhandled register from cv: {}", (Object)cv);
        throw new ProgrammerException();
    }

    protected abstract void timeout();
}

