/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.AbstractConnectionConfig;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.Bundle;
import jmri.jmrix.JmrixConfigPane;
import jmri.jmrix.PortAdapter;
import jmri.jmrix.SerialPortAdapter;
import jmri.util.PortNameMapper;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerialConnectionConfig
extends AbstractConnectionConfig {
    protected boolean init = false;
    UserPreferencesManager p = InstanceManager.getDefault(UserPreferencesManager.class);
    protected JComboBox<String> portBox = new JComboBox();
    protected JLabel portBoxLabel;
    protected JComboBox<String> baudBox = new JComboBox();
    protected JLabel baudBoxLabel;
    protected String[] baudList;
    private final SpinnerNumberModel intervalSpinner = new SpinnerNumberModel(250, 0, 10000, 1);
    protected JSpinner outputIntervalSpinner = new JSpinner(this.intervalSpinner);
    protected JLabel outputIntervalLabel;
    protected JButton outputIntervalReset = new JButton(Bundle.getMessage("ButtonReset"));
    protected SerialPortAdapter adapter;
    Vector<String> v;
    Vector<String> originalList;
    String invalidPort = null;
    private static final Logger log = LoggerFactory.getLogger(AbstractSerialConnectionConfig.class);

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Thought to be safe as default connection config")
    public AbstractSerialConnectionConfig(PortAdapter p) {
        this((SerialPortAdapter)p);
    }

    public AbstractSerialConnectionConfig(SerialPortAdapter p) {
        this.adapter = p;
    }

    public AbstractSerialConnectionConfig() {
        this.adapter = null;
    }

    @Override
    public SerialPortAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    protected void checkInitDone() {
        log.debug("init called for {}", (Object)this.name());
        if (this.init) {
            return;
        }
        this.baudBox.addActionListener(e -> {
            this.adapter.configureBaudRate((String)this.baudBox.getSelectedItem());
            this.p.setComboBoxLastSelection(this.adapter.getClass().getName() + ".baud", (String)this.baudBox.getSelectedItem());
        });
        this.addNameEntryCheckers(this.adapter);
        this.portBox.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                AbstractSerialConnectionConfig.this.refreshPortBox();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.outputIntervalSpinner.addChangeListener(e -> this.adapter.getSystemConnectionMemo().setOutputInterval((Integer)this.outputIntervalSpinner.getValue()));
        for (Map.Entry entry : this.options.entrySet()) {
            String item = (String)entry.getKey();
            if (!(((AbstractConnectionConfig.Option)entry.getValue()).getComponent() instanceof JComboBox)) continue;
            ((JComboBox)((AbstractConnectionConfig.Option)entry.getValue()).getComponent()).addActionListener(e -> this.adapter.setOptionState(item, ((AbstractConnectionConfig.Option)this.options.get(item)).getItem()));
            JComboBoxUtil.setupComboBoxMaxRows((JComboBox)((AbstractConnectionConfig.Option)entry.getValue()).getComponent());
        }
        this.init = true;
    }

    @Override
    public void updateAdapter() {
        log.debug("updateAdapter() to {}", (Object)this.systemPrefixField.getText());
        this.adapter.setPort(PortNameMapper.getPortFromName((String)this.portBox.getSelectedItem()));
        this.adapter.configureBaudRateFromIndex(this.baudBox.getSelectedIndex());
        for (Map.Entry entry : this.options.entrySet()) {
            this.adapter.setOptionState((String)entry.getKey(), ((AbstractConnectionConfig.Option)entry.getValue()).getItem());
        }
        if (this.adapter.getSystemConnectionMemo() != null && !this.adapter.getSystemConnectionMemo().setSystemPrefix(this.systemPrefixField.getText())) {
            this.systemPrefixField.setText(this.adapter.getSystemConnectionMemo().getSystemPrefix());
            this.connectionNameField.setText(this.adapter.getSystemConnectionMemo().getUserName());
        }
    }

    @Override
    protected abstract void setInstance();

    @Override
    public String getInfo() {
        String t = (String)this.portBox.getSelectedItem();
        if (t != null) {
            return PortNameMapper.getPortFromName(t);
        }
        if (this.adapter != null && this.adapter.getCurrentPortName() != null) {
            return this.adapter.getCurrentPortName();
        }
        return JmrixConfigPane.NONE;
    }

    public void refreshPortBox() {
        String portName;
        if (!this.init) {
            this.v = this.getPortNames();
            this.portBox.setRenderer(new ComboBoxRenderer());
            this.portBox.setPrototypeDisplayValue("A fairly long port name of 40 characters");
        } else {
            Vector<String> v2 = this.getPortNames();
            if (v2.equals(this.originalList)) {
                log.debug("List of valid Ports has not changed, therefore we will not refresh the port list");
                this.adapter.setPort(PortNameMapper.getPortFromName((String)this.portBox.getSelectedItem()));
                return;
            }
            log.debug("List of valid Ports has been changed, therefore we will refresh the port list");
            this.v = new Vector();
            this.v.setSize(v2.size());
            Collections.copy(this.v, v2);
        }
        if (this.v == null) {
            log.error("port name Vector v is null!");
            return;
        }
        this.originalList = new Vector();
        this.originalList.setSize(this.v.size());
        Collections.copy(this.originalList, this.v);
        if (this.portBox.getActionListeners().length > 0) {
            this.portBox.removeActionListener(this.portBox.getActionListeners()[0]);
        }
        this.portBox.removeAllItems();
        log.debug("getting fresh list of available Serial Ports");
        if (this.v.isEmpty()) {
            this.v.add(0, Bundle.getMessage("noPortsFound"));
        }
        if ((portName = this.adapter.getCurrentPortName()) != null && !portName.equals(Bundle.getMessage("noneSelected")) && !portName.equals(Bundle.getMessage("noPortsFound"))) {
            if (!this.v.contains(portName)) {
                this.v.add(0, portName);
                this.invalidPort = portName;
                this.portBox.setForeground(Color.red);
            } else if (this.invalidPort != null && this.invalidPort.equals(portName)) {
                this.invalidPort = null;
            }
        } else if (!this.v.contains(portName)) {
            this.v.add(0, Bundle.getMessage("noneSelected"));
        } else if (this.p.getComboBoxLastSelection(this.adapter.getClass().getName() + ".port") == null) {
            this.v.add(0, Bundle.getMessage("noneSelected"));
        }
        AbstractSerialConnectionConfig.updateSerialPortNames(portName, this.portBox, this.v);
        JComboBoxUtil.setupComboBoxMaxRows(this.portBox);
        boolean didSetName = false;
        if (portName == null || portName.equals(Bundle.getMessage("noneSelected")) || portName.equals(Bundle.getMessage("noPortsFound"))) {
            block0: for (int i = 0; i < this.portBox.getItemCount(); ++i) {
                for (String friendlyName : this.getPortFriendlyNames()) {
                    if (!this.portBox.getItemAt(i).contains(friendlyName)) continue;
                    this.portBox.setSelectedIndex(i);
                    this.adapter.setPort(PortNameMapper.getPortFromName(this.portBox.getItemAt(i)));
                    didSetName = true;
                    continue block0;
                }
            }
            if (!didSetName) {
                this.portBox.setSelectedIndex(0);
            }
        }
        this.adapter.setPort(PortNameMapper.getPortFromName((String)this.portBox.getSelectedItem()));
        this.portBox.addActionListener(e -> {
            String port = PortNameMapper.getPortFromName((String)this.portBox.getSelectedItem());
            this.adapter.setPort(port);
        });
    }

    @Override
    public void loadDetails(JPanel details) {
        this._details = details;
        this.setInstance();
        if (!this.init) {
            String[] optionsAvailable = this.adapter.getOptions();
            this.options.clear();
            String[] stringArray = optionsAvailable;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String i2 = stringArray[i];
                JComboBox<String> opt = new JComboBox<String>(this.adapter.getOptionChoices(i2));
                opt.setSelectedItem(this.adapter.getOptionState(i2));
                if (!this.adapter.getOptionState(i2).equals(opt.getSelectedItem())) {
                    opt.setSelectedIndex(0);
                    log.warn("Loading found invalid value for option {}, found \"{}\", setting to \"{}\"", new Object[]{i2, this.adapter.getOptionState(i2), opt.getSelectedItem()});
                    this.adapter.setOptionState(i2, (String)opt.getSelectedItem());
                }
                this.options.put(i2, new AbstractConnectionConfig.Option(this.adapter.getOptionDisplayName(i2), opt, this.adapter.isOptionAdvanced(i2)));
            }
        }
        try {
            this.v = this.getPortNames();
            if (log.isDebugEnabled()) {
                log.debug("loadDetails called in class {}", (Object)this.getClass().getName());
                log.debug("adapter class: {}", (Object)this.adapter.getClass().getName());
                log.debug("loadDetails called for {}", (Object)this.name());
                if (this.v != null) {
                    log.debug("Found {} ports", (Object)this.v.size());
                } else {
                    log.debug("Zero-length port vector");
                }
            }
        }
        catch (UnsatisfiedLinkError e1) {
            log.error("UnsatisfiedLinkError - the serial library has not been installed properly");
            log.error("java.library.path={}", (Object)System.getProperty("java.library.path", "<unknown>"));
            JmriJOptionPane.showMessageDialog(null, "Failed to load comm library.\nYou have to fix that before setting preferences.");
            return;
        }
        if (this.adapter.getSystemConnectionMemo() != null) {
            this.systemPrefixField.setText(this.adapter.getSystemConnectionMemo().getSystemPrefix());
            this.connectionNameField.setText(this.adapter.getSystemConnectionMemo().getUserName());
            this.NUMOPTIONS += 2;
        }
        this.refreshPortBox();
        this.baudList = this.adapter.validBaudRates();
        if (this.baudBox.getActionListeners().length > 0) {
            this.baudBox.removeActionListener(this.baudBox.getActionListeners()[0]);
        }
        this.baudBox.removeAllItems();
        if (log.isDebugEnabled()) {
            log.debug("after remove, {} items, first is {}", (Object)this.baudBox.getItemCount(), (Object)this.baudBox.getItemAt(0));
        }
        if (this.baudList.length == 0) {
            log.debug("empty array received from adapter");
        }
        for (String baudList1 : this.baudList) {
            this.baudBox.addItem(baudList1);
        }
        if (log.isDebugEnabled()) {
            log.debug("after reload, {} items, first is {}", (Object)this.baudBox.getItemCount(), (Object)this.baudBox.getItemAt(0));
        }
        if (this.baudList.length > 1) {
            this.baudBox.setToolTipText(Bundle.getMessage("TipBaudRateMatch"));
            this.baudBox.setEnabled(true);
        } else {
            this.baudBox.setToolTipText(Bundle.getMessage("TipBaudRateFixed"));
            this.baudBox.setEnabled(false);
        }
        this.NUMOPTIONS += this.options.size();
        this.portBoxLabel = new JLabel(Bundle.getMessage("SerialPortLabel"));
        this.baudBoxLabel = new JLabel(Bundle.getMessage("BaudRateLabel"));
        if (this.baudBox.getItemCount() > 0) {
            this.baudBox.setSelectedIndex(this.adapter.getCurrentBaudIndex());
        }
        this.outputIntervalLabel = new JLabel(Bundle.getMessage("OutputIntervalLabel"));
        this.outputIntervalSpinner.setToolTipText(Bundle.getMessage("OutputIntervalTooltip", this.adapter.getSystemConnectionMemo().getDefaultOutputInterval(), this.adapter.getManufacturer()));
        JFormattedTextField field = ((JSpinner.DefaultEditor)this.outputIntervalSpinner.getEditor()).getTextField();
        field.setColumns(6);
        this.outputIntervalSpinner.setMaximumSize(this.outputIntervalSpinner.getPreferredSize());
        this.outputIntervalSpinner.setValue(this.adapter.getSystemConnectionMemo().getOutputInterval());
        this.outputIntervalSpinner.setEnabled(true);
        this.outputIntervalReset.addActionListener(event -> {
            this.outputIntervalSpinner.setValue(this.adapter.getSystemConnectionMemo().getDefaultOutputInterval());
            this.adapter.getSystemConnectionMemo().setOutputInterval(this.adapter.getSystemConnectionMemo().getDefaultOutputInterval());
        });
        this.showAdvanced.setFont(this.showAdvanced.getFont().deriveFont(9.0f));
        this.showAdvanced.setForeground(Color.blue);
        this.showAdvanced.addItemListener(e -> this.showAdvancedItems());
        this.showAdvancedItems();
        this.init = false;
        this.checkInitDone();
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Type is checked before casting")
    protected void showAdvancedItems() {
        this._details.removeAll();
        this.cL.anchor = 17;
        this.cL.insets = new Insets(2, 5, 0, 5);
        this.cR.insets = new Insets(2, 0, 0, 5);
        this.cR.anchor = 17;
        this.cR.gridx = 1;
        this.cL.gridx = 0;
        int i = 0;
        int stdrows = 0;
        boolean incAdvancedOptions = true;
        if (!this.isBaudAdvanced()) {
            ++stdrows;
        }
        if (!this.isPortAdvanced()) {
            ++stdrows;
        }
        for (Map.Entry entry : this.options.entrySet()) {
            if (((AbstractConnectionConfig.Option)entry.getValue()).isAdvanced().booleanValue()) continue;
            ++stdrows;
        }
        if (this.adapter.getSystemConnectionMemo() != null) {
            stdrows += 2;
        }
        if (stdrows == this.NUMOPTIONS) {
            incAdvancedOptions = false;
        }
        this._details.setLayout(this.gbLayout);
        i = this.addStandardDetails(incAdvancedOptions, i);
        if (this.showAdvanced.isSelected()) {
            if (this.isPortAdvanced()) {
                this.cR.gridy = i;
                this.cL.gridy = i++;
                this.gbLayout.setConstraints(this.portBoxLabel, this.cL);
                this.gbLayout.setConstraints(this.portBox, this.cR);
                this._details.add(this.portBoxLabel);
                this._details.add(this.portBox);
            }
            if (this.isBaudAdvanced()) {
                this.cR.gridy = i;
                this.cL.gridy = i++;
                this.gbLayout.setConstraints(this.baudBoxLabel, this.cL);
                this.gbLayout.setConstraints(this.baudBox, this.cR);
                this._details.add(this.baudBoxLabel);
                this._details.add(this.baudBox);
            }
            for (Map.Entry entry : this.options.entrySet()) {
                if (!((AbstractConnectionConfig.Option)entry.getValue()).isAdvanced().booleanValue()) continue;
                this.cR.gridy = i;
                this.cL.gridy = i++;
                this.gbLayout.setConstraints(((AbstractConnectionConfig.Option)entry.getValue()).getLabel(), this.cL);
                this.gbLayout.setConstraints(((AbstractConnectionConfig.Option)entry.getValue()).getComponent(), this.cR);
                this._details.add(((AbstractConnectionConfig.Option)entry.getValue()).getLabel());
                this._details.add(((AbstractConnectionConfig.Option)entry.getValue()).getComponent());
            }
            this.cR.gridy = i;
            this.cL.gridy = i++;
            this.gbLayout.setConstraints(this.outputIntervalLabel, this.cL);
            this._details.add(this.outputIntervalLabel);
            JPanel intervalPanel = new JPanel();
            this.gbLayout.setConstraints(intervalPanel, this.cR);
            intervalPanel.add(this.outputIntervalSpinner);
            intervalPanel.add(this.outputIntervalReset);
            this._details.add(intervalPanel);
        }
        this.cL.gridwidth = 2;
        for (JComponent item : this.additionalItems) {
            this.cL.gridy = i++;
            this.gbLayout.setConstraints(item, this.cL);
            this._details.add(item);
        }
        this.cL.gridwidth = 1;
        if (this._details.getParent() != null && this._details.getParent() instanceof JViewport) {
            JViewport vp = (JViewport)this._details.getParent();
            vp.revalidate();
            vp.repaint();
        }
    }

    protected int addStandardDetails(boolean incAdvanced, int i) {
        if (!this.isPortAdvanced()) {
            this.cR.gridy = i;
            this.cL.gridy = i++;
            this.gbLayout.setConstraints(this.portBoxLabel, this.cL);
            this.gbLayout.setConstraints(this.portBox, this.cR);
            this._details.add(this.portBoxLabel);
            this._details.add(this.portBox);
        }
        if (!this.isBaudAdvanced()) {
            this.cR.gridy = i;
            this.cL.gridy = i++;
            this.gbLayout.setConstraints(this.baudBoxLabel, this.cL);
            this.gbLayout.setConstraints(this.baudBox, this.cR);
            this._details.add(this.baudBoxLabel);
            this._details.add(this.baudBox);
        }
        return this.addStandardDetails(this.adapter, incAdvanced, i);
    }

    public boolean isPortAdvanced() {
        return false;
    }

    public boolean isBaudAdvanced() {
        return true;
    }

    @Override
    public String getManufacturer() {
        return this.adapter.getManufacturer();
    }

    @Override
    public void setManufacturer(String manufacturer) {
        this.setInstance();
        this.adapter.setManufacturer(manufacturer);
    }

    @Override
    public boolean getDisabled() {
        if (this.adapter == null) {
            return true;
        }
        return this.adapter.getDisabled();
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.adapter != null) {
            this.adapter.setDisabled(disabled);
        }
    }

    @Override
    public String getConnectionName() {
        if (this.adapter != null && this.adapter.getSystemConnectionMemo() != null) {
            return this.adapter.getSystemConnectionMemo().getUserName();
        }
        return this.name();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.adapter != null) {
            this.adapter.dispose();
            this.adapter = null;
        }
    }

    protected static synchronized void updateSerialPortNames(String portName, JComboBox<String> portCombo, Vector<String> portList) {
        for (Map.Entry<String, PortNameMapper.SerialPortFriendlyName> en : PortNameMapper.getPortNameMap().entrySet()) {
            en.getValue().setValidPort(false);
        }
        for (int i = 0; i < portList.size(); ++i) {
            String commPort = portList.elementAt(i);
            PortNameMapper.SerialPortFriendlyName port = PortNameMapper.getPortNameMap().get(commPort);
            if (port == null) {
                port = new PortNameMapper.SerialPortFriendlyName(commPort, null);
                PortNameMapper.getPortNameMap().put(commPort, port);
            }
            port.setValidPort(true);
            portCombo.addItem(port.getDisplayName());
            if (!commPort.equals(portName)) continue;
            portCombo.setSelectedIndex(i);
        }
    }

    protected Vector<String> getPortNames() {
        return AbstractSerialPortController.getActualPortNames();
    }

    protected String[] getPortFriendlyNames() {
        return new String[0];
    }

    protected ResourceBundle getActionModelResourceBundle() {
        return null;
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        public ComboBoxRenderer() {
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String name, int index, boolean isSelected, boolean cellHasFocus) {
            String port;
            this.setOpaque(index > -1);
            this.setForeground(Color.black);
            list.setSelectionForeground(Color.black);
            if (isSelected && index > -1) {
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setBackground(list.getBackground());
            }
            if (AbstractSerialConnectionConfig.this.invalidPort != null && (port = PortNameMapper.getPortFromName(name)).equals(AbstractSerialConnectionConfig.this.invalidPort)) {
                list.setSelectionForeground(Color.red);
                this.setForeground(Color.red);
            }
            this.setText(name);
            return this;
        }
    }
}

