/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import jmri.SystemConnectionMemo;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.Bundle;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.ReplaceableInputStream;
import jmri.jmrix.ReplaceableOutputStream;
import jmri.jmrix.SerialPort;
import jmri.jmrix.SerialPortAdapter;
import jmri.jmrix.SerialPortDataListener;
import jmri.jmrix.fakeport.FakeInputStream;
import jmri.jmrix.fakeport.FakeSerialPort;
import jmri.jmrix.jserialcomm.JSerialPort;
import jmri.jmrix.purejavacomm.NoSuchPortException;
import jmri.jmrix.purejavacomm.PortInUseException;
import jmri.jmrix.purejavacomm.SerialPort;
import jmri.jmrix.purejavacomm.UnsupportedCommOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerialPortController
extends AbstractPortController
implements SerialPortAdapter {
    protected volatile jmri.jmrix.SerialPort currentSerialPort = null;
    private final ReplaceableInputStream inputStream = new ReplaceableInputStream();
    private final ReplaceableOutputStream outputStream = new ReplaceableOutputStream();
    protected String mPort = null;
    private FlowControl lastFlowControl = FlowControl.NONE;
    protected String mBaudRate = null;
    private static final Logger log = LoggerFactory.getLogger(AbstractSerialPortController.class);

    protected AbstractSerialPortController(SystemConnectionMemo connectionMemo) {
        super(connectionMemo);
    }

    public String handlePortBusy(PortInUseException p, String portName, Logger log) {
        log.error("{} port is in use: {}", (Object)portName, (Object)p.getMessage());
        ConnectionStatus.instance().setConnectionState(this.getSystemPrefix(), portName, "Not Connected");
        return Bundle.getMessage("SerialPortInUse", portName);
    }

    public String handlePortNotFound(NoSuchPortException p, String portName, Logger log) {
        log.error("Serial port {} not found", (Object)portName);
        ConnectionStatus.instance().setConnectionState(this.getSystemPrefix(), portName, "Not Connected");
        return Bundle.getMessage("SerialPortNotFound", portName);
    }

    public static String handlePortNotFound(String systemPrefix, String portName, Logger log, Exception ex) {
        log.error("Serial port {} not found: {}", (Object)portName, (Object)ex.getMessage());
        if (systemPrefix != null) {
            ConnectionStatus.instance().setConnectionState(systemPrefix, portName, "Not Connected");
        }
        return Bundle.getMessage("SerialPortNotFound", portName);
    }

    @Override
    public void connect() throws IOException {
        this.openPort(this.mPort, "JMRI app");
    }

    protected final jmri.jmrix.SerialPort activatePort(String portName, Logger log) {
        return AbstractSerialPortController.activatePort(this.getSystemPrefix(), portName, log, 1, SerialPort.Parity.NONE);
    }

    protected final jmri.jmrix.SerialPort activatePort(String portName, Logger log, int stop_bits) {
        return AbstractSerialPortController.activatePort(this.getSystemPrefix(), portName, log, stop_bits, SerialPort.Parity.NONE);
    }

    public static jmri.jmrix.SerialPort activatePort(String systemPrefix, String portName, Logger log, int stop_bits, SerialPort.Parity parity) {
        return JSerialPort.activatePort(systemPrefix, portName, log, stop_bits, parity);
    }

    protected final void setComPortTimeouts(jmri.jmrix.SerialPort serialPort, Blocking blocking, int timeout) {
        serialPort.setComPortTimeouts(blocking.getValue(), timeout, 0);
    }

    @Override
    public void setPort(String port) {
        log.debug("Setting port to {}", (Object)port);
        this.mPort = port;
    }

    @Override
    public String getCurrentPortName() {
        if (this.mPort == null) {
            if (this.getPortNames() == null) {
                log.error("Port names returned as null");
                return null;
            }
            if (this.getPortNames().size() <= 0) {
                log.error("No usable ports returned");
                return null;
            }
            return null;
        }
        return this.mPort;
    }

    public static Vector<String> getActualPortNames() {
        return JSerialPort.getActualPortNames();
    }

    protected void configureLeadsAndFlowControl(SerialPort serialPort, int flow, boolean rts, boolean dtr) {
        serialPort.setRTS(rts);
        serialPort.setDTR(dtr);
        try {
            if (flow != 0) {
                serialPort.setFlowControlMode(flow);
            }
        }
        catch (UnsupportedCommOperationException e) {
            log.warn("Could not set flow control, ignoring");
        }
        if (flow != 2) {
            serialPort.setRTS(rts);
        }
        serialPort.setDTR(dtr);
    }

    protected final void setBaudRate(jmri.jmrix.SerialPort serialPort, int baud) {
        serialPort.setBaudRate(baud);
    }

    protected final void configureLeads(jmri.jmrix.SerialPort serialPort, boolean rts, boolean dtr) {
        if (rts) {
            serialPort.setRTS();
        } else {
            serialPort.clearRTS();
        }
        if (dtr) {
            serialPort.setDTR();
        } else {
            serialPort.clearDTR();
        }
    }

    protected final void setFlowControl(jmri.jmrix.SerialPort serialPort, FlowControl flow) {
        this.lastFlowControl = flow;
        serialPort.setFlowControl(flow);
    }

    protected final FlowControl getFlowControl(jmri.jmrix.SerialPort serialPort) {
        int nowFlow = serialPort.getFlowControlSettings();
        switch (this.lastFlowControl) {
            case NONE: {
                if (nowFlow == 0) break;
                log.error("Expected flow {} but found {}", (Object)this.lastFlowControl, (Object)nowFlow);
                break;
            }
            case RTSCTS: {
                if (nowFlow == 17) break;
                log.error("Expected flow {} but found {}", (Object)this.lastFlowControl, (Object)nowFlow);
                break;
            }
            case XONXOFF: {
                if (nowFlow == 0x110000) break;
                log.error("Expected flow {} but found {}", (Object)this.lastFlowControl, (Object)nowFlow);
                break;
            }
            default: {
                log.warn("Unexpected FlowControl mode: {}", (Object)this.lastFlowControl);
            }
        }
        return this.lastFlowControl;
    }

    protected final void setDataListener(jmri.jmrix.SerialPort serialPort, SerialPortDataListener serialPortDataListener) {
        serialPort.addDataListener(serialPortDataListener);
    }

    protected final void closeSerialPort(jmri.jmrix.SerialPort serialPort) {
        serialPort.closePort();
    }

    protected final void configureLeadsAndFlowControl(SerialPort serialPort, int flow) {
        this.configureLeadsAndFlowControl(serialPort, flow, true, true);
    }

    protected final void reportPortStatus(Logger log, String portName) {
        if (log.isInfoEnabled()) {
            log.info("{}: Port {} opened at {} baud, sees DTR: {} RTS: {} DSR: {} CTS: {} DCD: {} flow: {}", new Object[]{this.getSystemConnectionMemo().getUserName(), this.currentSerialPort.getDescriptivePortName(), this.currentSerialPort.getBaudRate(), this.currentSerialPort.getDTR(), this.currentSerialPort.getRTS(), this.currentSerialPort.getDSR(), this.currentSerialPort.getCTS(), this.currentSerialPort.getDCD(), this.getFlowControl(this.currentSerialPort)});
        }
        if (log.isDebugEnabled()) {
            String stopBits;
            switch (this.currentSerialPort.getNumStopBits()) {
                case 3: {
                    stopBits = "2";
                    break;
                }
                case 1: {
                    stopBits = "1";
                    break;
                }
                default: {
                    stopBits = "unknown";
                }
            }
            log.debug("     {} data bits, {} stop bits", (Object)this.currentSerialPort.getNumDataBits(), (Object)stopBits);
        }
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before open, stream not available");
            return null;
        }
        this.inputStream.replaceStream(this.currentSerialPort.getInputStream());
        return new DataInputStream(this.inputStream);
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before open, stream not available");
        }
        this.outputStream.replaceStream(this.currentSerialPort.getOutputStream());
        return new DataOutputStream(this.outputStream);
    }

    @Override
    public final void configureBaudRate(String rate) {
        this.mBaudRate = rate;
    }

    @Override
    public final void configureBaudRateFromNumber(String indexString) {
        int baudNum;
        int index = 0;
        String[] rates = this.validBaudRates();
        int[] numbers = this.validBaudNumbers();
        if (numbers == null || numbers.length == 0) {
            this.mBaudRate = null;
            log.debug("no serial port speed values received (OK for simulator)");
            return;
        }
        if (numbers.length != rates.length) {
            this.mBaudRate = null;
            log.error("arrays wrong length in currentBaudNumber: {}, {}", (Object)numbers.length, (Object)rates.length);
            return;
        }
        if (indexString.isEmpty()) {
            this.mBaudRate = null;
            log.debug("empty baud rate received");
            return;
        }
        try {
            baudNum = Integer.parseInt(indexString);
            log.debug("new profile format port speed value");
        }
        catch (NumberFormatException ex) {
            log.warn("old profile format port speed value converted");
            StringBuilder baudNumber = new StringBuilder();
            boolean digitSeen = false;
            for (int n = 0; n < indexString.length(); ++n) {
                if (Character.isDigit(indexString.charAt(n))) {
                    digitSeen = true;
                    baudNumber.append(indexString.charAt(n));
                    continue;
                }
                if (indexString.charAt(n) == ' ' && digitSeen) break;
            }
            if (baudNumber.toString().equals("")) {
                baudNum = 0;
            }
            try {
                baudNum = Integer.parseInt(baudNumber.toString());
            }
            catch (NumberFormatException e2) {
                this.mBaudRate = null;
                log.error("error in filtering old profile format port speed value");
                return;
            }
            log.debug("old format baud number: {}", (Object)indexString);
        }
        for (int i = 0; i < numbers.length; ++i) {
            if (numbers[i] != baudNum) continue;
            index = i;
            log.debug("found new format baud value at index {}", (Object)i);
            break;
        }
        this.mBaudRate = this.validBaudRates()[index];
        log.debug("mBaudRate set to: {}", (Object)this.mBaudRate);
    }

    @Override
    public final void configureBaudRateFromIndex(int index) {
        if (this.validBaudRates().length > index && index > -1) {
            this.mBaudRate = this.validBaudRates()[index];
            log.debug("mBaudRate set by index to: {}", (Object)this.mBaudRate);
        } else {
            log.debug("no baud rate index {} in array size {}", (Object)index, (Object)this.validBaudRates().length);
        }
    }

    @Override
    public int defaultBaudIndex() {
        return -1;
    }

    @Override
    public String getCurrentBaudRate() {
        if (this.mBaudRate == null) {
            return "";
        }
        return this.mBaudRate;
    }

    @Override
    public final String getCurrentBaudNumber() {
        int[] numbers = this.validBaudNumbers();
        String[] rates = this.validBaudRates();
        if (numbers == null || rates == null || numbers.length != rates.length) {
            return "";
        }
        String baudNumString = "";
        if (this.mBaudRate != null) {
            for (int i = 0; i < numbers.length; ++i) {
                if (!rates[i].equals(this.mBaudRate)) continue;
                baudNumString = Integer.toString(numbers[i]);
                break;
            }
        } else if (this.defaultBaudIndex() > -1) {
            baudNumString = Integer.toString(numbers[this.defaultBaudIndex()]);
            log.debug("using default port speed {}", (Object)baudNumString);
        }
        log.debug("mBaudRate = {}, matched to string {}", (Object)this.mBaudRate, (Object)baudNumString);
        return baudNumString;
    }

    @Override
    public final int getCurrentBaudIndex() {
        if (this.mBaudRate != null) {
            String[] rates = this.validBaudRates();
            for (int i = 0; i < rates.length; ++i) {
                if (!rates[i].equals(this.mBaudRate)) continue;
                return i;
            }
        }
        return this.defaultBaudIndex();
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="null signals incorrect implementation of portcontroller")
    public String[] validBaudRates() {
        log.error("default validBaudRates implementation should not be used", (Throwable)new Exception());
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="null signals incorrect implementation of portcontroller")
    public int[] validBaudNumbers() {
        log.error("default validBaudNumbers implementation should not be used", (Throwable)new Exception());
        return null;
    }

    public final int currentBaudNumber(String currentBaudRate) {
        String[] rates = this.validBaudRates();
        int[] numbers = this.validBaudNumbers();
        if (numbers == null) {
            log.error("numbers array null in currentBaudNumber()");
            return -1;
        }
        if (rates == null) {
            log.error("rates array null in currentBaudNumber()");
            return -1;
        }
        if (numbers.length != rates.length) {
            log.error("arrays are of different length in currentBaudNumber: {} vs {}", (Object)numbers.length, (Object)rates.length);
            return -1;
        }
        if (numbers.length < 1) {
            log.warn("baudrate is not supported by adapter");
            return 0;
        }
        for (int i = 0; i < numbers.length; ++i) {
            if (!rates[i].equals(currentBaudRate)) continue;
            return numbers[i];
        }
        log.error("no match to ({}) in currentBaudNumber", (Object)currentBaudRate);
        return -1;
    }

    @Override
    protected void closeConnection() {
    }

    @Override
    protected void resetupConnection() {
    }

    public boolean isPortOpen() {
        return this.currentSerialPort != null;
    }

    public void replacePortWithFakePort() {
        log.warn("Replacing serial port with fake serial port: {}", (Object)this.currentSerialPort.getDescriptivePortName());
        jmri.jmrix.SerialPort oldSerialPort = this.currentSerialPort;
        FakeSerialPort serialPort = new FakeSerialPort();
        this.inputStream.replaceStream(new FakeInputStream());
        this.outputStream.replaceStream(OutputStream.nullOutputStream());
        this.currentSerialPort = serialPort;
        oldSerialPort.closePort();
    }

    public String getPortSettingsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Baudrate: ").append(this.currentSerialPort.getBaudRate()).append(", ");
        sb.append("FlowControl: ").append(this.currentSerialPort.getFlowControlSettings()).append(", ");
        sb.append("Num data bits: ").append(this.currentSerialPort.getNumDataBits()).append(", ");
        sb.append("Num stop bits: ").append(this.currentSerialPort.getNumStopBits()).append(", ");
        sb.append("Parity").append(this.currentSerialPort.getParity().name());
        return sb.toString();
    }

    public static enum Blocking {
        NONBLOCKING(0),
        READ_BLOCKING(16),
        READ_SEMI_BLOCKING(1);

        private final int value;

        private Blocking(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum FlowControl {
        NONE,
        RTSCTS,
        XONXOFF;

    }
}

