/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import jmri.jmrix.AbstractConnectionConfig;
import jmri.jmrix.Bundle;
import jmri.jmrix.SerialPortAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSimulatorConnectionConfig
extends AbstractConnectionConfig {
    protected boolean init = false;
    protected String[] baudList;
    protected SerialPortAdapter adapter;
    private static final Logger log = LoggerFactory.getLogger(AbstractSimulatorConnectionConfig.class);

    public AbstractSimulatorConnectionConfig(SerialPortAdapter p) {
        this.adapter = p;
    }

    @Override
    public SerialPortAdapter getAdapter() {
        return this.adapter;
    }

    public AbstractSimulatorConnectionConfig() {
        log.debug("AbstractSimulatorConnectionConfig null ctor used");
        this.adapter = null;
    }

    @Override
    protected void checkInitDone() {
        log.debug("init called for {}", (Object)this.name());
        if (this.init) {
            return;
        }
        this.addNameEntryCheckers(this.adapter);
        for (Map.Entry entry : this.options.entrySet()) {
            String item = (String)entry.getKey();
            if (!(((AbstractConnectionConfig.Option)entry.getValue()).getComponent() instanceof JComboBox)) continue;
            ((JComboBox)((AbstractConnectionConfig.Option)entry.getValue()).getComponent()).addActionListener(e -> this.adapter.setOptionState(item, ((AbstractConnectionConfig.Option)this.options.get(item)).getItem()));
        }
        this.init = true;
    }

    @Override
    public void updateAdapter() {
        for (Map.Entry entry : this.options.entrySet()) {
            this.adapter.setOptionState((String)entry.getKey(), ((AbstractConnectionConfig.Option)entry.getValue()).getItem());
        }
        if (!this.adapter.getSystemConnectionMemo().setSystemPrefix(this.systemPrefixField.getText())) {
            this.systemPrefixField.setText(this.adapter.getSystemConnectionMemo().getSystemPrefix());
            this.connectionNameField.setText(this.adapter.getSystemConnectionMemo().getUserName());
        }
    }

    @Override
    protected abstract void setInstance();

    @Override
    public String getInfo() {
        return Bundle.getMessage("none");
    }

    @Override
    public void loadDetails(JPanel details) {
        this._details = details;
        this.setInstance();
        if (!this.init) {
            String[] optionsAvailable = this.adapter.getOptions();
            this.options.clear();
            for (String i : optionsAvailable) {
                JComboBox<String> opt = new JComboBox<String>(this.adapter.getOptionChoices(i));
                opt.setSelectedItem(this.adapter.getOptionState(i));
                if (!this.adapter.getOptionState(i).equals(opt.getSelectedItem())) {
                    opt.setSelectedIndex(0);
                    log.warn("Loading found invalid value for option {}, found \"{}\", setting to \"{}\"", new Object[]{i, this.adapter.getOptionState(i), opt.getSelectedItem()});
                    this.adapter.setOptionState(i, (String)opt.getSelectedItem());
                }
                this.options.put(i, new AbstractConnectionConfig.Option(this.adapter.getOptionDisplayName(i), opt, this.adapter.isOptionAdvanced(i)));
            }
        }
        if (this.adapter.getSystemConnectionMemo() != null) {
            this.systemPrefixField.setText(this.adapter.getSystemConnectionMemo().getSystemPrefix());
            this.connectionNameField.setText(this.adapter.getSystemConnectionMemo().getUserName());
        }
        this.NUMOPTIONS += this.options.size();
        this.showAdvanced.setFont(this.showAdvanced.getFont().deriveFont(9.0f));
        this.showAdvanced.setForeground(Color.blue);
        this.showAdvanced.addItemListener(e -> this.showAdvancedItems());
        this.showAdvancedItems();
        this.init = false;
        this.checkInitDone();
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="Type is checked before casting")
    protected void showAdvancedItems() {
        this._details.removeAll();
        this.cL.anchor = 17;
        this.cL.insets = new Insets(2, 5, 0, 5);
        this.cR.insets = new Insets(2, 0, 0, 5);
        this.cR.anchor = 17;
        this.cR.gridx = 1;
        this.cL.gridx = 0;
        this._details.setLayout(this.gbLayout);
        int i = 0;
        boolean incAdvancedOptions = false;
        for (Map.Entry entry : this.options.entrySet()) {
            if (!((AbstractConnectionConfig.Option)entry.getValue()).isAdvanced().booleanValue()) continue;
            incAdvancedOptions = true;
        }
        i = this.addStandardDetails(this.adapter, incAdvancedOptions, i);
        if (this.showAdvanced.isSelected()) {
            for (Map.Entry entry : this.options.entrySet()) {
                if (!((AbstractConnectionConfig.Option)entry.getValue()).isAdvanced().booleanValue()) continue;
                this.cR.gridy = i;
                this.cL.gridy = i++;
                this.gbLayout.setConstraints(((AbstractConnectionConfig.Option)entry.getValue()).getLabel(), this.cL);
                this.gbLayout.setConstraints(((AbstractConnectionConfig.Option)entry.getValue()).getComponent(), this.cR);
                this._details.add(((AbstractConnectionConfig.Option)entry.getValue()).getLabel());
                this._details.add(((AbstractConnectionConfig.Option)entry.getValue()).getComponent());
            }
        }
        this.cL.gridwidth = 2;
        for (JComponent item : this.additionalItems) {
            this.cL.gridy = i++;
            this.gbLayout.setConstraints(item, this.cL);
            this._details.add(item);
        }
        this.cL.gridwidth = 1;
        if (this._details.getParent() != null && this._details.getParent() instanceof JViewport) {
            JViewport vp = (JViewport)this._details.getParent();
            vp.revalidate();
            vp.repaint();
        }
    }

    @Override
    public String getManufacturer() {
        return this.adapter.getManufacturer();
    }

    @Override
    public void setManufacturer(String manufacturer) {
        this.setInstance();
        this.adapter.setManufacturer(manufacturer);
    }

    @Override
    public String getConnectionName() {
        if (this.adapter.getSystemConnectionMemo() != null) {
            return this.adapter.getSystemConnectionMemo().getUserName();
        }
        return null;
    }

    @Override
    public boolean getDisabled() {
        if (this.adapter == null) {
            return true;
        }
        return this.adapter.getDisabled();
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.adapter.setDisabled(disabled);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.adapter != null) {
            this.adapter.dispose();
            this.adapter = null;
        }
    }
}

