/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import jmri.BasicRosterEntry;
import jmri.CommandStation;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.NmraPacket;
import jmri.SpeedStepMode;
import jmri.SystemConnectionMemo;
import jmri.Throttle;
import jmri.ThrottleListener;
import jmri.beans.PropertyChangeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThrottle
extends PropertyChangeSupport
implements DccThrottle {
    @GuardedBy(value="this")
    protected float speedSetting;
    protected SpeedStepMode speedStepMode = SpeedStepMode.UNKNOWN;
    protected boolean isForward;
    private final boolean[] FUNCTION_BOOLEAN_ARRAY;
    private final boolean[] FUNCTION_MOMENTARY_BOOLEAN_ARRAY;
    protected static final int[] FUNCTION_GROUPS = new int[]{1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10};
    protected boolean active = true;
    protected SystemConnectionMemo adapterMemo;
    private Boolean _dispatchEnabled = null;
    private Boolean _releaseEnabled = null;
    long durationRunning = 0L;
    protected long start;
    @GuardedBy(value="this")
    BasicRosterEntry re = null;
    private static final Logger log = LoggerFactory.getLogger(AbstractThrottle.class);

    public AbstractThrottle(SystemConnectionMemo memo) {
        this.adapterMemo = memo;
        this.FUNCTION_BOOLEAN_ARRAY = new boolean[29];
        this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY = new boolean[29];
    }

    public AbstractThrottle(SystemConnectionMemo memo, int totalFunctions) {
        this.adapterMemo = memo;
        this.FUNCTION_BOOLEAN_ARRAY = new boolean[totalFunctions];
        this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY = new boolean[totalFunctions];
    }

    @Override
    public synchronized float getSpeedSetting() {
        return this.speedSetting;
    }

    @Override
    public void setSpeedSetting(float speed) {
        this.setSpeedSetting(speed, false, false);
        this.record(speed);
    }

    @Override
    public synchronized void setSpeedSetting(float speed, boolean allowDuplicates, boolean allowDuplicatesOnStop) {
        if ((double)Math.abs(this.speedSetting - speed) > 1.0E-4) {
            this.speedSetting = speed;
            this.firePropertyChange("SpeedSetting", Float.valueOf(this.speedSetting), Float.valueOf(this.speedSetting));
        }
        this.record(speed);
    }

    @Override
    public void setSpeedSettingAgain(float speed) {
        this.setSpeedSetting(speed, true, true);
    }

    @Override
    public boolean getIsForward() {
        return this.isForward;
    }

    @Override
    public void setIsForward(boolean forward) {
        this.isForward = forward;
        this.firePropertyChange("IsForward", this.isForward, this.isForward);
    }

    @Override
    @Nonnull
    public boolean[] getFunctions() {
        return Arrays.copyOf(this.FUNCTION_BOOLEAN_ARRAY, this.FUNCTION_BOOLEAN_ARRAY.length);
    }

    @Override
    @Nonnull
    public boolean[] getFunctionsMomentary() {
        return Arrays.copyOf(this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY, this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY.length);
    }

    @Override
    public boolean getFunction(int fN) {
        if (fN < 0 || fN > this.FUNCTION_BOOLEAN_ARRAY.length - 1) {
            log.warn("Unhandled get function: {} {}", (Object)fN, (Object)this.getClass().getName());
            return false;
        }
        return this.FUNCTION_BOOLEAN_ARRAY[fN];
    }

    protected boolean getFunctionNoWarn(int fN) {
        if (fN < 0 || fN > this.FUNCTION_BOOLEAN_ARRAY.length - 1) {
            return false;
        }
        return this.FUNCTION_BOOLEAN_ARRAY[fN];
    }

    @Override
    public boolean getFunctionMomentary(int fN) {
        if (fN < 0 || fN > this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY.length - 1) {
            log.warn("Unhandled get momentary function: {} {}", (Object)fN, (Object)this.getClass().getName());
            return false;
        }
        return this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY[fN];
    }

    protected boolean getFunctionMomentaryNoWarn(int fN) {
        if (fN < 0 || fN > this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY.length - 1) {
            return false;
        }
        return this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY[fN];
    }

    protected void notifyThrottleDisconnect() {
        this.firePropertyChange("ThrottleConnected", true, false);
    }

    @Override
    public void notifyThrottleDispatchEnabled(boolean newVal) {
        this._dispatchEnabled = newVal;
        this.firePropertyChange("DispatchEnabled", this._dispatchEnabled, this._dispatchEnabled);
    }

    @Override
    public void notifyThrottleReleaseEnabled(boolean newVal) {
        this._releaseEnabled = newVal;
        this.firePropertyChange("ReleaseEnabled", this._releaseEnabled, this._releaseEnabled);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            return;
        }
        log.debug("addPropertyChangeListener(): Adding property change {} to {}", (Object)l.getClass().getSimpleName(), (Object)this.getLocoAddress());
        if (Arrays.asList(this.getPropertyChangeListeners()).contains(l)) {
            log.warn("Preventing {} adding duplicate PCL to {}", (Object)l.getClass().getSimpleName(), (Object)this.getClass().getName());
            return;
        }
        super.addPropertyChangeListener(l);
        log.debug("addPropertyChangeListener(): throttle: {} listeners size is {}", (Object)this.getLocoAddress(), (Object)this.getPropertyChangeListeners().length);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            return;
        }
        log.debug("removePropertyChangeListener(): Removing property change {} from {}", (Object)l.getClass().getSimpleName(), (Object)this.getLocoAddress());
        super.removePropertyChangeListener(l);
        log.debug("removePropertyChangeListener(): throttle: {} listeners size is {}", (Object)this.getLocoAddress(), (Object)this.getPropertyChangeListeners().length);
        if (this.getPropertyChangeListeners().length == 0) {
            log.debug("No listeners so calling ThrottleManager.dispose with an empty ThrottleListener for {}", (Object)this.getLocoAddress());
            InstanceManager.throttleManagerInstance().disposeThrottle(this, new ThrottleListener(){

                @Override
                public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
                }

                @Override
                public void notifyThrottleFound(DccThrottle t) {
                }

                @Override
                public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
                }
            });
        }
    }

    @Override
    public void dispose(ThrottleListener l) {
        if (!this.active) {
            log.error("Dispose called when not active {}", (Object)this.getClass().getName());
        }
        InstanceManager.throttleManagerInstance().disposeThrottle(this, l);
    }

    @Override
    public void dispatch(ThrottleListener l) {
        if (!this.active) {
            log.warn("dispatch called when not active {}", (Object)this.getClass().getName());
        }
        InstanceManager.throttleManagerInstance().dispatchThrottle(this, l);
    }

    @Override
    public void release(ThrottleListener l) {
        if (!this.active) {
            log.warn("release called when not active {}", (Object)this.getClass().getName());
        }
        InstanceManager.throttleManagerInstance().releaseThrottle(this, l);
    }

    protected abstract void throttleDispose();

    @Override
    public float getSpeedIncrement() {
        return this.speedStepMode.increment;
    }

    protected void sendFunctionGroup(int functionNum, boolean momentary) {
        switch (FUNCTION_GROUPS[functionNum]) {
            case 1: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup1();
                    break;
                }
                this.sendFunctionGroup1();
                break;
            }
            case 2: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup2();
                    break;
                }
                this.sendFunctionGroup2();
                break;
            }
            case 3: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup3();
                    break;
                }
                this.sendFunctionGroup3();
                break;
            }
            case 4: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup4();
                    break;
                }
                this.sendFunctionGroup4();
                break;
            }
            case 5: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup5();
                    break;
                }
                this.sendFunctionGroup5();
                break;
            }
            case 6: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup6();
                    break;
                }
                this.sendFunctionGroup6();
                break;
            }
            case 7: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup7();
                    break;
                }
                this.sendFunctionGroup7();
                break;
            }
            case 8: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup8();
                    break;
                }
                this.sendFunctionGroup8();
                break;
            }
            case 9: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup9();
                    break;
                }
                this.sendFunctionGroup9();
                break;
            }
            case 10: {
                if (momentary) {
                    this.sendMomentaryFunctionGroup10();
                    break;
                }
                this.sendFunctionGroup10();
                break;
            }
        }
    }

    @Override
    public void setFunction(int functionNum, boolean newState) {
        if (functionNum < 0 || functionNum > this.FUNCTION_BOOLEAN_ARRAY.length - 1) {
            log.warn("Unhandled set function number: {} {}", (Object)functionNum, (Object)this.getClass().getName());
            return;
        }
        boolean old = this.FUNCTION_BOOLEAN_ARRAY[functionNum];
        this.FUNCTION_BOOLEAN_ARRAY[functionNum] = newState;
        this.sendFunctionGroup(functionNum, false);
        this.firePropertyChange(Throttle.getFunctionString(functionNum), old, newState);
    }

    public void updateFunction(int fn, boolean state) {
        if (fn < 0 || fn > this.FUNCTION_BOOLEAN_ARRAY.length - 1) {
            log.warn("Unhandled update function number: {} {}", (Object)fn, (Object)this.getClass().getName());
            return;
        }
        boolean old = this.FUNCTION_BOOLEAN_ARRAY[fn];
        this.FUNCTION_BOOLEAN_ARRAY[fn] = state;
        this.firePropertyChange(Throttle.getFunctionString(fn), old, state);
    }

    public void updateFunctionMomentary(int fn, boolean state) {
        if (fn < 0 || fn > this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY.length - 1) {
            log.warn("Unhandled update momentary function number: {} {}", (Object)fn, (Object)this.getClass().getName());
            return;
        }
        boolean old = this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY[fn];
        this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY[fn] = state;
        this.firePropertyChange(Throttle.getFunctionMomentaryString(fn), old, state);
    }

    protected void sendFunctionGroup1() {
        log.error("sendFunctionGroup1 needs to be implemented if invoked");
    }

    protected void sendFunctionGroup2() {
        log.error("sendFunctionGroup2 needs to be implemented if invoked");
    }

    protected void sendFunctionGroup3() {
        log.error("sendFunctionGroup3 needs to be implemented if invoked");
    }

    protected void sendFunctionGroup4() {
        DccLocoAddress a = (DccLocoAddress)this.getLocoAddress();
        byte[] result = NmraPacket.function13Through20Packet(a.getNumber(), a.isLongAddress(), this.getFunction(13), this.getFunction(14), this.getFunction(15), this.getFunction(16), this.getFunction(17), this.getFunction(18), this.getFunction(19), this.getFunction(20));
        if (result == null) {
            return;
        }
        CommandStation c = this.adapterMemo != null && this.adapterMemo.get(CommandStation.class) != null ? this.adapterMemo.get(CommandStation.class) : InstanceManager.getNullableDefault(CommandStation.class);
        if (c != null) {
            c.sendPacket(result, 3);
        } else {
            log.error("Can't send F13-F20 since no command station defined");
        }
    }

    protected void sendFunctionGroup5() {
        DccLocoAddress a = (DccLocoAddress)this.getLocoAddress();
        byte[] result = NmraPacket.function21Through28Packet(a.getNumber(), a.isLongAddress(), this.getFunction(21), this.getFunction(22), this.getFunction(23), this.getFunction(24), this.getFunction(25), this.getFunction(26), this.getFunction(27), this.getFunction(28));
        if (result == null) {
            return;
        }
        CommandStation c = this.adapterMemo != null && this.adapterMemo.get(CommandStation.class) != null ? this.adapterMemo.get(CommandStation.class) : InstanceManager.getNullableDefault(CommandStation.class);
        if (c != null) {
            c.sendPacket(result, 3);
        } else {
            log.error("Can't send F21-F28 since no command station defined");
        }
    }

    protected void sendFunctionGroup6() {
        log.error("sendFunctionGroup6 needs to be implemented if invoked");
    }

    protected void sendFunctionGroup7() {
        log.error("sendFunctionGroup7 needs to be implemented if invoked");
    }

    protected void sendFunctionGroup8() {
        log.error("sendFunctionGroup8 needs to be implemented if invoked");
    }

    protected void sendFunctionGroup9() {
        log.error("sendFunctionGroup9 needs to be implemented if invoked");
    }

    protected void sendFunctionGroup10() {
        log.error("sendFunctionGroup10 needs to be implemented if invoked");
    }

    @Override
    public void setFunctionMomentary(int momFuncNum, boolean state) {
        if (momFuncNum < 0 || momFuncNum > this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY.length - 1) {
            log.warn("Unhandled set momentary function number: {} {}", (Object)momFuncNum, (Object)this.getClass().getName());
            return;
        }
        boolean old = this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY[momFuncNum];
        this.FUNCTION_MOMENTARY_BOOLEAN_ARRAY[momFuncNum] = state;
        this.sendFunctionGroup(momFuncNum, true);
        this.firePropertyChange(Throttle.getFunctionMomentaryString(momFuncNum), old, state);
    }

    protected void sendMomentaryFunctionGroup1() {
    }

    protected void sendMomentaryFunctionGroup2() {
    }

    protected void sendMomentaryFunctionGroup3() {
    }

    protected void sendMomentaryFunctionGroup4() {
    }

    protected void sendMomentaryFunctionGroup5() {
    }

    protected void sendMomentaryFunctionGroup6() {
    }

    protected void sendMomentaryFunctionGroup7() {
    }

    protected void sendMomentaryFunctionGroup8() {
    }

    protected void sendMomentaryFunctionGroup9() {
    }

    protected void sendMomentaryFunctionGroup10() {
    }

    @Override
    public void setSpeedStepMode(SpeedStepMode mode) {
        log.debug("Speed Step Mode Change from:{} to:{}", (Object)this.speedStepMode, (Object)mode);
        this.speedStepMode = mode;
        this.firePropertyChange("SpeedSteps", (Object)this.speedStepMode, (Object)this.speedStepMode);
    }

    @Override
    public SpeedStepMode getSpeedStepMode() {
        return this.speedStepMode;
    }

    protected synchronized void record(float speed) {
        if (this.re == null) {
            return;
        }
        if (speed == 0.0f) {
            this.stopClock();
        } else {
            this.startClock();
        }
    }

    protected synchronized void startClock() {
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        }
    }

    void stopClock() {
        if (this.start == 0L) {
            return;
        }
        long stop = System.currentTimeMillis();
        this.durationRunning += (stop - this.start) / 1000L;
        this.start = 0L;
    }

    protected synchronized void finishRecord() {
        if (this.re == null) {
            return;
        }
        this.stopClock();
        String currentDurationString = this.re.getAttribute("OperatingDuration");
        long currentDuration = 0L;
        if (currentDurationString == null) {
            currentDurationString = "0";
            log.info("operating duration for {} starts as zero", (Object)this.getLocoAddress());
        }
        try {
            currentDuration = Long.parseLong(currentDurationString);
        }
        catch (NumberFormatException e) {
            log.warn("current stored duration is not a valid number \"{} \"", (Object)currentDurationString);
        }
        this.re.putAttribute("OperatingDuration", "" + (currentDuration += this.durationRunning));
        this.re.putAttribute("LastOperated", new StdDateFormat().format(new Date()));
        if (!this.re.isOpen()) {
            this.re.store();
        } else {
            log.warn("Roster Entry {} running time not saved as entry is already open for editing", (Object)this.re.getId());
        }
        this.re = null;
    }

    @Override
    public synchronized void setRosterEntry(BasicRosterEntry re) {
        this.re = re;
    }

    @Override
    public synchronized BasicRosterEntry getRosterEntry() {
        return this.re;
    }

    protected int intSpeed(float speed) {
        return AbstractThrottle.intSpeed(speed, 127);
    }

    protected static int intSpeed(float speed, int steps) {
        if (speed < 0.0f) {
            return 1;
        }
        int value = Math.round(speed *= (float)(steps - 1));
        if (speed > 0.0f && speed <= 0.5f) {
            value = 1;
        }
        if (value < 0) {
            Exception ex = new Exception("Please send logs to the JMRI developers.");
            log.error("Error calculating speed.", (Throwable)ex);
            return 1;
        }
        if (value >= steps) {
            return steps;
        }
        if (value > 0) {
            return value + 1;
        }
        return 0;
    }
}

