/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import jmri.InstanceManager;
import jmri.jmrix.Bundle;
import jmri.jmrix.swing.ComponentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveSystemsMenu
extends JMenu {
    private static final Logger log = LoggerFactory.getLogger(ActiveSystemsMenu.class);

    public ActiveSystemsMenu(String name) {
        this();
        this.setText(name);
        ActiveSystemsMenu.addItems(this);
    }

    public ActiveSystemsMenu() {
        this.setText(Bundle.getMessage("MenuSystems"));
        ActiveSystemsMenu.addItems(this);
    }

    public static void addItems(JMenuBar m) {
        List<ComponentFactory> list = InstanceManager.getList(ComponentFactory.class);
        for (ComponentFactory memo : list) {
            try {
                JMenu menu = memo.getMenu();
                if (menu == null) continue;
                m.add(menu);
            }
            catch (RuntimeException ex) {
                log.error("Proceeding after error while trying to create menu for {}", memo.getClass(), (Object)ex);
            }
        }
    }

    public static void addItems(JMenu m) {
        List<ComponentFactory> list = InstanceManager.getList(ComponentFactory.class);
        for (ComponentFactory memo : list) {
            JMenu menu = memo.getMenu();
            if (menu == null) continue;
            m.add(menu);
        }
    }

    static JMenu getMenu(String className) {
        try {
            return (JMenu)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Could not load class {}", (Object)className, (Object)e);
            return null;
        }
    }
}

