/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.configurexml.ClassMigrationManager;
import jmri.configurexml.ConfigXmlManager;
import jmri.configurexml.ErrorHandler;
import jmri.configurexml.ErrorMemo;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.configurexml.XmlAdapter;
import jmri.jmrix.Bundle;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionTypeList;
import jmri.profile.Profile;
import jmri.profile.ProfileUtils;
import jmri.spi.PreferencesManager;
import jmri.util.jdom.JDOMUtil;
import jmri.util.prefs.AbstractPreferencesManager;
import jmri.util.prefs.HasConnectionButUnableToConnectException;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfigManager
extends AbstractPreferencesManager
implements Iterable<ConnectionConfig> {
    private final ArrayList<ConnectionConfig> connections = new ArrayList();
    private static final String NAMESPACE = "http://jmri.org/xml/schema/auxiliary-configuration/connections-2-9-6.xsd";
    public static final String CONNECTIONS = "connections";
    public static final String CONNECTION = "connection";
    public static final String CLASS = "class";
    public static final String USER_NAME = "userName";
    public static final String SYSTEM_NAME = "systemPrefix";
    public static final String MANUFACTURER = "manufacturer";
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfigManager.class);

    @Override
    public void initialize(Profile profile) throws HasConnectionButUnableToConnectException {
        if (!this.isInitialized(profile)) {
            log.debug("Initializing...");
            Element sharedConnections = null;
            Element perNodeConnections = null;
            this.setPortNamePattern();
            try {
                sharedConnections = JDOMUtil.toJDOMElement(ProfileUtils.getAuxiliaryConfiguration(profile).getConfigurationFragment(CONNECTIONS, NAMESPACE, true));
            }
            catch (NullPointerException ex) {
                log.info("No connections configured.");
                log.debug("Null pointer thrown reading shared configuration.", (Throwable)ex);
            }
            if (sharedConnections != null) {
                try {
                    perNodeConnections = JDOMUtil.toJDOMElement(ProfileUtils.getAuxiliaryConfiguration(profile).getConfigurationFragment(CONNECTIONS, NAMESPACE, false));
                }
                catch (NullPointerException ex) {
                    log.info("No local configuration found.");
                    log.debug("Null pointer thrown reading local configuration.", (Throwable)ex);
                }
                Iterator ex = sharedConnections.getChildren(CONNECTION).iterator();
                while (ex.hasNext()) {
                    String localized;
                    String english;
                    String newClassName;
                    Element shared;
                    Element perNode = shared = (Element)ex.next();
                    String className = shared.getAttributeValue(CLASS);
                    String userName = shared.getAttributeValue(USER_NAME, "");
                    String systemName = shared.getAttributeValue(SYSTEM_NAME, "");
                    String manufacturer = shared.getAttributeValue(MANUFACTURER, "");
                    log.debug("Read shared connection {}:{} ({}) class {}", new Object[]{userName, systemName, manufacturer, className});
                    if (perNodeConnections != null) {
                        for (Element e : perNodeConnections.getChildren(CONNECTION)) {
                            if (!systemName.equals(e.getAttributeValue(SYSTEM_NAME))) continue;
                            perNode = e;
                            className = perNode.getAttributeValue(CLASS);
                            userName = perNode.getAttributeValue(USER_NAME, "");
                            manufacturer = perNode.getAttributeValue(MANUFACTURER, "");
                            log.debug("Read perNode connection {}:{} ({}) class {}", new Object[]{userName, systemName, manufacturer, className});
                        }
                    }
                    if (!className.equals(newClassName = InstanceManager.getDefault(ClassMigrationManager.class).getClassName(className))) {
                        log.info("Class {} will be used for connection {} instead of {} if preferences are saved", new Object[]{newClassName, userName, className});
                        className = newClassName;
                    }
                    try {
                        log.debug("Creating connection {}:{} ({}) class {}", new Object[]{userName, systemName, manufacturer, className});
                        XmlAdapter adapter = (XmlAdapter)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        ConnectionConfigManagerErrorHandler handler = new ConnectionConfigManagerErrorHandler();
                        adapter.setExceptionHandler(handler);
                        if (!adapter.load(shared, perNode)) {
                            log.error("Unable to create {} for {}, load returned false", (Object)className, (Object)shared);
                            String english2 = Bundle.getMessage(Locale.ENGLISH, "ErrorSingleConnection", userName, systemName);
                            String localized2 = Bundle.getMessage("ErrorSingleConnection", userName, systemName);
                            this.addInitializationException(profile, new HasConnectionButUnableToConnectException(english2, localized2));
                        }
                        handler.exceptions.forEach((? super E exception) -> this.addInitializationException(profile, (Exception)exception));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex2) {
                        log.error("Unable to create {} for {}", new Object[]{className, shared, ex2});
                        english = Bundle.getMessage(Locale.ENGLISH, "ErrorSingleConnection", userName, systemName);
                        localized = Bundle.getMessage("ErrorSingleConnection", userName, systemName);
                        this.addInitializationException(profile, new HasConnectionButUnableToConnectException(english, localized, ex2));
                    }
                    catch (RuntimeException | JmriConfigureXmlException ex3) {
                        log.error("Unable to load {} into {}", new Object[]{shared, className, ex3});
                        english = Bundle.getMessage(Locale.ENGLISH, "ErrorSingleConnection", userName, systemName);
                        localized = Bundle.getMessage("ErrorSingleConnection", userName, systemName);
                        this.addInitializationException(profile, new HasConnectionButUnableToConnectException(english, localized, ex3));
                    }
                }
            }
            this.setInitialized(profile, true);
            List<Exception> exceptions = this.getInitializationExceptions(profile);
            if (exceptions.size() == 1) {
                if (exceptions.get(0) instanceof HasConnectionButUnableToConnectException) {
                    throw (HasConnectionButUnableToConnectException)exceptions.get(0);
                }
                throw new HasConnectionButUnableToConnectException(exceptions.get(0));
            }
            if (exceptions.size() > 1) {
                String english = Bundle.getMessage(Locale.ENGLISH, "ErrorMultipleConnections");
                String localized = Bundle.getMessage("ErrorMultipleConnections");
                throw new HasConnectionButUnableToConnectException(english, localized);
            }
            log.debug("Initialized...");
        }
    }

    @Override
    @Nonnull
    public Set<Class<? extends PreferencesManager>> getRequires() {
        return new HashSet<Class<? extends PreferencesManager>>();
    }

    @Override
    public void savePreferences(Profile profile) {
        log.debug("Saving connections preferences...");
        this.savePreferences(profile, true);
        this.savePreferences(profile, false);
        log.debug("Saved connections preferences...");
    }

    private synchronized void savePreferences(Profile profile, boolean shared) {
        Element element = new Element(CONNECTIONS, NAMESPACE);
        this.connections.stream().forEach(o -> {
            log.debug("Saving connection {} ({})...", (Object)o.getConnectionName(), (Object)shared);
            Element e = ConfigXmlManager.elementFromObject(o, shared);
            if (e != null) {
                element.addContent((Content)e);
            }
        });
        try {
            ProfileUtils.getAuxiliaryConfiguration(profile).putConfigurationFragment(JDOMUtil.toW3CElement(element), shared);
        }
        catch (JDOMException ex) {
            log.error("Unable to create create XML", (Throwable)ex);
        }
    }

    public boolean add(@Nonnull ConnectionConfig c) throws NullPointerException {
        if (c == null) {
            throw new NullPointerException();
        }
        if (!this.connections.contains(c)) {
            boolean result = this.connections.add(c);
            int i = this.connections.indexOf(c);
            this.fireIndexedPropertyChange(CONNECTIONS, i, null, c);
            return result;
        }
        return false;
    }

    public boolean remove(@Nonnull ConnectionConfig c) {
        int i = this.connections.indexOf(c);
        boolean result = this.connections.remove(c);
        if (result) {
            this.fireIndexedPropertyChange(CONNECTIONS, i, c, null);
        }
        return result;
    }

    @Nonnull
    public ConnectionConfig[] getConnections() {
        return this.connections.toArray(new ConnectionConfig[this.connections.size()]);
    }

    public ConnectionConfig getConnections(int index) {
        return this.connections.get(index);
    }

    @Override
    public Iterator<ConnectionConfig> iterator() {
        return this.connections.iterator();
    }

    @Nonnull
    public String[] getConnectionTypes(@Nonnull String manufacturer) {
        return this.getDefaultConnectionTypeManager().getConnectionTypes(manufacturer);
    }

    @Nonnull
    public String[] getConnectionManufacturers() {
        return this.getDefaultConnectionTypeManager().getConnectionManufacturers();
    }

    @CheckForNull
    public String getConnectionManufacturer(@Nonnull String connectionType) {
        for (String manufacturer : this.getConnectionManufacturers()) {
            for (String manufacturerType : this.getConnectionTypes(manufacturer)) {
                if (!connectionType.equals(manufacturerType)) continue;
                return manufacturer;
            }
        }
        return null;
    }

    @Nonnull
    public String[] getConnectionManufacturers(@Nonnull String connectionType) {
        ArrayList<String> manufacturers = new ArrayList<String>();
        for (String manufacturer : this.getConnectionManufacturers()) {
            for (String manufacturerType : this.getConnectionTypes(manufacturer)) {
                if (!connectionType.equals(manufacturerType)) continue;
                manufacturers.add(manufacturer);
            }
        }
        return manufacturers.toArray(new String[manufacturers.size()]);
    }

    private ConnectionTypeManager getDefaultConnectionTypeManager() {
        if (InstanceManager.getNullableDefault(ConnectionTypeManager.class) == null) {
            InstanceManager.setDefault(ConnectionTypeManager.class, new ConnectionTypeManager());
        }
        return InstanceManager.getDefault(ConnectionTypeManager.class);
    }

    private void setPortNamePattern() {
        String pattern = "purejavacomm.portnamepattern";
        Properties properties = System.getProperties();
        if (properties.getProperty("purejavacomm.portnamepattern") == null) {
            try (InputStream in = ConnectionConfigManager.class.getResourceAsStream("PortNamePatterns.properties");){
                properties.load(in);
            }
            catch (IOException ex) {
                log.error("Unable to read PortNamePatterns.properties", (Throwable)ex);
            }
        }
    }

    private static class ConnectionConfigManagerErrorHandler
    extends ErrorHandler {
        ArrayList<HasConnectionButUnableToConnectException> exceptions = new ArrayList();

        @Override
        public void handle(ErrorMemo memo) {
            if (memo.exception != null) {
                this.exceptions.add(new HasConnectionButUnableToConnectException(memo.description, Bundle.getMessage("ErrorSubException", memo.description), memo.exception));
            } else {
                this.exceptions.add(new HasConnectionButUnableToConnectException(memo.description, Bundle.getMessage("ErrorSubException", memo.description) + memo.description));
            }
        }
    }

    private static class ProxyConnectionTypeList
    implements ConnectionTypeList {
        private final ArrayList<ConnectionTypeList> connectionTypeLists = new ArrayList();

        public ProxyConnectionTypeList(@Nonnull ConnectionTypeList connectionTypeList) {
            log.debug("Creating proxy for {}", (Object)connectionTypeList.getManufacturers()[0]);
            this.add(connectionTypeList);
        }

        public final void add(@Nonnull ConnectionTypeList connectionTypeList) {
            log.debug("Adding {} to proxy", (Object)connectionTypeList.getClass().getName());
            this.connectionTypeLists.add(connectionTypeList);
        }

        @Override
        @Nonnull
        public String[] getAvailableProtocolClasses() {
            TreeSet classes = new TreeSet();
            this.connectionTypeLists.stream().forEach(connectionTypeList -> classes.addAll(Arrays.asList(connectionTypeList.getAvailableProtocolClasses())));
            return classes.toArray(new String[classes.size()]);
        }

        @Override
        @Nonnull
        public String[] getManufacturers() {
            TreeSet manufacturers = new TreeSet();
            this.connectionTypeLists.stream().forEach(connectionTypeList -> manufacturers.addAll(Arrays.asList(connectionTypeList.getManufacturers())));
            return manufacturers.toArray(new String[manufacturers.size()]);
        }
    }

    private static class ConnectionTypeManager {
        private final HashMap<String, ConnectionTypeList> connectionTypeLists = new HashMap();

        public ConnectionTypeManager() {
            for (ConnectionTypeList ctl : ServiceLoader.load(ConnectionTypeList.class)) {
                for (String manufacturer : ctl.getManufacturers()) {
                    if (!this.connectionTypeLists.containsKey(manufacturer)) {
                        this.connectionTypeLists.put(manufacturer, ctl);
                        log.debug("Added {} connectionTypeList", (Object)manufacturer);
                        continue;
                    }
                    log.debug("Need a proxy for {} from {} in {}", new Object[]{manufacturer, ctl.getClass().getName(), this});
                    ConnectionTypeList existing = this.connectionTypeLists.get(manufacturer);
                    ProxyConnectionTypeList proxy = existing instanceof ProxyConnectionTypeList ? (ProxyConnectionTypeList)existing : new ProxyConnectionTypeList(existing);
                    proxy.add(ctl);
                    this.connectionTypeLists.put(manufacturer, proxy);
                }
            }
        }

        public String[] getConnectionTypes(String manufacturer) {
            ConnectionTypeList ctl = this.connectionTypeLists.get(manufacturer);
            if (ctl != null) {
                return ctl.getAvailableProtocolClasses();
            }
            return this.connectionTypeLists.get("None").getAvailableProtocolClasses();
        }

        public String[] getConnectionManufacturers() {
            ArrayList<String> a = new ArrayList<String>(this.connectionTypeLists.keySet());
            a.remove("None");
            a.sort(null);
            a.add(0, "None");
            return a.toArray(new String[a.size()]);
        }
    }
}

