/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionStatus {
    public static final String CONNECTION_UNKNOWN = "Unknown";
    public static final String CONNECTION_UP = "Connected";
    public static final String CONNECTION_DOWN = "Not Connected";
    private final HashMap<ConnectionKey, String> portStatus = new HashMap();
    private static ConnectionStatus _instance = null;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final Logger log = LoggerFactory.getLogger(ConnectionStatus.class);

    public static synchronized ConnectionStatus instance() {
        if (_instance == null) {
            log.debug("ConnectionStatus creating instance");
            _instance = new ConnectionStatus();
        }
        return _instance;
    }

    static synchronized void clearInstance() {
        _instance = null;
    }

    private ConnectionStatus() {
    }

    public synchronized void addConnection(String systemName, @Nonnull String portName) {
        log.debug("addConnection systemName {} portName {}", (Object)systemName, (Object)portName);
        ConnectionKey newKey = new ConnectionKey(systemName, portName);
        if (!this.portStatus.containsKey(newKey)) {
            this.portStatus.put(newKey, CONNECTION_UNKNOWN);
            this.firePropertyChange("add", null, portName);
        }
    }

    public synchronized void setConnectionState(String systemName, @Nonnull String portName, @Nonnull String state) {
        log.debug("setConnectionState systemName: {} portName: {} state: {}", new Object[]{systemName, portName, state});
        ConnectionKey newKey = new ConnectionKey(systemName, portName);
        if (!this.portStatus.containsKey(newKey)) {
            this.portStatus.put(newKey, state);
            this.firePropertyChange("add", null, portName);
            log.debug("New Connection added: {} ", (Object)newKey);
        } else {
            this.firePropertyChange("change", this.portStatus.put(newKey, state), portName);
        }
    }

    public synchronized String getConnectionState(String systemName, @Nonnull String portName) {
        log.debug("getConnectionState systemName: {} portName: {}", (Object)systemName, (Object)portName);
        String stateText = CONNECTION_UNKNOWN;
        ConnectionKey newKey = new ConnectionKey(systemName, portName);
        if (this.portStatus.containsKey(newKey)) {
            stateText = this.portStatus.get(newKey);
            log.debug("connection found : {}", (Object)stateText);
        } else {
            log.debug("connection systemName {} portName {} not found, {}", new Object[]{systemName, portName, stateText});
        }
        return stateText;
    }

    public synchronized String getSystemState(@Nonnull String systemName) {
        log.debug("getSystemState systemName: {} ", (Object)systemName);
        for (Map.Entry<ConnectionKey, String> entry : this.portStatus.entrySet()) {
            if (entry.getKey().getSystemName() == null || !entry.getKey().getSystemName().equals(systemName)) continue;
            return entry.getValue();
        }
        log.warn("Didn't find system status for system {}", (Object)systemName);
        return CONNECTION_UNKNOWN;
    }

    public synchronized boolean isConnectionOk(String systemName, @Nonnull String portName) {
        String stateText = this.getConnectionState(systemName, portName);
        return !stateText.equals(CONNECTION_DOWN);
    }

    public synchronized boolean isSystemOk(@Nonnull String systemName) {
        for (Map.Entry<ConnectionKey, String> entry : this.portStatus.entrySet()) {
            if (entry.getKey().getSystemName() == null || !entry.getKey().getSystemName().equals(systemName)) continue;
            return !this.portStatus.get(entry.getKey()).equals(CONNECTION_DOWN);
        }
        return true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    protected void firePropertyChange(@Nonnull String p, Object old, Object n) {
        log.debug("firePropertyChange {} old: {} new: {}", new Object[]{p, old, n});
        this.pcs.firePropertyChange(p, old, n);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private static class ConnectionKey {
        String portName = null;
        String systemName = null;

        public ConnectionKey(String system, @Nonnull String port) {
            if (system == null && port == null) {
                throw new IllegalArgumentException("At least the port name must be provided");
            }
            this.systemName = system;
            this.portName = port;
        }

        public String getSystemName() {
            return this.systemName;
        }

        public String getPortName() {
            return this.portName;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ConnectionKey)) {
                return false;
            }
            ConnectionKey other = (ConnectionKey)o;
            return (this.systemName == null ? other.getSystemName() == null : this.systemName.equals(other.getSystemName())) && (this.portName == null ? other.getPortName() == null : this.portName.equals(other.getPortName()));
        }

        public int hashCode() {
            if (this.systemName == null) {
                return this.portName.hashCode();
            }
            if (this.portName == null) {
                return this.systemName.hashCode();
            }
            return this.systemName.hashCode() + this.portName.hashCode();
        }
    }
}

