/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import jmri.util.startup.AbstractStartupActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundleStartupActionFactory
extends AbstractStartupActionFactory {
    private final ResourceBundle bundle;
    private Class<?>[] classes;
    private static final Logger log = LoggerFactory.getLogger(ResourceBundleStartupActionFactory.class);

    protected ResourceBundleStartupActionFactory(ResourceBundle resource) {
        this.bundle = resource;
    }

    @Override
    public String getTitle(Class<?> clazz, Locale locale) throws IllegalArgumentException {
        if (Arrays.asList(this.getActionClasses()).contains(clazz)) {
            return ResourceBundle.getBundle(this.bundle.getBaseBundleName(), locale).getString(clazz.getName());
        }
        throw new IllegalArgumentException(clazz.getName() + " is not supported by " + this.getClass().getName());
    }

    @Override
    public Class<?>[] getActionClasses() {
        if (this.classes == null) {
            if (this.bundle != null) {
                HashSet set = new HashSet();
                this.bundle.keySet().forEach(k -> {
                    try {
                        set.add(Class.forName(k));
                    }
                    catch (ClassNotFoundException ex) {
                        log.error("Specified class {} not found.", k, (Object)ex);
                    }
                });
                this.classes = set.toArray(new Class[set.size()]);
            } else {
                this.classes = new Class[0];
            }
        }
        return this.classes;
    }
}

