/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix;

import java.io.InputStream;
import java.io.OutputStream;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.SerialPortDataListener;

public interface SerialPort {
    public static final int LISTENING_EVENT_DATA_AVAILABLE = 1;
    public static final int ONE_STOP_BIT = 1;
    public static final int NO_PARITY = 0;

    public void addDataListener(SerialPortDataListener var1);

    public InputStream getInputStream();

    public OutputStream getOutputStream();

    public void setRTS();

    public void clearRTS();

    public void setBaudRate(int var1);

    public int getBaudRate();

    public void setNumDataBits(int var1);

    public int getNumDataBits();

    public void setNumStopBits(int var1);

    public int getNumStopBits();

    public void setParity(Parity var1);

    public Parity getParity();

    public void setDTR();

    public void clearDTR();

    public boolean getDTR();

    public boolean getRTS();

    public boolean getDSR();

    public boolean getCTS();

    public boolean getDCD();

    public boolean getRI();

    public void setFlowControl(AbstractSerialPortController.FlowControl var1);

    public void setBreak();

    public void clearBreak();

    public int getFlowControlSettings();

    public boolean setComPortTimeouts(int var1, int var2, int var3);

    public void closePort();

    public String getDescriptivePortName();

    public String toString();

    public static enum Parity {
        NONE(0),
        EVEN(2),
        ODD(1);

        private final int value;

        private Parity(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Parity getParity(int parity) {
            for (Parity p : Parity.values()) {
                if (p.value != parity) continue;
                return p;
            }
            throw new IllegalArgumentException("Unknown parity");
        }
    }
}

