/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.acela;

import jmri.implementation.AbstractLight;
import jmri.jmrix.acela.AcelaAddress;
import jmri.jmrix.acela.AcelaNode;
import jmri.jmrix.acela.AcelaSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcelaLight
extends AbstractLight {
    AcelaSystemConnectionMemo _memo = null;
    int mBit = -1;
    private static final Logger log = LoggerFactory.getLogger(AcelaLight.class);

    public AcelaLight(String systemName, AcelaSystemConnectionMemo memo) {
        super(systemName);
        this._memo = memo;
        this.initializeLight(systemName);
    }

    public AcelaLight(String systemName, String userName, AcelaSystemConnectionMemo memo) {
        super(systemName, userName);
        this._memo = memo;
        this.initializeLight(systemName);
    }

    private void initializeLight(String systemName) {
        this.mBit = AcelaAddress.getBitFromSystemName(systemName, this._memo.getSystemPrefix());
        AcelaNode mNode = AcelaAddress.getNodeFromSystemName(this.mSystemName, this._memo);
        if (mNode != null) {
            int initbit = this.mBit - mNode.getStartingOutputAddress();
            int initstate = mNode.getOutputInit(initbit);
            if (initstate == 1) {
                this.setState(2);
            } else {
                this.setState(4);
            }
        }
    }

    @Override
    public void setState(int newState) {
        AcelaNode mNode = AcelaAddress.getNodeFromSystemName(this.mSystemName, this._memo);
        if (mNode != null) {
            switch (newState) {
                case 2: {
                    mNode.setOutputBit(this.mBit, true);
                    break;
                }
                case 4: {
                    mNode.setOutputBit(this.mBit, false);
                    break;
                }
                default: {
                    log.warn("illegal state requested for Light: {}", (Object)this.getSystemName());
                }
            }
        }
        if (newState != this.mState) {
            int oldState = this.mState;
            this.mState = newState;
            this.firePropertyChange("KnownState", oldState, newState);
        }
    }
}

