/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.acela;

import java.util.Comparator;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.SensorManager;
import jmri.TurnoutManager;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.acela.AcelaLightManager;
import jmri.jmrix.acela.AcelaSensorManager;
import jmri.jmrix.acela.AcelaTrafficController;
import jmri.jmrix.acela.AcelaTurnoutManager;
import jmri.jmrix.acela.swing.AcelaComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcelaSystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    ComponentFactory cf = null;
    private AcelaTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(AcelaSystemConnectionMemo.class);

    public AcelaSystemConnectionMemo() {
        this("A", "CTI Electronics");
    }

    public AcelaSystemConnectionMemo(@Nonnull String prefix, @Nonnull String userName) {
        super(prefix, userName);
        InstanceManager.store(this, AcelaSystemConnectionMemo.class);
        this.cf = new AcelaComponentFactory(this);
        InstanceManager.store(this.cf, ComponentFactory.class);
        log.debug("Created AcelaSystemConnectionMemo");
    }

    public AcelaSystemConnectionMemo(AcelaTrafficController tc) {
        super("A", "CTI Electronics");
        this.tc = tc;
        InstanceManager.store(this, AcelaSystemConnectionMemo.class);
        this.cf = new AcelaComponentFactory(this);
        InstanceManager.store(this.cf, ComponentFactory.class);
        log.debug("Created AcelaSystemConnectionMemo");
    }

    public AcelaTrafficController getTrafficController() {
        if (this.tc == null) {
            this.setAcelaTrafficController(new AcelaTrafficController());
            log.debug("Auto create of AcelaTrafficController for initial configuration");
        }
        return this.tc;
    }

    public void setAcelaTrafficController(AcelaTrafficController tc) {
        this.tc = tc;
    }

    @Override
    public void configureManagers() {
        InstanceManager.setLightManager(this.getLightManager());
        InstanceManager.setSensorManager(this.getSensorManager());
        this.getTrafficController().setSensorManager(this.getSensorManager());
        InstanceManager.setTurnoutManager(this.getTurnoutManager());
        this.getTrafficController().setTurnoutManager(this.getTurnoutManager());
        this.register();
    }

    public AcelaTurnoutManager getTurnoutManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (AcelaTurnoutManager)this.classObjectMap.computeIfAbsent(TurnoutManager.class, c -> new AcelaTurnoutManager(this));
    }

    public AcelaSensorManager getSensorManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (AcelaSensorManager)this.classObjectMap.computeIfAbsent(SensorManager.class, c -> new AcelaSensorManager(this));
    }

    public AcelaLightManager getLightManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (AcelaLightManager)this.classObjectMap.computeIfAbsent(LightManager.class, c -> new AcelaLightManager(this));
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.acela.AcelaActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void dispose() {
        this.tc = null;
        InstanceManager.deregister(this, AcelaSystemConnectionMemo.class);
        if (this.cf != null) {
            InstanceManager.deregister(this.cf, ComponentFactory.class);
        }
        super.dispose();
    }
}

