/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.acela;

import jmri.implementation.AbstractTurnout;
import jmri.jmrix.acela.AcelaAddress;
import jmri.jmrix.acela.AcelaNode;
import jmri.jmrix.acela.AcelaSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcelaTurnout
extends AbstractTurnout {
    private AcelaSystemConnectionMemo _memo = null;
    protected int mState = 1;
    int mBit = -1;
    private static final Logger log = LoggerFactory.getLogger(AcelaTurnout.class);

    public AcelaTurnout(String systemName, AcelaSystemConnectionMemo memo) {
        super(systemName);
        this._memo = memo;
        this.initializeTurnout(systemName);
    }

    public AcelaTurnout(String systemName, String userName, AcelaSystemConnectionMemo memo) {
        super(systemName, userName);
        this._memo = memo;
        this.initializeTurnout(systemName);
    }

    private void initializeTurnout(String systemName) {
        this.mBit = AcelaAddress.getBitFromSystemName(systemName, this._memo.getSystemPrefix());
        this.setState(1);
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        try {
            this.sendMessage(this.stateChangeCheck(newState));
        }
        catch (IllegalArgumentException ex) {
            log.error("new state invalid, Turnout not set");
        }
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean pushButtonLockout) {
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    private int adjustStateForInversion(int rawState) {
        if (this.getInverted() && (rawState == 2 || rawState == 4)) {
            if (rawState == 2) {
                return 4;
            }
            return 2;
        }
        return rawState;
    }

    protected void sendMessage(boolean closed) {
        int newState = closed ? this.adjustStateForInversion(2) : this.adjustStateForInversion(4);
        AcelaNode mNode = AcelaAddress.getNodeFromSystemName(this.mSystemName, this._memo);
        if (mNode != null) {
            switch (newState) {
                case 4: {
                    mNode.setOutputBit(this.mBit, true);
                    break;
                }
                case 2: {
                    mNode.setOutputBit(this.mBit, false);
                    break;
                }
                default: {
                    log.warn("illegal state requested for Turnout: {}", (Object)this.getSystemName());
                }
            }
        }
        if (newState != this.mState) {
            int oldState = this.mState;
            this.mState = newState;
            this.firePropertyChange("KnownState", oldState, newState);
        }
    }
}

