/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.anyma;

import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import jmri.jmrix.anyma.AnymaDMX_UsbPortAdapter;
import jmri.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnymaDMX_TrafficController {
    private byte[] old_data = new byte[512];
    private byte[] new_data = new byte[512];
    private ScheduledExecutorService execService = null;
    private AnymaDMX_UsbPortAdapter controller = null;
    private static final Logger log = LoggerFactory.getLogger(AnymaDMX_TrafficController.class);

    public AnymaDMX_TrafficController() {
        Arrays.fill(this.old_data, (byte)-1);
        this.execService = Executors.newScheduledThreadPool(5);
        this.execService.scheduleAtFixedRate(() -> {
            if (!Arrays.equals(this.old_data, this.new_data)) {
                int from = this.old_data.length;
                int to = 0;
                for (int i = 0; i < this.old_data.length; ++i) {
                    if (this.old_data[i] == this.new_data[i]) continue;
                    from = Math.min(from, i);
                    to = i;
                }
                if (from <= to) {
                    int len = to - from + 1;
                    byte[] buf = new byte[len];
                    System.arraycopy(this.new_data, from, buf, 0, len);
                    if (this.sendChannelRangeValues(from, to, buf)) {
                        System.arraycopy(this.new_data, from, this.old_data, from, len);
                    }
                }
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    public void connectPort(AnymaDMX_UsbPortAdapter p) {
        if (this.controller != null) {
            log.warn("connectPort called when already connected");
        } else {
            log.debug("connectPort invoked");
        }
        this.controller = p;
    }

    public void setChannelValue(int channel, byte value) {
        if (1 <= channel && channel <= 512) {
            this.new_data[channel - 1] = value;
        }
    }

    public void setChannelRangeValues(int from, int to, byte[] buf) {
        if (1 <= from && from <= 512 && 1 <= to && to <= 512) {
            int len = to - from + 1;
            if (len == buf.length) {
                System.arraycopy(this.new_data, from - 1, buf, 0, len);
            } else {
                log.error("range does not match buffer size");
            }
        } else {
            log.error("channel(s) out of range (1-512): {from: {}, to: {}}.", (Object)from, (Object)to);
        }
    }

    private boolean sendChannelRangeValues(int from, int to, byte[] buf) {
        boolean result = false;
        if (this.controller != null) {
            from = MathUtil.pin(from, 0, 511);
            to = MathUtil.pin(to, from, 511);
            int len = to - from + 1;
            int requestType = 64;
            int request = 2;
            result = this.controller.sendControlTransfer(requestType, request, len, from, buf);
        }
        return result;
    }

    public void dispose() {
        this.execService.shutdown();
        try {
            if (!this.execService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.execService.shutdownNow();
                if (!this.execService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    log.error("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.execService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

