/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.bachrus;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.jmrix.bachrus.Bundle;
import jmri.jmrix.bachrus.Speed;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJFileChooser;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DccSpeedProfile {
    protected int _length;
    protected float[] _dataPoints;
    protected float _max;
    protected int _lastPoint;
    protected List<CSVRecord> dccProfileData;
    private static final Logger log = LoggerFactory.getLogger(DccSpeedProfile.class);

    public DccSpeedProfile(int len) {
        this._length = len;
        this._dataPoints = new float[this._length];
        for (int i = 0; i < this._length; ++i) {
            this._dataPoints[i] = 0.0f;
        }
        this._max = 40.0f;
        this._lastPoint = -1;
    }

    public boolean setPoint(int idx, float val) {
        boolean ret = false;
        if (idx < this._length) {
            this._dataPoints[idx] = val;
            ++this._lastPoint;
            log.debug("Index: {} val: {}", (Object)idx, (Object)Float.valueOf(val));
            if (val > this._max) {
                log.debug("     Old max: {}", (Object)Float.valueOf(this._max));
                this._max = (float)(Math.floor(val / 20.0f) + 1.0) * 20.0f;
                log.debug("     New max: {}", (Object)Float.valueOf(this._max));
            }
            ret = true;
        }
        return ret;
    }

    public void clear() {
        for (int i = 0; i < this._length; ++i) {
            this._dataPoints[i] = 0.0f;
        }
        this._max = 40.0f;
        this._lastPoint = -1;
    }

    public float getPoint(int idx) {
        if (idx < this._length && idx <= this._lastPoint) {
            return this._dataPoints[idx];
        }
        return -1.0f;
    }

    public int getLength() {
        return this._length;
    }

    public void setMax(float m) {
        this._max = m;
    }

    public float getMax() {
        return this._max;
    }

    public int getLast() {
        return this._lastPoint;
    }

    public static void printHeading(@Nonnull CSVPrinter p, int address) throws IOException {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE d MMM yyyy", Locale.getDefault());
        String today = formatter.format(new Date());
        String annotate = Bundle.getMessage("ProfileFor") + " " + address + " " + Bundle.getMessage("CreatedOn") + " " + today;
        p.printRecord(new Object[]{annotate});
    }

    public static void export(DccSpeedProfile sp, int address, String dirString, Speed.Unit unit) {
        File file = DccSpeedProfile.openExportFile();
        try (CSVPrinter p = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), CSVFormat.DEFAULT);){
            String unitsString = unit == Speed.Unit.MPH ? "MPH" : "KPH";
            DccSpeedProfile.printHeading(p, address);
            p.printRecord(new Object[]{"Step", "Speed(" + dirString + " " + unitsString + ")"});
            for (int i = 0; i < sp.getLength(); ++i) {
                p.printRecord(new Object[]{i, Float.valueOf(unit == Speed.Unit.MPH ? Speed.kphToMph(sp.getPoint(i)) : sp.getPoint(i))});
            }
            p.flush();
            p.close();
        }
        catch (IOException ex) {
            log.error("Error exporting speed profile", (Throwable)ex);
        }
    }

    public static void export(DccSpeedProfile[] sp, int address, Speed.Unit unit) {
        File file = DccSpeedProfile.openExportFile();
        try (CSVPrinter p = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), CSVFormat.DEFAULT);){
            String unitsString = unit == Speed.Unit.MPH ? "MPH" : "KPH";
            DccSpeedProfile.printHeading(p, address);
            p.printRecord(new Object[]{"Step", "Speed(fwd " + unitsString + ")", "Speed(rev " + unitsString + ")"});
            for (int i = 0; i < sp[0].getLength(); ++i) {
                ArrayList<Number> list = new ArrayList<Number>();
                list.add(i);
                for (DccSpeedProfile item : sp) {
                    list.add(Float.valueOf(unit == Speed.Unit.MPH ? Speed.kphToMph(item.getPoint(i)) : item.getPoint(i)));
                }
                p.printRecord(list);
            }
            p.flush();
            p.close();
        }
        catch (IOException ex) {
            log.error("Error exporting speed profile", (Throwable)ex);
        }
    }

    private static File openExportFile() {
        JmriJFileChooser fileChooser = new JmriJFileChooser(FileUtil.getUserFilesPath());
        if (fileChooser.showSaveDialog(null) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public int importDccProfile(Speed.Unit unit) {
        this.openImportFile();
        if (this.dccProfileData.size() < 31) {
            log.error("Not enough lines in reference speed profile file");
            this.clear();
            return -1;
        }
        String secondLine = this.dccProfileData.get(1).toString();
        if (!secondLine.contains("MPH") && !secondLine.contains("KPH")) {
            log.error("Bad 'units' format on line 2 of reference speed profile file");
            this.clear();
            return -1;
        }
        for (int i = 2; i < this.dccProfileData.size(); ++i) {
            try {
                String value = this.dccProfileData.get(i).get(1);
                float speed = Float.parseFloat(value);
                if (secondLine.contains("MPH")) {
                    speed = Speed.mphToKph(speed);
                }
                this.setPoint(i - 2, speed);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException | NullPointerException | NumberFormatException ex) {
                log.error("Bad data or format in reference speed profile file", (Throwable)ex);
                this.clear();
                return -1;
            }
        }
        return 0;
    }

    private void openImportFile() {
        JmriJFileChooser fileChooser = new JmriJFileChooser(FileUtil.getUserFilesPath());
        if (fileChooser.showOpenDialog(null) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                this.dccProfileData = CSVParser.parse((File)file, (Charset)StandardCharsets.UTF_8, (CSVFormat)CSVFormat.DEFAULT).getRecords();
            }
            catch (IOException ex) {
                log.error("Failed to read reference profile file", (Throwable)ex);
            }
        }
    }
}

